/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.thirdOrganization.service.org.imp;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.thirdOrganization.dao.org.ThirdOrgLinkWayMapper;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrgLinkWay;
import cn.smarthse.modules.health.thirdOrganization.model.sys.SysAreaStandard;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrgLinkWayService;
import cn.smarthse.modules.health.thirdOrganization.service.sys.AreaService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@DubboService
@Transactional(readOnly=true)
public class ThirdOrgLinkWayServiceImpl
extends BaseServiceImpl<ThirdOrgLinkWayMapper, ThirdOrgLinkWay>
implements IThirdOrgLinkWayService {
    @Autowired
    AreaService areaService;

    public PageInfo<ThirdOrgLinkWay> queryPage(JqGridParam jqGridParam, Long orgId) {
        Example example = new Example(ThirdOrgLinkWay.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("isValid", (Object)true).andEqualTo("thirdOrgId", (Object)orgId);
        PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        List list = this.getListByExample(example);
        return new PageInfo(list);
    }

    @Transactional(readOnly=false)
    public void saveLinkWay(ThirdOrgLinkWay way) {
        Integer num = ((ThirdOrgLinkWayMapper)this.dao).getLinkWayNumByAreaIdAndOrgIdWithOutChild(way.getThirdOrgId(), way.getAreaId());
        if (num != null && num > 0 && way.getId() == null) {
            throw new HealthException("\u6bcf\u4e2a\u533a\u57df\u53ea\u80fd\u6709\u4e00\u4e2a\u8054\u7cfb\u65b9\u5f0f");
        }
        if (way != null) {
            if (way.getId() != null) {
                this.update(way, way.getCreateBy());
            } else {
                this.add(way, way.getCreateBy(), null);
            }
        }
    }

    public PageInfo<ThirdOrgLinkWay> getLinkWayByAreaIdAndOrgId(JqGridParam jqGridParam, Long areaId, Long orgId) {
        SysAreaStandard area = this.areaService.get(areaId);
        if (area == null) {
            return new PageInfo();
        }
        int linkNum = ((ThirdOrgLinkWayMapper)this.dao).getLinkWayNumByAreaIdAndOrgId(orgId, areaId, area.getLevel());
        if (linkNum > 0 || area.getLevel().intValue() <= 1) {
            PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
            List<ThirdOrgLinkWay> list = ((ThirdOrgLinkWayMapper)this.dao).getLinkWayByAreaIdAndOrgId(orgId, area.getId(), area.getLevel());
            return new PageInfo(list);
        }
        SysAreaStandard area1 = this.getLinkArea(area.getParentId(), orgId);
        PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        List<ThirdOrgLinkWay> list = ((ThirdOrgLinkWayMapper)this.dao).getLinkWayByAreaIdAndOrgIdWithOutChild(orgId, area1.getId());
        return new PageInfo(list);
    }

    private SysAreaStandard getLinkArea(Long areaId, Long orgId) {
        SysAreaStandard area = this.areaService.get(areaId);
        if (area == null) {
            return null;
        }
        int linkNum = ((ThirdOrgLinkWayMapper)this.dao).getLinkWayNumByAreaIdAndOrgIdWithOutChild(orgId, areaId);
        if (linkNum > 0 || area.getLevel().intValue() <= 1) {
            return area;
        }
        return this.getLinkArea(area.getParentId(), orgId);
    }

    @Transactional(readOnly=false)
    public void updateOrgIdByNotRealOrgId(Long orgId, Long notRealOrgId) {
        if (orgId != null && notRealOrgId != null) {
            Example example = new Example(ThirdOrgLinkWay.class);
            example.createCriteria().andEqualTo("thirdOrgId", (Object)notRealOrgId);
            ThirdOrgLinkWay tol = new ThirdOrgLinkWay();
            tol.setThirdOrgId(orgId);
            ((ThirdOrgLinkWayMapper)this.dao).updateByExampleSelective(tol, example);
        }
    }
}

