/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.thirdOrganization.service.org.imp;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.thirdOrganization.dao.org.ThirdOrgInfoMapper;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrgInfo;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrgInfoDic;
import cn.smarthse.modules.health.thirdOrganization.model.org.OrgInfoDicTypeEnum;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrgInfoService;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@Service
@DubboService
public class ThirdOrgInfoServiceImp
extends BaseServiceImpl<ThirdOrgInfoMapper, ThirdOrgInfo>
implements IThirdOrgInfoService {
    @Override
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={Exception.class})
    public void update(List<ThirdOrgInfo> newInfo, Long orgId) {
        ((ThirdOrgInfoMapper)this.dao).deleteByOrgId(orgId);
        if (!CollectionUtils.isEmpty(newInfo)) {
            for (ThirdOrgInfo info : newInfo) {
                info.setOrgId(orgId);
                info.setId(null);
                if (info.getInfoDicStrId() != null) {
                    info.setInfoDicId(Long.valueOf(Long.parseLong(info.getInfoDicStrId())));
                }
                this.add(info);
            }
        }
    }

    public List<ThirdOrgInfo> query(Long orgId, OrgInfoDicTypeEnum typeEnum) {
        return ((ThirdOrgInfoMapper)this.dao).queryByType(typeEnum.getType(), orgId);
    }

    public List<ThirdOrgInfo> getByOrg(Long orgId) {
        Example example = new Example(ThirdOrgInfo.class);
        example.createCriteria().andEqualTo("orgId", (Object)orgId);
        return this.getListByExample(example);
    }

    public List<ThirdOrgInfo> getOtherDicInfo(Long orgId, Integer currentOrgType) {
        if (currentOrgType.equals(1)) {
            return ((ThirdOrgInfoMapper)this.dao).queryNoDetectionInfo(orgId);
        }
        if (currentOrgType.equals(2)) {
            return ((ThirdOrgInfoMapper)this.dao).queryNoDicInfo(orgId, 300);
        }
        if (currentOrgType.equals(4)) {
            return ((ThirdOrgInfoMapper)this.dao).queryNoDicInfo(orgId, 400);
        }
        return this.getByOrg(orgId);
    }

    public List<ThirdOrgInfo> getDetectionInfo(Long cid) {
        return ((ThirdOrgInfoMapper)this.dao).queryDetectionInfo(cid);
    }

    public List<ThirdOrgInfoDic> getDetectionServiceRange(Long cid) {
        return ((ThirdOrgInfoMapper)this.dao).getDetectionServiceRange(cid);
    }

    public List<ThirdOrgInfoDic> getExamTypes(Long cid) {
        return ((ThirdOrgInfoMapper)this.dao).getExamTypes(cid);
    }

    public List<ThirdOrgInfo> getExamInfo(Long orgId) {
        return this.query(orgId, OrgInfoDicTypeEnum.RECORD_CHECK_TYPE_AND_PROJECT);
    }

    public List<ThirdOrgInfo> getByOrgAndDicId(Long orgId, Long dicId) {
        Example example = new Example(ThirdOrgInfo.class);
        example.createCriteria().andEqualTo("orgId", (Object)orgId).andEqualTo("infoDicId", (Object)dicId);
        return this.getListByExample(example);
    }

    public List<ThirdOrgInfo> getAll() {
        return this.getListByExample(new Example(ThirdOrgInfo.class));
    }

    @Transactional(readOnly=false)
    public void deleteByOrgIdAndDicTypes(Long id, List<String> types) {
        ((ThirdOrgInfoMapper)this.dao).deleteByOrgIdAndDicTypes(id, String.join((CharSequence)",", types));
    }

    public List<ThirdOrgInfoDic> getDetectionServeRange(Long id) {
        return ((ThirdOrgInfoMapper)this.dao).getDetectionServeRange(id);
    }
}

