/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.thirdOrganization.service.notice.impl;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.entity.sys.message.vo.MessageParam;
import cn.smarthse.modules.health.thirdOrganization.dao.notice.ThirdOrgNoticeMapper;
import cn.smarthse.modules.health.thirdOrganization.entity.notice.ThirdOrgNotice;
import cn.smarthse.modules.health.thirdOrganization.entity.notice.ThirdOrgNoticeReceiver;
import cn.smarthse.modules.health.thirdOrganization.service.notice.IThirdOrgNoticeFileService;
import cn.smarthse.modules.health.thirdOrganization.service.notice.IThirdOrgNoticeReceiverService;
import cn.smarthse.modules.health.thirdOrganization.service.notice.IThirdOrgNoticeService;
import cn.smarthse.modules.health.thirdOrganization.service.notice.IThirdOrgNoticeUserService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Collections;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@DubboService
@Transactional(readOnly=true)
public class ThirdOrgNoticeServiceImpl
extends BaseServiceImpl<ThirdOrgNoticeMapper, ThirdOrgNotice>
implements IThirdOrgNoticeService {
    @Autowired
    IThirdOrgNoticeFileService thirdOrgNoticeFileService;
    @Autowired
    IThirdOrgNoticeReceiverService thirdOrgNoticeReceiverService;
    @Autowired
    IThirdOrgNoticeUserService thirdOrgNoticeUserService;

    public PageInfo<ThirdOrgNotice> pageOrgNotices(JqGridParam gparam, MessageParam param) {
        if (gparam == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<ThirdOrgNotice> infoList = this.listOrgNotices(param);
        return new PageInfo(infoList);
    }

    public List<ThirdOrgNotice> listOrgNotices(MessageParam param) {
        if (param.getCid() == null || param.getUserId() == null) {
            return Collections.emptyList();
        }
        return ((ThirdOrgNoticeMapper)this.dao).listOrgNotices(param);
    }

    public ThirdOrgNotice getDetailById(Long id) {
        ThirdOrgNotice notice = (ThirdOrgNotice)this.getById(id);
        this.setNoticeReceviers(notice);
        List files = this.thirdOrgNoticeFileService.getFiles(id);
        notice.setFiles(files);
        return notice;
    }

    private void setNoticeReceviers(ThirdOrgNotice notice) {
        List receivers = this.thirdOrgNoticeReceiverService.getReceivers(notice.getId());
        if (receivers == null || receivers.isEmpty()) {
            return;
        }
        Long orgId = notice.getThirdOrgId();
        for (ThirdOrgNoticeReceiver r : receivers) {
            String receiverState = r.getReceiverState();
            String receiverType = r.getReceiverType();
            Long receiverId = r.getReceiverId();
            if (String.valueOf(receiverId).equals(String.valueOf(orgId)) && "4".equals(receiverType)) {
                notice.setReceiver(r);
            }
            if ("1".equals(receiverState)) {
                notice.getSendReceivers().add(r);
                continue;
            }
            if ("2".equals(receiverState)) {
                notice.getSendReceivers().add(r);
                continue;
            }
            if (!"3".equals(receiverState)) continue;
            notice.getCopyReceivers().add(r);
        }
    }

    @Transactional(readOnly=false)
    public void addReader(Long loginUserId, Long id) {
        this.thirdOrgNoticeUserService.updateReader(loginUserId, id);
    }

    public ThirdOrgNotice getByNoticeIdAndOrgId(Long noticeId, Long orgId) {
        List<ThirdOrgNotice> list = this.getList(noticeId, orgId);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public List<ThirdOrgNotice> getList(Long noticeId, Long orgId) {
        Example example = new Example(ThirdOrgNotice.class);
        example.createCriteria().andEqualTo("messageId", (Object)noticeId).andEqualTo("thirdOrgId", (Object)orgId);
        return ((ThirdOrgNoticeMapper)this.dao).selectByExample(example);
    }

    public List<Long> getPushedThirdOrgs(Long noticeId) {
        return ((ThirdOrgNoticeMapper)this.dao).getPushedThirdOrgs(noticeId);
    }

    public List<Long> getReadCount(Long noticeId) {
        return ((ThirdOrgNoticeMapper)this.dao).getReadCount(noticeId);
    }

    @Transactional(readOnly=false)
    public void deleteByNoticeId(Long noticeId) {
        ThirdOrgNotice orgNotice = new ThirdOrgNotice();
        orgNotice.setMessageId(noticeId);
        this.delete(orgNotice);
    }
}

