/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.thirdOrganization.service.notice.impl;

import cn.smarthse.modules.health.entity.sys.message.Message;
import cn.smarthse.modules.health.entity.sys.message.MessageFile;
import cn.smarthse.modules.health.entity.sys.message.MessageReceiver;
import cn.smarthse.modules.health.thirdOrganization.entity.notice.ThirdOrgNotice;
import cn.smarthse.modules.health.thirdOrganization.entity.notice.ThirdOrgNoticeFile;
import cn.smarthse.modules.health.thirdOrganization.entity.notice.ThirdOrgNoticeReceiver;
import cn.smarthse.modules.health.thirdOrganization.service.message.IThirdOrgMessageService;
import cn.smarthse.modules.health.thirdOrganization.service.notice.IThirdOrgNoticeFileService;
import cn.smarthse.modules.health.thirdOrganization.service.notice.IThirdOrgNoticeProviderService;
import cn.smarthse.modules.health.thirdOrganization.service.notice.IThirdOrgNoticeReceiverService;
import cn.smarthse.modules.health.thirdOrganization.service.notice.IThirdOrgNoticeService;
import cn.smarthse.modules.health.thirdOrganization.service.notice.IThirdOrgNoticeUserService;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@DubboService
@Transactional(readOnly=true)
public class ThirdOrgNoticeProviderServiceImpl
implements IThirdOrgNoticeProviderService {
    @Autowired
    IThirdOrgNoticeService thirdOrgNoticeService;
    @Autowired
    IThirdOrgNoticeFileService thirdOrgNoticeFileService;
    @Autowired
    IThirdOrgNoticeReceiverService thirdOrgNoticeReceiverService;
    @Autowired
    IThirdOrgNoticeUserService thirdOrgNoticeUserService;
    @Autowired
    IThirdOrgMessageService thirdOrgMessageService;

    @Transactional(readOnly=false)
    public void addMessageFromSupervise(Message message) {
        List receivers = message.getReceivers();
        if (receivers == null || receivers.isEmpty()) {
            return;
        }
        Long noticeId = message.getBussinesId();
        for (MessageReceiver mr : receivers) {
            ThirdOrgNotice thirdOrgNoticeOld;
            Long receviverId = mr.getReveiver();
            String receiverType = mr.getReceiverType();
            if (!"4".equals(receiverType) || (thirdOrgNoticeOld = this.thirdOrgNoticeService.getByNoticeIdAndOrgId(noticeId, receviverId)) != null) continue;
            ThirdOrgNotice thirdOrgNotice = (ThirdOrgNotice)this.thirdOrgNoticeService.add((Object)this.convertToThirdOrgNotice(message, receviverId));
            Long thirdOrgNoticeId = thirdOrgNotice.getId();
            this.addFiles(thirdOrgNoticeId, message.getFiles());
            this.addReceivers(thirdOrgNoticeId, message.getReceivers());
        }
    }

    private void addReceivers(Long thirdOrgNoticeId, List<MessageReceiver> receivers) {
        if (receivers == null || receivers.isEmpty()) {
            return;
        }
        for (MessageReceiver r : receivers) {
            ThirdOrgNoticeReceiver thirdOrgNoticeReceiver = this.convertToThirdOrgNoticeReceiver(thirdOrgNoticeId, r);
            this.thirdOrgNoticeReceiverService.add((Object)thirdOrgNoticeReceiver);
        }
    }

    private ThirdOrgNoticeReceiver convertToThirdOrgNoticeReceiver(Long thirdOrgNoticeId, MessageReceiver r) {
        ThirdOrgNoticeReceiver thirdOrgNoticeReceiver = new ThirdOrgNoticeReceiver();
        thirdOrgNoticeReceiver.setNoticeId(thirdOrgNoticeId);
        thirdOrgNoticeReceiver.setReceiverId(r.getReveiver());
        thirdOrgNoticeReceiver.setReceiverName(r.getReceiverName());
        thirdOrgNoticeReceiver.setReceiverState(r.getMessageSate());
        thirdOrgNoticeReceiver.setReceiverType(r.getReceiverType());
        return thirdOrgNoticeReceiver;
    }

    private void addFiles(Long thirdOrgNoticeId, List<MessageFile> files) {
        if (files == null || files.isEmpty()) {
            return;
        }
        for (MessageFile f : files) {
            ThirdOrgNoticeFile thirdOrgNoticeFile = this.convertToThirdOrgNoticeFile(thirdOrgNoticeId, f);
            this.thirdOrgNoticeFileService.add((Object)thirdOrgNoticeFile);
        }
    }

    private ThirdOrgNoticeFile convertToThirdOrgNoticeFile(Long thirdOrgNoticeId, MessageFile f) {
        ThirdOrgNoticeFile thirdOrgNoticeFile = new ThirdOrgNoticeFile();
        thirdOrgNoticeFile.setNoticeId(thirdOrgNoticeId);
        thirdOrgNoticeFile.setFileName(f.getFileName());
        thirdOrgNoticeFile.setFileOss(f.getFileOss());
        return thirdOrgNoticeFile;
    }

    private ThirdOrgNotice convertToThirdOrgNotice(Message message, Long thirdOrgId) {
        ThirdOrgNotice thirdOrgNotice = new ThirdOrgNotice();
        thirdOrgNotice.setSendTime(new Date());
        thirdOrgNotice.setContent(message.getBussinessContent());
        thirdOrgNotice.setTitle(message.getBussinesName());
        thirdOrgNotice.setPublishName(message.getBussinesFrom());
        thirdOrgNotice.setMessageId(message.getBussinesId());
        thirdOrgNotice.setPublishId(message.getCid());
        thirdOrgNotice.setThirdOrgId(thirdOrgId);
        return thirdOrgNotice;
    }

    public int getPushedThirdOrgs(Long noticeId) {
        List<Long> oids = this.getSendIds(noticeId);
        return oids.size();
    }

    public int getReadCount(Long noticeId) {
        List<Long> oids = this.getReadIds(noticeId);
        return oids.size();
    }

    public List<Long> getSendIds(Long noticeId) {
        List oids = this.thirdOrgNoticeService.getPushedThirdOrgs(noticeId);
        return oids == null ? Collections.emptyList() : oids;
    }

    public List<Long> getReadIds(Long noticeId) {
        List oids = this.thirdOrgNoticeService.getReadCount(noticeId);
        return oids == null ? Collections.emptyList() : oids;
    }

    @Transactional(readOnly=false)
    public void deleteNoticeMessage(Long noticeId) {
        this.thirdOrgMessageService.deleteNoticeMessage(noticeId);
    }
}

