/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.thirdOrganization.service.message.impl;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.entity.sys.message.vo.MessageParam;
import cn.smarthse.modules.health.thirdOrganization.dao.message.ThirdOrgMessageMapper;
import cn.smarthse.modules.health.thirdOrganization.entity.message.ThirdOrgMessage;
import cn.smarthse.modules.health.thirdOrganization.entity.notice.ThirdOrgNotice;
import cn.smarthse.modules.health.thirdOrganization.service.message.IThirdOrgMessageService;
import cn.smarthse.modules.health.thirdOrganization.service.message.IThirdOrgMessageUserService;
import cn.smarthse.modules.health.thirdOrganization.service.notice.IThirdOrgNoticeService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@DubboService
@Transactional(readOnly=true)
public class ThirdOrgMessageServiceImpl
extends BaseServiceImpl<ThirdOrgMessageMapper, ThirdOrgMessage>
implements IThirdOrgMessageService {
    @Autowired
    IThirdOrgMessageUserService thirdOrgMessageUserService;
    @Autowired
    IThirdOrgNoticeService noticeService;

    public PageInfo<ThirdOrgMessage> page(JqGridParam gparam, MessageParam param) {
        if (gparam == null) {
            return new PageInfo();
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<ThirdOrgMessage> infoList = this.list(param);
        return new PageInfo(infoList);
    }

    public List<ThirdOrgMessage> list(MessageParam param) {
        if (param.getCid() == null || param.getUserId() == null) {
            return Collections.emptyList();
        }
        return ((ThirdOrgMessageMapper)this.dao).list(param);
    }

    @Transactional(readOnly=false)
    public void deleteNoticeMessage(Long noticeId) {
        List noticeList = this.noticeService.getList(noticeId, null);
        if (noticeList == null || noticeList.isEmpty()) {
            return;
        }
        for (ThirdOrgNotice notice : noticeList) {
            ThirdOrgMessage message = new ThirdOrgMessage();
            message.setCid(notice.getThirdOrgId());
            message.setBussinesType(Byte.valueOf((byte)1));
            message.setBussinesFrom(notice.getPublishName());
            message.setBussinesId(notice.getMessageId());
            message.setBussinesName(notice.getTitle() + "\u901a\u77e5\u64a4\u56de");
            message.setBussinessContent(notice.getTitle() + "\u901a\u77e5\u5df2\u88ab\u53d1\u5e03\u5355\u4f4d\u64a4\u56de\u3002");
            message.setSendTime(new Date());
            this.add(message);
        }
        this.noticeService.deleteByNoticeId(noticeId);
    }

    @Transactional(readOnly=false)
    public void addReader(Long loginUserId, Long id) {
        this.thirdOrgMessageUserService.updateReader(loginUserId, id);
    }

    public Integer getUnreadCount(Long orgId, Long userId) {
        return ((ThirdOrgMessageMapper)this.dao).getUnreadCount(orgId, userId);
    }
}

