/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.thirdOrganization.service.check.impl;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.health.entity.base.staff.vo.StaffBasicVo;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheck;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckData;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckDataResult;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckThirdInfo;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckType;
import cn.smarthse.modules.health.entity.work.check.vo.CheckReportCheckDataVo;
import cn.smarthse.modules.health.entity.work.check.vo.CheckReportDataVo;
import cn.smarthse.modules.health.entity.work.check.vo.HudongSysStaffInfoVo;
import cn.smarthse.modules.health.supervise.entity.check.project.CheckDataInfo;
import cn.smarthse.modules.health.supervise.entity.check.project.CheckDataResultInfo;
import cn.smarthse.modules.health.supervise.entity.check.project.CheckDetailInfo;
import cn.smarthse.modules.health.supervise.entity.check.project.CheckListInfo;
import cn.smarthse.modules.health.supervise.entity.check.project.ImportDataParam;
import cn.smarthse.modules.health.supervise.entity.check.project.PageCheckDataParam;
import cn.smarthse.modules.health.supervise.entity.check.project.PageCheckListParam;
import cn.smarthse.modules.health.supervise.entity.sys.SysFileThirdModel;
import cn.smarthse.modules.health.supervise.service.check.ISuperviseCheckThirdOrganizationService;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrganization;
import cn.smarthse.modules.health.thirdOrganization.service.check.IProjectCheckService;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrganizationService;
import cn.smarthse.snowflake.IdWorker;
import com.github.pagehelper.PageInfo;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@DubboService
@Transactional(readOnly=true)
public class ProjectCheckServiceImpl
implements IProjectCheckService {
    @Autowired
    protected IdWorker idworker;
    @DubboReference
    ISuperviseCheckThirdOrganizationService checkThirdOrganizationService;
    @Autowired
    IThirdOrganizationService thirdOrganizationService;
    @DubboReference(version="1.0.0")
    IHarmFactorService harmFactorService;

    public CheckDetailInfo getCheckDetailById(Long checkId) {
        return this.checkThirdOrganizationService.getCheckDetailById(checkId);
    }

    public PageInfo<CheckDataInfo> pageCheckData(JqGridParam gparam, PageCheckDataParam param) {
        return this.checkThirdOrganizationService.pageCheckData(gparam, param);
    }

    public List<CheckDataInfo> listCheckData(PageCheckDataParam param) {
        return this.checkThirdOrganizationService.listCheckData(param);
    }

    public CheckDataResultInfo getCheckResultInfo(Long id) {
        return this.checkThirdOrganizationService.getCheckResultInfo(id);
    }

    public PageInfo<CheckListInfo> thirdOrgPage(JqGridParam gparam, PageCheckListParam param) {
        return this.checkThirdOrganizationService.thirdOrgPage(gparam, param);
    }

    public List<CheckListInfo> thirdOrgList(PageCheckListParam param) {
        return this.checkThirdOrganizationService.thirdOrgList(param);
    }

    @Transactional(readOnly=false)
    public void deleteByIds(String ids, Long userId) {
        this.checkThirdOrganizationService.deleteByIds(ids, userId);
    }

    @Transactional(readOnly=false)
    public CheckDetailInfo info(CheckDetailInfo checkDetail, String companyName) {
        List<SysFileThirdModel> thirdFiles = this.smarthseFile(checkDetail);
        if (checkDetail.getHospital() != null) {
            ThirdOrganization org = (ThirdOrganization)this.thirdOrganizationService.getById(checkDetail.getHospital());
            checkDetail.setHospitalName(org == null ? null : org.getName());
        }
        checkDetail = this.checkThirdOrganizationService.info(checkDetail, thirdFiles, companyName);
        return checkDetail;
    }

    private List<SysFileThirdModel> smarthseFile(CheckDetailInfo checkDetail) {
        ArrayList<SysFileThirdModel> thirdFiles = new ArrayList<SysFileThirdModel>();
        String fileIds = this.getFileIds(checkDetail);
        if (StringUtils.isEmpty((CharSequence)fileIds)) {
            return thirdFiles;
        }
        return thirdFiles;
    }

    private String getFileIds(CheckDetailInfo checkDetail) {
        String reportIds = StringUtils.convertArrayToString((String[])checkDetail.getCheckTypeCount().getReportIds(), (String)",");
        checkDetail.getCheckTypeCount().setCheckReportFileIds(reportIds);
        String otherIds = StringUtils.convertArrayToString((String[])checkDetail.getCheckTypeCount().getOtherIds(), (String)",");
        checkDetail.getCheckTypeCount().setOtherFileIds(otherIds);
        if (StringUtils.isEmpty((CharSequence)reportIds)) {
            return otherIds;
        }
        if (StringUtils.isEmpty((CharSequence)otherIds)) {
            return reportIds;
        }
        return reportIds + "," + otherIds;
    }

    @Transactional(readOnly=false)
    public void deleteCheckResultByIds(String ids) {
        this.checkThirdOrganizationService.deleteCheckResultByIds(ids);
    }

    @Transactional(readOnly=false)
    public CheckDataResultInfo resultInfo(CheckDataResultInfo resultInfo) {
        return this.checkThirdOrganizationService.resultInfo(resultInfo);
    }

    @Transactional(readOnly=false)
    public void deleteCheckResult(CheckDataResultInfo resultInfo) {
        this.checkThirdOrganizationService.deleteCheckResult(resultInfo);
    }

    public List<String> importData(ImportDataParam param, List<List<String>> contents) {
        return this.checkThirdOrganizationService.importData(param, contents);
    }

    public Integer checkIdCard(CheckDataResultInfo resultInfo) {
        return this.checkThirdOrganizationService.checkIdCard(resultInfo);
    }

    public void deleteMultiCheckData(String dataIds, String resultIds, String resultGroup) {
        this.checkThirdOrganizationService.deleteMultiCheckData(dataIds, resultIds, resultGroup);
    }

    public Integer checkDataCount(Long checkId) {
        return this.checkThirdOrganizationService.checkDataCount(checkId);
    }

    public ResponseData<StaffBasicVo> checkIdCardAndName(String idCard, String name, Long cid) {
        return this.checkThirdOrganizationService.checkIdCardAndName(idCard, name, cid);
    }

    public ResponseData<List<StaffBasicVo>> importDataCheck(ImportDataParam param, List<List<String>> contents) {
        return this.checkThirdOrganizationService.importDataCheck(param, contents);
    }

    public int getCheckCountByNo(String no) {
        return this.checkThirdOrganizationService.getCheckCountByNo(no);
    }

    @Transactional(readOnly=false)
    public void addCheckReportDataVo(CheckReportDataVo data) {
        int count = this.getCheckCountByNo(data.getProjNo());
        if (count > 0) {
            return;
        }
        PhcPhysicalCheck check = new PhcPhysicalCheck();
        check.setId(Long.valueOf(this.idworker.nextId()));
        check.setStatus(Byte.valueOf((byte)1));
        check.setCid(data.getCid());
        check.setNo(data.getProjNo());
        check.setWorkName(data.getProjName());
        check.setBeginTime(data.getCheckBeginTime());
        check.setEndTime(data.getCheckEndTime());
        check.setCompanyName(data.getCompanyName());
        check.setHospital(data.getHospital());
        check.setThirdOrgName(data.getCheckOrgName());
        this.checkThirdOrganizationService.addPhcPhysicalCheck(check);
        PhcPhysicalCheckThirdInfo thirdInfo = new PhcPhysicalCheckThirdInfo();
        thirdInfo.setId(Long.valueOf(this.idworker.nextId()));
        thirdInfo.setCheckId(check.getId());
        thirdInfo.setCompanyAreaId(data.getCompanyAreaId());
        thirdInfo.setCompanyAddress(data.getCompanyAddress());
        thirdInfo.setIsRecheck(data.getIsRecheck());
        thirdInfo.setContactor(data.getContactor());
        thirdInfo.setContactorTel(data.getContactorTel());
        thirdInfo.setReportTime(new Date());
        thirdInfo.setCheckAddress(data.getCheckAddress());
        thirdInfo.setState(Byte.valueOf((byte)1));
        this.checkThirdOrganizationService.addPhcPhysicalCheckThirdInfo(thirdInfo);
        PhcPhysicalCheckType checkType = new PhcPhysicalCheckType();
        checkType.setId(Long.valueOf(this.idworker.nextId()));
        checkType.setCheckType(data.getCheckType());
        checkType.setNeedCheckTotal(data.getNeedChecks());
        checkType.setCheckProjects(data.getCheckProjects());
        checkType.setCheckId(check.getId());
        checkType.setCid(check.getCid());
        checkType.setCheckReportFileIds(data.getCheckReportFileIds());
        checkType.setOtherFileIds(data.getOtherFileIds());
        this.checkThirdOrganizationService.addPhcPhysicalCheckType(checkType);
        HashMap cidStaffInfoVosMap = new HashMap();
        if (data.getClientType() == 1L) {
            cidStaffInfoVosMap.put(data.getCid(), new ArrayList());
            ((List)cidStaffInfoVosMap.get(data.getCid())).addAll(this.checkThirdOrganizationService.getAllStaffInfoListByCid(data.getCid()));
        } else {
            for (CheckReportCheckDataVo vo : data.getCheckDatas()) {
                if (cidStaffInfoVosMap.get(vo.getStaffCid()) != null) continue;
                cidStaffInfoVosMap.put(vo.getStaffCid(), new ArrayList());
                ((List)cidStaffInfoVosMap.get(vo.getStaffCid())).addAll(this.checkThirdOrganizationService.getAllStaffInfoListByCid(vo.getStaffCid()));
            }
        }
        HashMap staffCheckDatasMap = new HashMap();
        HashMap staffIdCheckDatasMap = new HashMap();
        for (CheckReportCheckDataVo vo : data.getCheckDatas()) {
            HudongSysStaffInfoVo staffInfoVo = ((List)cidStaffInfoVosMap.get(vo.getStaffCid())).stream().filter(s -> vo.getStaffName().trim().equals(s.getRealName()) && vo.getIdCard().trim().equals(s.getIdCard())).findFirst().orElse(null);
            if (staffInfoVo == null) {
                staffInfoVo = this.checkThirdOrganizationService.addHuadongStaffInfo(vo.getStaffName().trim(), vo.getIdCard().trim(), null, vo.getStaffCid());
                ((List)cidStaffInfoVosMap.get(vo.getStaffCid())).add(staffInfoVo);
            }
            if (staffCheckDatasMap.get(staffInfoVo) == null) {
                staffCheckDatasMap.put(staffInfoVo, new ArrayList());
                staffIdCheckDatasMap.put(staffInfoVo.getStaffId(), new ArrayList());
            }
            ((List)staffCheckDatasMap.get(staffInfoVo)).add(vo);
            ((List)staffIdCheckDatasMap.get(staffInfoVo.getStaffId())).add(vo);
            staffInfoVo.setCurrentWorkName(vo.getWorkName());
        }
        HashMap<CallSite, PhcPhysicalCheckData> sysCheckDataMap = new HashMap<CallSite, PhcPhysicalCheckData>();
        for (HudongSysStaffInfoVo hudongSysStaffInfoVo : staffCheckDatasMap.keySet()) {
            PhcPhysicalCheckData ppcd = (PhcPhysicalCheckData)sysCheckDataMap.get(data.getCid() + check.getId() + hudongSysStaffInfoVo.getStaffId() + (long)data.getCheckType().byteValue());
            if (ppcd == null) {
                ppcd = this.checkThirdOrganizationService.getPhcPhysicalCheckDataByCheckIdAndStaffIdAndCheckType(data.getCid(), check.getId(), hudongSysStaffInfoVo.getStaffId(), data.getCheckType());
            }
            if (ppcd == null) {
                ppcd = new PhcPhysicalCheckData();
                ppcd.setCheckId(check.getId());
                ppcd.setCid(data.getCid());
                ppcd.setCheckType(data.getCheckType());
                ppcd.setStaffId(hudongSysStaffInfoVo.getStaffId());
                ppcd.setStaffName(hudongSysStaffInfoVo.getRealName());
                ppcd.setStaffWorkNo(hudongSysStaffInfoVo.getWorkNo());
                ppcd.setStaffDeptName(hudongSysStaffInfoVo.getOrgName());
                ppcd.setStaffDeptId(hudongSysStaffInfoVo.getOrgId());
                ppcd.setStaffWorkId(hudongSysStaffInfoVo.getCurrentWorkId());
                ppcd.setStaffWorkName(hudongSysStaffInfoVo.getCurrentWorkName());
                ppcd = this.checkThirdOrganizationService.addPhcPhysicalCheckData(ppcd, null, data.getCid());
            }
            sysCheckDataMap.put((CallSite)((Object)(data.getCid().toString() + check.getId().toString() + hudongSysStaffInfoVo.getStaffId().toString() + data.getCheckType())), ppcd);
            List checkDataVos = (List)staffIdCheckDatasMap.get(hudongSysStaffInfoVo.getStaffId());
            for (CheckReportCheckDataVo resultVo : checkDataVos) {
                PhcPhysicalCheckDataResult result = new PhcPhysicalCheckDataResult();
                result.setId(Long.valueOf(this.idworker.nextId()));
                result.setDataId(ppcd.getId());
                result.setCid(data.getCid());
                result.setExamResult(Byte.valueOf(resultVo.getResult().byteValue()));
                result.setHarmYear(resultVo.getHarmYear());
                result.setAbnormal(resultVo.getAbnormal());
                result.setCheckAdvice(resultVo.getCheckAdvice());
                result.setMedicalAdvice(resultVo.getMedicalAdvice());
                result.setMissingItems(resultVo.getMissingItems());
                result.setHarmDescId(resultVo.getHarmDesc());
                result.setHarmFactor(this.harmFactorService.getHarmIdsForApiByNames(resultVo.getHarmNames()));
                result.setOccId(this.harmFactorService.getHarmIdsForApiByNames(resultVo.getOccHarmNames()));
                this.checkThirdOrganizationService.addPhcPhysicalCheckDataResult(result);
            }
        }
    }
}

