/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.thirdOrganization.component;

import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.thirdOrganization.component.OrgBaseParser;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrgInfo;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrganization;
import cn.smarthse.modules.health.thirdOrganization.enums.org.ThirdOrgSourceEnum;
import cn.smarthse.modules.health.thirdOrganization.model.org.OrgUpdateDto;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrgInfoService;
import cn.smarthse.util.common.excel.model.RowModel;
import cn.smarthse.util.common.excel.model.SheetModel;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PhysicalExamParser
extends OrgBaseParser {
    private static Map<String, Long> dicMap = new HashMap<String, Long>();

    public PhysicalExamParser(IThirdOrgInfoService thirdOrgInfoService, ISysAreaProvideService sysAreaService) {
        this.thirdOrgInfoService = thirdOrgInfoService;
        this.sysAreaService = sysAreaService;
    }

    @Override
    public List<OrgUpdateDto> parse(SheetModel sheetModel) {
        LinkedList<OrgUpdateDto> orgList = new LinkedList<OrgUpdateDto>();
        List rows = sheetModel.getRows();
        for (int i = 1; i < rows.size(); ++i) {
            RowModel row = (RowModel)rows.get(i);
            OrgUpdateDto dto = this.createOrgUpdateDto();
            orgList.add(dto);
            ThirdOrganization org = new ThirdOrganization();
            org.setExcelPosition("\u7b2c" + (i + 2) + "\u884c");
            dto.setThirdOrganization(org);
            org.setOrgTypes("2");
            org.setOrgType(Integer.valueOf(2));
            int col = 0;
            org.setName((String)row.get(col++));
            org.setDetailAreaId(this.getAreaId((String)row.get(col++)));
            org.setAddress((String)row.get(col++));
            org.setServiceAreas("330000000000");
            org.setOrgSource(ThirdOrgSourceEnum.leadingIn.getCode());
            org.setLegalPerson((String)row.get(col++));
            org.setLegalPersonPhone((String)row.get(col++));
            org.setCreditCode((String)row.get(col++));
            if (this.haveCanServeCol()) {
                dto.setCanService(this.getBoolean((String)row.get(col++)));
            }
            org.setContactName((String)row.get(col++));
            org.setContactPhone((String)row.get(col++));
            org.setCanOutCheck(this.getBoolean((String)row.get(col++)));
            dto.setThirdOrgInfoList(this.createOrgDicInfo((String)row.get(col++)));
        }
        return orgList;
    }

    public List<ThirdOrgInfo> createOrgDicInfo(String s) {
        String[] strings;
        LinkedList<ThirdOrgInfo> list = new LinkedList<ThirdOrgInfo>();
        if (this.isEmpty(s).booleanValue()) {
            return list;
        }
        s = s.replaceAll("\uff0c", ",");
        for (String dic : strings = s.split(",")) {
            Long dicId = dicMap.get(dic);
            if (dicId == null) continue;
            ThirdOrgInfo orgInfo = new ThirdOrgInfo();
            orgInfo.setInfoDicId(dicId);
            orgInfo.setInfoDicStrId("" + dicId);
            list.add(orgInfo);
        }
        return list;
    }

    static {
        dicMap.put("\u7c89\u5c18\u4f5c\u4e1a", 98356945135650518L);
        dicMap.put("\u5316\u5b66\u6bd2\u7269\u4f5c\u4e1a", 98356945135650519L);
        dicMap.put("\u7269\u7406\u56e0\u7d20\u4f5c\u4e1a", 98356945135650520L);
        dicMap.put("\u751f\u7269\u56e0\u7d20\u4f5c\u4e1a", 98356945135650521L);
        dicMap.put("\u7535\u79bb\u8f90\u5c04\u4f5c\u4e1a", 98356945135650522L);
        dicMap.put("\u5176\u4ed6\u4f5c\u4e1a", 98356945135650523L);
    }
}

