/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.thirdOrganization.component;

import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.thirdOrganization.component.OrgBaseParser;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrgInfo;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrganization;
import cn.smarthse.modules.health.thirdOrganization.enums.org.ThirdOrgSourceEnum;
import cn.smarthse.modules.health.thirdOrganization.model.org.OrgUpdateDto;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrgInfoService;
import cn.smarthse.util.common.excel.model.RowModel;
import cn.smarthse.util.common.excel.model.SheetModel;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DiagnoseParser
extends OrgBaseParser {
    private static Map<String, Long> dicMap = new HashMap<String, Long>();

    public DiagnoseParser(IThirdOrgInfoService thirdOrgInfoService, ISysAreaProvideService sysAreaService) {
        this.thirdOrgInfoService = thirdOrgInfoService;
        this.sysAreaService = sysAreaService;
    }

    @Override
    public List<OrgUpdateDto> parse(SheetModel sheetModel) {
        LinkedList<OrgUpdateDto> orgList = new LinkedList<OrgUpdateDto>();
        List rows = sheetModel.getRows();
        for (int i = 1; i < rows.size(); ++i) {
            RowModel row = (RowModel)rows.get(i);
            OrgUpdateDto dto = this.createOrgUpdateDto();
            dto.setThirdOrgInfoList(new LinkedList());
            orgList.add(dto);
            ThirdOrganization org = new ThirdOrganization();
            dto.setThirdOrganization(org);
            org.setOrgTypes("4");
            org.setOrgType(Integer.valueOf(4));
            int col = 0;
            org.setName((String)row.get(col++));
            org.setExcelPosition("\u7b2c" + (i + 2) + "\u884c");
            org.setCreditCode((String)row.get(col++));
            org.setDetailAreaId(this.getAreaId((String)row.get(col++)));
            org.setAddress((String)row.get(col++));
            org.setServiceAreas("330000000000");
            org.setOrgSource(ThirdOrgSourceEnum.leadingIn.getCode());
            org.setLegalPerson((String)row.get(col++));
            org.setLegalPersonPhone((String)row.get(col++));
            if (this.haveCanServeCol()) {
                dto.setCanService(this.getBoolean((String)row.get(col++)));
            }
            org.setContactName((String)row.get(col++));
            org.setContactPhone((String)row.get(col++));
            dto.setThirdOrgInfoList(this.createOrgDicInfo((String)row.get(col++)));
        }
        return orgList;
    }

    public List<ThirdOrgInfo> createOrgDicInfo(String s) {
        String[] strings;
        LinkedList<ThirdOrgInfo> list = new LinkedList<ThirdOrgInfo>();
        if (this.isEmpty(s).booleanValue()) {
            return list;
        }
        s = s.replaceAll("\uff0c", ",");
        for (String dic : strings = s.split(",")) {
            Long dicId = dicMap.get(dic);
            if (dicId == null) continue;
            ThirdOrgInfo orgInfo = new ThirdOrgInfo();
            orgInfo.setInfoDicId(dicId);
            orgInfo.setInfoDicStrId("" + dicId);
            list.add(orgInfo);
        }
        return list;
    }

    static {
        dicMap.put("\u804c\u4e1a\u6027\u5c18\u80ba\u75c5\u53ca\u5176\u4ed6\u547c\u5438\u7cfb\u7edf\u75be\u75c5", 98723966985872850L);
        dicMap.put("\u804c\u4e1a\u6027\u76ae\u80a4\u75c5", 98723966985872851L);
        dicMap.put("\u804c\u4e1a\u6027\u773c\u75c5", 98723966985872852L);
        dicMap.put("\u804c\u4e1a\u6027\u8033\u9f3b\u5589\u53e3\u8154\u75be\u75c5", 98723966985872853L);
        dicMap.put("\u804c\u4e1a\u6027\u5316\u5b66\u4e2d\u6bd2", 98723966985872854L);
        dicMap.put("\u7269\u7406\u56e0\u7d20\u6240\u81f4\u804c\u4e1a\u75c5", 98723966985872855L);
        dicMap.put("\u804c\u4e1a\u6027\u653e\u5c04\u6027\u75be\u75c5", 98723966985872856L);
        dicMap.put("\u804c\u4e1a\u6027\u4f20\u67d3\u75c5", 98723966985872858L);
        dicMap.put("\u804c\u4e1a\u6027\u80bf\u7624", 98723966985872859L);
        dicMap.put("\u5176\u4ed6\u804c\u4e1a\u75c5", 98723966985872861L);
    }
}

