/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.task;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import cn.smarthse.common.framework.beans.OssClientBean;
import cn.smarthse.common.framework.file.FileUploadSimple;
import cn.smarthse.common.framework.file.UploadFileParameter;
import cn.smarthse.common.framework.file.UploadFilePathEnum;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.email.IEmailService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.supervise.entity.keyIndustryTrain.KeyIndustryTrain;
import cn.smarthse.modules.health.supervise.enums.keyIndustryTrain.KeyIndustryTrainStatusEnum;
import cn.smarthse.modules.health.supervise.enums.keyIndustryTrain.VideoSlicingStatusEnum;
import cn.smarthse.modules.health.supervise.service.keyIndustryTrain.IKeyIndustryTrainService;
import cn.smarthse.modules.kafka.model.EmailModel;
import cn.smarthse.modules.uploader.FileResourceEnum;
import cn.smarthse.modules.uploader.m3u8.FFmpegUtils;
import cn.smarthse.modules.uploader.m3u8.TranscodeConfig;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import tk.mybatis.mapper.entity.Example;

@Component
public class VideoTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VideoTask.class);
    @Autowired
    private IKeyIndustryTrainService keyIndustryTrainService;
    @DubboReference
    private ISysFileProvideService sysFileProvideService;
    @Autowired
    private OssClientBean ossClientBean;
    @DubboReference(version="1.0.0")
    private IEmailService emailService;

    @XxlJob(value="videoJobHandler")
    public void videoJobHandler() {
        Example example = new Example(KeyIndustryTrain.class);
        example.createCriteria().andIsNotNull("videoFileId").andEqualTo("isValid", (Object)Boolean.TRUE).andIn("videoSlicingStatus", Arrays.asList(VideoSlicingStatusEnum.NOT.getCode(), VideoSlicingStatusEnum.FAIL.getCode())).andEqualTo("status", (Object)KeyIndustryTrainStatusEnum.SUBMIT.getCode());
        List list = this.keyIndustryTrainService.getListByExample(example);
        if (CollUtil.isEmpty((Collection)list)) {
            return;
        }
        ExecutorService executorService = Executors.newFixedThreadPool(list.size());
        list.forEach(keyIndustryTrain -> executorService.execute(() -> {
            File destFile;
            Object realPath;
            block17: {
                block18: {
                    block15: {
                        block16: {
                            realPath = "";
                            destFile = null;
                            try {
                                SysFileModel sysFileModel = this.sysFileProvideService.getFileById(keyIndustryTrain.getVideoFileId());
                                String fileUrl = sysFileModel.getFullOssurl();
                                if (StrUtil.isBlank((CharSequence)fileUrl)) {
                                    this.keyIndustryTrainService.updateVideoSlicingStatus(keyIndustryTrain.getId(), VideoSlicingStatusEnum.FAIL.getCode(), null);
                                    return;
                                }
                                String uploadDir = UploadFileParameter.FILE_PATH + FileResourceEnum.supervise_05.getCode() + File.separator + UploadFilePathEnum.M3U8.getPath() + File.separator + FileUploadSimple.getDataPath() + File.separator + FileUploadSimple.getNumberFile() + File.separator;
                                realPath = this.ossClientBean.getLocal() + uploadDir;
                                String ossUrl = uploadDir.replace("\\", "/") + "index.m3u8";
                                String tsUrl = uploadDir.replace("\\", "/");
                                destFile = File.createTempFile(UUID.randomUUID().toString(), sysFileModel.getFileExt());
                                if (ObjectUtil.isNull((Object)destFile)) {
                                    this.keyIndustryTrainService.updateVideoSlicingStatus(keyIndustryTrain.getId(), VideoSlicingStatusEnum.FAIL.getCode(), null);
                                    if (!StrUtil.isNotBlank((CharSequence)realPath)) break block15;
                                    break block16;
                                }
                                HttpUtil.downloadFile((String)fileUrl, (File)destFile);
                                log.info("\u5f00\u59cb\u8f6c\u7801\u6587\u4ef6\u76ee\u5f55\uff1a{}", (Object)destFile.getAbsoluteFile());
                                this.keyIndustryTrainService.updateVideoSlicingStatus(keyIndustryTrain.getId(), VideoSlicingStatusEnum.IN.getCode(), null);
                                FFmpegUtils.transcodeToM3u8((String)destFile.getAbsolutePath(), (String)realPath, (TranscodeConfig)new TranscodeConfig());
                                File[] files = new File((String)realPath).listFiles();
                                if (files != null) {
                                    for (File file : files) {
                                        if (!file.getName().endsWith(".m3u8") && !file.getName().endsWith(".ts") && !file.getName().endsWith(".jpg") && !file.getName().equals("key") || !this.ossClientBean.isAsynch()) continue;
                                        this.ossClientBean.OSSPutObject(file.getName(), file, tsUrl, file.getName());
                                    }
                                }
                                log.info("\u5b8c\u6210\u8f6c\u7801\u6587\u4ef6\u76ee\u5f55\uff1a{}", (Object)destFile.getAbsoluteFile());
                                SysFileModel addSysFileModel = new SysFileModel();
                                addSysFileModel.setResource(Integer.valueOf(FileResourceEnum.supervise_05.getValue()));
                                addSysFileModel.setFileName(destFile.getName());
                                addSysFileModel.setFileSize(String.valueOf(FileUtil.size((File)destFile)));
                                addSysFileModel.setFileExt("m3u8");
                                addSysFileModel.setFileHash(String.valueOf(FileUtils.checksumCRC32((File)destFile)));
                                addSysFileModel.setOssUrl(ossUrl);
                                addSysFileModel = this.sysFileProvideService.addSysFile(addSysFileModel, Long.valueOf(0L));
                                this.keyIndustryTrainService.updateVideoSlicingStatus(keyIndustryTrain.getId(), VideoSlicingStatusEnum.SUCCESS.getCode(), addSysFileModel.getId());
                                if (!StrUtil.isNotBlank((CharSequence)realPath)) break block17;
                                break block18;
                            }
                            catch (Exception e) {
                                log.error("\u8f6c\u7801\u5f02\u5e38\uff1a", (Throwable)e);
                                this.keyIndustryTrainService.updateVideoSlicingStatus(keyIndustryTrain.getId(), VideoSlicingStatusEnum.FAIL.getCode(), null);
                                try {
                                    EmailModel emailModel = new EmailModel();
                                    emailModel.setReceivers(new String[]{"985025327@qq.com"});
                                    emailModel.setSubject("\u91cd\u70b9\u884c\u4e1a\u57f9\u8bad\u89c6\u9891\u8f6c\u7801\u51fa\u9519\u4e86");
                                    emailModel.setEmailContent(String.format("\u8f6c\u7801\u5f02\u5e38\uff1aid\uff1a%s trainProjName\uff1a%s %s", keyIndustryTrain.getId(), keyIndustryTrain.getTrainProjName(), e.getMessage()));
                                    this.emailService.sendEmail(emailModel, new Date());
                                    return;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                    return;
                                }
                            }
                        }
                        FileUtil.del((String)realPath);
                    }
                    if (!ObjectUtil.isNotNull((Object)destFile)) return;
                    FileUtil.del((File)destFile);
                    return;
                }
                FileUtil.del((String)realPath);
            }
            if (!ObjectUtil.isNotNull((Object)destFile)) return;
            FileUtil.del((File)destFile);
            return;
            finally {
                if (StrUtil.isNotBlank((CharSequence)realPath)) {
                    FileUtil.del((String)realPath);
                }
                if (ObjectUtil.isNotNull(destFile)) {
                    FileUtil.del(destFile);
                }
            }
        }));
    }
}

