/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.task;

import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.datacentre.provider.sms.ISMSProviderService;
import cn.smarthse.modules.health.supervise.entity.sys.Param;
import cn.smarthse.modules.health.supervise.home.entity.ComExpireDate;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationService;
import cn.smarthse.modules.health.supervise.service.sys.IParamService;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

@Component
@EnableScheduling
public class ScheduleTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScheduleTask.class);
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IParamService paramService;
    @Autowired
    private IOrganizationService organizationService;
    @DubboReference(version="1.0.0")
    private ISMSProviderService smsProviderService;

    @XxlJob(value="ScheduleTask-setCompanySupervisionUnit")
    public void setCompanySupervisionUnit() {
        long beginTime = new Date().getTime();
        this.logger.info("--------\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb-------\u4f01\u4e1a(\u6d59\u6c5f\u8303\u56f4)\u6ca1\u6709\u586b\u5199\u76d1\u7763\u5355\u4f4d\u7684\uff0c\u8bbe\u7f6e\u9ed8\u8ba4\u76d1\u7763\u5355\u4f4d");
        this.organizationService.setCompanySupervisionUnit();
        this.logger.info("--------\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f-------\u4f01\u4e1a(\u6d59\u6c5f\u8303\u56f4)\u6ca1\u6709\u586b\u5199\u76d1\u7763\u5355\u4f4d\u7684\uff0c\u8bbe\u7f6e\u9ed8\u8ba4\u76d1\u7763\u5355\u4f4d\uff0c\u8017\u65f6\uff1a" + (new Date().getTime() - beginTime) + "----------------");
    }

    @XxlJob(value="ScheduleTask-generateAllOrganizationAncestorIdTree")
    public void generateAllOrganizationAncestorIdTree() {
        StopWatch sw = new StopWatch("\u7edf\u8ba1\u6240\u6709\u76d1\u7ba1id\u7956\u5148id\u6811");
        log.info("[{}]\u5f00\u59cb\u6267\u884c", (Object)sw.getId());
        sw.start();
        this.organizationService.generateAllOrganizationAncestorIdTree();
        sw.stop();
        log.info("[{}]\u6267\u884c\u7ed3\u675f\uff0c\u603b\u8017\u65f6::{}\u79d2", (Object)sw.getId(), (Object)sw.getTotalTimeSeconds());
    }

    public void tm1() {
        this.logger.info("\u5b9a\u65f6\u4efb\u52a1........Scheduled task");
    }

    public void checkComExpireDateSendMsg() {
        this.logger.info("\u68c0\u67e5\u4f01\u4e1a\u68c0\u6d4b\u548c\u4f53\u68c0\u8fc7\u671f\u65f6\u95f4\u662f\u5426\u5feb\u5230\u671f,\u7136\u540e\u53d1\u77ed\u4fe1");
    }

    private void sendMsg(ComExpireDate com) {
        List<Param> params = this.getSmsParam(com);
        if (params == null || params.isEmpty()) {
            return;
        }
        this.sendCheckMsg(params, com.getHcCheckPlanExpireDate(), "check_sms_time", "check_sms_template", com.getOccManagerTel());
        this.sendCheckMsg(params, com.getPhysicalCheckExpireDate(), "exam_sms_time", "exam_sms_template", com.getOccManagerTel());
    }

    private void sendCheckMsg(List<Param> params, Date expireDate, String timeKey, String templateKey, String phone) {
        if (expireDate == null) {
            return;
        }
        Param param = this.getParam(params, timeKey);
        if (param == null) {
            return;
        }
        Long areaId = param.getAreaId();
        String key = "sms_area_" + areaId;
        Param forbiddenParam = this.paramService.getByKeyAndArea(key, areaId);
        if (forbiddenParam != null && Boolean.TRUE.equals(forbiddenParam.getIsForbidden())) {
            return;
        }
        String value = param.getParamValue();
        try {
            Param templateParam;
            int month = Integer.parseInt(value);
            long m = DateUtil.caculateMonths((LocalDate)LocalDate.now(), (LocalDate)DateUtil.getFromDate((Date)expireDate).toLocalDate());
            if (m <= (long)month && m > 0L && (templateParam = this.getParam(params, templateKey)) != null) {
                String text = templateParam.getParamValue();
                text = text.replace("##", DateUtil.format((Date)expireDate, (String)"yyyy-MM-dd"));
                this.logger.info("\u53d1\u9001\u68c0\u6d4b\uff08\u4f53\u68c0\uff09\u901a\u77e5\u77ed\u4fe1,phone:{}", (Object)phone);
                this.smsProviderService.sendTextSms(text, phone);
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            this.logger.error("\u6708\u4efd\u8bbe\u7f6e\u53c2\u6570\u975e\u6cd5", (Throwable)e);
        }
    }

    private List<Param> getSmsParam(ComExpireDate com) {
        Long areaId;
        Long[] areaIds = new Long[]{com.getStreetId(), com.getAreaId(), com.getCityId(), com.getProvinceId()};
        List params = null;
        Long[] longArray = areaIds;
        int n = longArray.length;
        for (int i = 0; i < n && ((params = this.paramService.getSmsParamByArea(areaId = longArray[i])) == null || params.isEmpty()); ++i) {
        }
        return params;
    }

    private Param getParam(List<Param> params, String key) {
        for (Param param : params) {
            if (!param.getParamKey().equals(key)) continue;
            return param;
        }
        return null;
    }
}

