/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.train.impl;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.entity.work.train.TrainPlanCount;
import cn.smarthse.modules.health.service.work.train.IStaffOnlineTrainTestService;
import cn.smarthse.modules.health.supervise.entity.certificate.CertificateInfo;
import cn.smarthse.modules.health.supervise.entity.trainPlan.TrainPlanCompanyInfo;
import cn.smarthse.modules.health.supervise.entity.trainPlan.TrainPlanCountQueryVo;
import cn.smarthse.modules.health.supervise.entity.trainPlan.TrainPlanInfo;
import cn.smarthse.modules.health.supervise.enums.company.CompanyCollectGroupByEnum;
import cn.smarthse.modules.health.supervise.service.certificate.ISuperviseCertificateService;
import cn.smarthse.modules.health.supervise.service.company.ICompanyService;
import cn.smarthse.modules.health.supervise.service.sys.ISuperviseSysAreaService;
import cn.smarthse.modules.health.supervise.service.train.ITrainPlanService;
import cn.smarthse.modules.health.supervise.service.trainPlan.ISuperviseTrainPlanService;
import cn.smarthse.modules.health.supervise.service.trainPlan.ITrainPlanCountService;
import com.github.pagehelper.PageInfo;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="trainPlanServiceImpl")
@DubboService
@Transactional(readOnly=true)
public class TrainPlanImpl
implements ITrainPlanService {
    @DubboReference
    ISuperviseTrainPlanService trainPlanService;
    @Autowired
    ICompanyService companyService;
    @Autowired
    ISuperviseSysAreaService sysAreaService;
    @DubboReference
    ISuperviseCertificateService superviseCertificateService;
    @DubboReference
    ITrainPlanCountService trainPlanCountService;
    @DubboReference
    private IStaffOnlineTrainTestService staffOnlineTrainTestService;

    public int getTrainNumberByYear(Long cid, Integer year) {
        int num = this.trainPlanService.trainNumberThisYear(cid, year);
        return num;
    }

    public PageInfo<TrainPlanInfo> getTrainInfoByCid(JqGridParam gparam, Long cid, Integer yearFlag) {
        if (cid == null) {
            return null;
        }
        PageInfo page = this.trainPlanService.getPreviousTrainInfo(gparam, cid, yearFlag);
        List attendVos = this.staffOnlineTrainTestService.getNeedAttends(cid);
        HashMap attendVoMap = new HashMap();
        attendVos.forEach(s -> attendVoMap.put(s.getTrainId(), s.getAttends()));
        page.getList().forEach(s -> {
            s.setNoPassCount(Long.valueOf(0L));
            s.setNotTestCount(Long.valueOf(0L));
            s.setPassCount(Long.valueOf(0L));
            if (StringUtils.isNotEmpty((String)((String)attendVoMap.get(s.getId())))) {
                for (String attend : ((String)attendVoMap.get(s.getId())).split(",")) {
                    Boolean flag = this.staffOnlineTrainTestService.isPassTestByStaffId(s.getId(), Long.valueOf(attend), cid);
                    if (flag != null) {
                        if (flag.booleanValue()) {
                            s.setPassCount(Long.valueOf(s.getPassCount() + 1L));
                            continue;
                        }
                        s.setNoPassCount(Long.valueOf(s.getNoPassCount() + 1L));
                        continue;
                    }
                    s.setNotTestCount(Long.valueOf(s.getNotTestCount() + 1L));
                }
            }
        });
        return page;
    }

    public PageInfo<CertificateInfo> getCertificateInfoByCid(JqGridParam param, Long cid) {
        if (cid == null) {
            return null;
        }
        param.setCid(cid);
        PageInfo page = this.superviseCertificateService.getPreviousCertificateInfo(param);
        return page;
    }

    public List<CertificateInfo> getCertificateInfoByCidList(Long cid) {
        List list = this.superviseCertificateService.getPreviousCertificateInfoList(cid);
        return list;
    }

    public PageInfo<TrainPlanCount> getCountPageByArea(JqGridParam param, TrainPlanCountQueryVo vo, String path) {
        PageInfo page = this.trainPlanCountService.getCountPageByArea(param, vo);
        Integer areaLevel = vo.getAreaLevel() + 1;
        if (page.getList() != null && page.getList().size() > 0) {
            for (TrainPlanCount info : page.getList()) {
                float equipmentRate = 0.0f;
                float mainHseManaRate = 0.0f;
                float trainRate = 0.0f;
                if (info.getManaTrainInfo() == null) {
                    info.setManaTrainInfo(Integer.valueOf(0));
                }
                DecimalFormat df = new DecimalFormat("0.00");
                if (info.getComNum() != null && info.getComNum() != 0) {
                    if (info.getEquipmentRate() == null) {
                        info.setEquipmentRate(Float.valueOf(0.0f));
                    }
                    equipmentRate = Float.parseFloat(df.format(info.getEquipmentRate().floatValue() * 100.0f));
                    if (info.getMainHseManaRate() == null) {
                        info.setMainHseManaRate(Float.valueOf(0.0f));
                    }
                    mainHseManaRate = Float.parseFloat(df.format(info.getMainHseManaRate().floatValue() * 100.0f));
                    if (info.getTrainRate() == null) {
                        info.setTrainRate(Float.valueOf(0.0f));
                    }
                    trainRate = Float.parseFloat(df.format(info.getTrainRate().floatValue() * 100.0f));
                }
                info.setEquipmentRateStr(equipmentRate + "%");
                info.setMainHseManaRateStr(mainHseManaRate + "%");
                info.setTrainRateStr(trainRate + "%");
                Integer level = 4;
                if (info.getTypeName() == null) {
                    info.setTypeName("\u672a\u5212\u5206\u533a\u57df");
                }
                this.setdefaultData(info);
                if (info.getAreaId() == null || areaLevel.equals(level) || info.getAreaId() == 1L || info.getAreaId() == 2L) continue;
                String url = path + "/trainPlan/countByArea?areaId=" + info.getAreaId() + "&areaLevel=" + areaLevel;
                String str = "<a href='" + url + "'   style='color:#6FB3E0' >" + info.getTypeName() + "</a>";
                info.setTypeName(str);
            }
        }
        return page;
    }

    public TrainPlanCount getCountData(TrainPlanCountQueryVo vo) {
        if (vo.getStartTrainDate() == null && vo.getEndTrainDate() == null) {
            vo.setStartTrainDate(DateUtils.getYearFirstDay((int)DateUtils.getThisYear()));
            vo.setEndTrainDate(DateUtils.getYearLastDay((int)DateUtils.getThisYear()));
        }
        List list = this.trainPlanCountService.getCountData(vo);
        float equipmentRate = 0.0f;
        float mainHseManaRate = 0.0f;
        float trainRate = 0.0f;
        if (list != null && list.size() > 0) {
            TrainPlanCount info = (TrainPlanCount)list.get(0);
            DecimalFormat df = new DecimalFormat("0.00");
            if (info.getManaTrainInfo() == null) {
                info.setManaTrainInfo(Integer.valueOf(0));
            }
            if (info.getComNum() != null && info.getComNum() != 0) {
                if (info.getEquipmentRate() == null) {
                    info.setEquipmentRate(Float.valueOf(0.0f));
                }
                equipmentRate = Float.parseFloat(df.format(info.getEquipmentRate().floatValue() * 100.0f));
                if (info.getMainHseManaRate() == null) {
                    info.setMainHseManaRate(Float.valueOf(0.0f));
                }
                mainHseManaRate = Float.parseFloat(df.format(info.getMainHseManaRate().floatValue() * 100.0f));
                if (info.getTrainRate() == null) {
                    info.setTrainRate(Float.valueOf(0.0f));
                }
                trainRate = Float.parseFloat(df.format(info.getTrainRate().floatValue() * 100.0f));
            }
            info.setEquipmentRateStr(equipmentRate + "%");
            info.setMainHseManaRateStr(mainHseManaRate + "%");
            info.setTrainRateStr(trainRate + "%");
            this.setdefaultData(info);
            return info;
        }
        return null;
    }

    public PageInfo<TrainPlanCount> getCountPageByRegistrationType(JqGridParam param, TrainPlanCountQueryVo vo) {
        PageInfo page = this.trainPlanCountService.getCountPageByRegistrationType(param, vo);
        if (page.getList() != null && page.getList().size() > 0) {
            for (TrainPlanCount info : page.getList()) {
                float equipmentRate = 0.0f;
                float mainHseManaRate = 0.0f;
                float trainRate = 0.0f;
                if (info.getManaTrainInfo() == null) {
                    info.setManaTrainInfo(Integer.valueOf(0));
                }
                DecimalFormat df = new DecimalFormat("0.00");
                if (info.getComNum() != null && info.getComNum() != 0) {
                    if (info.getEquipmentRate() == null) {
                        info.setEquipmentRate(Float.valueOf(0.0f));
                    }
                    equipmentRate = Float.parseFloat(df.format(info.getEquipmentRate().floatValue() * 100.0f));
                    if (info.getMainHseManaRate() == null) {
                        info.setMainHseManaRate(Float.valueOf(0.0f));
                    }
                    mainHseManaRate = Float.parseFloat(df.format(info.getMainHseManaRate().floatValue() * 100.0f));
                    if (info.getTrainRate() == null) {
                        info.setTrainRate(Float.valueOf(0.0f));
                    }
                    trainRate = Float.parseFloat(df.format(info.getTrainRate().floatValue() * 100.0f));
                }
                info.setEquipmentRateStr(equipmentRate + "%");
                info.setMainHseManaRateStr(mainHseManaRate + "%");
                info.setTrainRateStr(trainRate + "%");
                if (info.getTypeName() == null) {
                    info.setTypeName("\u627e\u4e0d\u5230\u5206\u7c7b");
                }
                this.setdefaultData(info);
            }
        }
        return page;
    }

    public PageInfo<TrainPlanCount> getCountPageByIndustry(JqGridParam param, TrainPlanCountQueryVo vo) {
        PageInfo page = this.trainPlanCountService.getCountPageByIndustry(param, vo);
        if (page.getList() != null && page.getList().size() > 0) {
            for (TrainPlanCount info : page.getList()) {
                float equipmentRate = 0.0f;
                float mainHseManaRate = 0.0f;
                float trainRate = 0.0f;
                DecimalFormat df = new DecimalFormat("0.00");
                if (info.getManaTrainInfo() == null) {
                    info.setManaTrainInfo(Integer.valueOf(0));
                }
                if (info.getComNum() != null && info.getComNum() != 0) {
                    if (info.getEquipmentRate() == null) {
                        info.setEquipmentRate(Float.valueOf(0.0f));
                    }
                    equipmentRate = Float.parseFloat(df.format(info.getEquipmentRate().floatValue() * 100.0f));
                    if (info.getMainHseManaRate() == null) {
                        info.setMainHseManaRate(Float.valueOf(0.0f));
                    }
                    mainHseManaRate = Float.parseFloat(df.format(info.getMainHseManaRate().floatValue() * 100.0f));
                    if (info.getTrainRate() == null) {
                        info.setTrainRate(Float.valueOf(0.0f));
                    }
                    trainRate = Float.parseFloat(df.format(info.getTrainRate().floatValue() * 100.0f));
                }
                info.setEquipmentRateStr(equipmentRate + "%");
                info.setMainHseManaRateStr(mainHseManaRate + "%");
                info.setTrainRateStr(trainRate + "%");
                if (info.getTypeName() == null) {
                    info.setTypeName("\u627e\u4e0d\u5230\u5206\u7c7b");
                }
                this.setdefaultData(info);
            }
        }
        return page;
    }

    public PageInfo<TrainPlanCount> getCountPageByScale(JqGridParam param, TrainPlanCountQueryVo vo) {
        PageInfo page = this.trainPlanCountService.getCountPageByScale(param, vo);
        if (page.getList() != null && page.getList().size() > 0) {
            for (TrainPlanCount info : page.getList()) {
                float equipmentRate = 0.0f;
                float mainHseManaRate = 0.0f;
                float trainRate = 0.0f;
                DecimalFormat df = new DecimalFormat("0.00");
                if (info.getManaTrainInfo() == null) {
                    info.setManaTrainInfo(Integer.valueOf(0));
                }
                if (info.getComNum() != null && info.getComNum() != 0) {
                    if (info.getEquipmentRate() == null) {
                        info.setEquipmentRate(Float.valueOf(0.0f));
                    }
                    equipmentRate = Float.parseFloat(df.format(info.getEquipmentRate().floatValue() * 100.0f));
                    if (info.getMainHseManaRate() == null) {
                        info.setMainHseManaRate(Float.valueOf(0.0f));
                    }
                    mainHseManaRate = Float.parseFloat(df.format(info.getMainHseManaRate().floatValue() * 100.0f));
                    if (info.getTrainRate() == null) {
                        info.setTrainRate(Float.valueOf(0.0f));
                    }
                    trainRate = Float.parseFloat(df.format(info.getTrainRate().floatValue() * 100.0f));
                }
                info.setEquipmentRateStr(equipmentRate + "%");
                info.setMainHseManaRateStr(mainHseManaRate + "%");
                info.setTrainRateStr(trainRate + "%");
                if (info.getTypeName() == null) {
                    info.setTypeName("\u627e\u4e0d\u5230\u5206\u7c7b");
                }
                this.setdefaultData(info);
            }
        }
        return page;
    }

    public PageInfo<TrainPlanCount> getCountPageByRisk(JqGridParam param, TrainPlanCountQueryVo vo) {
        PageInfo page = this.trainPlanCountService.getCountPageByRisk(param, vo);
        if (page.getList() != null && page.getList().size() > 0) {
            for (TrainPlanCount info : page.getList()) {
                float equipmentRate = 0.0f;
                float mainHseManaRate = 0.0f;
                float trainRate = 0.0f;
                DecimalFormat df = new DecimalFormat("0.00");
                if (info.getManaTrainInfo() == null) {
                    info.setManaTrainInfo(Integer.valueOf(0));
                }
                if (info.getComNum() != null && info.getComNum() != 0) {
                    if (info.getEquipmentRate() == null) {
                        info.setEquipmentRate(Float.valueOf(0.0f));
                    }
                    equipmentRate = Float.parseFloat(df.format(info.getEquipmentRate().floatValue() * 100.0f));
                    if (info.getMainHseManaRate() == null) {
                        info.setMainHseManaRate(Float.valueOf(0.0f));
                    }
                    mainHseManaRate = Float.parseFloat(df.format(info.getMainHseManaRate().floatValue() * 100.0f));
                    if (info.getTrainRate() == null) {
                        info.setTrainRate(Float.valueOf(0.0f));
                    }
                    trainRate = Float.parseFloat(df.format(info.getTrainRate().floatValue() * 100.0f));
                }
                info.setEquipmentRateStr(equipmentRate + "%");
                info.setMainHseManaRateStr(mainHseManaRate + "%");
                info.setTrainRateStr(trainRate + "%");
                if (info.getTypeName() == null) {
                    info.setTypeName("\u627e\u4e0d\u5230\u5206\u7c7b");
                }
                this.setdefaultData(info);
            }
        }
        return page;
    }

    public List<TrainPlanCount> getTrainCountList(CompanyCollectGroupByEnum typeEnum, TrainPlanCountQueryVo trainCountParam) {
        List list = this.trainPlanCountService.getCountList(trainCountParam, typeEnum);
        if (list != null) {
            for (TrainPlanCount info : list) {
                float equipmentRate = 0.0f;
                float mainHseManaRate = 0.0f;
                float trainRate = 0.0f;
                DecimalFormat df = new DecimalFormat("0.00");
                if (info.getComNum() != null && info.getComNum() != 0) {
                    if (info.getEquipmentRate() == null) {
                        info.setEquipmentRate(Float.valueOf(0.0f));
                    }
                    equipmentRate = Float.parseFloat(df.format(info.getEquipmentRate().floatValue() * 100.0f));
                    if (info.getMainHseManaRate() == null) {
                        info.setMainHseManaRate(Float.valueOf(0.0f));
                    }
                    mainHseManaRate = Float.parseFloat(df.format(info.getMainHseManaRate().floatValue() * 100.0f));
                    if (info.getTrainRate() == null) {
                        info.setTrainRate(Float.valueOf(0.0f));
                    }
                    trainRate = Float.parseFloat(df.format(info.getTrainRate().floatValue() * 100.0f));
                }
                info.setEquipmentRateStr(equipmentRate + "%");
                info.setMainHseManaRateStr(mainHseManaRate + "%");
                info.setTrainRateStr(trainRate + "%");
                if (info.getTypeName() == null) {
                    info.setTypeName("\u627e\u4e0d\u5230\u5206\u7c7b");
                }
                this.setdefaultData(info);
            }
        }
        return list;
    }

    public String getTrainRateStr(Long areaId, Byte areaLevel) {
        Double trainRate = this.trainPlanCountService.getTrainRate(areaId, areaLevel);
        NumberFormat nf = NumberFormat.getPercentInstance();
        nf.setMaximumIntegerDigits(2);
        nf.setMinimumFractionDigits(2);
        if (trainRate != null) {
            return nf.format(trainRate);
        }
        return "-";
    }

    private void setdefaultData(TrainPlanCount info) {
        if (info.getComNum() == null || info.getComNum() == 0) {
            info.setComNum(Integer.valueOf(0));
            info.setFullTimeNum(Integer.valueOf(0));
            info.setPartTimeNum(Integer.valueOf(0));
            info.setCertEffectiveNum(Integer.valueOf(0));
            info.setCertEffectiveNumMain(Integer.valueOf(0));
            info.setManaTrainInfo(Integer.valueOf(0));
            info.setManagerNum(Integer.valueOf(0));
            info.setEquipmentHseMana(Integer.valueOf(0));
            info.setMainHseMana(Integer.valueOf(0));
            info.setEquipmentRateStr("0.0%");
            info.setMainHseManaRateStr("0.0%");
            info.setTrainRateStr("0.0%");
        }
        if (info.getCertEffectiveNum() == null) {
            info.setCertEffectiveNum(Integer.valueOf(0));
        }
        if (info.getCertEffectiveNumMain() == null) {
            info.setCertEffectiveNumMain(Integer.valueOf(0));
        }
        if (info.getManagerNum() == null) {
            info.setManagerNum(Integer.valueOf(0));
        }
        if (info.getPartTimeNum() == null) {
            info.setPartTimeNum(Integer.valueOf(0));
        }
        if (info.getFullTimeNum() == null) {
            info.setFullTimeNum(Integer.valueOf(0));
        }
    }

    public int getTrainCompanyNumByAreaAndYear(Long areaId, Byte level, Integer year) {
        return this.trainPlanService.getTrainCompanyNumByAreaAndYear(areaId, level, year);
    }

    public int getTrainCompanyNumByAreaAndTime(Long areaId, Byte level, Date beginTime, Date endTime) {
        return this.trainPlanService.getTrainCompanyNumByAreaAndTime(areaId, level, beginTime, endTime, null);
    }

    public int getWillExpireMainTrainComNum(Long areaId, Byte level, Date beginTime, Date endTime) {
        return this.trainPlanService.getWillExpireMainTrainComNum(areaId, level, beginTime, endTime);
    }

    public int getExpireMainTrainComNum(Long areaId, Byte level) {
        return this.trainPlanService.getExpireMainTrainComNum(areaId, level);
    }

    public int getExpireHseTrainComNum(Long areaId, Byte level) {
        return this.trainPlanService.getExpireHseTrainComNum(areaId, level);
    }

    public int getWillExpireHseTrainComNum(Long areaId, Byte level, Date beginTime, Date endTime) {
        return this.trainPlanService.getWillExpireHseTrainComNum(areaId, level, beginTime, endTime);
    }

    public List<TrainPlanCompanyInfo> getWillExpireMainTrainComList(Long areaId, Byte level, Date beginTime, Date endTime) {
        return this.trainPlanService.getWillExpireMainTrainComList(areaId, level, beginTime, endTime);
    }

    public List<TrainPlanCompanyInfo> getExpireMainTrainComList(Long areaId, Byte level) {
        return this.trainPlanService.getExpireMainTrainComList(areaId, level);
    }

    public List<TrainPlanCompanyInfo> getExpireHseTrainComList(Long areaId, Byte level) {
        return this.trainPlanService.getExpireHseTrainComList(areaId, level);
    }

    public List<TrainPlanCompanyInfo> getWillExpireHseTrainComList(Long areaId, Byte level, Date beginTime, Date endTime) {
        return this.trainPlanService.getWillExpireHseTrainComList(areaId, level, beginTime, endTime);
    }
}

