/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.sys.impl.v3;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.supervise.dao.sys.v3.SysRoleMenuV3Mapper;
import cn.smarthse.modules.health.supervise.dao.sys.v3.SysRoleV3Mapper;
import cn.smarthse.modules.health.supervise.entity.sys.v3.SysRoleMenuV3;
import cn.smarthse.modules.health.supervise.entity.sys.v3.SysRoleV3;
import cn.smarthse.modules.health.supervise.model.sys.v3.role.SysRoleV3AddParam;
import cn.smarthse.modules.health.supervise.model.sys.v3.role.SysRoleV3ChangePermissionDto;
import cn.smarthse.modules.health.supervise.model.sys.v3.role.SysRoleV3ChangePermissionsParam;
import cn.smarthse.modules.health.supervise.model.sys.v3.role.SysRoleV3EditParam;
import cn.smarthse.modules.health.supervise.model.sys.v3.role.SysRoleV3ListParam;
import cn.smarthse.modules.health.supervise.service.sys.v3.ISysRoleV3Service;
import cn.smarthse.modules.health.supervise.vo.sys.v3.organization.OrganizationUserV3ListVo;
import cn.smarthse.modules.health.supervise.vo.sys.v3.role.SysRoleV3SelectVo;
import cn.smarthse.modules.health.supervise.vo.sys.v3.role.SysRoleV3Vo;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.HealthException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@DubboService
@Transactional(readOnly=true)
public class SysRoleV3ServiceImpl
extends BaseServiceImpl<SysRoleV3Mapper, SysRoleV3>
implements ISysRoleV3Service {
    private final SysRoleMenuV3Mapper sysRoleMenuV3Mapper;

    public Set<String> selectJGRolePermissionByUserId(Long userId) {
        return ((SysRoleV3Mapper)this.dao).selectJGRolePermissionByUserId(userId);
    }

    public List<SysRoleV3Vo> selectRoleListByUserId(Long userId) {
        return this.selectJGRoleListByUserIdList(Collections.singletonList(userId)).get(userId);
    }

    public Map<Long, List<SysRoleV3Vo>> selectJGRoleListByUserIdList(List<Long> userIdList) {
        List<SysRoleV3Vo> list = ((SysRoleV3Mapper)this.dao).selectJGRoleListByUserIdList(userIdList);
        if (CollUtil.isEmpty(list)) {
            return Collections.emptyMap();
        }
        return list.stream().collect(Collectors.groupingBy(SysRoleV3Vo::getUserId));
    }

    public SysRoleV3SelectVo selectRoleSelectList(SysRoleV3ListParam param) {
        ArrayList<SysRoleV3Vo> rst = new ArrayList<SysRoleV3Vo>();
        rst.addAll(((SysRoleV3Mapper)this.dao).selectSysRoleListByLevel(param));
        List<SysRoleV3Vo> roleV3VoList = ((SysRoleV3Mapper)this.dao).selectAllRoleListByOid(param.getSystemWide(), param.getOrgId());
        return new SysRoleV3SelectVo().setHaveManager(Boolean.valueOf(CollUtil.isNotEmpty(roleV3VoList) && roleV3VoList.stream().anyMatch(i -> i.getIsManger() == 1))).setItems(rst.stream().distinct().sorted(Comparator.comparing(SysRoleV3Vo::getLevel).thenComparing(SysRoleV3Vo::getRoleSort)).collect(Collectors.toList()));
    }

    public PageInfo<SysRoleV3Vo> selectRoleList(SysRoleV3ListParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<SysRoleV3Vo> rst = ((SysRoleV3Mapper)this.dao).selectRoleListBySystemWide(param.getSystemWide());
        return new PageInfo(rst);
    }

    public PageInfo<SysRoleV3Vo> selectRoleForComList(SysRoleV3ListParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<SysRoleV3Vo> rst = ((SysRoleV3Mapper)this.dao).selectRoleForComListBySystemWide(param.getSystemWide());
        return new PageInfo(rst);
    }

    public SysRoleV3Vo selectRoleById(Long roleId) {
        SysRoleV3 role = (SysRoleV3)this.getById(roleId);
        if (Objects.isNull(role) || !Objects.equals(role.getIsValid(), Boolean.TRUE)) {
            throw new HealthException("\u8be5\u89d2\u8272\u5df2\u4e0d\u5b58\u5728");
        }
        return new SysRoleV3Vo().setRoleId(role.getRoleId()).setRoleName(role.getRoleName()).setRoleKey(role.getRoleKey()).setDescription(role.getDescription()).setRoleSort(role.getRoleSort()).setLevel(role.getLevel()).setIsManger(role.getIsManger()).setIsSys(role.getIsSys()).setIsTest(role.getIsTest()).setIsShow(role.getIsShow()).setCreateBy(role.getCreateBy()).setSystemWide(role.getSystemWide()).setSystemWideMenu(role.getSystemWideMenu());
    }

    public boolean checkRoleKeyUnique(String roleKey, Long roleId) {
        Example example = new Example(SysRoleV3.class);
        Example.Criteria c = example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("roleKey", (Object)roleKey);
        if (ObjectUtil.isNotNull((Object)roleId)) {
            c.andNotEqualTo("roleId", (Object)roleId);
        }
        return ((SysRoleV3Mapper)this.dao).selectCountByExample(example) == 0;
    }

    @Transactional
    public int insertRole(SysRoleV3AddParam param) {
        if (param.getIsManger() == 1) {
            SysRoleV3ListParam param2 = new SysRoleV3ListParam();
            param2.setLevel(param.getLevel());
            List<SysRoleV3Vo> list = ((SysRoleV3Mapper)this.dao).selectSysRoleListByLevel(param2);
            if (CollUtil.isNotEmpty(list) && list.stream().anyMatch(i -> i.getIsManger() == 1) && !StrUtil.contains((CharSequence)param.getRoleName(), (CharSequence)"\u8bd5\u70b9")) {
                throw new HealthException("\u65b0\u589e\u5931\u8d25\uff0c\u8be5\u7ea7\u522b\u4e0b\u5df2\u5b58\u5728\u7ba1\u7406\u5458\u89d2\u8272 \u3010\u5982\u679c\u4e00\u5b9a\u8981\u6dfb\u52a0\u7ba1\u7406\u5458\u89d2\u8272\uff0c\u8bf7\u5728\u540d\u79f0\u4e2d\u6dfb\u52a0\u201c\u8bd5\u70b9\u201d\u4e8c\u5b57\u3011");
            }
        }
        SysRoleV3 entity = new SysRoleV3();
        entity.setRoleId(Long.valueOf(IdWorker.getId()));
        entity.setRoleName(param.getRoleName());
        entity.setRoleKey(param.getRoleKey());
        entity.setDescription(param.getDescription());
        entity.setRoleSort(param.getRoleSort());
        entity.setLevel(param.getLevel());
        entity.setIsManger(param.getIsManger());
        entity.setIsSys(param.getIsSys());
        entity.setIsTest(param.getIsTest());
        entity.setIsShow(param.getIsShow());
        entity.setCreateBy(param.getLoginUserId());
        entity.setUpdateBy(param.getLoginUserId());
        entity.setSystemWide(param.getSystemWide());
        entity.setSystemWideMenu(param.getSystemWideMenu());
        return ((SysRoleV3Mapper)this.dao).insertSelective(entity);
    }

    @Transactional
    public int updateRole(SysRoleV3EditParam param) {
        if (param.getRoleId() < 1000L) {
            throw new HealthException("\u66f4\u65b0\u5931\u8d25\uff0c\u5f00\u53d1\u8005\u5f3a\u5236\u9650\u5236");
        }
        SysRoleV3 role = (SysRoleV3)this.getById(param.getRoleId());
        if (Objects.isNull(role) || !Objects.equals(role.getIsValid(), Boolean.TRUE)) {
            throw new HealthException("\u8be5\u89d2\u8272\u5df2\u4e0d\u5b58\u5728");
        }
        if (role.getIsSys() == 1 && param.getUserAreaLevel() > 0) {
            throw new HealthException("\u66f4\u65b0\u5931\u8d25\uff0c\u8be5\u89d2\u8272\u4e3a\u7cfb\u7edf\u9ed8\u8ba4\u89d2\u8272");
        }
        if (param.getIsManger() == 1 && role.getIsManger() != 1) {
            SysRoleV3ListParam param2 = new SysRoleV3ListParam();
            param2.setLevel(param.getLevel());
            List<SysRoleV3Vo> list = ((SysRoleV3Mapper)this.dao).selectSysRoleListByLevel(param2);
            if (CollUtil.isNotEmpty(list) && list.stream().anyMatch(i -> i.getIsManger() == 1) && !StrUtil.contains((CharSequence)param.getRoleName(), (CharSequence)"\u8bd5\u70b9")) {
                throw new HealthException("\u66f4\u65b0\u5931\u8d25\uff0c\u8be5\u7ea7\u522b\u4e0b\u5df2\u5b58\u5728\u7ba1\u7406\u5458\u89d2\u8272 \u3010\u5982\u679c\u4e00\u5b9a\u8981\u4fee\u6539\u4e3a\u7ba1\u7406\u5458\u89d2\u8272\uff0c\u8bf7\u5728\u540d\u79f0\u4e2d\u6dfb\u52a0\u201c\u8bd5\u70b9\u201d\u4e8c\u5b57\u3011");
            }
        }
        SysRoleV3 entity = new SysRoleV3();
        entity.setRoleId(param.getRoleId());
        entity.setRoleName(param.getRoleName());
        entity.setRoleKey(param.getRoleKey());
        entity.setDescription(param.getDescription());
        entity.setRoleSort(param.getRoleSort());
        entity.setLevel(param.getLevel());
        entity.setIsManger(param.getIsManger());
        entity.setIsSys(param.getIsSys());
        entity.setIsTest(param.getIsTest());
        entity.setIsShow(param.getIsShow());
        entity.setUpdateBy(param.getLoginUserId());
        entity.setSystemWideMenu(param.getSystemWideMenu());
        int i2 = ((SysRoleV3Mapper)this.dao).updateByPrimaryKeySelective(entity);
        if (i2 > 0) {
            ((SysRoleV3Mapper)this.dao).updateUserRedundantByRoleId(entity);
        }
        return i2;
    }

    @Transactional
    public int deleteRoleById(Long roleId, Long loginUserId, Byte userAreaLevel) {
        if (roleId < 400L) {
            throw new HealthException("\u5220\u9664\u5931\u8d25\uff0c\u5f00\u53d1\u8005\u5f3a\u5236\u9650\u5236");
        }
        SysRoleV3 role = (SysRoleV3)this.getById(roleId);
        if (Objects.isNull(role) || !Objects.equals(role.getIsValid(), Boolean.TRUE)) {
            throw new HealthException("\u8be5\u89d2\u8272\u5df2\u4e0d\u5b58\u5728");
        }
        if (role.getIsSys() == 1 && userAreaLevel > 0) {
            throw new HealthException("\u5220\u9664\u5931\u8d25\uff0c\u8be5\u89d2\u8272\u4e3a\u7cfb\u7edf\u9ed8\u8ba4\u89d2\u8272");
        }
        if (((SysRoleV3Mapper)this.dao).selectUserCountByRoleId(roleId) > 0) {
            throw new HealthException("\u5220\u9664\u5931\u8d25\uff0c\u8be5\u89d2\u8272\u5df2\u6709\u7528\u6237\u88ab\u6388\u4e88");
        }
        SysRoleV3 entity = new SysRoleV3();
        entity.setRoleId(roleId);
        entity.setIsValid(Boolean.valueOf(false));
        entity.setUpdateBy(loginUserId);
        SysRoleMenuV3 sysRoleMenu = new SysRoleMenuV3();
        sysRoleMenu.setIsValid(Boolean.valueOf(false));
        sysRoleMenu.setUpdateBy(loginUserId);
        Example example = new Example(SysRoleMenuV3.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("roleId", (Object)roleId);
        this.sysRoleMenuV3Mapper.updateByExampleSelective(sysRoleMenu, example);
        return ((SysRoleV3Mapper)this.dao).updateByPrimaryKeySelective(entity);
    }

    @Transactional
    public int changePermissions(SysRoleV3ChangePermissionsParam param) {
        Long roleId = param.getRoleId();
        List permissionList = param.getPermissionList();
        SysRoleV3 role = (SysRoleV3)this.getById(roleId);
        if (Objects.isNull(role) || !Objects.equals(role.getIsValid(), Boolean.TRUE)) {
            throw new HealthException("\u8be5\u89d2\u8272\u5df2\u4e0d\u5b58\u5728");
        }
        if (CollUtil.isEmpty((Collection)permissionList)) {
            throw new HealthException("\u6743\u9650\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int originalSize = permissionList.size();
        List menuIdList = permissionList.stream().map(SysRoleV3ChangePermissionDto::getMenuId).distinct().collect(Collectors.toList());
        if (menuIdList.size() < originalSize) {
            throw new HealthException("\u53bb\u91cd\u540e\u53d1\u73b0\u91cd\u590d\u7684\u83dc\u5355ID");
        }
        Set<Long> oldMenuIdSet = this.sysRoleMenuV3Mapper.selectMenuIdListByRoleIdAndSystemWide(roleId, param.getSystemWide());
        List<Object> addList = new ArrayList(originalSize);
        ArrayList<SysRoleV3ChangePermissionDto> updateList = new ArrayList<SysRoleV3ChangePermissionDto>(originalSize);
        if (CollUtil.isNotEmpty(oldMenuIdSet)) {
            Map<Long, SysRoleV3ChangePermissionDto> map = permissionList.stream().collect(Collectors.toMap(SysRoleV3ChangePermissionDto::getMenuId, i -> i, (v1, v2) -> v1));
            for (Long menuId : menuIdList) {
                if (oldMenuIdSet.contains(menuId)) {
                    updateList.add(map.get(menuId));
                    continue;
                }
                addList.add(menuId);
            }
        } else {
            addList = menuIdList;
        }
        Long loginUserId = param.getLoginUserId();
        Date now = new Date();
        if (CollUtil.isNotEmpty(addList)) {
            Map<Long, SysRoleV3ChangePermissionDto> validTrueMap = permissionList.stream().filter(SysRoleV3ChangePermissionDto::getChecked).collect(Collectors.toMap(SysRoleV3ChangePermissionDto::getMenuId, i -> i, (v1, v2) -> v2));
            ArrayList<SysRoleMenuV3> list = new ArrayList<SysRoleMenuV3>(addList.size());
            for (Long l : addList) {
                SysRoleMenuV3 sm = new SysRoleMenuV3();
                sm.setId(Long.valueOf(IdWorker.getId()));
                sm.setRoleId(roleId);
                sm.setMenuId(l);
                sm.setIsValid(Boolean.valueOf(validTrueMap.containsKey(l)));
                sm.setCreateBy(loginUserId);
                sm.setUpdateBy(loginUserId);
                sm.setCreateDate(now);
                sm.setUpdateDate(now);
                list.add(sm);
            }
            this.sysRoleMenuV3Mapper.insertList2(list);
        }
        if (CollUtil.isNotEmpty(updateList)) {
            Example example;
            Map partitioned = updateList.stream().collect(Collectors.partitioningBy(SysRoleV3ChangePermissionDto::getChecked, Collectors.mapping(SysRoleV3ChangePermissionDto::getMenuId, Collectors.toList())));
            List validTrueList = partitioned.get(true);
            List validFalseList = partitioned.get(false);
            if (!validTrueList.isEmpty()) {
                SysRoleMenuV3 sysRoleMenuV3 = new SysRoleMenuV3();
                sysRoleMenuV3.setIsValid(Boolean.valueOf(true));
                sysRoleMenuV3.setUpdateBy(loginUserId);
                sysRoleMenuV3.setUpdateDate(now);
                example = new Example(SysRoleMenuV3.class);
                example.createCriteria().andEqualTo("roleId", (Object)roleId).andEqualTo("isValid", (Object)false).andIn("menuId", validTrueList);
                this.sysRoleMenuV3Mapper.updateByExampleSelective(sysRoleMenuV3, example);
            }
            if (!validFalseList.isEmpty()) {
                SysRoleMenuV3 sysRoleMenuV3 = new SysRoleMenuV3();
                sysRoleMenuV3.setIsValid(Boolean.valueOf(false));
                sysRoleMenuV3.setUpdateBy(loginUserId);
                sysRoleMenuV3.setUpdateDate(now);
                example = new Example(SysRoleMenuV3.class);
                example.createCriteria().andEqualTo("roleId", (Object)roleId).andEqualTo("isValid", (Object)true).andIn("menuId", validFalseList);
                this.sysRoleMenuV3Mapper.updateByExampleSelective(sysRoleMenuV3, example);
            }
        }
        return 1;
    }

    public String getThirdRoleKey(Integer orgType) {
        return ((SysRoleV3Mapper)this.dao).selectThirdRolePermissionByCid(orgType);
    }

    public PageInfo<OrganizationUserV3ListVo> selectUserByRoleId(JqGridParam jqGridParam, Long roleId) {
        PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        return new PageInfo(((SysRoleV3Mapper)this.dao).selectUserByRoleId(roleId));
    }

    @Generated
    public SysRoleV3ServiceImpl(SysRoleMenuV3Mapper sysRoleMenuV3Mapper) {
        this.sysRoleMenuV3Mapper = sysRoleMenuV3Mapper;
    }
}

