/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.sys.impl.v3;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.tree.Tree;
import cn.smarthse.modules.health.supervise.entity.basic.OrganizationUser;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationUserService;
import cn.smarthse.modules.health.supervise.service.sys.v3.ISysMenuAreaV3Service;
import cn.smarthse.modules.health.supervise.service.sys.v3.ISysMenuV3Service;
import cn.smarthse.modules.health.supervise.service.sys.v3.ISysPermissionV3Service;
import cn.smarthse.modules.health.supervise.service.sys.v3.ISysRoleV3Service;
import cn.smarthse.modules.health.supervise.vo.sys.v3.menu.SysMenuV3Vo;
import cn.smarthse.modules.sys.enumd.UserSystemWideEnum;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@DubboService
public class SysPermissionV3ForRegulatoryOrOlineServiceImpl
implements ISysPermissionV3Service {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SysPermissionV3ForRegulatoryOrOlineServiceImpl.class);
    private final IOrganizationUserService organizationUserService;
    private final ISysRoleV3Service roleService;
    private final ISysMenuV3Service menuService;
    private final ISysMenuAreaV3Service menuAreaService;

    public Set<String> getRolePermission(Long userId) {
        if (Objects.isNull(userId)) {
            return CollUtil.newHashSet((Object[])new String[0]);
        }
        return this.roleService.selectJGRolePermissionByUserId(userId);
    }

    public Set<String> getMenuPermission(Integer systemWideMenu, Long userId) {
        if (Objects.isNull(systemWideMenu) || Objects.isNull(userId)) {
            return CollUtil.newHashSet((Object[])new String[0]);
        }
        return this.menuService.selectMenuPermsByUserId(systemWideMenu, userId);
    }

    public List<Tree<Long>> getRouters(Integer systemWideMenu, Long userId) {
        return this.menuService.buildMenuTreeSelect(this.getSysMenuByUserId(systemWideMenu, userId));
    }

    public List<SysMenuV3Vo> getSysMenuByUserId(Integer systemWideMenu, Long userId) {
        if (Objects.isNull(systemWideMenu) || Objects.isNull(userId)) {
            return CollUtil.newArrayList((Object[])new SysMenuV3Vo[0]);
        }
        OrganizationUser user = this.organizationUserService.getUserInfoById(userId);
        if (Objects.isNull(user)) {
            return CollUtil.newArrayList((Object[])new SysMenuV3Vo[0]);
        }
        List menus = this.menuService.selectMCListByUserId(systemWideMenu, userId);
        if (UserSystemWideEnum.MAINTENANCE.getCode().equals(systemWideMenu) || UserSystemWideEnum.ZLWQ_YC.getCode().equals(systemWideMenu) || UserSystemWideEnum.ZLWQ_DY.getCode().equals(systemWideMenu)) {
            return menus;
        }
        Set menuIdSet = this.menuAreaService.selectMenuAreaListByAreaId(systemWideMenu, user.getOrganization().getAreaId());
        return menus.stream().filter(menu -> menuIdSet.contains(menu.getMenuId())).filter(menu -> Objects.equals(user.getIsTest(), 1) || menu.getIsTest() == 0).distinct().collect(Collectors.toList());
    }

    @Generated
    public SysPermissionV3ForRegulatoryOrOlineServiceImpl(IOrganizationUserService organizationUserService, ISysRoleV3Service roleService, ISysMenuV3Service menuService, ISysMenuAreaV3Service menuAreaService) {
        this.organizationUserService = organizationUserService;
        this.roleService = roleService;
        this.menuService = menuService;
        this.menuAreaService = menuAreaService;
    }
}

