/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.sys.impl.v3;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.tree.Tree;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.TreeBuildUtils;
import cn.smarthse.modules.datacentre.enums.StopTypeEnums;
import cn.smarthse.modules.health.supervise.dao.sys.v3.SysMenuAreaV3Mapper;
import cn.smarthse.modules.health.supervise.dao.sys.v3.SysMenuV3Mapper;
import cn.smarthse.modules.health.supervise.entity.sys.SysArea;
import cn.smarthse.modules.health.supervise.entity.sys.v3.SysMenuAreaV3;
import cn.smarthse.modules.health.supervise.entity.sys.v3.SysMenuV3;
import cn.smarthse.modules.health.supervise.enums.companyChange.CompanyChangeTypeMenuCodeMapEnum;
import cn.smarthse.modules.health.supervise.enums.companyChange.CompanyChangeTypeMenuCodeMapV3Enum;
import cn.smarthse.modules.health.supervise.model.home.OrgMenuPermission;
import cn.smarthse.modules.health.supervise.model.sys.v3.menu.SysMenuV3Bo;
import cn.smarthse.modules.health.supervise.model.sys.v3.menu.SysMenuV3SortParam;
import cn.smarthse.modules.health.supervise.service.companyChange.ICompanyChangeInfoService;
import cn.smarthse.modules.health.supervise.service.sys.v3.ISysMenuV3Service;
import cn.smarthse.modules.health.supervise.vo.companyChange.CompanyChangeTypeUnconfirmedInfoVo;
import cn.smarthse.modules.health.supervise.vo.sys.v3.menu.SysMenuV3Vo;
import cn.smarthse.modules.sys.enumd.UserSystemWideEnum;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.cn.smarthse.modules.health.exception.HealthException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@DubboService
@Transactional(readOnly=true)
public class SysMenuV3ServiceImpl
extends BaseServiceImpl<SysMenuV3Mapper, SysMenuV3>
implements ISysMenuV3Service {
    private final SysMenuAreaV3Mapper sysMenuAreaV3Mapper;
    @DubboReference
    private ICompanyChangeInfoService changeInfoService;

    public Set<String> selectMenuPermsByUserId(Integer systemWideMenu, Long userId) {
        return ((SysMenuV3Mapper)this.dao).selectRolePermissionByUserId(systemWideMenu, userId);
    }

    public List<Tree<Long>> buildMenuTreeSelect(List<SysMenuV3Vo> menus) {
        return CollUtil.isEmpty(menus) ? CollUtil.newArrayList((Object[])new Tree[0]) : TreeBuildUtils.build(menus, (Object)0L, (menu, tree) -> {
            tree.setId((Object)menu.getMenuId());
            tree.setParentId((Object)menu.getParentId());
            tree.setName((CharSequence)menu.getMenuName());
            tree.setWeight((Comparable)menu.getOrderNum());
            tree.putExtra("menuCode", (Object)menu.getMenuCode());
            tree.putExtra("menuType", (Object)menu.getMenuType());
            tree.putExtra("icon", (Object)menu.getIcon());
            tree.putExtra("isFrame", (Object)menu.getIsFrame());
            tree.putExtra("path", (Object)menu.getPath());
        });
    }

    public List<Tree<Long>> buildRoleMenuTreeSelect(List<Long> checkedKeys, List<SysMenuV3Vo> menus, String keyword) {
        if (CollUtil.isEmpty(menus)) {
            return CollUtil.newArrayList((Object[])new Tree[0]);
        }
        if (CollUtil.isNotEmpty(checkedKeys)) {
            HashSet<Long> checkedKeySet = new HashSet<Long>(checkedKeys);
            for (SysMenuV3Vo menu2 : menus) {
                menu2.setIsChecked(Integer.valueOf(checkedKeySet.contains(menu2.getMenuId()) ? 1 : 0));
            }
        }
        Map<Long, List<SysMenuV3Vo>> groupMenusByParentId = menus.stream().filter(menu -> "F".equals(menu.getMenuType())).collect(Collectors.groupingBy(SysMenuV3Vo::getParentId));
        List<Object> filteredWithAncestors = menus.stream().filter(i -> !"F".equals(i.getMenuType())).collect(Collectors.toList());
        if (StrUtil.isNotBlank((CharSequence)keyword)) {
            List<SysMenuV3Vo> filteredMenus = filteredWithAncestors.stream().filter(menu -> menu.getMenuName().contains(keyword)).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(filteredMenus)) {
                Set<Long> allAncestorsAndFiltered = this.collectAncestorsAndFiltered(filteredMenus, filteredWithAncestors);
                filteredWithAncestors = filteredWithAncestors.stream().filter(menu -> allAncestorsAndFiltered.contains(menu.getMenuId())).collect(Collectors.toList());
            } else {
                filteredWithAncestors = CollUtil.newArrayList((Object[])new SysMenuV3Vo[0]);
            }
        }
        return TreeBuildUtils.build(filteredWithAncestors, (Object)0L, (menu, tree) -> {
            SysMenuV3Vo dto = new SysMenuV3Vo().setMenuId(menu.getMenuId()).setIsChecked(menu.getIsChecked());
            ArrayList dtoList = CollUtil.newArrayList((Object[])new SysMenuV3Vo[0]);
            if ("M".equals(menu.getMenuType())) {
                dtoList.add(dto.setMenuName("\u662f\u5426\u663e\u793a\u8be5\u76ee\u5f55"));
            } else if ("C".equals(menu.getMenuType())) {
                dtoList.add(dto.setMenuName("\u662f\u5426\u663e\u793a\u8be5\u83dc\u5355"));
            }
            tree.setId((Object)menu.getMenuId());
            tree.setParentId((Object)menu.getParentId());
            tree.setName((CharSequence)menu.getMenuName());
            tree.setWeight((Comparable)menu.getOrderNum());
            tree.putExtra("mclist", (Object)dtoList);
            tree.putExtra("flist", (Object)groupMenusByParentId.getOrDefault(menu.getMenuId(), CollUtil.newArrayList((Object[])new SysMenuV3Vo[0])));
        });
    }

    private Set<Long> collectAncestorsAndFiltered(List<SysMenuV3Vo> filteredMenus, List<SysMenuV3Vo> allMenus) {
        HashSet<Long> result = new HashSet<Long>();
        for (SysMenuV3Vo menu : filteredMenus) {
            result.add(menu.getMenuId());
            this.collectAncestors(menu.getMenuId(), allMenus, result);
        }
        return result;
    }

    private void collectAncestors(Long menuId, List<SysMenuV3Vo> allMenus, Set<Long> collectedIds) {
        Optional<SysMenuV3Vo> parent = allMenus.stream().filter(menu -> menu.getMenuId().equals(menuId)).findFirst();
        if (parent.isPresent() && !parent.get().getParentId().equals(0L)) {
            collectedIds.add(parent.get().getParentId());
            this.collectAncestors(parent.get().getParentId(), allMenus, collectedIds);
        }
    }

    public List<SysMenuV3Vo> selectMCFList(Integer systemWideMenu) {
        return ((SysMenuV3Mapper)this.dao).selectMCFList(systemWideMenu);
    }

    public List<SysMenuV3Vo> selectMCList(Integer systemWideMenu) {
        return ((SysMenuV3Mapper)this.dao).selectMCList(systemWideMenu);
    }

    public List<SysMenuV3Vo> selectMCListByUserId(Integer systemWideMenu, Long userId) {
        return ((SysMenuV3Mapper)this.dao).selectMCListByUserId(systemWideMenu, userId);
    }

    public List<Long> selectMCFListByRoleId(Integer systemWideMenu, Long roleId) {
        return ((SysMenuV3Mapper)this.dao).selectMCFListByRoleId(systemWideMenu, roleId);
    }

    public List<SysMenuV3Vo> selectMCFListByRoleIdList(Integer systemWideMenu, List<Long> roleIdList) {
        return ((SysMenuV3Mapper)this.dao).selectMCFListByRoleIdList(systemWideMenu, roleIdList);
    }

    public SysMenuV3Vo selectMenuById(Long menuId) {
        SysMenuV3 menu = (SysMenuV3)this.getById(menuId);
        if (Objects.isNull(menu) || !Objects.equals(menu.getIsValid(), Boolean.TRUE)) {
            throw new HealthException("\u8be5\u76ee\u5f55/\u83dc\u5355/\u6743\u9650\u5df2\u4e0d\u5b58\u5728");
        }
        return new SysMenuV3Vo().setMenuId(menu.getMenuId()).setMenuName(menu.getMenuName()).setMenuCode(menu.getMenuCode()).setParentId(menu.getParentId()).setMenuType(menu.getMenuType()).setIcon(menu.getIcon()).setTarget(menu.getTarget()).setIsFrame(menu.getIsFrame()).setPath(menu.getPath()).setPerms(menu.getPerms()).setOrderNum(menu.getOrderNum()).setIsTest(menu.getIsTest()).setSystemWide(menu.getSystemWide());
    }

    public boolean checkMenuNameUnique(SysMenuV3Bo menu) {
        Example example = new Example(SysMenuV3.class);
        Example.Criteria c = example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("systemWide", (Object)menu.getSystemWide()).andEqualTo("menuName", (Object)menu.getMenuName()).andEqualTo("parentId", (Object)menu.getParentId());
        if (ObjectUtil.isNotNull((Object)menu.getMenuId())) {
            c.andNotEqualTo("menuId", (Object)menu.getMenuId());
        }
        return ((SysMenuV3Mapper)this.dao).selectCountByExample(example) == 0;
    }

    public boolean checkMenuCodeUnique(SysMenuV3Bo menu) {
        Example example = new Example(SysMenuV3.class);
        Example.Criteria c = example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("systemWide", (Object)menu.getSystemWide()).andEqualTo("menuCode", (Object)menu.getMenuCode());
        if (ObjectUtil.isNotNull((Object)menu.getMenuId())) {
            c.andNotEqualTo("menuId", (Object)menu.getMenuId());
        }
        return ((SysMenuV3Mapper)this.dao).selectCountByExample(example) == 0;
    }

    public boolean checkMenuPermsUnique(SysMenuV3Bo menu) {
        Example example = new Example(SysMenuV3.class);
        Example.Criteria c = example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("systemWide", (Object)menu.getSystemWide()).andEqualTo("perms", (Object)menu.getPerms());
        if (ObjectUtil.isNotNull((Object)menu.getPerms())) {
            c.andNotEqualTo("menuId", (Object)menu.getMenuId());
        }
        return ((SysMenuV3Mapper)this.dao).selectCountByExample(example) == 0;
    }

    @Transactional
    public int insertMenu(SysMenuV3Bo menu) {
        if (menu.getParentId() == 0L) {
            if ("F".equals(menu.getMenuType())) {
                throw new HealthException("\u4e0d\u80fd\u5728\u8be5\u7ea7\u4e0b\u6dfb\u52a0\u6309\u94ae");
            }
        } else {
            SysMenuV3 sysMenuV3 = (SysMenuV3)this.getById(menu.getParentId());
            if (Objects.isNull(sysMenuV3) || !Objects.equals(sysMenuV3.getIsValid(), Boolean.TRUE)) {
                throw new HealthException("\u8be5\u4e0a\u7ea7\u5df2\u4e0d\u5b58\u5728");
            }
            if ("F".equals(sysMenuV3.getMenuType())) {
                throw new HealthException("\u8be5\u4e0a\u7ea7\u7c7b\u578b\u4e3a\u6309\u94ae\uff0c\u4e0d\u80fd\u6dfb\u52a0\u4e0b\u7ea7");
            }
            if ("M".equals(sysMenuV3.getMenuType()) && "F".equals(menu.getMenuType())) {
                throw new HealthException("\u8be5\u4e0a\u7ea7\u7c7b\u578b\u4e3a\u76ee\u5f55\uff0c\u4e0d\u80fd\u6dfb\u52a0\u6309\u94ae");
            }
            char lastChar = menu.getMenuCode().charAt(menu.getMenuCode().length() - 1);
            if (("M".equals(menu.getMenuType()) || "C".equals(menu.getMenuType())) && !Character.isDigit(lastChar)) {
                throw new HealthException("\u8be5\u7c7b\u578b\u4e3a\u83dc\u5355\uff0c\u5fc5\u987b\u4ee5\u7eaf\u6570\u5b57\u7ed3\u5c3e");
            }
            if ("F".equals(menu.getMenuType())) {
                if (!Pattern.matches("[A-Z]", String.valueOf(lastChar))) {
                    throw new HealthException("\u8be5\u7c7b\u578b\u4e3a\u6309\u94ae\uff0c\u5fc5\u987b\u4ee5\u5927\u5199\u5b57\u6bcd\u7ed3\u5c3e");
                }
                menu.setIcon("#");
            }
        }
        ArrayList<SysMenuV3> list = new ArrayList<SysMenuV3>();
        Date now = new Date();
        SysMenuV3 entity = new SysMenuV3();
        Long menuId = IdWorker.getId();
        entity.setMenuId(menuId);
        entity.setMenuName(menu.getMenuName());
        entity.setMenuCode(menu.getMenuCode());
        entity.setParentId(menu.getParentId());
        entity.setMenuType(menu.getMenuType());
        entity.setIcon(menu.getIcon());
        entity.setTarget(menu.getTarget());
        entity.setIsFrame(menu.getIsFrame());
        entity.setPath(menu.getPath());
        entity.setPerms(menu.getPerms());
        entity.setOrderNum(Integer.valueOf(this.getMaxMenuSort(menu.getParentId()) + 1));
        entity.setIsTest(menu.getIsTest());
        entity.setIsValid(Boolean.valueOf(true));
        entity.setCreateBy(menu.getUserId());
        entity.setUpdateBy(menu.getUserId());
        entity.setCreateDate(now);
        entity.setUpdateDate(now);
        entity.setSystemWide(menu.getSystemWide());
        list.add(entity);
        if ("C".equals(menu.getMenuType())) {
            SysMenuV3 entity2 = new SysMenuV3();
            entity2.setMenuId(Long.valueOf(IdWorker.getId()));
            entity2.setMenuName("\u901a\u7528\u67e5\u770b");
            entity2.setMenuCode(menu.getMenuCode() + "A");
            entity2.setParentId(menuId);
            entity2.setMenuType("F");
            entity2.setIcon("#");
            entity2.setTarget("_self");
            entity2.setIsFrame(Integer.valueOf(0));
            entity2.setPerms(menu.getPerms() + ".view");
            entity2.setOrderNum(Integer.valueOf(1));
            entity2.setIsTest(Integer.valueOf(0));
            entity2.setIsValid(Boolean.valueOf(true));
            entity2.setCreateBy(menu.getUserId());
            entity2.setUpdateBy(menu.getUserId());
            entity.setCreateDate(now);
            entity.setUpdateDate(now);
            entity2.setSystemWide(menu.getSystemWide());
            list.add(entity2);
            SysMenuV3 entity3 = new SysMenuV3();
            entity3.setMenuId(Long.valueOf(IdWorker.getId()));
            entity3.setMenuName("\u901a\u7528\u7f16\u8f91");
            entity3.setMenuCode(menu.getMenuCode() + "B");
            entity3.setParentId(menuId);
            entity3.setMenuType("F");
            entity3.setIcon("#");
            entity3.setTarget("_self");
            entity3.setIsFrame(Integer.valueOf(0));
            entity3.setPerms(menu.getPerms() + ".edit");
            entity3.setOrderNum(Integer.valueOf(2));
            entity3.setIsTest(Integer.valueOf(0));
            entity3.setIsValid(Boolean.valueOf(true));
            entity3.setCreateBy(menu.getUserId());
            entity3.setUpdateBy(menu.getUserId());
            entity.setCreateDate(now);
            entity.setUpdateDate(now);
            entity3.setSystemWide(menu.getSystemWide());
            list.add(entity3);
        }
        return ((SysMenuV3Mapper)this.dao).insertList2(list);
    }

    @Transactional
    public int updateMenu(SysMenuV3Bo menu) {
        if (menu.getParentId() == 0L) {
            if ("F".equals(menu.getMenuType())) {
                throw new HealthException("\u4e0d\u80fd\u5728\u8be5\u7ea7\u4e0b\u4fee\u6539\u4e3a\u6309\u94ae");
            }
        } else {
            SysMenuV3 sysMenuV3 = (SysMenuV3)this.getById(menu.getParentId());
            if (Objects.isNull(sysMenuV3) || !Objects.equals(sysMenuV3.getIsValid(), Boolean.TRUE)) {
                throw new HealthException("\u8be5\u4e0a\u7ea7\u5df2\u4e0d\u5b58\u5728");
            }
            if ("M".equals(sysMenuV3.getMenuType()) && "F".equals(menu.getMenuType())) {
                throw new HealthException("\u8be5\u4e0a\u7ea7\u7c7b\u578b\u4e3a\u76ee\u5f55\uff0c\u4e0d\u80fd\u4fee\u6539\u4e3a\u6309\u94ae");
            }
            char lastChar = menu.getMenuCode().charAt(menu.getMenuCode().length() - 1);
            if (("M".equals(menu.getMenuType()) || "C".equals(menu.getMenuType())) && !Character.isDigit(lastChar)) {
                throw new HealthException("\u8be5\u7c7b\u578b\u4e3a\u83dc\u5355\uff0c\u5fc5\u987b\u4ee5\u7eaf\u6570\u5b57\u7ed3\u5c3e");
            }
            if ("F".equals(menu.getMenuType())) {
                if (!Pattern.matches("[A-Z]", String.valueOf(lastChar))) {
                    throw new HealthException("\u8be5\u7c7b\u578b\u4e3a\u6309\u94ae\uff0c\u5fc5\u987b\u4ee5\u5927\u5199\u5b57\u6bcd\u7ed3\u5c3e");
                }
                menu.setIcon("#");
            }
        }
        SysMenuV3 entity = new SysMenuV3();
        entity.setMenuId(menu.getMenuId());
        entity.setMenuName(menu.getMenuName());
        entity.setMenuCode(menu.getMenuCode());
        entity.setParentId(menu.getParentId());
        entity.setMenuType(menu.getMenuType());
        entity.setIcon(menu.getIcon());
        entity.setTarget(menu.getTarget());
        entity.setIsFrame(menu.getIsFrame());
        entity.setPath(menu.getPath());
        entity.setPerms(menu.getPerms());
        entity.setIsTest(menu.getIsTest());
        entity.setUpdateBy(menu.getUserId());
        entity.setUpdateDate(new Date());
        return ((SysMenuV3Mapper)this.dao).updateByPrimaryKeySelective(entity);
    }

    public boolean hasChildByMenuId(Long menuId) {
        Example example = new Example(SysMenuV3.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("parentId", (Object)menuId);
        return ((SysMenuV3Mapper)this.dao).selectCountByExample(example) > 0;
    }

    @Transactional
    public int deleteMenuById(Long menuId, Long loginUserId) {
        Date now = new Date();
        SysMenuV3 menu = new SysMenuV3();
        menu.setMenuId(menuId);
        menu.setIsValid(Boolean.valueOf(false));
        menu.setUpdateBy(loginUserId);
        menu.setUpdateDate(now);
        SysMenuAreaV3 entity = new SysMenuAreaV3();
        entity.setIsValid(Boolean.valueOf(false));
        entity.setUpdateBy(loginUserId);
        entity.setUpdateDate(now);
        Example example = new Example(SysMenuAreaV3.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("menuId", (Object)menuId);
        this.sysMenuAreaV3Mapper.updateByExampleSelective(entity, example);
        return ((SysMenuV3Mapper)this.dao).updateByPrimaryKeySelective(menu);
    }

    public int getMaxMenuSort(Long id) {
        Example example = new Example(SysMenuV3.class);
        example.createCriteria().andEqualTo("parentId", (Object)id);
        example.orderBy("orderNum").desc();
        List list = this.getListByExample(example);
        return CollUtil.isNotEmpty(list) ? ((SysMenuV3)list.get(0)).getOrderNum() : 0;
    }

    @Transactional
    public boolean dragMenu(Long draggedId, Long parentId, Long aheadId, Long backId, Long userId) {
        return false;
    }

    @Transactional
    public boolean modifySortingMenu(SysMenuV3SortParam param) {
        return ((SysMenuV3Mapper)this.dao).batchUpdateOrderNum(param.getList(), param.getLoginUserId()) > 0;
    }

    public List<SysMenuV3Vo> getUnconfirmedInfo(SysMenuV3Vo menuParam, SysArea loginRegion, Long principalId, Boolean isV3, Byte systemDeploymentSource) {
        ArrayList<SysMenuV3Vo> resultMenuList = new ArrayList<SysMenuV3Vo>();
        Long menuId = menuParam.getMenuId();
        if (menuId == null || loginRegion == null || principalId == null) {
            return resultMenuList;
        }
        Long regionId = loginRegion.getId();
        Byte regionLevel = loginRegion.getLevel();
        List<SysMenuV3Vo> menuList = this.selectMCListByUserId(UserSystemWideEnum.ZLWQ.getCode(), principalId);
        Map menuMap = menuList.stream().collect(Collectors.toMap(SysMenuV3Vo::getMenuId, m -> m, (m1, m2) -> m2, LinkedHashMap::new));
        List<SysMenuV3Vo> nestMenuList = SysMenuV3ServiceImpl.getNestMenuList(menuMap);
        List<SysMenuV3Vo> flatMenuList = SysMenuV3ServiceImpl.getFlatMenuList(nestMenuList);
        SysMenuV3Vo menu = flatMenuList.stream().filter(t -> Objects.equals(t.getMenuId(), menuId)).findFirst().orElse(null);
        if (menu == null) {
            return resultMenuList;
        }
        List<Object> businessTypeList = new ArrayList();
        if (Boolean.TRUE.equals(isV3)) {
            businessTypeList = Arrays.stream(CompanyChangeTypeMenuCodeMapV3Enum.values()).map(CompanyChangeTypeMenuCodeMapV3Enum::getType).collect(Collectors.toList());
        }
        if (Boolean.FALSE.equals(isV3)) {
            businessTypeList = Arrays.stream(CompanyChangeTypeMenuCodeMapEnum.values()).map(CompanyChangeTypeMenuCodeMapEnum::getType).collect(Collectors.toList());
        }
        List changeTypeUnconfirmedList = this.changeInfoService.getChangeTypeUnconfirmedList(regionId, regionLevel, businessTypeList);
        List<Integer> clueTypeList = List.of(StopTypeEnums.CLOSE.getCode(), StopTypeEnums.CHANGECROSS.getCode(), StopTypeEnums.CHANGEWITHIN.getCode(), StopTypeEnums.CHANGEDISTRICTWITHIN.getCode(), StopTypeEnums.NORMAL.getCode());
        List clueTypeUnconfirmedList = this.changeInfoService.getClueTypeUnconfirmedList(regionId, regionLevel, clueTypeList, systemDeploymentSource);
        List unconfirmedList = Stream.concat(changeTypeUnconfirmedList.stream(), clueTypeUnconfirmedList.stream()).toList();
        Map<Integer, Long> businessTypeNumMap = unconfirmedList.stream().collect(Collectors.groupingBy(CompanyChangeTypeUnconfirmedInfoVo::getChangeType, Collectors.counting()));
        switch (menu.getMenuType()) {
            case "M": {
                resultMenuList.add(menu);
                resultMenuList.addAll(menu.getChildren());
                break;
            }
            case "C": {
                this.processResultMenuList(menu, flatMenuList, resultMenuList);
                break;
            }
        }
        List<SysMenuV3Vo> relateMenuList = SysMenuV3ServiceImpl.getRelatedNavList(nestMenuList, menu);
        List<SysMenuV3Vo> leafMenuList = SysMenuV3ServiceImpl.collectLeafMenuListDistinct(flatMenuList);
        List<SysMenuV3Vo> activeLeafMenuList = this.loadActiveMenuListWithCount(leafMenuList, regionId, regionLevel, businessTypeNumMap, isV3);
        this.recursiveSetParentPromptField(activeLeafMenuList, flatMenuList);
        List<SysMenuV3Vo> activeDirectoryList = activeLeafMenuList.stream().filter(n -> Objects.equals(n.getMenuType(), "M")).filter(m -> relateMenuList.stream().anyMatch(n -> Objects.equals(m.getMenuId(), n.getMenuId()))).toList();
        resultMenuList.forEach(n -> n.setChildren(null));
        List<SysMenuV3Vo> activeMenuList = this.loadActiveMenuListWithCount(resultMenuList, regionId, regionLevel, businessTypeNumMap, isV3);
        activeMenuList.addAll(activeDirectoryList);
        return activeMenuList;
    }

    public Map<String, Boolean> getThirdMenu(Long userId, String orgTypes) {
        Set<String> thirdMenu = ((SysMenuV3Mapper)this.dao).getThirdMenu(userId, UserSystemWideEnum.ZLWQ_ORGANIZATION.getCode());
        return SysMenuV3ServiceImpl.setThirdMenuPermission(thirdMenu);
    }

    private static Map<String, Boolean> setThirdMenuPermission(Set<String> menuPermission) {
        OrgMenuPermission orgMenuPermission = new OrgMenuPermission();
        HashMap<String, Boolean> permissionSetterMap = new HashMap<String, Boolean>();
        for (String key : menuPermission) {
            permissionSetterMap.put(key, Boolean.TRUE);
        }
        return permissionSetterMap;
    }

    public Set<String> selectThirdPermission(Integer systemWideMenu, Long userId) {
        return ((SysMenuV3Mapper)this.dao).getThirdMenu(userId, UserSystemWideEnum.ZLWQ_ORGANIZATION.getCode());
    }

    private static List<SysMenuV3Vo> getNestMenuList(Map<Long, SysMenuV3Vo> menuMap) {
        ArrayList<SysMenuV3Vo> nestMenuList = new ArrayList<SysMenuV3Vo>();
        menuMap.values().forEach(menu -> {
            Long parentId = menu.getParentId();
            if (parentId == null || Objects.equals(parentId, 0L)) {
                nestMenuList.add((SysMenuV3Vo)menu);
            } else {
                SysMenuV3Vo parentMenu = (SysMenuV3Vo)menuMap.get(parentId);
                if (parentMenu != null) {
                    if (parentMenu.getChildren() == null) {
                        parentMenu.setChildren(new ArrayList());
                    }
                    parentMenu.getChildren().add(menu);
                }
            }
        });
        return nestMenuList;
    }

    private static List<SysMenuV3Vo> getFlatMenuList(List<SysMenuV3Vo> nestMenuList) {
        ArrayList<SysMenuV3Vo> flatMenuList = new ArrayList<SysMenuV3Vo>();
        if (CollUtil.isNotEmpty(nestMenuList)) {
            nestMenuList.forEach(menu -> {
                flatMenuList.add((SysMenuV3Vo)menu);
                if (CollUtil.isNotEmpty((Collection)menu.getChildren())) {
                    flatMenuList.addAll(SysMenuV3ServiceImpl.getFlatMenuList(menu.getChildren()));
                }
            });
        }
        return flatMenuList;
    }

    private void processResultMenuList(SysMenuV3Vo menu, List<SysMenuV3Vo> flatMenuList, List<SysMenuV3Vo> resultMenuList) {
        Long pid = menu.getParentId();
        if (Objects.equals(pid, 0L)) {
            resultMenuList.addAll(flatMenuList.stream().filter(n -> Objects.equals(n.getParentId(), 0L)).toList());
        } else {
            flatMenuList.stream().filter(m -> Objects.equals(m.getMenuId(), pid)).findFirst().ifPresent(parentMenu -> {
                resultMenuList.addAll(parentMenu.getChildren());
                this.processResultMenuList((SysMenuV3Vo)parentMenu, flatMenuList, resultMenuList);
            });
        }
    }

    public static List<SysMenuV3Vo> getRelatedNavList(List<SysMenuV3Vo> nestMenuList, SysMenuV3Vo menu) {
        ArrayList<SysMenuV3Vo> relateMenuList = new ArrayList<SysMenuV3Vo>();
        if (CollUtil.isEmpty(nestMenuList) || menu == null) {
            return relateMenuList;
        }
        SysMenuV3ServiceImpl.findRelatedMenuList(nestMenuList, menu.getMenuId(), relateMenuList);
        List children = menu.getChildren();
        if (children != null) {
            relateMenuList.addAll(children);
        }
        relateMenuList.forEach(m -> m.setChildren(null));
        return relateMenuList;
    }

    private static boolean findRelatedMenuList(List<SysMenuV3Vo> nestMenuList, Long menuId, List<SysMenuV3Vo> relateMenuList) {
        for (SysMenuV3Vo nestMenu : nestMenuList) {
            boolean foundInChildren;
            if (Objects.equals(nestMenu.getMenuId(), menuId)) {
                relateMenuList.addAll(nestMenuList);
                return Boolean.TRUE;
            }
            List children = nestMenu.getChildren();
            if (!CollUtil.isNotEmpty((Collection)children) || !(foundInChildren = SysMenuV3ServiceImpl.findRelatedMenuList(children, menuId, relateMenuList))) continue;
            relateMenuList.addAll(nestMenuList);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private static List<SysMenuV3Vo> collectLeafMenuListDistinct(List<SysMenuV3Vo> flatMenuList) {
        ArrayList<SysMenuV3Vo> leafMenuList = new ArrayList<SysMenuV3Vo>();
        HashSet<Long> existSet = new HashSet<Long>();
        for (SysMenuV3Vo menu : flatMenuList) {
            if (CollUtil.isEmpty((Collection)menu.getChildren())) {
                if (!existSet.add(menu.getMenuId())) continue;
                leafMenuList.add(menu);
                continue;
            }
            leafMenuList.addAll(SysMenuV3ServiceImpl.collectLeafMenuListDistinct(menu.getChildren()));
        }
        return leafMenuList;
    }

    private void recursiveSetParentPromptField(List<SysMenuV3Vo> activeMenuList, List<SysMenuV3Vo> flatMenuList) {
        ArrayList<SysMenuV3Vo> currentActiveList = new ArrayList<SysMenuV3Vo>(activeMenuList);
        currentActiveList.forEach(menu -> flatMenuList.stream().filter(parent -> menu.getParentId().equals(parent.getMenuId())).findFirst().ifPresent(parent -> {
            boolean noneIn = activeMenuList.stream().noneMatch(active -> active.getMenuId().equals(parent.getMenuId()));
            if (noneIn) {
                parent.setExistUnconfirmedInfo(Boolean.TRUE);
                activeMenuList.add((SysMenuV3Vo)parent);
                if (parent.getParentId() != 0L) {
                    this.recursiveSetParentPromptField(activeMenuList, flatMenuList);
                }
            }
        }));
    }

    private List<SysMenuV3Vo> loadActiveMenuListWithCount(List<SysMenuV3Vo> menuList, Long regionId, Byte regionLevel, Map<Integer, Long> businessTypeNumMap, Boolean isV3) {
        ArrayList<SysMenuV3Vo> activeMenuList = new ArrayList<SysMenuV3Vo>(menuList.size());
        for (SysMenuV3Vo menu : menuList) {
            Long num;
            String code = menu.getMenuCode();
            if (("0A015018100".equals(code) || "0A015018101".equals(code)) && Boolean.FALSE.booleanValue()) {
                num = this.changeInfoService.getIntoLocalUnconfirmedNum(regionId, regionLevel);
            } else {
                Integer type = Boolean.TRUE.equals(isV3) ? CompanyChangeTypeMenuCodeMapV3Enum.getType((String)code) : (Boolean.FALSE.equals(isV3) ? CompanyChangeTypeMenuCodeMapEnum.getType((String)code) : null);
                Long l = num = businessTypeNumMap != null ? businessTypeNumMap.get(type) : null;
            }
            if (num == null || num == 0L) continue;
            menu.setUnconfirmedNum(num);
            activeMenuList.add(menu);
        }
        return activeMenuList;
    }

    @Transactional
    public void insertThirdUserRole(Long user_id, String orgTypes, boolean isManager) {
        String[] split;
        String[] stringArray = split = orgTypes.split(",");
        int n = stringArray.length;
        block12: for (int i = 0; i < n; ++i) {
            String orgType;
            switch (orgType = stringArray[i]) {
                case "1": {
                    Long roleId = 6001L;
                    if (!isManager) {
                        roleId = 6002L;
                    }
                    ((SysMenuV3Mapper)this.dao).insertThirdUserRole(user_id, roleId);
                    continue block12;
                }
                case "2": {
                    Long roleId = 6003L;
                    if (!isManager) {
                        roleId = 6004L;
                    }
                    ((SysMenuV3Mapper)this.dao).insertThirdUserRole(user_id, roleId);
                    continue block12;
                }
                case "12": {
                    Long roleId = 6009L;
                    if (!isManager) {
                        roleId = 6010L;
                    }
                    ((SysMenuV3Mapper)this.dao).insertThirdUserRole(user_id, roleId);
                    continue block12;
                }
                case "14": {
                    Long roleId = 6011L;
                    if (!isManager) {
                        roleId = 6012L;
                    }
                    ((SysMenuV3Mapper)this.dao).insertThirdUserRole(user_id, roleId);
                }
            }
        }
    }

    @Generated
    public SysMenuV3ServiceImpl(SysMenuAreaV3Mapper sysMenuAreaV3Mapper) {
        this.sysMenuAreaV3Mapper = sysMenuAreaV3Mapper;
    }
}

