/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.sys.impl.v3;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.supervise.dao.sys.v3.SysMenuAreaV3Mapper;
import cn.smarthse.modules.health.supervise.entity.sys.v3.SysMenuAreaV3;
import cn.smarthse.modules.health.supervise.model.sys.v3.menu.SysMenuAreaIsOpenLowerLevelParam;
import cn.smarthse.modules.health.supervise.model.sys.v3.menu.SysMenuAreaV3AddParam;
import cn.smarthse.modules.health.supervise.model.sys.v3.menu.SysMenuAreaV3ListParam;
import cn.smarthse.modules.health.supervise.service.sys.v3.ISysMenuAreaV3Service;
import cn.smarthse.modules.health.supervise.vo.sys.v3.menu.SysMenuAreaV3Vo;
import cn.smarthse.modules.platform.model.v3.sysArea.SysAreaV3OneVo;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.cn.smarthse.modules.health.exception.HealthException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@DubboService
@Transactional(readOnly=true)
public class SysMenuAreaV3ServiceImpl
extends BaseServiceImpl<SysMenuAreaV3Mapper, SysMenuAreaV3>
implements ISysMenuAreaV3Service {
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;

    public PageInfo<SysMenuAreaV3Vo> selectMenuAreaList(SysMenuAreaV3ListParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<SysMenuAreaV3Vo> list = ((SysMenuAreaV3Mapper)this.dao).getMenuAreaListByMenuId(param.getMenuId());
        return new PageInfo(list);
    }

    @Transactional
    public int insertMenuArea(SysMenuAreaV3AddParam param) {
        Example example = new Example(SysMenuAreaV3.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("areaId", (Object)param.getAreaId()).andEqualTo("menuId", (Object)param.getMenuId());
        if (this.getCountByExample(example) > 0) {
            throw new HealthException("\u8be5\u533a\u57df\u5df2\u88ab\u6dfb\u52a0");
        }
        Date now = new Date();
        SysMenuAreaV3 entity = new SysMenuAreaV3();
        entity.setId(Long.valueOf(IdWorker.getId()));
        entity.setMenuId(param.getMenuId());
        entity.setAreaId(param.getAreaId());
        entity.setIsOpenLowerLevel(Integer.valueOf(Objects.isNull(param.getIsOpenLowerLevel()) ? 0 : param.getIsOpenLowerLevel()));
        entity.setIsValid(Boolean.valueOf(true));
        entity.setCreateBy(param.getLoginUserId());
        entity.setUpdateBy(param.getLoginUserId());
        entity.setCreateDate(now);
        entity.setUpdateDate(now);
        return ((SysMenuAreaV3Mapper)this.dao).insertSelective(entity);
    }

    @Transactional
    public int deleteMenuAreaById(Long id, Long loginUserId) {
        SysMenuAreaV3 entity = new SysMenuAreaV3();
        entity.setId(id);
        entity.setIsValid(Boolean.valueOf(false));
        entity.setUpdateBy(loginUserId);
        entity.setUpdateDate(new Date());
        return ((SysMenuAreaV3Mapper)this.dao).updateByPrimaryKeySelective(entity);
    }

    @Transactional
    public boolean isOpenLowerLevel(SysMenuAreaIsOpenLowerLevelParam param) {
        SysMenuAreaV3 entity = new SysMenuAreaV3();
        entity.setId(param.getId());
        entity.setIsOpenLowerLevel(param.getIsOpenLowerLevel());
        entity.setUpdateBy(param.getLoginUserId());
        entity.setUpdateDate(new Date());
        return ((SysMenuAreaV3Mapper)this.dao).updateByPrimaryKeySelective(entity) > 0;
    }

    public Set<Long> selectMenuAreaListByAreaId(Integer systemWideMenu, Long areaId) {
        if (ObjectUtil.isNull((Object)systemWideMenu) || ObjectUtil.isNull((Object)areaId)) {
            this.logger.error("\u83b7\u53d6\u8def\u7531\u5931\u8d25\uff0c\u5f02\u5e38\u6570\u636e\uff0csystemWideMenu \u6216 areaId \u4e3a\u7a7a");
            return CollUtil.newHashSet((Object[])new Long[0]);
        }
        SysAreaV3OneVo area = this.sysAreaProvideService.getAreaByIdV3(areaId);
        if (ObjectUtil.isNull((Object)area)) {
            return CollUtil.newHashSet((Object[])new Long[0]);
        }
        ArrayList<Long> areaIdList = new ArrayList<Long>();
        areaIdList.add(0L);
        if (ObjectUtil.isNotNull((Object)area.getProvinceId())) {
            areaIdList.add(area.getProvinceId());
        }
        if (ObjectUtil.isNotNull((Object)area.getCityId())) {
            areaIdList.add(area.getCityId());
        }
        if (ObjectUtil.isNotNull((Object)area.getAreaId())) {
            areaIdList.add(area.getAreaId());
        }
        if (ObjectUtil.isNotNull((Object)area.getStreetId())) {
            areaIdList.add(area.getStreetId());
        }
        Example example = new Example(SysMenuAreaV3.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andIn("areaId", areaIdList);
        List menuAreaList = this.getListByExample(example);
        if (CollUtil.isEmpty(menuAreaList)) {
            return CollUtil.newHashSet((Object[])new Long[0]);
        }
        HashSet<Long> menuIdSet = new HashSet<Long>(menuAreaList.size());
        for (SysMenuAreaV3 menuArea : menuAreaList) {
            if (!Objects.equals(menuArea.getAreaId(), areaId) && menuArea.getIsOpenLowerLevel() != 1) continue;
            menuIdSet.add(menuArea.getMenuId());
        }
        return menuIdSet;
    }

    @Generated
    public SysMenuAreaV3ServiceImpl() {
    }
}

