/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.sys.impl.dic;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.excel.ExcelContent;
import cn.smarthse.common.util.excel.ExcelUtil;
import cn.smarthse.modules.health.supervise.dao.sys.dic.DicValueMapper;
import cn.smarthse.modules.health.supervise.entity.sys.dic.DicType;
import cn.smarthse.modules.health.supervise.entity.sys.dic.DicValue;
import cn.smarthse.modules.health.supervise.service.sys.dic.IDicTypeService;
import cn.smarthse.modules.health.supervise.service.sys.dic.IDicValueService;
import cn.smarthse.modules.health.supervise.vo.sys.dic.DicValueImportVo;
import cn.smarthse.modules.health.supervise.vo.sys.dic.DicValueVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@DubboService
public class DicValueServiceImpl
extends BaseServiceImpl<DicValueMapper, DicValue>
implements IDicValueService {
    @Autowired
    private IDicTypeService dicTypeService;

    public PageInfo<DicValueVo> query(Long dicId, String valueLabel, Integer status, int page, int rows) {
        PageHelper.startPage((int)page, (int)rows);
        List<DicValueVo> list = ((DicValueMapper)this.dao).queryList(dicId, valueLabel, status);
        for (DicValueVo vo : list) {
            if (vo.getPid() != 0L || list.size() <= 1) continue;
            vo.setExpanded(Boolean.valueOf(true));
            vo.setIsLeaf(Boolean.valueOf(false));
            break;
        }
        return new PageInfo(list);
    }

    @Transactional(readOnly=false)
    public void deleteMulit(List<Long> idList, Long loginStaffId) {
        if (idList == null || idList.isEmpty()) {
            return;
        }
        ((DicValueMapper)this.dao).deleteMulti(idList, loginStaffId);
    }

    @Transactional(readOnly=true)
    public List<DicValueVo> queryDicValueByTypeCode(String typeCode) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)typeCode)) {
            return Collections.emptyList();
        }
        return ((DicValueMapper)this.dao).queryDicValueByTypeCode(typeCode);
    }

    public boolean isSameValue(String value, Long id) {
        if (StringUtils.isNotEmpty((String)value)) {
            Example example = new Example(DicValue.class);
            example.createCriteria().andEqualTo("value", (Object)value.trim()).andNotEqualTo("id", (Object)id).andEqualTo("isValid", (Object)true);
            return ((DicValueMapper)this.dao).selectCountByExample(example) > 0;
        }
        return false;
    }

    public boolean isSameValueLabel(String valueLabel, Long id) {
        if (StringUtils.isNotEmpty((String)valueLabel)) {
            Example example = new Example(DicValue.class);
            example.createCriteria().andEqualTo("valueLabel", (Object)valueLabel.trim()).andNotEqualTo("id", (Object)id).andEqualTo("isValid", (Object)true);
            return ((DicValueMapper)this.dao).selectCountByExample(example) > 0;
        }
        return false;
    }

    @Transactional(readOnly=false)
    public DicValue addDicValue(DicValue dicValue) {
        if (dicValue != null && dicValue.getPid() != null) {
            DicValue pV = (DicValue)this.getById(dicValue.getPid());
            if (pV != null) {
                pV.setId(dicValue.getPid());
                pV.setIsLeaf(Boolean.valueOf(false));
                this.update(pV, dicValue.getCreateBy());
                dicValue.setLevel(Integer.valueOf(pV.getLevel() + 1));
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)pV.getPath())) {
                    dicValue.setPath(pV.getPath() + "," + pV.getId());
                }
                if (pV.getStatus() == 2) {
                    dicValue.setStatus(Integer.valueOf(2));
                }
            } else {
                dicValue.setPath("" + dicValue.getTypeId());
            }
            dicValue = this.add(dicValue);
        }
        return dicValue;
    }

    @Transactional(readOnly=false)
    public DicValue updateDicValue(DicValue dicValue) {
        DicValue dvDb = (DicValue)this.getById(dicValue.getId());
        Boolean isChirldrenPath = false;
        List<DicValue> dvDBs = this.getChildrenDv(dicValue.getId());
        DicValue pDv = null;
        if (dvDBs != null && dvDBs.size() > 0) {
            for (DicValue dicValue2 : dvDBs) {
                if (!dicValue2.getId().equals(dicValue.getPid()) || !dicValue2.getPath().contains("" + dicValue.getId())) continue;
                isChirldrenPath = true;
                pDv = dicValue2;
                break;
            }
        }
        if (!isChirldrenPath.booleanValue()) {
            List<DicValue> list;
            List<DicValue> list2;
            pDv = (DicValue)this.getById(dicValue.getPid());
            DicValue oldPDv = (DicValue)this.getById(dvDb.getPid());
            if (pDv == null) {
                dicValue.setLevel(Integer.valueOf(1));
                dicValue.setPath("" + dicValue.getPid());
            } else {
                dicValue.setLevel(Integer.valueOf(pDv.getLevel() + 1));
                dicValue.setPath(pDv.getPath() + "," + dicValue.getPid());
                dicValue.setStatus(Integer.valueOf(pDv.getStatus() == 2 ? 2 : dicValue.getStatus()));
            }
            if (dvDBs != null && dvDBs.size() > 0) {
                dicValue.setIsLeaf(Boolean.valueOf(false));
                for (DicValue dv : dvDBs) {
                    if (pDv != null) {
                        dv.setStatus(Integer.valueOf(pDv.getStatus() == 2 ? 2 : dv.getStatus()));
                    }
                    String path = dicValue.getPath() + dv.getPath().replace(dvDb.getPath(), "");
                    dv.setPath(path);
                    dv.setLevel(Integer.valueOf(dv.getPath().split(",").length));
                    this.update(dv, dicValue.getUpdateBy());
                }
            }
            this.update(dicValue);
            if (oldPDv != null && (list2 = this.getChildrenDv(oldPDv.getId())) != null) {
                oldPDv.setIsLeaf(Boolean.valueOf(list2.size() == 0));
                this.update(oldPDv, dicValue.getUpdateBy());
            }
            if (pDv != null && (list = this.getChildrenDv(dicValue.getPid())) != null) {
                pDv.setIsLeaf(Boolean.valueOf(list.size() == 0));
                this.update(pDv, dicValue.getUpdateBy());
            }
        }
        return dicValue;
    }

    public List<DicValue> getChildrenDv(Long id) {
        Example example = new Example(DicValue.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andLike("path", "%" + id + "%");
        return ((DicValueMapper)this.dao).selectByExample(example);
    }

    @Transactional(readOnly=false)
    public void showOrHide(Integer status, Long id) {
        if (status == null || id == null) {
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(id);
        List<DicValue> children = this.getChildrenDv(id);
        if (children != null && children.size() > 0) {
            ids.addAll(children.stream().mapToLong(s -> s.getId()).boxed().collect(Collectors.toList()));
        }
        DicValue dv = new DicValue();
        dv.setStatus(status);
        Example example = new Example(DicValue.class);
        example.createCriteria().andIn("id", ids);
        ((DicValueMapper)this.dao).updateByExampleSelective(dv, example);
    }

    @Transactional(readOnly=false)
    public Map<Long, List<DicValueImportVo>> importDicValueImportVosDataSubmit(Long dicId, String ossfile, Long userId) throws Exception {
        HashMap colTypeMap = new HashMap();
        List excelContentMap = ExcelUtil.getInstance().getSingleExcelContentHasExcelInfo(ossfile, Integer.valueOf(5), Integer.valueOf(1), colTypeMap);
        HashMap<Long, List<DicValueImportVo>> resultMap = new HashMap<Long, List<DicValueImportVo>>();
        resultMap.put(1L, new ArrayList());
        resultMap.put(3L, new ArrayList());
        resultMap.put(5L, new ArrayList());
        ArrayList list = new ArrayList();
        HashMap<String, String> keyValFromExcel = new HashMap<String, String>();
        HashMap<String, String> keyPKeyFromExcel = new HashMap<String, String>();
        DicType dicType = (DicType)this.dicTypeService.getById(dicId);
        if (excelContentMap.size() > 0 && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)dicType.getName()) && !dicType.getName().equals(((ExcelContent)((List)excelContentMap.get(0)).get(0)).getSheetName())) {
            DicValueImportVo vo = new DicValueImportVo();
            vo.setErrReason("\u5bfc\u5165\u7684\u662f\u975e\u8be5\u5b57\u5178\u6570\u636e!");
            ((List)resultMap.get(3L)).add(vo);
            return resultMap;
        }
        String errStr = "\u7b2c{}\u884c,\u7b2c{}\u5217{};";
        for (List row : excelContentMap) {
            DicValueImportVo vo = new DicValueImportVo();
            vo.setErrReason("");
            for (int i = 0; i < row.size(); ++i) {
                ExcelContent cc = (ExcelContent)row.get(i);
                vo.setRowNum(cc.getRowNum());
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)cc.getContent()) && i != 4) {
                    vo.setErrReason(vo.getErrReason() + DicValueServiceImpl.getErrStr(errStr, "" + cc.getRowNum(), "" + (i + 1), "\u4e3a\u5fc5\u586b\u9879"));
                    continue;
                }
                if (i == 0) {
                    vo.setValueLabel(cc.getContent());
                    if (!keyValFromExcel.keySet().contains(vo.getValueLabel())) continue;
                    vo.setErrReason(vo.getErrReason() + DicValueServiceImpl.getErrStr(errStr, "" + cc.getRowNum(), "" + (i + 1), "\u6709\u91cd\u590d\u7684\u5b57\u5178\u6807\u7b7e"));
                    continue;
                }
                if (i == 1) {
                    vo.setValue(cc.getContent());
                    if (!keyValFromExcel.values().contains(vo.getValue())) continue;
                    vo.setErrReason(vo.getErrReason() + DicValueServiceImpl.getErrStr(errStr, "" + cc.getRowNum(), "" + (i + 1), "\u6709\u91cd\u590d\u7684\u5b57\u5178\u952e\u503c"));
                    continue;
                }
                if (i == 2) {
                    vo.setPValueLabel(cc.getContent());
                    continue;
                }
                if (i == 3) {
                    vo.setStatusName(cc.getContent());
                    vo.setStatus(Integer.valueOf(cc.getContent().trim().equals("\u663e\u793a") ? 1 : 2));
                    continue;
                }
                if (i != 4) continue;
                vo.setRemark(cc.getContent());
            }
            keyValFromExcel.put(vo.getValueLabel(), vo.getValue());
            keyPKeyFromExcel.put(vo.getValueLabel(), vo.getPValueLabel());
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)vo.getErrReason())) {
                ((List)resultMap.get(5L)).add(vo);
                continue;
            }
            ((List)resultMap.get(1L)).add(vo);
        }
        if (((List)resultMap.get(5L)).size() == 0) {
            for (Object vo : (List)resultMap.get(1L)) {
                if (keyValFromExcel.get(vo.getPValueLabel()) != null || vo.getPValueLabel().equals(dicType.getName())) continue;
                vo.setErrReason(DicValueServiceImpl.getErrStr(errStr, "" + vo.getRowNum(), "3", "\u627e\u4e0d\u5230\u7236\u5b57\u5178\u6807\u7b7e"));
                ((List)resultMap.get(5L)).add(vo);
            }
        }
        int maxLength = 0;
        if (((List)resultMap.get(5L)).size() == 0) {
            for (DicValueImportVo vo : (List)resultMap.get(1L)) {
                vo.setPath(this.getPath(vo.getValueLabel(), vo.getPValueLabel(), keyPKeyFromExcel));
                String[] paths = vo.getPath().split("==>>");
                List<String> pathList = Arrays.asList(paths);
                if (pathList.size() != pathList.stream().distinct().collect(Collectors.toList()).size()) {
                    vo.setErrReason(DicValueServiceImpl.getErrStr(errStr, "" + vo.getRowNum(), "3", "\u4e0d\u80fd\u5c06\u81ea\u5df1\u53ca\u5176\u5b50\u8282\u70b9\u4f5c\u4e3a\u7236\u8282\u70b9"));
                    ((List)resultMap.get(5L)).add(vo);
                    continue;
                }
                if (vo.getPath().length() <= maxLength) continue;
                maxLength = vo.getPath().length();
            }
        }
        if (((List)resultMap.get(5L)).size() == 0) {
            for (DicValueImportVo vo : (List)resultMap.get(1L)) {
                vo.setOrderStr(org.apache.commons.lang3.StringUtils.rightPad((String)vo.getPath(), (int)maxLength, (String)"0"));
            }
            List finalList = ((List)resultMap.get(1L)).stream().sorted(Comparator.comparing(DicValueImportVo::getOrderStr)).collect(Collectors.toList());
            resultMap.put(1L, finalList);
            DicValue oldDv = new DicValue();
            oldDv.setIsValid(Boolean.valueOf(false));
            oldDv.setUpdateBy(userId);
            oldDv.setUpdateDate(new Date());
            Example example = new Example(DicValue.class);
            example.createCriteria().andEqualTo("typeId", (Object)dicId);
            ((DicValueMapper)this.dao).updateByExampleSelective(oldDv, example);
            for (DicValueImportVo vo : finalList) {
                DicValue dv = new DicValue();
                dv.setCreateBy(userId);
                dv.setCreateDate(new Date());
                dv.setIsValid(Boolean.valueOf(true));
                dv.setUpdateDate(new Date());
                dv.setUpdateBy(userId);
                dv.setTypeId(dicId);
                dv.setValueLabel(vo.getValueLabel());
                dv.setRemark(vo.getRemark());
                dv.setIsLeaf(Boolean.valueOf(true));
                dv.setStatus(vo.getStatus());
                dv.setValue(vo.getValue());
                if (vo.getValueLabel().equals(vo.getPath())) {
                    dv.setPid(dicId);
                } else {
                    DicValue pDv = this.getDVByLabel(vo.getPValueLabel());
                    if (pDv != null) {
                        dv.setPid(pDv.getId());
                    }
                }
                this.addDicValue(dv);
            }
        }
        return resultMap;
    }

    private DicValue getDVByLabel(String label) {
        Example example = new Example(DicValue.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("valueLabel", (Object)label);
        List list = ((DicValueMapper)this.dao).selectByExample(example);
        if (list != null && list.size() > 0) {
            return (DicValue)list.get(0);
        }
        return null;
    }

    private static String getErrStr(String template, String ... val) {
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)template) && val != null && val.length > 0) {
            int index = template.indexOf("{}");
            int i = 0;
            while (index >= 0) {
                template = template.replaceFirst("\\{\\}", val[i]);
                if (++i == val.length) break;
                index = template.indexOf("{}");
            }
        }
        return template;
    }

    private Map<String, String> getAllKeyValueMap(Long dicType) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<DicValue> list = this.getAllDicValue(dicType);
        for (DicValue dic : list) {
            map.put(dic.getValueLabel(), dic.getValue());
        }
        return map;
    }

    private List<DicValue> getAllDicValue(Long dicType) {
        Example example = new Example(DicValue.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("typeId", (Object)dicType);
        List list = ((DicValueMapper)this.dao).selectByExample(example);
        return list;
    }

    private Map<String, DicValue> getAllDicValueMap(Long dicType) {
        Example example = new Example(DicValue.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("typeId", (Object)dicType);
        List<DicValue> list = this.getAllDicValue(dicType);
        HashMap<String, DicValue> map = new HashMap<String, DicValue>();
        for (DicValue dic : list) {
            map.put(dic.getValueLabel(), dic);
        }
        return map;
    }

    private List<DicValueImportVo> getDicValueImportVoByLabel(Long dicType, List<DicValueImportVo> data, String valueLabel) {
        return null;
    }

    private String getPath(String path, String pPath, Map<String, String> search) {
        if (search.get(pPath) != null) {
            return this.getPath(pPath + "==>>" + path, search.get(pPath), search);
        }
        return path;
    }
}

