/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.sys.impl.dic;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.supervise.dao.sys.dic.DicTypeMapper;
import cn.smarthse.modules.health.supervise.entity.sys.dic.DicType;
import cn.smarthse.modules.health.supervise.service.sys.dic.IDicTypeService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@DubboService
public class DicTypeServiceImpl
extends BaseServiceImpl<DicTypeMapper, DicType>
implements IDicTypeService {
    public PageInfo<DicType> query(String nameOrTypeCode, Integer status, Date createStartDate, Date createEndDate, int pageNum, int pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List<DicType> list = ((DicTypeMapper)this.dao).queryList(nameOrTypeCode, status, createStartDate, createEndDate);
        return new PageInfo(list);
    }

    @Transactional(readOnly=false)
    public void deleteMulit(List<Long> idList, Long loginStaffId) {
        if (idList == null || idList.isEmpty()) {
            return;
        }
        ((DicTypeMapper)this.dao).deleteMulti(idList, loginStaffId);
    }

    public boolean isSameName(String name, Long id) {
        if (StringUtils.isNotEmpty((String)name)) {
            Example example = new Example(DicType.class);
            example.createCriteria().andEqualTo("name", (Object)name.trim()).andNotEqualTo("id", (Object)id).andEqualTo("isValid", (Object)true);
            return ((DicTypeMapper)this.dao).selectCountByExample(example) > 0;
        }
        return false;
    }

    public boolean isSameTypeCode(String typeCode, Long id) {
        if (StringUtils.isNotEmpty((String)typeCode)) {
            Example example = new Example(DicType.class);
            example.createCriteria().andEqualTo("typeCode", (Object)typeCode.trim()).andNotEqualTo("id", (Object)id).andEqualTo("isValid", (Object)true);
            return ((DicTypeMapper)this.dao).selectCountByExample(example) > 0;
        }
        return false;
    }

    public DicType getHarmDicType() {
        Example example = new Example(DicType.class);
        example.createCriteria().andEqualTo("typeCode", (Object)"harm_factor").andEqualTo("isValid", (Object)true);
        List list = ((DicTypeMapper)this.dao).selectByExample(example);
        if (list != null && list.size() > 0) {
            return (DicType)list.get(0);
        }
        return null;
    }
}

