/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.sys.impl;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.enums.UserCustomerInfoTypeEnum;
import cn.smarthse.modules.health.supervise.dao.sys.UserCustomerMapper;
import cn.smarthse.modules.health.supervise.entity.basic.OrganizationUser;
import cn.smarthse.modules.health.supervise.entity.sys.UserCustomerInfo;
import cn.smarthse.modules.health.supervise.enums.sys.UserRolesEnum;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationUserService;
import cn.smarthse.modules.health.supervise.service.sys.IUserCustomerInfoService;
import cn.smarthse.modules.platform.model.AreaModel;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="userCustomerInfoServiceImpl")
@DubboService
@Transactional(readOnly=true)
public class UserCustomerInfoServiceImpl
extends BaseServiceImpl<UserCustomerMapper, UserCustomerInfo>
implements IUserCustomerInfoService {
    @Autowired
    private IOrganizationUserService organizationUserService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService regionService;

    @Transactional(readOnly=false)
    public void addUserCustomerInfo(UserCustomerInfo userCustomerInfo, AreaModel areaModel) {
        if (userCustomerInfo.getUserId() == null) {
            return;
        }
        UserCustomerInfo dbuserCustomerInfo = this.getUserCustomerInfoByUserId(userCustomerInfo.getUserId(), userCustomerInfo.getTableId(), areaModel);
        OrganizationUser user = this.organizationUserService.getUserInfoById(userCustomerInfo.getUserId());
        if (dbuserCustomerInfo != null) {
            Boolean isShow = this.isShowRemarks(userCustomerInfo.getTableId(), areaModel.getAreaName(), user);
            if (isShow.booleanValue()) {
                this.setTableHead(userCustomerInfo, dbuserCustomerInfo, areaModel.getAreaId(), user.getRole());
                dbuserCustomerInfo.setAreaId(areaModel.getAreaId());
                dbuserCustomerInfo.setUserRole(user.getRole());
            }
            dbuserCustomerInfo.setCompanyHeadSet(userCustomerInfo.getCompanyHeadSet());
            dbuserCustomerInfo.setUpdateDate(new Date());
            dbuserCustomerInfo.setUpdateBy(userCustomerInfo.getUserId());
            this.update(dbuserCustomerInfo);
            if (user.getRole().contains(UserRolesEnum.countyAdmin.getValue().toString())) {
                this.setLowwerRole(userCustomerInfo, areaModel.getAreaId());
            }
            Example e = new Example(UserCustomerInfo.class);
            e.createCriteria().andEqualTo("userRole", (Object)user.getRole()).andEqualTo("areaId", (Object)areaModel.getAreaId()).andNotEqualTo("userId", (Object)userCustomerInfo.getUserId()).andEqualTo("tableId", (Object)userCustomerInfo.getTableId()).andEqualTo("isValid", (Object)1);
            UserCustomerInfo info = new UserCustomerInfo();
            BeanUtils.copyProperties((Object)dbuserCustomerInfo, (Object)info, (String[])new String[]{"id", "userId", "areaId", "userRole", "createDate", "createBy", "updateDate", "updateBy"});
            ((UserCustomerMapper)this.dao).updateByExampleSelective(info, e);
        } else {
            userCustomerInfo.setAreaId(areaModel.getAreaId());
            userCustomerInfo.setUserRole(user.getRole());
            this.add(userCustomerInfo);
        }
    }

    @Transactional
    public void addUserCustomerInfoGeneral(UserCustomerInfo customerInfo) {
        Integer tableId;
        UserCustomerInfoTypeEnum tableEnum;
        Long userId;
        Date now = new Date();
        Long regionId = customerInfo.getAreaId();
        if (ObjectUtil.hasNull((Object[])new Object[]{regionId, userId = customerInfo.getUserId(), tableEnum = UserCustomerInfoTypeEnum.getEnum((Integer)(tableId = customerInfo.getTableId()))})) {
            return;
        }
        AreaModel region = this.regionService.getAreaById(regionId);
        if (ObjectUtil.hasNull((Object[])new Object[]{region})) {
            return;
        }
        OrganizationUser user = this.organizationUserService.getUserInfoById(userId);
        if (ObjectUtil.hasNull((Object[])new Object[]{user})) {
            return;
        }
        Long regionAreaId = region.getAreaId();
        customerInfo.setAreaId(regionAreaId);
        UserCustomerInfo existingCustomerInfo = this.getUserCustomerInfoByUserIdGeneral(region, user, tableEnum);
        if (existingCustomerInfo != null) {
            existingCustomerInfo.setCompanyHeadSet(customerInfo.getCompanyHeadSet());
            existingCustomerInfo.setUpdateDate(now);
            existingCustomerInfo.setUpdateBy(userId);
            this.update(existingCustomerInfo);
            String countyAdminRole = UserRolesEnum.countyAdmin.getValue().toString();
            String userRole = user.getRole();
            if (CharSequenceUtil.isNotEmpty((CharSequence)userRole) && userRole.contains(countyAdminRole)) {
                this.setLowwerRole(customerInfo, regionAreaId);
            }
            Example example = new Example(UserCustomerInfo.class);
            example.createCriteria().andEqualTo("areaId", (Object)regionAreaId).andEqualTo("userRole", (Object)userRole).andNotEqualTo("userId", (Object)userId).andEqualTo("tableId", (Object)tableId).andEqualTo("isValid", (Object)Boolean.TRUE);
            UserCustomerInfo syncUpdateInfo = new UserCustomerInfo();
            BeanUtils.copyProperties((Object)existingCustomerInfo, (Object)syncUpdateInfo, (String[])new String[]{"id", "userId", "areaId", "userRole", "createDate", "createBy", "updateDate", "updateBy"});
            ((UserCustomerMapper)this.dao).updateByExampleSelective(syncUpdateInfo, example);
        } else {
            customerInfo.setAreaId(regionAreaId);
            customerInfo.setUserRole(user.getRole());
            this.add(customerInfo);
        }
    }

    @Transactional(readOnly=false)
    public UserCustomerInfo getUserCustomerInfoByUserId(Long userId, Integer tableId, AreaModel areaModel) {
        if (userId == null) {
            return null;
        }
        if (tableId == null) {
            tableId = UserCustomerInfoTypeEnum.COMPANY.getValue();
        }
        Example e = new Example(UserCustomerInfo.class);
        e.createCriteria().andEqualTo("userId", (Object)userId).andEqualTo("tableId", (Object)tableId).andEqualTo("isValid", (Object)1);
        OrganizationUser user = this.organizationUserService.getUserInfoById(userId);
        List listByExample = this.getListByExample(e);
        if (CollectionUtils.isNotEmpty(listByExample)) {
            UserCustomerInfo userCustomerInfo = (UserCustomerInfo)listByExample.get(0);
            userCustomerInfo.setUserRole(user.getRole());
            userCustomerInfo.setAreaId(areaModel.getAreaId());
            ((UserCustomerMapper)this.dao).updateByPrimaryKeySelective(userCustomerInfo);
            Boolean isShow = this.isShowRemarks(tableId, areaModel.getAreaName(), user);
            if (isShow.booleanValue()) {
                UserCustomerInfo countyAdmin = this.getByRole(areaModel.getAreaId(), UserRolesEnum.countyAdmin.getValue());
                UserCustomerInfo countyUser = this.getByRole(areaModel.getAreaId(), UserRolesEnum.countyUser.getValue());
                UserCustomerInfo streetAdmin = this.getByRole(areaModel.getAreaId(), UserRolesEnum.streetAdmin.getValue());
                UserCustomerInfo streetUser = this.getByRole(areaModel.getAreaId(), UserRolesEnum.streetUser.getValue());
                if (user.getRole().contains(UserRolesEnum.countyAdmin.getValue().toString())) {
                    if (countyUser != null) {
                        userCustomerInfo.setRemark6(countyUser.getRemark6());
                        userCustomerInfo.setRemark7(countyUser.getRemark7());
                    }
                    if (streetAdmin != null) {
                        userCustomerInfo.setRemark8(streetAdmin.getRemark8());
                        userCustomerInfo.setRemark9(streetAdmin.getRemark9());
                    }
                    if (streetUser != null) {
                        userCustomerInfo.setRemark10(streetUser.getRemark10());
                    }
                } else if (user.getRole().contains(UserRolesEnum.countyUser.getValue().toString())) {
                    if (countyAdmin != null) {
                        userCustomerInfo.setRemark1(countyAdmin.getRemark1());
                        userCustomerInfo.setRemark2(countyAdmin.getRemark2());
                        userCustomerInfo.setRemark3(countyAdmin.getRemark3());
                        userCustomerInfo.setRemark4(countyAdmin.getRemark4());
                        userCustomerInfo.setRemark5(countyAdmin.getRemark5());
                    }
                    if (streetAdmin != null) {
                        userCustomerInfo.setRemark8(streetAdmin.getRemark8());
                        userCustomerInfo.setRemark9(streetAdmin.getRemark9());
                    } else {
                        userCustomerInfo.setRemark8(countyAdmin.getRemark8());
                        userCustomerInfo.setRemark9(countyAdmin.getRemark9());
                    }
                    if (streetUser != null) {
                        userCustomerInfo.setRemark10(streetUser.getRemark10());
                    } else {
                        userCustomerInfo.setRemark10(countyAdmin.getRemark10());
                    }
                    if (userCustomerInfo.getUpdateDate().before(countyAdmin.getUpdateDate())) {
                        userCustomerInfo.setRemark6(countyAdmin.getRemark6());
                        userCustomerInfo.setRemark7(countyAdmin.getRemark7());
                        userCustomerInfo.setUpdateDate(new Date());
                        this.update(userCustomerInfo);
                    }
                } else if (user.getRole().contains(UserRolesEnum.streetAdmin.getValue().toString())) {
                    if (countyAdmin != null) {
                        userCustomerInfo.setRemark1(countyAdmin.getRemark1());
                        userCustomerInfo.setRemark2(countyAdmin.getRemark2());
                        userCustomerInfo.setRemark3(countyAdmin.getRemark3());
                        userCustomerInfo.setRemark4(countyAdmin.getRemark4());
                        userCustomerInfo.setRemark5(countyAdmin.getRemark5());
                    }
                    if (countyUser != null) {
                        userCustomerInfo.setRemark6(countyUser.getRemark6());
                        userCustomerInfo.setRemark7(countyUser.getRemark7());
                    }
                    if (streetUser != null) {
                        userCustomerInfo.setRemark10(streetUser.getRemark10());
                    } else {
                        userCustomerInfo.setRemark10(countyAdmin.getRemark10());
                    }
                    if (userCustomerInfo.getUpdateDate().before(countyAdmin.getUpdateDate())) {
                        userCustomerInfo.setRemark8(countyAdmin.getRemark8());
                        userCustomerInfo.setRemark9(countyAdmin.getRemark9());
                        userCustomerInfo.setUpdateDate(new Date());
                        this.update(userCustomerInfo);
                    }
                } else if (user.getRole().contains(UserRolesEnum.streetUser.getValue().toString())) {
                    if (countyAdmin != null) {
                        userCustomerInfo.setRemark1(countyAdmin.getRemark1());
                        userCustomerInfo.setRemark2(countyAdmin.getRemark2());
                        userCustomerInfo.setRemark3(countyAdmin.getRemark3());
                        userCustomerInfo.setRemark4(countyAdmin.getRemark4());
                        userCustomerInfo.setRemark5(countyAdmin.getRemark5());
                    }
                    if (countyUser != null) {
                        userCustomerInfo.setRemark6(countyUser.getRemark6());
                        userCustomerInfo.setRemark7(countyUser.getRemark7());
                    }
                    if (streetAdmin != null) {
                        userCustomerInfo.setRemark8(streetAdmin.getRemark8());
                        userCustomerInfo.setRemark9(streetAdmin.getRemark9());
                    }
                    if (userCustomerInfo.getUpdateDate().before(countyAdmin.getUpdateDate())) {
                        userCustomerInfo.setRemark10(countyAdmin.getRemark10());
                        userCustomerInfo.setUpdateDate(new Date());
                        this.update(userCustomerInfo);
                    }
                }
            }
            return userCustomerInfo;
        }
        return null;
    }

    @Transactional
    public UserCustomerInfo getUserCustomerInfoByUserIdGeneral(AreaModel region, OrganizationUser user, UserCustomerInfoTypeEnum tableEnum) {
        if (ObjectUtil.hasNull((Object[])new Object[]{region, user, tableEnum})) {
            return null;
        }
        Example example = new Example(UserCustomerInfo.class);
        example.createCriteria().andEqualTo("userId", (Object)user.getId()).andEqualTo("tableId", (Object)tableEnum.getValue()).andEqualTo("isValid", (Object)Boolean.TRUE);
        List customerInfoList = this.getListByExample(example);
        return customerInfoList.stream().findFirst().map(i -> {
            i.setAreaId(region.getAreaId());
            i.setUserRole(user.getRole());
            ((UserCustomerMapper)this.dao).updateByPrimaryKeySelective(i);
            return i;
        }).orElse(null);
    }

    private void setTableHead(UserCustomerInfo userCustomerInfo, UserCustomerInfo dbuserCustomerInfo, Long areaId, String role) {
        if (role.contains(UserRolesEnum.countyAdmin.getValue().toString())) {
            BeanUtils.copyProperties((Object)userCustomerInfo, (Object)dbuserCustomerInfo, (String[])new String[]{"id", "companyHeadSet"});
        } else if (role.contains(UserRolesEnum.countyUser.getValue().toString())) {
            if (userCustomerInfo.getRemark6() != null) {
                dbuserCustomerInfo.setRemark6(userCustomerInfo.getRemark6());
            }
            if (userCustomerInfo.getRemark7() != null) {
                dbuserCustomerInfo.setRemark7(userCustomerInfo.getRemark7());
            }
        } else if (role.contains(UserRolesEnum.streetAdmin.getValue().toString())) {
            if (userCustomerInfo.getRemark8() != null) {
                dbuserCustomerInfo.setRemark8(userCustomerInfo.getRemark8());
            }
            if (userCustomerInfo.getRemark9() != null) {
                dbuserCustomerInfo.setRemark9(userCustomerInfo.getRemark9());
            }
        } else if (role.contains(UserRolesEnum.streetUser.getValue().toString()) && userCustomerInfo.getRemark10() != null) {
            dbuserCustomerInfo.setRemark10(userCustomerInfo.getRemark10());
        }
    }

    private void setLowwerRole(UserCustomerInfo userCustomerInfo, Long areaId) {
        Date date = new Date();
        if (userCustomerInfo.getRemark6() != null || userCustomerInfo.getRemark7() != null) {
            Example example1 = new Example(UserCustomerInfo.class);
            example1.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("areaId", (Object)areaId).andEqualTo("userRole", (Object)8);
            UserCustomerInfo qxCommonInfo = new UserCustomerInfo();
            qxCommonInfo.setRemark6(userCustomerInfo.getRemark6());
            qxCommonInfo.setRemark7(userCustomerInfo.getRemark7());
            qxCommonInfo.setUpdateDate(date);
            ((UserCustomerMapper)this.dao).updateByExampleSelective(qxCommonInfo, example1);
        }
        if (userCustomerInfo.getRemark8() != null || userCustomerInfo.getRemark9() != null) {
            Example example2 = new Example(UserCustomerInfo.class);
            example2.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("areaId", (Object)areaId).andEqualTo("userRole", (Object)9);
            UserCustomerInfo jdAdminInfo = new UserCustomerInfo();
            jdAdminInfo.setRemark8(userCustomerInfo.getRemark8());
            jdAdminInfo.setRemark9(userCustomerInfo.getRemark9());
            jdAdminInfo.setUpdateDate(date);
            ((UserCustomerMapper)this.dao).updateByExampleSelective(jdAdminInfo, example2);
        }
        if (userCustomerInfo.getRemark10() != null) {
            Example example3 = new Example(UserCustomerInfo.class);
            example3.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("areaId", (Object)areaId).andEqualTo("userRole", (Object)10);
            UserCustomerInfo jdCommonInfo = new UserCustomerInfo();
            jdCommonInfo.setRemark10(userCustomerInfo.getRemark10());
            jdCommonInfo.setUpdateDate(date);
            ((UserCustomerMapper)this.dao).updateByExampleSelective(jdCommonInfo, example3);
        }
    }

    private UserCustomerInfo getByRole(Long areaId, Byte role) {
        if (role != null) {
            Example example = new Example(UserCustomerInfo.class);
            example.createCriteria().andEqualTo("isValid", (Object)1).andEqualTo("tableId", (Object)1).andEqualTo("areaId", (Object)areaId).andEqualTo("userRole", (Object)role);
            List infoList = this.getListByExample(example);
            if (CollectionUtils.isNotEmpty(infoList)) {
                return (UserCustomerInfo)infoList.get(0);
            }
        }
        return null;
    }

    private Boolean isShowRemarks(Integer tableId, String areaName, OrganizationUser user) {
        if (UserCustomerInfoTypeEnum.COMPANY.getValue().equals(tableId) && "\u9e7f\u57ce\u533a".equals(areaName) && user != null && StringUtils.isNotBlank((CharSequence)user.getRole())) {
            return true;
        }
        return false;
    }
}

