/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.sys.impl;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.enums.sysParam.SysParamGroupEnum;
import cn.smarthse.modules.health.supervise.dao.sys.SysParamMapper;
import cn.smarthse.modules.health.supervise.entity.sys.SysParam;
import cn.smarthse.modules.health.supervise.service.sys.ISuperSysParamService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="superviseSysParamService")
@DubboService
@Transactional(readOnly=true)
public class SysParamServiceImpl
extends BaseServiceImpl<SysParamMapper, SysParam>
implements ISuperSysParamService {
    @Autowired
    SysParamMapper sysParamMapper;

    public List<SysParam> getListByGroup(SysParamGroupEnum group) {
        Example example = new Example(SysParam.class);
        example.createCriteria().andEqualTo("paramGroup", (Object)group.getValue()).andIsNotNull("pid").andEqualTo("isValid", (Object)true);
        return this.getListByExample(example);
    }

    public List<SysParam> getListByGroup(String group) {
        Example example = new Example(SysParam.class);
        example.createCriteria().andEqualTo("paramGroup", (Object)group).andIsNotNull("pid").andEqualTo("isValid", (Object)true);
        return this.getListByExample(example);
    }

    public SysParam getSysParamByName(String paramName, Long cid, SysParamGroupEnum group) {
        if (StringUtils.isEmpty((CharSequence)paramName) || group == null) {
            return null;
        }
        Example example = new Example(SysParam.class);
        Example.Criteria criteria2 = example.createCriteria();
        Example.Criteria criteria = example.createCriteria();
        if (group != null) {
            criteria.andEqualTo("paramGroup", (Object)group.getValue());
            criteria2.andEqualTo("paramGroup", (Object)group.getValue());
        }
        if (cid != null) {
            criteria.andEqualTo("cid", (Object)cid);
        }
        criteria2.andEqualTo("cid", (Object)0);
        if (StringUtils.isNotEmpty((CharSequence)paramName)) {
            criteria.andEqualTo("paramValue", (Object)paramName);
            criteria2.andEqualTo("paramValue", (Object)paramName);
        }
        criteria.andEqualTo("isValid", (Object)true);
        criteria2.andEqualTo("isValid", (Object)true);
        example.setOrderByClause("cid asc");
        example.or(criteria);
        return this.getSysParamByExample(example);
    }

    private SysParam getSysParamByExample(Example example) {
        if (example == null) {
            return null;
        }
        List list = super.getListByExample(example);
        return list == null || list.isEmpty() ? null : (SysParam)list.get(0);
    }

    public SysParam getSysParamByNameGroupCode(String paramName, Long cid, SysParamGroupEnum group, String paramCode) {
        if (StringUtils.isEmpty((CharSequence)paramName) || StringUtils.isEmpty((CharSequence)paramCode) || group == null) {
            return null;
        }
        Example example = new Example(SysParam.class);
        Example.Criteria criteria2 = example.createCriteria();
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("paramGroup", (Object)group.getValue());
        criteria2.andEqualTo("paramGroup", (Object)group.getValue());
        criteria.andEqualTo("paramCode", (Object)paramCode);
        criteria2.andEqualTo("paramCode", (Object)paramCode);
        if (cid != null) {
            criteria.andEqualTo("cid", (Object)cid);
        }
        criteria2.andEqualTo("cid", (Object)0);
        criteria.andEqualTo("paramValue", (Object)paramName);
        criteria2.andEqualTo("paramValue", (Object)paramName);
        criteria.andEqualTo("isValid", (Object)true);
        criteria2.andEqualTo("isValid", (Object)true);
        example.setOrderByClause("cid asc");
        example.or(criteria);
        return this.getSysParamByExample(example);
    }

    public List<SysParam> getSysParamListByChildren(String paramGroup) {
        Example example = new Example(SysParam.class);
        example.createCriteria().andEqualTo("paramGroup", (Object)paramGroup).andNotEqualTo("pid", (Object)0).andEqualTo("isValid", (Object)true);
        return ((SysParamMapper)this.dao).selectByExample(example);
    }
}

