/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.sys.impl;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseSearchModel;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.sms.ISMSProviderService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.entity.sys.message.Message;
import cn.smarthse.modules.health.entity.sys.message.MessageFile;
import cn.smarthse.modules.health.entity.sys.message.MessageReceiver;
import cn.smarthse.modules.health.enums.sys.MessageBusinessFromEnum;
import cn.smarthse.modules.health.enums.sys.MessageTypeEnum;
import cn.smarthse.modules.health.enums.sysParam.SysNoticeStatusEnum;
import cn.smarthse.modules.health.enums.sysParam.SysNoticeTypeEnum;
import cn.smarthse.modules.health.supervise.entity.basic.Organization;
import cn.smarthse.modules.health.supervise.entity.basic.OrganizationUser;
import cn.smarthse.modules.health.supervise.entity.sys.NotificationTemplate;
import cn.smarthse.modules.health.supervise.entity.sys.SysNotice;
import cn.smarthse.modules.health.supervise.entity.sys.SysNoticeFiles;
import cn.smarthse.modules.health.supervise.entity.sys.SysNoticeReceiver;
import cn.smarthse.modules.health.supervise.home.service.IExpireDateCompanyService;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationService;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationUserService;
import cn.smarthse.modules.health.supervise.service.message.IMessageThirdService;
import cn.smarthse.modules.health.supervise.service.sys.INotificationTemplateService;
import cn.smarthse.modules.health.supervise.service.sys.ISysNoticeFilesService;
import cn.smarthse.modules.health.supervise.service.sys.ISysNoticeReceiverService;
import cn.smarthse.modules.health.supervise.service.sys.ISysNoticeReceiverStateService;
import cn.smarthse.modules.health.supervise.service.sys.ISysNoticeService;
import cn.smarthse.modules.health.supervise.service.sys.ISysNoticeTaskService;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrganization;
import cn.smarthse.modules.health.thirdOrganization.service.notice.IThirdOrgNoticeProviderService;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrganizationService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@DubboService
@Transactional(readOnly=true)
public class SysNoticeTaskServiceImpl
implements ISysNoticeTaskService {
    @Autowired
    ISysNoticeService sysNoticeService;
    @Autowired
    ISysNoticeReceiverService sysNoticeReceiverService;
    @Autowired
    ISysNoticeFilesService sysNoticeFilesService;
    @DubboReference
    IMessageThirdService messageThirdService;
    @DubboReference
    ISysFileProvideService fileService;
    @Autowired
    IOrganizationService orgService;
    @Autowired
    IOrganizationUserService orgUserService;
    @DubboReference(version="1.0.0")
    ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @DubboReference(version="1.0.0")
    ISMSProviderService smsProviderService;
    @Autowired
    ISysNoticeReceiverStateService sysNoticeReceiverStateService;
    Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    @DubboReference
    IThirdOrgNoticeProviderService thirdOrgNoticeProviderService;
    @DubboReference(check=false)
    IThirdOrganizationService thirdOrganizationService;
    @Autowired
    INotificationTemplateService notificationTemplateService;
    @DubboReference(check=false)
    IExpireDateCompanyService expireDateCompanyService;
    private static final String wrapLine = "<br>";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=false)
    public void doTask() {
        List notices = this.sysNoticeService.getSendingList();
        if (notices == null || notices.isEmpty()) {
            this.logger.info("\u6ca1\u6709\u5f85\u53d1\u9001\u7684\u901a\u77e5");
            return;
        }
        NotificationTemplate dutyTemplate = (NotificationTemplate)this.notificationTemplateService.getById(Long.valueOf(123L));
        for (SysNotice notice : notices) {
            Long noticeId = notice.getId();
            Byte sendState = SysNoticeStatusEnum.sent.getValue();
            Message message = this.convertToMessage(notice);
            try {
                List receivers = this.sysNoticeReceiverService.listByNoticeId(noticeId);
                if (receivers == null || receivers.isEmpty()) {
                    this.updateNoticeState(noticeId, sendState);
                    this.logger.info("\u6ca1\u6709\u6536\u4ef6\u4eba");
                    continue;
                }
                Boolean sendSmsFlag = notice.getSendSmsFlag() == null ? false : notice.getSendSmsFlag();
                HashSet<String> superviseMobiles = new HashSet<String>();
                HashSet<String> smarthseMobiles = new HashSet<String>();
                HashSet<String> thirdOrgMobiles = new HashSet<String>();
                HashSet<Long> companies = new HashSet<Long>();
                ArrayList<MessageReceiver> messageReceiverList = new ArrayList<MessageReceiver>();
                ArrayList<SysNoticeReceiver> controlDutyCidList = new ArrayList<SysNoticeReceiver>();
                for (SysNoticeReceiver r : receivers) {
                    if (SysNoticeTypeEnum.controlduty.getValue().equals(r.getReceiverType())) {
                        controlDutyCidList.add(r);
                        continue;
                    }
                    this.addMobilesAndCompanies(superviseMobiles, smarthseMobiles, thirdOrgMobiles, companies, r.getReceiverId(), r.getReceiverType(), sendSmsFlag);
                    MessageReceiver messageReceiver = this.convertToMessageReceiver(r);
                    messageReceiverList.add(messageReceiver);
                }
                if (CollectionUtils.isNotEmpty(controlDutyCidList)) {
                    this.doControlDuty(controlDutyCidList, message, notice, sendSmsFlag, dutyTemplate);
                }
                if (!CollectionUtils.isNotEmpty(messageReceiverList)) continue;
                message.setReceivers(messageReceiverList);
                this.pushMessageToSmarthse(message, companies);
                this.pushMessageToThirdOrg(message);
                if (!sendSmsFlag.booleanValue()) continue;
                String noticeTile = notice.getNoticeTitle();
                String pubOrg = notice.getPublicOrg();
                String superviseSmsContent = "\u60a8\u7684\u804c\u4e1a\u5065\u5eb7\u76d1\u7ba1\u5e73\u53f0\u63a5\u6536\u5230\u4e00\u6761\u65b0\u7684\u901a\u77e5\uff0c\u4e3b\u9898\u4e3a\uff1a" + noticeTile + "\u3002\u8bf7\u53ca\u65f6\u767b\u5f55\u7cfb\u7edf\u67e5\u770b\uff01\u901a\u77e5\u6765\u6e90\uff1a" + pubOrg;
                this.sendSms(superviseSmsContent, superviseMobiles);
                System.out.println("------------superviseSmsContent:" + superviseSmsContent);
                String smarthseSmsContent = "\u60a8\u7684\u804c\u4e1a\u5065\u5eb7\u81ea\u4e3b\u7ba1\u7406\u7cfb\u7edf\u63a5\u6536\u5230\u4e00\u6761\u65b0\u7684\u901a\u77e5\uff0c\u4e3b\u9898\u4e3a\uff1a" + noticeTile + "\u3002\u8bf7\u53ca\u65f6\u767b\u5f55\u7cfb\u7edf\u67e5\u770b\uff01\u901a\u77e5\u6765\u6e90\uff1a" + pubOrg;
                this.sendSms(smarthseSmsContent, smarthseMobiles);
                System.out.println("------------smarthseSmsContent:" + smarthseSmsContent);
                String thirdOrgSmsContent = "\u60a8\u7684\u670d\u52a1\u673a\u6784\u7cfb\u7edf\u63a5\u6536\u5230\u4e00\u6761\u65b0\u7684\u901a\u77e5\uff0c\u4e3b\u9898\u4e3a\uff1a" + noticeTile + "\u3002\u8bf7\u53ca\u65f6\u767b\u5f55\u7cfb\u7edf\u67e5\u770b\uff01\u901a\u77e5\u6765\u6e90\uff1a" + pubOrg;
                this.sendSms(thirdOrgSmsContent, thirdOrgMobiles);
                System.out.println("------------thirdOrgSmsContent:" + thirdOrgSmsContent);
            }
            catch (Exception e) {
                this.logger.debug("\u901a\u77e5\u53d1\u9001\u9519\u8bef", (Throwable)e);
                sendState = SysNoticeStatusEnum.fail.getValue();
            }
            finally {
                this.updateNoticeState(noticeId, sendState);
            }
        }
    }

    private void doControlDuty(List<SysNoticeReceiver> controlDutyReceiverList, Message msg, SysNotice notice, Boolean sendSmsFlag, NotificationTemplate dutyTemplate) {
        List controlDutyCidList = controlDutyReceiverList.stream().map(SysNoticeReceiver::getReceiverId).collect(Collectors.toList());
        Map longListMap = this.expireDateCompanyService.expireComProject(controlDutyCidList);
        for (SysNoticeReceiver sysNoticeReceiver : controlDutyReceiverList) {
            Message message = new Message();
            BeanUtils.copyProperties((Object)msg, (Object)message);
            if (longListMap.containsKey(sysNoticeReceiver.getReceiverId())) {
                List integers = (List)longListMap.get(sysNoticeReceiver.getReceiverId());
                String controlDutyStr = this.getControlDutyStr(dutyTemplate, integers);
                message.setBussinessContent(controlDutyStr);
            }
            MessageReceiver messageReceiver = this.convertToMessageReceiver(sysNoticeReceiver);
            ArrayList<MessageReceiver> messageReceiverList = new ArrayList<MessageReceiver>();
            messageReceiverList.add(messageReceiver);
            message.setReceivers(messageReceiverList);
            HashSet<Long> companies = new HashSet<Long>();
            companies.add(sysNoticeReceiver.getReceiverId());
            this.pushMessageToSmarthse(message, companies);
            this.pushMessageToThirdOrg(message);
        }
        if (sendSmsFlag.booleanValue()) {
            HashSet<String> mobiles = new HashSet<String>();
            for (Long cid : controlDutyCidList) {
                CompanySuperviseModel companyInfo = this.companyProvideBySuperviseService.getCompanyInfoById(cid);
                if (companyInfo == null) continue;
                String legTel = companyInfo.getLegalTel();
                mobiles.add(legTel);
            }
            String string = notice.getPublicOrg();
            String noticeTile = notice.getNoticeTitle();
            String smarthseSmsContent = "\u60a8\u7684\u804c\u4e1a\u5065\u5eb7\u81ea\u4e3b\u7ba1\u7406\u7cfb\u7edf\u63a5\u6536\u5230\u4e00\u6761\u65b0\u7684\u901a\u77e5\uff0c\u4e3b\u9898\u4e3a\uff1a" + noticeTile + "\u3002\u8bf7\u53ca\u65f6\u767b\u5f55\u7cfb\u7edf\u67e5\u770b\uff01\u901a\u77e5\u6765\u6e90\uff1a" + string;
            this.sendSms(smarthseSmsContent, mobiles);
        }
    }

    private void pushMessageToThirdOrg(Message message) {
        this.thirdOrgNoticeProviderService.addMessageFromSupervise(message);
    }

    private MessageReceiver convertToMessageReceiver(SysNoticeReceiver r) {
        MessageReceiver mr = new MessageReceiver();
        mr.setReveiver(r.getReceiverId());
        mr.setMessageId(r.getNoticeId());
        mr.setReceiverName(this.sysNoticeReceiverService.getReceiverName(r.getReceiverId(), r.getReceiverType()));
        mr.setReceiverType(r.getReceiverType());
        mr.setMessageSate(r.getReceiverState());
        return mr;
    }

    private String getPubOrg(String noticeSource) {
        String pubOrg = "";
        try {
            Organization org = (Organization)this.orgService.getById(Long.valueOf(Long.parseLong(noticeSource)));
            pubOrg = org == null ? "" : org.getName();
        }
        catch (Exception e) {
            e.printStackTrace();
            return pubOrg;
        }
        return pubOrg == null ? "" : pubOrg;
    }

    private void updateNoticeState(Long noticeId, Byte state) {
        this.sysNoticeService.updateStatus(noticeId, state);
    }

    private void addMobilesAndCompanies(Set<String> superviseMobiles, Set<String> smarthseMobiles, Set<String> thirdOrgMobiles, Set<Long> companies, Long receiverId, String receiverType, Boolean sendSmsFlag) {
        block5: {
            block8: {
                block7: {
                    block6: {
                        block4: {
                            if (!SysNoticeTypeEnum.org.getValue().equals(receiverType) || !sendSmsFlag.booleanValue()) break block4;
                            List orgMobiles = this.orgUserService.getMobilesByOid(receiverId);
                            if (orgMobiles == null || orgMobiles.size() <= 0) break block5;
                            superviseMobiles.addAll(orgMobiles);
                            break block5;
                        }
                        if (!SysNoticeTypeEnum.company.getValue().equals(receiverType)) break block6;
                        CompanySuperviseModel companyInfo = this.companyProvideBySuperviseService.getCompanyInfoById(receiverId);
                        if (companyInfo == null) break block5;
                        String legTel = companyInfo.getLegalTel();
                        smarthseMobiles.add(legTel);
                        companies.add(receiverId);
                        break block5;
                    }
                    if (!SysNoticeTypeEnum.area.getValue().equals(receiverType)) break block7;
                    CompanySuperviseSearchModel companySearchVo = new CompanySuperviseSearchModel();
                    companySearchVo.setAreaId(receiverId);
                    List companyInfos = this.companyProvideBySuperviseService.listCompanyInfo(companySearchVo, false, Boolean.valueOf(false));
                    if (companyInfos == null || companyInfos.size() <= 0) break block5;
                    for (CompanySuperviseModel companyInfo : companyInfos) {
                        String legTel = companyInfo.getLegalTel();
                        smarthseMobiles.add(legTel);
                        companies.add(companyInfo.getId());
                    }
                    break block5;
                }
                if (!SysNoticeTypeEnum.third.getValue().equals(receiverType)) break block8;
                ThirdOrganization thirdOrganization = (ThirdOrganization)this.thirdOrganizationService.getById(receiverId);
                if (thirdOrganization == null) break block5;
                String tel = thirdOrganization.getContactPhone();
                thirdOrgMobiles.add(tel);
                break block5;
            }
            if (SysNoticeTypeEnum.indu.getValue().equals(receiverType)) {
                CompanySuperviseSearchModel companySearchVo = new CompanySuperviseSearchModel();
                companySearchVo.setIndustryCategory(receiverId);
                List companyInfos = this.companyProvideBySuperviseService.listCompanyInfo(companySearchVo, false, Boolean.valueOf(false));
                if (companyInfos != null && companyInfos.size() > 0) {
                    for (CompanySuperviseModel companyInfo : companyInfos) {
                        String legTel = companyInfo.getLegalTel();
                        smarthseMobiles.add(legTel);
                        companies.add(companyInfo.getId());
                    }
                }
            }
        }
    }

    private void sendSms(String title, Set<String> mobiles) {
        if (mobiles.isEmpty()) {
            return;
        }
        Object mobileStr = "";
        int i = 0;
        for (String m : mobiles) {
            if (!StringUtils.isMobile((String)m)) continue;
            mobileStr = (String)mobileStr + m;
            if (i == 1000) {
                String result = this.smsProviderService.batchSendTextSms(title, (String)mobileStr);
                i = 0;
                mobileStr = "";
            }
            ++i;
            mobileStr = (String)mobileStr + ",";
        }
        if (StringUtils.isNotEmpty((String)mobileStr)) {
            String string = this.smsProviderService.batchSendTextSms(title, (String)mobileStr);
        }
    }

    private Message convertToMessage(SysNotice notice) {
        Message message = new Message();
        List noticeFiles = this.sysNoticeFilesService.getListByNoticeId(notice.getId());
        OrganizationUser user = (OrganizationUser)this.orgUserService.getById(notice.getCreateBy());
        message.setBussinesId(notice.getId());
        message.setBussinesName(notice.getNoticeTitle());
        message.setBussinesType(MessageTypeEnum.notice.getValue());
        message.setBussinessContent(notice.getNoticeContent());
        message.setBussinesFromType(MessageBusinessFromEnum.superviseNotice.getValue());
        message.setCreateBy(notice.getCreateBy());
        message.setFiles(this.getMessageFilesByFileIds(noticeFiles));
        if (user != null) {
            message.setCreateUser(user == null ? null : user.getUsername());
            Organization org = (Organization)this.orgService.getById(user.getOid());
            message.setBussinesFrom(org == null ? null : org.getName());
            message.setCid(org.getId());
        }
        message.setSendTime(new Date());
        return message;
    }

    private void pushMessageToSmarthse(Message message, Set<Long> companies) {
        if (companies.isEmpty()) {
            return;
        }
        for (Long cid : companies) {
            Message messageOld;
            if (cid == null || (messageOld = this.messageThirdService.getMessage(message.getBussinesId(), cid)) != null) continue;
            this.messageThirdService.pushMessage(message, message.getCreateBy(), cid);
        }
    }

    private List<MessageFile> getMessageFilesByFileIds(List<SysNoticeFiles> noticeFiles) {
        if (noticeFiles == null || noticeFiles.isEmpty()) {
            return null;
        }
        ArrayList<MessageFile> files = new ArrayList<MessageFile>();
        for (SysNoticeFiles noticeFile : noticeFiles) {
            SysFileModel sysFile = noticeFile.getFile();
            if (sysFile == null) continue;
            MessageFile file = new MessageFile();
            file.setFileName(sysFile.getFileName());
            file.setFileOss(sysFile.getOssUrl());
            files.add(file);
        }
        return files;
    }

    public String getControlDutyStr(NotificationTemplate template, List<Integer> typeList) {
        if (template != null) {
            String fzStart = template.getFzStart();
            String fzEnd = template.getFzEnd();
            List<String> dutyList = this.getControlDutyStrList(template, typeList);
            StringBuffer content = new StringBuffer();
            content.append(fzStart);
            if (CollectionUtils.isNotEmpty(dutyList)) {
                for (int i = 0; i < dutyList.size(); ++i) {
                    content.append(wrapLine + (i + 1) + ":" + dutyList.get(i));
                }
            }
            content.append(wrapLine + fzEnd);
            return content.toString();
        }
        return "";
    }

    private List<String> getControlDutyStrList(NotificationTemplate template, List<Integer> typeList) {
        ArrayList<String> result = new ArrayList<String>();
        String[] tempStartArr = new String[]{"\u672a\u5f00\u5c55\u804c\u4e1a\u75c5\u5371\u5bb3\u9879\u76ee\u7533\u62a5", "\u672a\u5f00\u5c55\u804c\u4e1a\u75c5\u5371\u5bb3\u5b9a\u671f\u68c0\u6d4b", "\u672a\u5f00\u5c55\u804c\u4e1a\u75c5\u5371\u5bb3\u73b0\u72b6\u8bc4\u4ef7", "\u4f01\u4e1a\u4e3b\u8981\u8d1f\u8d23\u4eba\u672a\u53c2\u52a0\u804c\u4e1a\u5065\u5eb7\u57f9\u8bad", "\u4f01\u4e1a\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u4eba\u5458\u672a\u53c2\u52a0\u804c\u4e1a\u5065\u5eb7\u57f9\u8bad", "\u672a\u5f00\u5c55\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5"};
        if (template != null && CollectionUtils.isNotEmpty(typeList)) {
            for (Integer type : typeList) {
                if (type < 0 || type > 6) continue;
                String startStr = "";
                switch (type) {
                    case 0: {
                        result.add(startStr + template.getFzDeclare());
                        break;
                    }
                    case 1: {
                        result.add(startStr + template.getFzCheck());
                        break;
                    }
                    case 2: {
                        result.add(startStr + template.getFzEvaluate());
                        break;
                    }
                    case 3: {
                        result.add(startStr + template.getFzMain());
                        break;
                    }
                    case 4: {
                        result.add(startStr + template.getFzHse());
                        break;
                    }
                    case 5: {
                        result.add(startStr + template.getFzHealth());
                        break;
                    }
                }
            }
        }
        return result;
    }
}

