/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.sys.impl;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseSearchModel;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.entity.sys.message.Message;
import cn.smarthse.modules.health.entity.sys.message.MessageFile;
import cn.smarthse.modules.health.enums.sys.MessageBusinessFromEnum;
import cn.smarthse.modules.health.enums.sys.MessageTypeEnum;
import cn.smarthse.modules.health.enums.sysParam.SysNoticeStateEnum;
import cn.smarthse.modules.health.enums.sysParam.SysNoticeStatusEnum;
import cn.smarthse.modules.health.enums.sysParam.SysNoticeTypeEnum;
import cn.smarthse.modules.health.supervise.dao.sys.SysNoticeMapper;
import cn.smarthse.modules.health.supervise.entity.basic.Organization;
import cn.smarthse.modules.health.supervise.entity.basic.OrganizationUser;
import cn.smarthse.modules.health.supervise.entity.sys.SysMessage;
import cn.smarthse.modules.health.supervise.entity.sys.SysNotice;
import cn.smarthse.modules.health.supervise.entity.sys.SysNoticeFiles;
import cn.smarthse.modules.health.supervise.entity.sys.SysNoticeReceiver;
import cn.smarthse.modules.health.supervise.entity.sys.SysNoticeReceiverState;
import cn.smarthse.modules.health.supervise.entity.sys.ThirdNoticeSendCount;
import cn.smarthse.modules.health.supervise.entity.sys.ThirdNoticeSendRecord;
import cn.smarthse.modules.health.supervise.enums.sys.NoticeFromEnum;
import cn.smarthse.modules.health.supervise.model.sys.SysNoticeParam;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationService;
import cn.smarthse.modules.health.supervise.service.message.IMessageThirdService;
import cn.smarthse.modules.health.supervise.service.sys.ISuperviseSysAreaService;
import cn.smarthse.modules.health.supervise.service.sys.ISysMessageService;
import cn.smarthse.modules.health.supervise.service.sys.ISysNoticeFilesService;
import cn.smarthse.modules.health.supervise.service.sys.ISysNoticeReceiverService;
import cn.smarthse.modules.health.supervise.service.sys.ISysNoticeReceiverStateService;
import cn.smarthse.modules.health.supervise.service.sys.ISysNoticeService;
import cn.smarthse.modules.health.supervise.service.sys.ISysNoticeUserService;
import cn.smarthse.modules.health.supervise.vo.sys.SysNoticeReadCountVo;
import cn.smarthse.modules.health.thirdOrganization.service.notice.IThirdOrgNoticeProviderService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@DubboService
@Transactional(readOnly=true)
public class SysNoticeServiceImpl
extends BaseServiceImpl<SysNoticeMapper, SysNotice>
implements ISysNoticeService {
    @Autowired
    ISysNoticeFilesService sysNoticeFilesService;
    @Autowired
    ISysNoticeUserService noticeUserService;
    @Autowired
    ISuperviseSysAreaService sysAreaService;
    @DubboReference
    IMessageThirdService messageThirdService;
    @DubboReference
    ISysFileProvideService fileService;
    @Autowired
    IOrganizationService orgService;
    @Autowired
    ISysMessageService messageService;
    @Autowired
    ISysNoticeReceiverService sysNoticeReceiverService;
    @DubboReference(version="1.0.0")
    ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @DubboReference
    IThirdOrgNoticeProviderService thirdOrgNoticeProviderService;
    @Autowired
    ISysNoticeReceiverStateService sysNoticeReceiverStateService;

    public SysNotice getDetailById(Long id, Long orgId) {
        SysNotice notice = (SysNotice)((SysNoticeMapper)this.dao).selectByPrimaryKey(id);
        if (notice == null) {
            return notice;
        }
        this.sysNoticeReceiverService.setReceiver(notice, orgId);
        return notice;
    }

    @Transactional(readOnly=false)
    public SysNotice addOrUpdateNotice(SysNotice notice, String[] fileIds, OrganizationUser user, List<Company> companies) {
        Long userId = user == null ? null : user.getId();
        notice.setUpdateBy(userId);
        notice.setUpdateDate(new Date());
        if (notice.getId() == null) {
            notice.setCreateBy(userId);
            notice.setCreateDate(new Date());
            notice.setUpdateBy(userId);
            notice.setUpdateDate(new Date());
            this.add(notice);
        } else {
            this.update(notice, userId);
        }
        if (notice.getNoticeState() != null && notice.getNoticeState().intValue() == 1) {
            this.addUser(userId, notice.getId());
        }
        this.sysNoticeFilesService.adds(fileIds, userId, notice.getId());
        this.sysNoticeReceiverService.addReceiver(userId, notice);
        return notice;
    }

    private void doOthers(SysNotice notice, String[] fileIds, List<SysNoticeReceiver> companies, OrganizationUser user) {
        this.pushMessageToSmarthse(notice, fileIds, companies, user);
    }

    private void pushMessageToSmarthse(SysNotice notice, String[] fileIds, List<SysNoticeReceiver> companies, OrganizationUser user) {
        Byte noticeState = notice.getNoticeState() == null ? (byte)0 : notice.getNoticeState();
        if (1 != noticeState) {
            return;
        }
        if (companies == null || companies.size() == 0) {
            return;
        }
        Long createBy = null;
        Message message = new Message();
        message.setBussinesId(notice.getId());
        message.setBussinesName(notice.getNoticeTitle());
        message.setBussinesType(MessageTypeEnum.notice.getValue());
        message.setBussinessContent(notice.getNoticeContent());
        message.setBussinesFromType(MessageBusinessFromEnum.blocNotice.getValue());
        message.setFiles(this.getMessageFilesByFileIds(fileIds));
        if (user != null) {
            createBy = user.getId();
            message.setCreateUser(user == null ? null : user.getUsername());
            Organization org = (Organization)this.orgService.getById(user.getOid());
            message.setBussinesFrom(org == null ? null : org.getName());
        }
        message.setSendTime(new Date());
        for (SysNoticeReceiver c : companies) {
            Long cid = c.getReceiverId();
            if (cid == null) continue;
            this.messageThirdService.pushMessage(message, createBy, cid);
        }
    }

    private void pushMessage(SysNotice notice, String[] fileIds, List<Company> companies, OrganizationUser user) {
        Byte noticeState = notice.getNoticeState() == null ? (byte)0 : notice.getNoticeState();
        if (1 != noticeState) {
            return;
        }
        if (companies == null || companies.size() == 0) {
            return;
        }
        Long createBy = null;
        Message message = new Message();
        message.setBussinesId(notice.getId());
        message.setBussinesName(notice.getNoticeTitle());
        message.setBussinesType(MessageTypeEnum.notice.getValue());
        message.setBussinessContent(notice.getNoticeContent());
        message.setBussinesFromType(MessageBusinessFromEnum.blocNotice.getValue());
        message.setFiles(this.getMessageFilesByFileIds(fileIds));
        if (user != null) {
            createBy = user.getId();
            message.setCreateUser(user == null ? null : user.getUsername());
            Organization org = (Organization)this.orgService.getById(user.getOid());
            message.setBussinesFrom(org == null ? null : org.getName());
        }
        message.setSendTime(new Date());
        for (Company c : companies) {
            this.messageThirdService.pushMessage(message, createBy, c.getId());
        }
    }

    private List<MessageFile> getMessageFilesByFileIds(String[] fileIds) {
        if (fileIds == null || fileIds.length == 0) {
            return null;
        }
        ArrayList<MessageFile> files = new ArrayList<MessageFile>();
        for (String fileId : fileIds) {
            SysFileModel sysFile = this.fileService.getFileById(Long.valueOf(fileId));
            if (sysFile == null) continue;
            MessageFile file = new MessageFile();
            file.setFileName(sysFile.getFileName());
            file.setFileOss(sysFile.getOssUrl());
            files.add(file);
        }
        return files;
    }

    public PageInfo<SysNotice> getListByGridParam(JqGridParam gparam, SysNoticeParam param) {
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        if (StringUtils.isNotEmpty((String)gparam.getSidx())) {
            param.setOrder(gparam.getSidx() + " " + gparam.getSord());
        } else {
            param.setOrder("updateDate desc");
        }
        List<SysNotice> list = this.getList(param);
        return new PageInfo(list);
    }

    public PageInfo<SysNoticeReadCountVo> getListReadCountVoByGridParam(JqGridParam gparam, SysNoticeParam param) {
        if (StringUtils.isNotEmpty((String)gparam.getSidx())) {
            param.setOrder(gparam.getSidx() + " " + gparam.getSord());
        } else {
            param.setOrder("updateDate desc");
        }
        HashMap<Long, Set> allSendNotice = new HashMap<Long, Set>();
        HashMap<Long, Integer> readCidMap = new HashMap<Long, Integer>();
        List<SysNoticeReceiverState> noticeReceiverState = ((SysNoticeMapper)this.dao).getNoticeReceiverState(param.getOrgUserId(), null);
        if (CollUtil.isNotEmpty(noticeReceiverState)) {
            for (SysNoticeReceiverState sysNoticeReceiverState : noticeReceiverState) {
                allSendNotice.computeIfAbsent(sysNoticeReceiverState.getNoticeId(), v -> new HashSet()).add(sysNoticeReceiverState.getNoticeReceiverDetailId());
            }
            if (param.getUnread() != null && param.getUnread().booleanValue()) {
                ArrayList<Long> unReadNoticeList = new ArrayList<Long>();
                Set keyset = allSendNotice.keySet();
                for (Long noticeId : keyset) {
                    List smarthseReadCid = this.messageThirdService.getReadIds(noticeId);
                    readCidMap.put(noticeId, smarthseReadCid.size());
                    HashSet readCidSet = new HashSet(smarthseReadCid);
                    Set allCidSet = (Set)allSendNotice.get(noticeId);
                    if (allCidSet.size() <= readCidSet.size()) continue;
                    unReadNoticeList.add(noticeId);
                }
                param.setUnReadNoticeList(unReadNoticeList);
            }
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<SysNotice> list = this.getList(param);
        PageInfo sysNoticePageInfo = new PageInfo(list);
        PageInfo sysNoticeReadCountVoPageInfo = new PageInfo();
        BeanUtils.copyProperties((Object)sysNoticePageInfo, (Object)sysNoticeReadCountVoPageInfo);
        if (CollUtil.isNotEmpty(list)) {
            List voList = list.stream().map(m -> {
                SysNoticeReadCountVo vo = new SysNoticeReadCountVo();
                BeanUtils.copyProperties((Object)m, (Object)vo);
                if (vo.getNoticeState() != null && vo.getNoticeState() == 2 && vo.getNeedReadCount() != null && vo.getNeedReadCount().booleanValue()) {
                    if (readCidMap.containsKey(vo.getId())) {
                        Integer integer = (Integer)readCidMap.get(vo.getId());
                        vo.setReadNum((String)(integer == null ? "0" : "" + integer));
                        Set allsendCidSet = (Set)allSendNotice.get(vo.getId());
                        vo.setUnreadNum("" + (allsendCidSet.size() - integer));
                    } else {
                        List smarthseReadCid = this.messageThirdService.getReadIds(vo.getId());
                        int readNum = smarthseReadCid.size();
                        vo.setReadNum("" + readNum);
                        Set allsendCidSet = (Set)allSendNotice.get(vo.getId());
                        if (CollUtil.isNotEmpty((Collection)allsendCidSet)) {
                            vo.setUnreadNum("" + (allsendCidSet.size() - readNum));
                        }
                    }
                }
                vo.setReceiveOrgList(this.sysNoticeReceiverStateService.receiveOrgList(m.getId()));
                return vo;
            }).collect(Collectors.toList());
            sysNoticeReadCountVoPageInfo.setList(voList);
            return sysNoticeReadCountVoPageInfo;
        }
        return new PageInfo();
    }

    public PageInfo<CompanySuperviseModel> pageUnreadList(JqGridParam gparam, Long noticeId, String keyword) {
        HashSet<Long> allSendNotice = new HashSet<Long>();
        List<SysNoticeReceiverState> noticeReceiverState = ((SysNoticeMapper)this.dao).getNoticeReceiverState(null, noticeId);
        if (CollUtil.isNotEmpty(noticeReceiverState)) {
            for (SysNoticeReceiverState sysNoticeReceiverState : noticeReceiverState) {
                allSendNotice.add(sysNoticeReceiverState.getNoticeReceiverDetailId());
            }
        }
        List smarthseReadCid = this.messageThirdService.getReadIds(noticeId);
        allSendNotice.removeAll(smarthseReadCid);
        return new PageInfo();
    }

    public List<SysNotice> getList(SysNoticeParam param) {
        if (param.getOrgId() == null) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)param.getOrder())) {
            param.setOrder("updateDate desc");
        }
        return ((SysNoticeMapper)this.dao).selectReceiverList(param);
    }

    @Transactional(readOnly=false)
    public void deleteFile(SysNoticeFiles notice, Long loginUserOid) {
        this.sysNoticeFilesService.delete((Object)notice, loginUserOid);
    }

    public List<SysNoticeFiles> getListByNoticeId(Long noticeId) {
        return this.sysNoticeFilesService.getListByNoticeId(noticeId);
    }

    @Transactional(readOnly=false)
    public void addUser(Long loginUserOid, Long noticeId) {
        this.noticeUserService.addUser(loginUserOid, noticeId);
    }

    public String getFileIdsByNoticeId(Long noticeId) {
        return this.sysNoticeFilesService.getFileIdsByNoticeId(noticeId);
    }

    public Integer getUnreadCount(Organization org, Long orgUserId) {
        if (org == null || org.getId() == null) {
            return null;
        }
        SysNoticeParam param = new SysNoticeParam();
        param.setOrgUserId(orgUserId);
        param.setOrgId(org.getId());
        param.setOrgIds(this.getOrgIds(org, NoticeFromEnum.received.getName()));
        param.setNoticeState(String.valueOf(1));
        int total = 0;
        Integer noticeCount = ((SysNoticeMapper)this.dao).getReceiverUnreadCount(param);
        total += noticeCount == null ? 0 : noticeCount;
        Integer messageCount = this.messageService.getUnreadCount(org.getId(), orgUserId);
        return total += messageCount == null ? 0 : messageCount;
    }

    public List<Long> getOrgIds(Organization org, String from) {
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(org.getId());
        if (NoticeFromEnum.received.getName().equals(from)) {
            List parents = StringUtils.parseToLongList((String)org.getTreePath(), (String)",");
            list.addAll(parents);
        }
        return list;
    }

    public PageInfo<SysNotice> getReceivedPage(JqGridParam gparam, Long orgId, Long orgUserId) {
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<SysNotice> list = this.getReceivedList(orgId, orgUserId);
        return new PageInfo(list);
    }

    public List<SysNotice> getReceivedList(Long orgId, Long orgUserId) {
        if (orgUserId == null) {
            return null;
        }
        SysNoticeParam param = new SysNoticeParam();
        param.setOrgId(orgId);
        param.setOrgUserId(orgUserId);
        param.setNoticeType(Byte.valueOf((byte)1));
        param.setNoticeState("" + SysNoticeStatusEnum.sent.getValue());
        List<SysNotice> list = this.getList(param);
        return list;
    }

    @Transactional(readOnly=false)
    public void receipt(Long noticeId, Long noticeReceiverId, Long noticeReceiverName, Long loginUserId) {
        this.sysNoticeReceiverService.receipt(noticeId, noticeReceiverId, loginUserId);
        if (noticeId == null || noticeReceiverId == null) {
            return;
        }
        SysNotice send = (SysNotice)this.getById(noticeId);
        SysNotice notice = new SysNotice();
        String content = "\u8fd9\u662f\u90ae\u4ef6\u6536\u6761\uff0c\u6536\u4ef6\u4eba\uff1a" + noticeReceiverName + "</br>\u539f\u90ae\u4ef6\u4e3b\u9898\uff1a" + send.getNoticeTitle() + "\u6b64\u6536\u6761\u8868\u660e\u6536\u4ef6\u4eba\u7684\u7535\u8111\u4e0a\u66fe\u663e\u793a\u8fc7\u6b64\u90ae\u4ef6\uff0c\u663e\u793a\u65f6\u95f4\uff1a" + DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        notice.setNoticeContent(content);
        notice.setNoticeTitle("\u6536\u6761\uff1a" + send.getNoticeTitle());
        notice.setIsValid(Boolean.valueOf(true));
        notice.setNoticeState(Byte.valueOf((byte)1));
        notice = this.add(notice, loginUserId, null);
        SysNoticeReceiver r = new SysNoticeReceiver();
        r.setNoticeId(notice.getId());
        r.setReceiverType(SysNoticeTypeEnum.org.getValue());
        r.setReceiverState(SysNoticeStateEnum.send.getValue());
        r.setReceiverId(notice.getCreateBy());
        this.sysNoticeReceiverService.add((Object)r, loginUserId, null);
    }

    public List<SysNotice> getSendingList() {
        return ((SysNoticeMapper)this.dao).getSendingList();
    }

    @Transactional(readOnly=false)
    public void updateStatus(Long noticeId, Byte state) {
        if (noticeId == null) {
            return;
        }
        ((SysNoticeMapper)this.dao).updateStatus(noticeId, state);
    }

    public ThirdNoticeSendCount countReceiverState(SysNotice notice) {
        Long noticeId = notice.getId();
        Byte noticeState = notice.getNoticeState();
        ThirdNoticeSendCount count = new ThirdNoticeSendCount();
        if (noticeState == null) {
            return count;
        }
        List allReceivers = notice.getAllReceivers();
        int all = this.countAll(allReceivers);
        count.setAll(Integer.valueOf(all));
        if (all == 0) {
            return count;
        }
        if (noticeState == SysNoticeStatusEnum.sending.getValue()) {
            int sendCount = this.getSendCount(noticeId, allReceivers);
            count.setSentCount(Integer.valueOf(sendCount));
        } else if (noticeState == SysNoticeStatusEnum.sent.getValue()) {
            int readCount = this.getReadCount(noticeId);
            count.setReadCount(Integer.valueOf(readCount));
        }
        return count;
    }

    private int getReadCount(Long noticeId) {
        int thirdOrgCount = this.thirdOrgNoticeProviderService.getReadCount(noticeId);
        int smarthseCount = this.messageThirdService.thirdReadRecords(noticeId);
        int superviseCount = this.getReadNum(noticeId);
        return thirdOrgCount + smarthseCount + superviseCount;
    }

    private int getReadNum(Long noticeId) {
        List<Long> orgIds = this.getReadIds(noticeId);
        return orgIds.size();
    }

    private int getSendCount(Long noticeId, List<SysNoticeReceiver> allReceivers) {
        int thirdOrgCount = this.thirdOrgNoticeProviderService.getPushedThirdOrgs(noticeId);
        int smarthseCount = this.messageThirdService.getPushedCids(noticeId);
        int superviseCount = this.getSupervierseCount(allReceivers);
        return thirdOrgCount + smarthseCount + superviseCount;
    }

    private int getSupervierseCount(List<SysNoticeReceiver> allReceivers) {
        int count = 0;
        if (allReceivers == null || allReceivers.isEmpty()) {
            return count;
        }
        for (SysNoticeReceiver r : allReceivers) {
            String receiverType = r.getReceiverType();
            if (!SysNoticeTypeEnum.org.getValue().equals(receiverType)) continue;
            ++count;
        }
        return count;
    }

    private int countAll(List<SysNoticeReceiver> allReceivers) {
        int count = 0;
        if (allReceivers == null || allReceivers.isEmpty()) {
            return count;
        }
        for (SysNoticeReceiver r : allReceivers) {
            String receiverType = r.getReceiverType();
            if (SysNoticeTypeEnum.area.getValue().equals(receiverType)) {
                int companies = this.countAreaCompany(r.getReceiverId());
                count += companies;
                continue;
            }
            ++count;
        }
        return count;
    }

    private int countAreaCompany(Long receiverId) {
        CompanySuperviseSearchModel companySearchVo = new CompanySuperviseSearchModel();
        companySearchVo.setAreaId(receiverId);
        List companyInfos = this.companyProvideBySuperviseService.listCompanyInfo(companySearchVo, false, Boolean.valueOf(false));
        if (companyInfos != null && companyInfos.size() > 0) {
            return companyInfos.size();
        }
        return 0;
    }

    private void countRead(List<ThirdNoticeSendRecord> readRecords, ThirdNoticeSendCount count) {
        if (readRecords == null || readRecords.isEmpty()) {
            return;
        }
        for (ThirdNoticeSendRecord readRecord : readRecords) {
            Integer readCount = readRecord.getCount();
            if (readCount == null) continue;
            if (StringUtils.isNotBlank((CharSequence)readRecord.getFlag())) {
                count.setReadCount(Integer.valueOf(count.getReadCount() + readCount));
                continue;
            }
            count.setUnreadCount(Integer.valueOf(count.getReadCount() + readCount));
        }
    }

    @Transactional(readOnly=false)
    public void resend(Long noticeId) {
        this.updateStatus(noticeId, SysNoticeStatusEnum.sending.getValue());
    }

    public List<Long> getSendIds(Long noticeId) {
        List<Long> orgIds = ((SysNoticeMapper)this.dao).getSendIds(noticeId);
        return orgIds == null ? Collections.emptyList() : orgIds;
    }

    public List<Long> getReadIds(Long noticeId) {
        List<Long> orgIds = ((SysNoticeMapper)this.dao).superviseReadRecords(noticeId);
        return orgIds == null ? Collections.emptyList() : orgIds;
    }

    @Transactional(readOnly=false)
    public void deleteNotice(Long noticeId, Long loginUserId, Long oid) {
        SysNotice notice = (SysNotice)this.getById(noticeId);
        if (notice == null || notice.getNoticeState() == null || notice.getNoticeState().equals(SysNoticeStatusEnum.sent.getValue())) {
            return;
        }
        this.delete(notice, loginUserId);
        this.addTips(notice, loginUserId, oid);
    }

    private void addTips(SysNotice notice, Long longiUserId, Long oid) {
        this.addSuperviseTip(notice, longiUserId, oid);
        this.addThirdOrgTip(notice, longiUserId, oid);
    }

    private void addSuperviseTip(SysNotice notice, Long longiUserId, Long oid) {
        String title = notice.getNoticeTitle();
        List receivers = this.sysNoticeReceiverService.listByNoticeId(notice.getId());
        if (receivers == null || receivers.isEmpty()) {
            return;
        }
        for (SysNoticeReceiver r : receivers) {
            if (!SysNoticeTypeEnum.org.getValue().equals(r.getReceiverType())) continue;
            SysMessage sysMessage = new SysMessage();
            sysMessage.setContent(title + "\u901a\u77e5\u5df2\u88ab\u53d1\u5e03\u5355\u4f4d\u64a4\u56de\u3002");
            sysMessage.setTitle(title + "\u901a\u77e5\u64a4\u56de");
            sysMessage.setType(Byte.valueOf((byte)2));
            sysMessage.setSendTime(new Date());
            sysMessage.setOid(r.getReceiverId());
            this.messageService.add((Object)sysMessage, longiUserId, oid);
        }
    }

    private void addThirdOrgTip(SysNotice notice, Long longiUserId, Long oid) {
        this.thirdOrgNoticeProviderService.deleteNoticeMessage(notice.getId());
    }
}

