/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.sys.impl;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseSearchModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.health.enums.sysParam.SysNoticeStatusEnum;
import cn.smarthse.modules.health.enums.sysParam.SysNoticeTypeEnum;
import cn.smarthse.modules.health.supervise.dao.sys.SysNoticeReceiverStateMapper;
import cn.smarthse.modules.health.supervise.entity.sys.SysNotice;
import cn.smarthse.modules.health.supervise.entity.sys.SysNoticeReceiver;
import cn.smarthse.modules.health.supervise.entity.sys.SysNoticeReceiverState;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationService;
import cn.smarthse.modules.health.supervise.service.message.IMessageThirdService;
import cn.smarthse.modules.health.supervise.service.sys.ISuperviseSysAreaService;
import cn.smarthse.modules.health.supervise.service.sys.ISysNoticeReceiverStateService;
import cn.smarthse.modules.health.supervise.service.sys.ISysNoticeService;
import cn.smarthse.modules.health.supervise.vo.sys.SysNoticeReceiverInfo;
import cn.smarthse.modules.health.thirdOrganization.service.notice.IThirdOrgNoticeProviderService;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrganizationService;
import cn.smarthse.snowflake.IdWorker;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@Service
@DubboService
@Transactional(readOnly=true)
public class SysNoticeReceiverStateServiceImpl
extends BaseServiceImpl<SysNoticeReceiverStateMapper, SysNoticeReceiverState>
implements ISysNoticeReceiverStateService {
    @Autowired
    IOrganizationService orgService;
    @DubboReference(version="1.0.0")
    ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @Autowired
    ISuperviseSysAreaService sysAreaService;
    @DubboReference(check=false)
    IThirdOrganizationService thirdOrganizationService;
    @DubboReference
    IMessageThirdService messageThirdService;
    @DubboReference
    IThirdOrgNoticeProviderService thirdOrgNoticeProviderService;
    @Autowired
    ISysNoticeService sysNoticeService;
    @Autowired
    protected IdWorker idworker;

    @Transactional(readOnly=false)
    public void addByReceiver(SysNoticeReceiver receiver) {
        String receiverType = receiver.getReceiverType();
        Long noticeId = receiver.getNoticeId();
        Long rid = receiver.getId();
        Long receiverDetailId = receiver.getReceiverId();
        String receiverName = receiver.getReceiverName();
        if (SysNoticeTypeEnum.area.getValue().equals(receiverType)) {
            CompanySuperviseSearchModel companySearchVo = new CompanySuperviseSearchModel();
            companySearchVo.setAreaId(receiverDetailId);
            List companyInfos = this.companyProvideBySuperviseService.listCompanyInfo(companySearchVo, false, Boolean.valueOf(false));
            if (companyInfos != null && companyInfos.size() > 0) {
                ArrayList<SysNoticeReceiverState> list = new ArrayList<SysNoticeReceiverState>();
                for (CompanySuperviseModel companyInfo : companyInfos) {
                    SysNoticeReceiverState s = new SysNoticeReceiverState(noticeId, rid, companyInfo.getId(), companyInfo.getName());
                    s.setId(Long.valueOf(this.idworker.nextId()));
                    list.add(s);
                }
                if (list == null || list.isEmpty()) {
                    return;
                }
                ((SysNoticeReceiverStateMapper)this.dao).insertBatch(list);
            }
        } else {
            this.addOne(noticeId, rid, receiverDetailId, receiverName);
        }
    }

    private void addOne(Long noticeId, Long rid, Long receiverDetailId, String receiverName) {
        SysNoticeReceiverState state = new SysNoticeReceiverState(noticeId, rid, receiverDetailId, receiverName);
        this.add(state);
    }

    public PageInfo<SysNoticeReceiverInfo> getNoticeReceiverStatePage(JqGridParam gparam, Long noticeId) {
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        SysNotice notice = (SysNotice)this.sysNoticeService.getById(noticeId);
        if (notice == null) {
            return new PageInfo();
        }
        List<SysNoticeReceiverInfo> list = ((SysNoticeReceiverStateMapper)this.dao).getReceverStateList(noticeId);
        if (list == null || list.isEmpty()) {
            return new PageInfo(list);
        }
        List superviseSendOrgId = this.sysNoticeService.getSendIds(noticeId);
        List superviseReadOrgId = this.sysNoticeService.getReadIds(noticeId);
        List smarthseSendCid = this.messageThirdService.getSendIds(noticeId);
        List smarthseReadCid = this.messageThirdService.getReadIds(noticeId);
        List thirdOrgSendId = this.thirdOrgNoticeProviderService.getSendIds(noticeId);
        List thirdOrgReadId = this.thirdOrgNoticeProviderService.getReadIds(noticeId);
        String sendSate = SysNoticeStatusEnum.getName((Byte)notice.getNoticeState());
        for (SysNoticeReceiverInfo l : list) {
            l.setSendSate(sendSate);
            l.setReadSate("-");
            String receiverType = l.getReceiverType();
            Long receiverId = l.getReceiverId();
            if (SysNoticeTypeEnum.org.getValue().equals(receiverType)) {
                if (!superviseSendOrgId.contains(receiverId)) continue;
                l.setSendSate("\u53d1\u9001\u6210\u529f");
                if (superviseReadOrgId.contains(receiverId)) {
                    l.setReadSate("\u5df2\u9605\u8bfb");
                    continue;
                }
                l.setReadSate("\u672a\u9605\u8bfb");
                continue;
            }
            if (SysNoticeTypeEnum.company.getValue().equals(receiverType) || SysNoticeTypeEnum.area.getValue().equals(receiverType)) {
                if (!smarthseSendCid.contains(receiverId)) continue;
                l.setSendSate("\u53d1\u9001\u6210\u529f");
                if (smarthseReadCid.contains(receiverId)) {
                    l.setReadSate("\u5df2\u9605\u8bfb");
                    continue;
                }
                l.setReadSate("\u672a\u9605\u8bfb");
                continue;
            }
            if (!SysNoticeTypeEnum.third.getValue().equals(receiverType) || !thirdOrgSendId.contains(receiverId)) continue;
            l.setSendSate("\u53d1\u9001\u6210\u529f");
            if (thirdOrgReadId.contains(receiverId)) {
                l.setReadSate("\u5df2\u9605\u8bfb");
                continue;
            }
            l.setReadSate("\u672a\u9605\u8bfb");
        }
        return new PageInfo(list);
    }

    @Transactional(readOnly=false)
    public void deleteByNoticeId(Long noticeId) {
        Example example = new Example(SysNoticeReceiverState.class);
        example.createCriteria().andEqualTo("noticeId", (Object)noticeId);
        ((SysNoticeReceiverStateMapper)this.dao).deleteByExample(example);
    }

    public List<String> receiveOrgList(Long noticeId) {
        Example example = new Example(SysNoticeReceiverState.class);
        example.createCriteria().andEqualTo("noticeId", (Object)noticeId).andIn("sendState", Arrays.asList(1, 2));
        example.selectProperties(new String[]{"noticeReceiverDetailName"});
        List stateList = ((SysNoticeReceiverStateMapper)this.dao).selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)stateList)) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(stateList.size());
        for (SysNoticeReceiverState sysNoticeReceiverState : stateList) {
            result.add(sysNoticeReceiverState.getNoticeReceiverDetailName());
        }
        return result;
    }
}

