/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.sys.impl;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.system.IndustryModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.system.IndustryProvideService;
import cn.smarthse.modules.health.enums.sysParam.SysNoticeStateEnum;
import cn.smarthse.modules.health.enums.sysParam.SysNoticeTypeEnum;
import cn.smarthse.modules.health.supervise.dao.sys.SysNoticeReceiverMapper;
import cn.smarthse.modules.health.supervise.entity.basic.Organization;
import cn.smarthse.modules.health.supervise.entity.sys.SysArea;
import cn.smarthse.modules.health.supervise.entity.sys.SysNotice;
import cn.smarthse.modules.health.supervise.entity.sys.SysNoticeReceiver;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationService;
import cn.smarthse.modules.health.supervise.service.sys.ISuperviseSysAreaService;
import cn.smarthse.modules.health.supervise.service.sys.ISysNoticeReceiverService;
import cn.smarthse.modules.health.supervise.service.sys.ISysNoticeReceiverStateService;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrganization;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrganizationService;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@DubboService
@Transactional(readOnly=true)
public class SysNoticeReceiverServiceImpl
extends BaseServiceImpl<SysNoticeReceiverMapper, SysNoticeReceiver>
implements ISysNoticeReceiverService {
    @Autowired
    IOrganizationService orgService;
    @DubboReference(version="1.0.0")
    ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @Autowired
    ISuperviseSysAreaService sysAreaService;
    @DubboReference(check=false)
    IThirdOrganizationService thirdOrganizationService;
    @Autowired
    ISysNoticeReceiverStateService sysNoticeReceiverStateService;
    @DubboReference(version="1.0.0")
    IndustryProvideService industryProvideService;

    @Transactional(readOnly=false)
    public void addReceiver(Long userId, SysNotice notice) {
        Long noticeId = notice.getId();
        this.deleteAllReceiver(noticeId);
        this.addReceiverByType(userId, noticeId, SysNoticeStateEnum.send.getValue(), notice.getSendReceivers());
        this.addReceiverByType(userId, noticeId, SysNoticeStateEnum.copy.getValue(), notice.getCopyReceivers());
        this.addReceiverByType(userId, noticeId, SysNoticeStateEnum.separate.getValue(), notice.getSeparateReceivers());
    }

    private void addReceiverByType(Long userId, Long noticeId, String receiverState, List<SysNoticeReceiver> receiverList) {
        if (receiverList == null || receiverList.isEmpty()) {
            return;
        }
        for (SysNoticeReceiver r : receiverList) {
            if (r.getReceiverId() == null) continue;
            r.setNoticeId(noticeId);
            r.setReceiverState(receiverState);
            r.setIsValid(Global.TRUE);
            r.setCreateBy(userId);
            this.add(r);
            this.sysNoticeReceiverStateService.addByReceiver(r);
        }
    }

    private void deleteAllReceiver(Long noticeId) {
        Example example = new Example(SysNoticeReceiver.class);
        example.createCriteria().andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("noticeId", (Object)noticeId);
        ((SysNoticeReceiverMapper)this.dao).deleteByExample(example);
        this.sysNoticeReceiverStateService.deleteByNoticeId(noticeId);
    }

    public void setReceiver(SysNotice notice, Long orgId) {
        Long noticeId = notice.getId();
        Example example = new Example(SysNoticeReceiver.class);
        example.createCriteria().andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("noticeId", (Object)noticeId);
        List receiverList = ((SysNoticeReceiverMapper)this.dao).selectByExample(example);
        if (receiverList == null || receiverList.isEmpty()) {
            return;
        }
        notice.setAllReceivers(receiverList);
        for (SysNoticeReceiver r : receiverList) {
            String receivedType = r.getReceiverType();
            String receivedState = r.getReceiverState();
            Long receiverId = r.getReceiverId();
            r.setReceiverName(this.getReceiverName(receiverId, receivedType));
            if (SysNoticeStateEnum.send.getValue().equals(receivedState)) {
                notice.getSendReceivers().add(r);
            } else if (SysNoticeStateEnum.copy.getValue().equals(receivedState)) {
                notice.getCopyReceivers().add(r);
            } else if (SysNoticeStateEnum.separate.getValue().equals(receivedState)) {
                notice.getSeparateReceivers().add(r);
            }
            if (!String.valueOf(receiverId).equals(String.valueOf(orgId))) continue;
            notice.setReceiver(r);
        }
    }

    public String getReceiverName(Long receiverId, String receiverType) {
        String receiverName = "";
        if (SysNoticeTypeEnum.org.getValue().equals(receiverType)) {
            Organization org = (Organization)this.orgService.getById(receiverId);
            receiverName = org == null ? "" : org.getName();
        } else if (SysNoticeTypeEnum.company.getValue().equals(receiverType) || SysNoticeTypeEnum.controlduty.getValue().equals(receiverType)) {
            CompanySuperviseModel companyInfo = this.companyProvideBySuperviseService.getCompanyInfoById(receiverId);
            receiverName = companyInfo == null ? "" : companyInfo.getName();
        } else if (SysNoticeTypeEnum.area.getValue().equals(receiverType)) {
            SysArea area = (SysArea)this.sysAreaService.getById(receiverId);
            receiverName = area == null ? "" : area.getName();
        } else if (SysNoticeTypeEnum.third.getValue().equals(receiverType)) {
            ThirdOrganization thirdOrg = (ThirdOrganization)this.thirdOrganizationService.getById(receiverId);
            receiverName = thirdOrg == null ? "" : thirdOrg.getName();
        } else if (SysNoticeTypeEnum.indu.getValue().equals(receiverType)) {
            IndustryModel industry = this.industryProvideService.getIndustryById(receiverId);
            receiverName = industry == null ? "" : industry.getName();
        } else if (SysNoticeTypeEnum.indu.getValue().equals(receiverType)) {
            IndustryModel industry = this.industryProvideService.getIndustryById(receiverId);
            receiverName = industry == null ? "" : industry.getName();
        }
        return receiverName;
    }

    @Transactional(readOnly=false)
    public void receipt(Long noticeId, Long noticeReceiverId, Long loginUserId) {
        SysNoticeReceiver r = new SysNoticeReceiver();
        r.setReceipted(Boolean.valueOf(true));
        r.setUpdateBy(loginUserId);
        r.setUpdateDate(new Date());
        Example example = new Example(SysNoticeReceiver.class);
        example.createCriteria().andEqualTo("noticeId", (Object)noticeId).andEqualTo("receiverId", (Object)noticeReceiverId);
        ((SysNoticeReceiverMapper)this.dao).updateByExampleSelective(r, example);
    }

    public List<SysNoticeReceiver> listByNoticeId(Long noticeId) {
        Example example = new Example(SysNoticeReceiver.class);
        example.createCriteria().andEqualTo("noticeId", (Object)noticeId);
        return ((SysNoticeReceiverMapper)this.dao).selectByExample(example);
    }

    public List<Long> selectRecverIds(Long noticeId) {
        return ((SysNoticeReceiverMapper)this.dao).selectRecverIds(noticeId);
    }
}

