/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.sys.impl;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.supervise.dao.sys.SysNoticeFilesMapper;
import cn.smarthse.modules.health.supervise.entity.sys.SysNoticeFiles;
import cn.smarthse.modules.health.supervise.service.sys.ISysNoticeFilesService;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@DubboService
@Transactional(readOnly=true)
public class SysNoticeFilesServiceImpl
extends BaseServiceImpl<SysNoticeFilesMapper, SysNoticeFiles>
implements ISysNoticeFilesService {
    @DubboReference
    ISysFileProvideService sysFileService;

    @Transactional(readOnly=false)
    public void adds(String[] fileIds, Long userId, Long noticeId) {
        this.deleteByNoticeId(noticeId);
        if (fileIds != null && fileIds.length > 0) {
            SysNoticeFiles file = new SysNoticeFiles();
            file.setNoticeId(noticeId);
            file.setCreateBy(userId);
            int j = fileIds.length;
            for (int i = 0; i < j; ++i) {
                file.setId(null);
                file.setNoticeFileId(Long.valueOf(fileIds[i]));
                this.add(file);
            }
        }
    }

    private void deleteByNoticeId(Long noticeId) {
        if (noticeId == null) {
            return;
        }
        Example example = new Example(SysNoticeFiles.class);
        example.createCriteria().andEqualTo("noticeId", (Object)noticeId);
        ((SysNoticeFilesMapper)this.dao).deleteByExample(example);
    }

    public List<SysNoticeFiles> getListByNoticeId(Long noticeId) {
        Example example = new Example(SysNoticeFiles.class);
        example.createCriteria().andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("noticeId", (Object)noticeId);
        List list = ((SysNoticeFilesMapper)this.dao).selectByExample(example);
        for (SysNoticeFiles files : list) {
            SysFileModel file = this.sysFileService.getFileById(files.getNoticeFileId());
            files.setFile(file);
        }
        return list;
    }

    public String getFileIdsByNoticeId(Long noticeId) {
        return ((SysNoticeFilesMapper)this.dao).getFileIdsByNoticeId(noticeId);
    }
}

