/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.sys.impl;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.supervise.dao.sys.SysMessageMapper;
import cn.smarthse.modules.health.supervise.entity.basic.Organization;
import cn.smarthse.modules.health.supervise.entity.sys.SysMessage;
import cn.smarthse.modules.health.supervise.enums.sys.MessageStateEnum;
import cn.smarthse.modules.health.supervise.model.sys.SysMessageParam;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationService;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationUserService;
import cn.smarthse.modules.health.supervise.service.sys.ISysMessageService;
import cn.smarthse.modules.health.supervise.service.sys.ISysMessageUserService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@DubboService
@Transactional(readOnly=true)
public class SysMessageServiceImpl
extends BaseServiceImpl<SysMessageMapper, SysMessage>
implements ISysMessageService {
    @Autowired
    ISysMessageUserService messageUserService;
    @Autowired
    IOrganizationService orgService;
    @Autowired
    IOrganizationUserService organizationUserService;

    public PageInfo<SysMessage> getPage(JqGridParam gparam, SysMessageParam param) {
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        if (StringUtils.isNotEmpty((String)gparam.getSidx())) {
            param.setOrder(gparam.getSidx() + " " + gparam.getSord());
        } else {
            param.setOrder("updateDate desc");
        }
        List<SysMessage> list = this.getList(param);
        return new PageInfo(list);
    }

    @Transactional
    public void sendMessage2Admin(String content, Long createBy) {
    }

    public List<SysMessage> getList(SysMessageParam param) {
        if (param == null || param.getOrgId() == null) {
            return null;
        }
        return ((SysMessageMapper)this.dao).getList(param);
    }

    @Transactional
    public SysMessage push(SysMessage message, Long userId, Long cid) {
        if (message == null || cid == null) {
            return message;
        }
        this.setOidByCid(message, cid);
        this.add(message, userId, cid);
        return message;
    }

    private void setOidByCid(SysMessage message, Long cid) {
        Organization org = this.orgService.getNearestOrganHasUserByCidAnd(cid);
        message.setOid(org == null ? null : org.getId());
    }

    @Transactional
    public SysMessage getById(Long id, Long orgUserId, boolean isRead) {
        if (id == null) {
            return null;
        }
        SysMessage message = (SysMessage)this.getById(id);
        if (message != null && isRead) {
            this.messageUserService.addUserState(orgUserId, message.getCid(), id, MessageStateEnum.read.getValue());
        }
        return message;
    }

    public Integer getUnreadCount(Long orgId, Long orgUserId) {
        return ((SysMessageMapper)this.dao).getUnreadCount(orgId, orgUserId);
    }

    public SysMessage pushFromPlant(SysMessage message, Long userId, Long cid) {
        if (message == null || cid == null) {
            return message;
        }
        this.add(message, userId, cid);
        return message;
    }
}

