/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.sys.impl;

import cn.smarthse.common.annotation.LogConstans;
import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.es.esservice.ISysLogEsService;
import cn.smarthse.es.esservice.ISysLoginLogEsService;
import cn.smarthse.modules.datacentre.model.log.SysLog;
import cn.smarthse.modules.health.entity.sys.SysArea;
import cn.smarthse.modules.health.entity.sys.SysLoginStatV2;
import cn.smarthse.modules.health.model.syslog.SysLogSearchParam;
import cn.smarthse.modules.health.supervise.dao.sys.SysLogMapper;
import cn.smarthse.modules.health.supervise.service.sys.ISysLogService;
import cn.smarthse.snowflake.IdWorker;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="superviseSysLogServiceImpl")
@DubboService
@Transactional(readOnly=true)
public class SysLogServiceImpl
extends BaseServiceImpl<SysLogMapper, cn.smarthse.modules.health.entity.sys.SysLog>
implements ISysLogService {
    @DubboReference(check=false)
    ISysLogEsService sysLogEsService;
    @DubboReference(check=false)
    ISysLoginLogEsService loginLogEsService;
    @Autowired
    protected IdWorker idworker;
    @Autowired
    @Qualifier(value="commonThreadPoolExecutor")
    protected ThreadPoolExecutor executor;
    @Autowired
    protected RedisClient client;
    private static final String AREA_ISNULL_CACHE_NAME = "LOGINSTATE_AREA_ISNULL_CACHE";

    @Transactional(readOnly=false)
    public void addLog(cn.smarthse.modules.health.entity.sys.SysLog log) {
        log.setId(Long.valueOf(this.idworker.nextId()));
        if (log.getLogSource() == null) {
            log.setLogSource(Byte.valueOf(LogConstans.SUPERVISE.getValue().byteValue()));
        }
        this.executor.execute(() -> {
            try {
                if (Objects.equals(log.getType(), (byte)1)) {
                    String itemKey;
                    Object hget;
                    this.loginLogEsService.addLog(log);
                    if (log.getSysArea() != null && log.getSysArea().getProvinceId() != null && (hget = this.client.hget(AREA_ISNULL_CACHE_NAME, itemKey = String.valueOf(log.getLogSource()) + ":" + String.valueOf(log.getCreateBy()))) != null) {
                        this.loginLogEsService.updateAreaIsNullLog(log.getLogSource(), log.getCreateBy(), log.getSysArea());
                        this.client.setRemove(AREA_ISNULL_CACHE_NAME, new Object[]{itemKey});
                    }
                }
                this.sysLogEsService.addLog(log);
            }
            catch (Exception e) {
                this.logger.error("\u4fdd\u5b58es \u6570\u636e\u51fa\u9519:{}", (Throwable)e);
            }
        });
        try {
            this.add(log);
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58\u65e5\u5fd7\u6570\u636e\u51fa\u9519:{}", (Object)JSON.toJSONString((Object)log));
            this.logger.error("\u4fdd\u5b58\u65e5\u5fd7\u6570\u636e\u51fa\u9519:{}", (Throwable)e);
        }
    }

    public PageInfo<cn.smarthse.modules.health.entity.sys.SysLog> getList(JqGridParam param) {
        Example example = new Example(cn.smarthse.modules.health.entity.sys.SysLog.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("cid", (Object)param.getCid());
        c.andEqualTo("isValid", (Object)Global.TRUE);
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List list = null;
        if (StringUtils.isNotEmpty((String)param.getSidx())) {
            example.setOrderByClause(param.getSidx() + " " + param.getSord());
        } else {
            example.setOrderByClause("update_date desc");
        }
        list = this.getListByExample(example);
        return new PageInfo(list);
    }

    public PageInfo<cn.smarthse.modules.health.entity.sys.SysLog> getErrorList(JqGridParam param) {
        Example example = new Example(cn.smarthse.modules.health.entity.sys.SysLog.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("isValid", (Object)Global.FALSE);
        c.andEqualTo("type", (Object)0);
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List list = null;
        if (StringUtils.isNotEmpty((String)param.getSidx())) {
            example.setOrderByClause(param.getSidx() + " " + param.getSord());
        } else {
            example.setOrderByClause("update_date desc");
        }
        list = this.getListByExample(example);
        return new PageInfo(list);
    }

    public PageInfo<cn.smarthse.modules.health.entity.sys.SysLog> getListByAreaId(JqGridParam jparam, SysLogSearchParam param) {
        PageHelper.startPage((int)jparam.getPage(), (int)jparam.getRows());
        List<cn.smarthse.modules.health.entity.sys.SysLog> list = ((SysLogMapper)this.dao).getListByAreaId(param);
        return new PageInfo(list);
    }

    @Transactional(readOnly=false)
    public void synSysLog(SysLog log) {
        cn.smarthse.modules.health.entity.sys.SysLog localLog = new cn.smarthse.modules.health.entity.sys.SysLog();
        BeanUtils.copyProperties((Object)log, (Object)localLog);
        localLog.setId(Long.valueOf(this.idworker.nextId()));
        SysArea sysArea = localLog.getSysArea();
        if (sysArea == null) {
            sysArea = new SysArea();
            sysArea.setProvinceId(log.getProvinceId());
            sysArea.setCityId(log.getCityId());
            sysArea.setAreaId(log.getAreaId());
            sysArea.setStreetId(log.getStreetId());
            localLog.setSysArea(sysArea);
        }
        try {
            if (Objects.equals(log.getType(), (byte)1)) {
                this.loginLogEsService.addLog(localLog);
            }
            this.sysLogEsService.addLog(localLog);
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58es \u6570\u636e\u51fa\u9519:{}", (Throwable)e);
        }
        this.add(localLog);
    }

    public void collectAreaIsNullLogTask() {
        List sysLoginStatV2s = this.loginLogEsService.collectAreaIsNullLog();
        if (CollectionUtils.isNotEmpty((Collection)sysLoginStatV2s)) {
            for (SysLoginStatV2 v2 : sysLoginStatV2s) {
                this.client.hset(AREA_ISNULL_CACHE_NAME, v2.getSystemFlag() + ":" + v2.getCreateBy(), (Object)v2.getLoginCount());
            }
        }
    }
}

