/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.sys.impl;

import cn.smarthse.common.framework.Constants;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.supervise.dao.sys.SysAreaMapper;
import cn.smarthse.modules.health.supervise.entity.sys.SysArea;
import cn.smarthse.modules.health.supervise.model.regcollect.CompanyGovernQuery;
import cn.smarthse.modules.health.supervise.service.sys.ISuperviseSysAreaService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="superviseSysAreaServiceImpl")
@DubboService
@Transactional(readOnly=true)
public class SysAreaServiceImpl
extends BaseServiceImpl<SysAreaMapper, SysArea>
implements ISuperviseSysAreaService {
    @Autowired
    SysAreaMapper sysAreaMapper;

    public List<SysArea> listProvince() {
        SysArea criObj = new SysArea();
        criObj.setLevel(Byte.valueOf((byte)1));
        criObj.setParentId(Long.valueOf(0L));
        return this.commonQuerySysArea(criObj);
    }

    public List<SysArea> listCity(Long provinceId) throws Exception {
        if (provinceId == null) {
            throw new Exception("\u8bf7\u4f20\u5165\u7701\u4efd\u7684\u7f16\u53f7");
        }
        SysArea criObj = new SysArea();
        criObj.setLevel(Byte.valueOf((byte)2));
        criObj.setParentId(provinceId);
        return this.commonQuerySysArea(criObj);
    }

    public List<SysArea> listArea(Long cityId) throws Exception {
        if (cityId == null) {
            throw new Exception("\u8bf7\u4f20\u5165\u5e02\u7684\u7f16\u53f7");
        }
        SysArea criObj = new SysArea();
        criObj.setLevel(Byte.valueOf((byte)3));
        criObj.setParentId(cityId);
        return this.commonQuerySysArea(criObj);
    }

    public List<SysArea> listStreet(Long areaId) throws Exception {
        if (areaId == null) {
            throw new Exception("\u8bf7\u4f20\u5165\u533a\u57df\u7684\u7f16\u53f7");
        }
        SysArea criObj = new SysArea();
        criObj.setLevel(Byte.valueOf((byte)4));
        criObj.setParentId(areaId);
        return this.commonQuerySysArea(criObj);
    }

    public List<SysArea> commonQuerySysArea(SysArea queryObj) {
        Example example = new Example(SysArea.class);
        Example.Criteria cri = example.createCriteria();
        queryObj.setIsValid(Boolean.valueOf(true));
        cri.andEqualTo((Object)queryObj);
        example.orderBy("orderBy");
        return this.sysAreaMapper.selectByExample(example);
    }

    public String getFullName(Long areaId, String separation) {
        if (areaId == null) {
            return "";
        }
        SysArea area = this.getById(areaId);
        if (area != null) {
            StringBuffer areaName = new StringBuffer();
            areaName.append(area.getProvinceName());
            if (StringUtils.isNotBlank((CharSequence)area.getCityName())) {
                areaName.append(separation + area.getCityName());
            }
            if (StringUtils.isNotBlank((CharSequence)area.getAreaName())) {
                areaName.append(separation + area.getAreaName());
            }
            if (StringUtils.isNotBlank((CharSequence)area.getStreetName())) {
                areaName.append(separation + area.getStreetName());
            }
            return areaName.toString();
        }
        return "";
    }

    public Long getAreaIdByName(String areaName) {
        SysArea area = this.getAreaByName(areaName);
        return area == null ? null : area.getId();
    }

    public SysArea getAreaByName(String areaName) {
        if (StringUtils.isNotBlank((CharSequence)areaName)) {
            areaName = StringUtils.replace((String)areaName, (String)"\u300b", (String)">");
            String[] areaArr = StringUtils.split((String)(areaName = StringUtils.replace((String)areaName, (String)"\uff1e", (String)">")), (String)">");
            if (areaArr == null || areaArr.length == 0) {
                return null;
            }
            int leng = areaArr.length;
            SysArea criObj = new SysArea();
            if (leng == 1) {
                criObj.setProvinceName(areaArr[0].trim());
            }
            if (leng == 2) {
                criObj.setProvinceName(areaArr[0].trim());
                criObj.setCityName(areaArr[1].trim());
            }
            if (leng == 3) {
                criObj.setProvinceName(areaArr[0].trim());
                criObj.setCityName(areaArr[1].trim());
                criObj.setAreaName(areaArr[2].trim());
            }
            if (leng == 4) {
                criObj.setProvinceName(areaArr[0].trim());
                criObj.setCityName(areaArr[1].trim());
                criObj.setAreaName(areaArr[2].trim());
                criObj.setStreetName(areaArr[3].trim());
            }
            criObj.setIsValid(Boolean.valueOf(true));
            criObj.setLevel(Byte.valueOf((byte)leng));
            List areaList = this.sysAreaMapper.select(criObj);
            if (areaList != null && !areaList.isEmpty()) {
                return (SysArea)areaList.get(0);
            }
        }
        return null;
    }

    public SysArea getAreaByNameTwo(CompanyGovernQuery queryParam) {
        SysArea criObj2 = null;
        if (StringUtils.isNotBlank((CharSequence)queryParam.getAreaName())) {
            SysArea criObj = new SysArea();
            criObj.setName(queryParam.getAreaName());
            List<SysArea> areaList = this.sysAreaMapper.selectByAreaNameTwo(criObj);
            SysArea queryParamArea = this.getById(queryParam.getUserAreaId());
            if (areaList.size() > 0 && queryParamArea != null) {
                for (SysArea area : areaList) {
                    if (area.getCityId() != null) {
                        if (!area.getCityId().equals(queryParamArea.getCityId())) continue;
                        criObj2 = area;
                        return criObj2;
                    }
                    if (area.getProvinceId() == null || !area.getProvinceId().equals(queryParamArea.getProvinceId())) continue;
                    criObj2 = area;
                    return criObj2;
                }
            }
        }
        return criObj2;
    }

    public List<SysArea> getChildByParentId(Long parentId) {
        if (parentId == null) {
            parentId = 0L;
        }
        SysArea area = new SysArea();
        area.setIsValid(Boolean.valueOf(true));
        area.setParentId(parentId);
        return ((SysAreaMapper)this.dao).select(area);
    }

    public List<SysArea> getChildByParentId(Long parentId, String name) {
        if (parentId == null) {
            parentId = 0L;
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            parentId = null;
        }
        SysArea area = new SysArea();
        area.setIsValid(Boolean.valueOf(true));
        area.setParentId(parentId);
        area.setName(name);
        return ((SysAreaMapper)this.dao).listArea(area);
    }

    public int countParentId(Long parentId) {
        if (parentId == null) {
            parentId = 0L;
        }
        return ((SysAreaMapper)this.dao).countParentId(parentId);
    }

    @Override
    public SysArea getById(Long id) {
        if (Constants.NATIONAL_LEVEL_ID.equals(id)) {
            SysArea area = new SysArea();
            area = new SysArea();
            area.setId(Constants.NATIONAL_LEVEL_ID);
            area.setLevel(Byte.valueOf((byte)0));
            area.setIsValid(Boolean.valueOf(true));
            area.setName("\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd");
            area.setParentId(Long.valueOf(-1L));
            area.setShortName("\u4e2d\u56fd");
            return area;
        }
        return (SysArea)super.getById(id);
    }

    public List<SysArea> containAuthArea(SysArea sarea) {
        return ((SysAreaMapper)this.dao).containAuthArea(sarea);
    }

    public SysArea getAreaByName(Long areaId, Byte levle, String name) {
        if (name == null) {
            return null;
        }
        SysArea criObj = new SysArea();
        if (levle == 1) {
            criObj.setProvinceId(areaId);
        } else if (levle == 2) {
            criObj.setCityId(areaId);
        } else if (levle == 3) {
            criObj.setAreaId(areaId);
        } else if (levle == 4) {
            criObj.setStreetId(areaId);
        }
        criObj.setName(name);
        List<SysArea> list = this.commonQuerySysArea(criObj);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public List<SysArea> getListByLevel(Long areaId, Byte resLevel, Byte areaLevel) {
        SysArea criObj = new SysArea();
        criObj.setLevel(resLevel);
        if (areaLevel == 1) {
            criObj.setProvinceId(areaId);
        } else if (areaLevel == 2) {
            criObj.setCityId(areaId);
        } else if (areaLevel == 3) {
            criObj.setAreaId(areaId);
        } else if (areaLevel == 4) {
            criObj.setStreetId(areaId);
        }
        return this.commonQuerySysArea(criObj);
    }

    public List<SysArea> getStreetListByCoordinate(Long provinceId, String blng, String elng, String blat, String elat) {
        return ((SysAreaMapper)this.dao).getStreetListByCoordinate(provinceId, blng, elng, blat, elat);
    }

    public List<SysArea> getDistrictListByCoordinate(String blng, String elng, String blat, String elat) {
        return ((SysAreaMapper)this.dao).getDistrictListByCoordinate(blng, elng, blat, elat);
    }

    public SysArea queryByName(String areaName) {
        if (areaName == null || areaName.isEmpty()) {
            return null;
        }
        List<SysArea> sysAreas = ((SysAreaMapper)this.dao).queryByName(areaName);
        if (sysAreas.size() > 0) {
            return sysAreas.get(0);
        }
        return null;
    }

    public SysArea getParentAreaById(Long childAreaId) {
        return ((SysAreaMapper)this.dao).getParentAreaById(childAreaId);
    }

    public String getBxLoginCode(Long loginUserAreaId, Byte loginAreaLevle) {
        return ((SysAreaMapper)this.dao).getBxLoginCode(loginUserAreaId, loginAreaLevle);
    }
}

