/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.sys.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.supervise.dao.sys.ParamMapper;
import cn.smarthse.modules.health.supervise.entity.sys.Param;
import cn.smarthse.modules.health.supervise.service.sys.IParamService;
import cn.smarthse.modules.platform.model.AreaModel;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@DubboService
@Transactional(readOnly=true)
public class ParamServiceImpl
extends BaseServiceImpl<ParamMapper, Param>
implements IParamService {
    @Autowired
    ParamMapper paramMapper;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;

    @PostConstruct
    public void init() {
        if (!this.haveThisrKey(null, "sms_areas", 0L).booleanValue()) {
            this.logger.info("\u6dfb\u52a0\u77ed\u4fe1\u53d1\u9001\u533a\u57df\u7684\u7cfb\u7edf\u53c2\u6570");
            Param param = new Param();
            param.setId(Long.valueOf(10L));
            param.setParamKey("sms_areas");
            param.setParamValue("");
            param.setName("\u77ed\u4fe1\u53d1\u9001\u533a\u57df");
            param.setParamDescribe("\u5177\u6709\u77ed\u4fe1\u901a\u77e5\u5373\u5c06\u903e\u671f\u4f01\u4e1a\u529f\u80fd\u7684\u533a\u57dfID\u96c6\u5408\uff0c\u533a\u57dfID\u53ef\u5230\u884c\u653f\u533a\u5212\u6a21\u5757\u67e5\u8be2\uff0cID\u4e4b\u95f4\u7528\u82f1\u6587\u72b6\u6001\u4e0b\u7684\u9017\u53f7\u9694\u5f00");
            param.setCreateBy(Long.valueOf(0L));
            param.setUpdateBy(Long.valueOf(0L));
            param.setCreateDate(new Date());
            param.setCreateDate(new Date());
            param.setIsValid(Boolean.valueOf(true));
            this.add(param);
        }
    }

    public PageInfo<Param> getParamPage(JqGridParam gparam, Param param) {
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<Param> list = this.paramMapper.getListByParam(param);
        PageInfo page = new PageInfo(list);
        return page;
    }

    @Transactional(readOnly=false)
    public void addSelfAssessmentWarningCycle(Long areaId, Long loginUserId) {
        String value = this.getByKey("general_self_assessment_warning_cycle", areaId);
        if (value == null) {
            Param param1 = new Param();
            param1.setAreaId(areaId);
            param1.setName("\u4e00\u822c\u7c7b\u522b\u81ea\u6211\u8bc4\u4f30\u9884\u8b66\u5468\u671f");
            param1.setParamKey("general_self_assessment_warning_cycle");
            param1.setParamValue("3");
            param1.setParamDescribe("\u804c\u4e1a\u75c5\u5371\u5bb3\u7c7b\u522b\u4e3a\u4e00\u822c\u7684\u4f01\u4e1a\u7684\u81ea\u6211\u8bc4\u4f30\u9884\u8b66\u5468\u671f\uff0c\u5355\u4f4d\u4e3a\u201c\u5e74\u201d");
            this.add(param1, loginUserId, null);
        }
        if ((value = this.getByKey("serious_self_assessment_warning_cycle", areaId)) == null) {
            Param param2 = new Param();
            param2.setAreaId(areaId);
            param2.setName("\u4e25\u91cd\u7c7b\u522b\u81ea\u6211\u8bc4\u4f30\u9884\u8b66\u5468\u671f");
            param2.setParamKey("serious_self_assessment_warning_cycle");
            param2.setParamValue("1");
            param2.setParamDescribe("\u804c\u4e1a\u75c5\u5371\u5bb3\u7c7b\u522b\u4e3a\u4e25\u91cd\u7684\u4f01\u4e1a\u7684\u81ea\u6211\u8bc4\u4f30\u9884\u8b66\u5468\u671f\uff0c\u5355\u4f4d\u4e3a\u201c\u5e74\u201d");
            this.add(param2, loginUserId, null);
        }
    }

    public Long getGeneralSelfAssessmentWarningCycle(Long areaId) {
        String value = this.getByKey("general_self_assessment_warning_cycle", areaId);
        if (StringUtils.isNumber((String)value)) {
            return Long.valueOf(value);
        }
        return 3L;
    }

    public Long getSeriousSelfAssessmentWarningCycle(Long areaId) {
        String value = this.getByKey("general_self_assessment_warning_cycle", areaId);
        if (StringUtils.isNumber((String)value)) {
            return Long.valueOf(value);
        }
        return 1L;
    }

    @Transactional(readOnly=false)
    public void addSmsAreaskey(Long loginStaffId) {
        Example example = new Example(Param.class);
        example.createCriteria().andEqualTo("paramKey", (Object)"sms_areas").andEqualTo("isValid", (Object)true).andEqualTo("areaId", (Object)0);
        List list = this.getListByExample(example);
        if (list.size() > 0) {
            Param param = (Param)list.get(0);
            if (StringUtils.isNotEmpty((String)param.getParamValue())) {
                Arrays.stream(param.getParamValue().trim().split(",")).filter(s -> StringUtils.isNumber((String)s.trim())).collect(Collectors.toList()).forEach(s -> {
                    Example e = new Example(Param.class);
                    e.createCriteria().andEqualTo("paramKey", (Object)("sms_area_" + s.trim())).andEqualTo("isValid", (Object)true).andEqualTo("areaId", (Object)Long.valueOf(s.trim()));
                    if (this.getCountByExample(e) == 0) {
                        Param pa = new Param();
                        pa.setAreaId(Long.valueOf(s.trim()));
                        pa.setParamKey("sms_area_" + s.trim());
                        pa.setParamValue(s.trim());
                        AreaModel am = this.sysAreaProvideService.getAreaById(pa.getAreaId());
                        pa.setName(am.getFullname() + "\u77ed\u4fe1\u53d1\u9001\u529f\u80fd");
                        pa.setIsForbidden(Boolean.valueOf(true));
                        pa.setParamDescribe("\u53ef\u8bbe\u7f6e\u662f\u5426\u53d1\u9001\u77ed\u4fe1\u7ed9\u4f53\u68c0\u548c\u68c0\u6d4b\u5373\u5c06\u903e\u671f\u4f01\u4e1a");
                        this.add(pa, loginStaffId, null);
                    }
                });
            }
        } else {
            Param param = new Param();
            param.setAreaId(Long.valueOf(0L));
            param.setParamKey("sms_areas");
            param.setName("\u77ed\u4fe1\u53d1\u9001\u533a\u57df");
            param.setParamDescribe("\u5177\u6709\u77ed\u4fe1\u901a\u77e5\u5373\u5c06\u903e\u671f\u4f01\u4e1a\u529f\u80fd\u7684\u533a\u57dfID\u96c6\u5408\uff0c\u533a\u57dfID\u53ef\u5230\u884c\u653f\u533a\u5212\u6a21\u5757\u67e5\u8be2\uff0cID\u4e4b\u95f4\u7528\u82f1\u6587\u72b6\u6001\u4e0b\u7684\u9017\u53f7\u9694\u5f00");
            this.add(param, loginStaffId, null);
        }
    }

    @Transactional(readOnly=false)
    public void isOrNotForbidden(Long id, Boolean isForbidden, Long loginStaffId) {
        if (id != null) {
            Param param = new Param();
            param.setId(id);
            param.setIsForbidden(isForbidden);
            this.update(param, loginStaffId);
        }
    }

    public Param getByKeyAndArea(String key, Long areaId) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        Example example = new Example(Param.class);
        example.createCriteria().andEqualTo("paramKey", (Object)key).andEqualTo("isValid", (Object)true).andEqualTo("areaId", (Object)areaId);
        List params = this.paramMapper.selectByExample(example);
        if (params == null || params.isEmpty()) {
            return null;
        }
        return (Param)params.get(0);
    }

    @Transactional(readOnly=false)
    public Param addDefaltParam(Param defaltParam, Long areaId, Long loginStaffId) {
        if (defaltParam == null) {
            return null;
        }
        AreaModel am = this.sysAreaProvideService.getAreaById(areaId);
        defaltParam.setAreaId(areaId);
        if (am != null && StringUtils.isEmpty((CharSequence)defaltParam.getName())) {
            defaltParam.setName(am.getName() + defaltParam.getParamKey());
        }
        this.add(defaltParam, loginStaffId, null);
        return defaltParam;
    }

    @Transactional(readOnly=false)
    public void smsBatchAddOrUpdate(List<Param> infos, Long loginStaffId) {
        this.batchUpdateOrInsert(infos, ParamMapper.class, (item, mapper) -> {
            item.setUpdateBy(loginStaffId);
            item.setUpdateDate(new Date());
            if (ObjectUtil.isNull((Object)item.getId())) {
                item.setId(Long.valueOf(this.idworker.nextId()));
                item.setCreateBy(loginStaffId);
                item.setCreateDate(new Date());
                return mapper.insertSelective(item);
            }
            return mapper.updateByPrimaryKeySelective(item);
        });
    }

    public List<Param> getByKeyListAndArea(List<String> keyList, Long areaId) {
        if (CollectionUtil.isEmpty(keyList)) {
            return new ArrayList<Param>();
        }
        Example example = new Example(Param.class);
        example.createCriteria().andIn("paramKey", keyList).andEqualTo("isValid", (Object)true).andEqualTo("areaId", (Object)areaId);
        List params = this.paramMapper.selectByExample(example);
        return params;
    }

    public Map<String, Param> getMapByKeyListAndArea(List<String> keyList, Long areaId) {
        List<Param> byKeyListAndArea = this.getByKeyListAndArea(keyList, areaId);
        if (CollectionUtil.isNotEmpty(byKeyListAndArea)) {
            return byKeyListAndArea.stream().collect(Collectors.toMap(Param::getParamKey, p -> p, (p1, p2) -> p1));
        }
        return new HashMap<String, Param>();
    }

    public String getByKey(String paramKey, Long areaId) {
        Param param = this.getByKeyAndArea(paramKey, areaId);
        if (param != null) {
            return param.getParamValue();
        }
        return null;
    }

    public String getMaintenanceValueByKey(String paramKey) {
        if (StringUtils.isBlank((CharSequence)paramKey)) {
            return null;
        }
        Example example = new Example(Param.class);
        example.createCriteria().andEqualTo("paramKey", (Object)paramKey).andEqualTo("isValid", (Object)true).andEqualTo("dataSource", (Object)2);
        List params = this.paramMapper.selectByExample(example);
        if (params == null || params.isEmpty()) {
            return null;
        }
        return ((Param)params.get(0)).getParamValue();
    }

    @Transactional(readOnly=false)
    @Async
    public void updateSmsArea() {
        String areas = this.getByKey("sms_areas", 0L);
        this.logger.info("\u66f4\u65b0\u53d1\u9001\u77ed\u4fe1\u7684\u533a\u57df:" + areas);
        if (areas == null || areas.isEmpty()) {
            this.deleteSmsAreaNotIn(Arrays.asList(-1L));
            return;
        }
        areas = areas.replaceAll("\uff0c", ",");
        List<Long> areaIds = Arrays.stream(areas.split(",")).map(Long::parseLong).collect(Collectors.toList());
        this.deleteSmsAreaNotIn(areaIds);
        List<Long> oldAreaIds = ((ParamMapper)this.dao).getSmsAreaIds(Arrays.asList("check_sms_template", "check_sms_time", "exam_sms_template", "exam_sms_time"));
        List<Long> newAreaIds = areaIds.stream().filter(id -> !oldAreaIds.contains(id)).collect(Collectors.toList());
        this.addSmsArea(newAreaIds);
    }

    public List<Param> getSmsParamByArea(Long areaId) {
        if (areaId == null) {
            return Collections.emptyList();
        }
        Example example = new Example(Param.class);
        example.createCriteria().andIn("paramKey", Arrays.asList("check_sms_template", "check_sms_time", "exam_sms_template", "exam_sms_time")).andEqualTo("isValid", (Object)true).andEqualTo("areaId", (Object)areaId);
        return this.paramMapper.selectByExample(example);
    }

    private void deleteSmsAreaNotIn(List<Long> areaIds) {
        ((ParamMapper)this.dao).deleteSmsAreaNotIn(Arrays.asList("check_sms_template", "check_sms_time", "exam_sms_template", "exam_sms_time"), areaIds);
    }

    private void addSmsArea(List<Long> areaIds) {
        areaIds.forEach(id -> {
            Param p = new Param();
            p.setCreateBy(Long.valueOf(0L));
            p.setUpdateBy(Long.valueOf(0L));
            p.setCreateDate(new Date());
            p.setCreateDate(new Date());
            p.setIsValid(Boolean.valueOf(true));
            p.setAreaId(id);
            p.setParamKey("check_sms_template");
            p.setName("\u68c0\u6d4b\u903e\u671f\u77ed\u4fe1\u53d1\u9001\u6a21\u677f");
            p.setParamValue("\u8d35\u53f8\u5b9a\u671f\u68c0\u6d4b\u5de5\u4f5c\u5373\u5c06\u5728##\u903e\u671f\uff0c\u8bf7\u5c3d\u5feb\u59d4\u6258\u4e13\u4e1a\u673a\u6784\u8fdb\u884c\u68c0\u6d4b\uff1b\u82e5\u5df2\u5b8c\u6210\uff0c\u8bf7\u63d0\u9192\u673a\u6784\u5c3d\u5feb\u4e0a\u4f20\u9879\u76ee");
            p.setParamDescribe("\u901a\u77e5\u5b9a\u671f\u68c0\u6d4b\u5373\u5c06\u903e\u671f\u4f01\u4e1a\u7684\u77ed\u4fe1\u6a21\u677f\u3002##\u5728\u77ed\u4fe1\u4e2d\u4f1a\u663e\u793a\u4e3a\u5373\u5c06\u903e\u671f\u65e5\u671f\uff0c\u8bf7\u52ff\u4fee\u6539");
            this.add(p);
            p.setParamKey("check_sms_time");
            p.setName("\u68c0\u6d4b\u903e\u671f\u77ed\u4fe1\u53d1\u9001\u65f6\u95f4");
            p.setParamValue("3");
            p.setParamDescribe("\u8bbe\u7f6e\u68c0\u6d4b\u903e\u671f\u63d0\u9192\u77ed\u4fe1\u63d0\u524d\u53d1\u9001\u65f6\u95f4\uff0c\u4ee5\u6708\u4e3a\u5355\u4f4d");
            this.add(p);
            p.setParamKey("exam_sms_template");
            p.setName("\u4f53\u68c0\u903e\u671f\u77ed\u4fe1\u53d1\u9001\u6a21\u677f");
            p.setParamValue("\u8d35\u53f8\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5\u5de5\u4f5c\u5373\u5c06\u5728##\u903e\u671f\uff0c\u8bf7\u5c3d\u5feb\u59d4\u6258\u4e13\u4e1a\u673a\u6784\u8fdb\u884c\u4f53\u68c0\uff1b\u82e5\u5df2\u5b8c\u6210\uff0c\u8bf7\u63d0\u9192\u673a\u6784\u5c3d\u5feb\u4e0a\u4f20\u9879\u76ee");
            p.setParamDescribe("\u901a\u77e5\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5\u5373\u5c06\u903e\u671f\u4f01\u4e1a\u7684\u77ed\u4fe1\u6a21\u677f\u3002##\u5728\u77ed\u4fe1\u4e2d\u4f1a\u663e\u793a\u4e3a\u5373\u5c06\u903e\u671f\u65e5\u671f\uff0c\u8bf7\u52ff\u4fee\u6539");
            this.add(p);
            p.setParamKey("exam_sms_time");
            p.setName("\u4f53\u68c0\u903e\u671f\u77ed\u4fe1\u53d1\u9001\u65f6\u95f4");
            p.setParamValue("3");
            p.setParamDescribe("\u8bbe\u7f6e\u4f53\u68c0\u903e\u671f\u63d0\u9192\u77ed\u4fe1\u63d0\u524d\u53d1\u9001\u65f6\u95f4\uff0c\u4ee5\u6708\u4e3a\u5355\u4f4d");
            this.add(p);
        });
    }

    public Boolean haveThisrKey(Long id, String key, Long areaId) {
        Example example = new Example(Param.class);
        example.createCriteria().andEqualTo("paramKey", (Object)key).andEqualTo("isValid", (Object)true).andEqualTo("areaId", (Object)areaId).andNotEqualTo("id", (Object)id);
        List list = this.getListByExample(example);
        if (list != null && list.size() > 0) {
            return true;
        }
        return false;
    }
}

