/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.setting.impl;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.supervise.dao.setting.ThresholdValueMapper;
import cn.smarthse.modules.health.supervise.entity.setting.ThresholdParam;
import cn.smarthse.modules.health.supervise.entity.setting.ThresholdValue;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationUserService;
import cn.smarthse.modules.health.supervise.service.setting.IThresholdParamService;
import cn.smarthse.modules.health.supervise.service.setting.IThresholdValueService;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@DubboService
public class ThresholdValueServiceImp
extends BaseServiceImpl<ThresholdValueMapper, ThresholdValue>
implements IThresholdValueService {
    @Autowired
    private IThresholdParamService thresholdParamService;
    @Autowired
    private IOrganizationUserService organizationUserService;

    public Map<String, String> getByUser(Long userId) {
        this.thresholdParamService.getAll();
        Example example = new Example(ThresholdValue.class);
        example.setOrderByClause(" id asc");
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("userId", (Object)userId);
        List thresholdValues = ((ThresholdValueMapper)this.dao).selectByExample(example);
        return this.getByList(thresholdValues);
    }

    private Map<String, String> getByList(List<ThresholdValue> thresholdValues) {
        HashMap<Long, ThresholdValue> map = new HashMap<Long, ThresholdValue>();
        for (ThresholdValue value : thresholdValues) {
            map.put(value.getParamId(), value);
        }
        List params = this.thresholdParamService.getAll();
        HashMap<String, String> rMap = new HashMap<String, String>();
        for (ThresholdParam param : params) {
            rMap.put("param" + param.getId(), param.getDefaultValue());
            ThresholdValue thresholdValue = (ThresholdValue)map.get(param.getId());
            if (thresholdValue == null || thresholdValue.getValue() == null || thresholdValue.getValue().isEmpty()) continue;
            rMap.put("param" + param.getId(), thresholdValue.getValue());
        }
        return rMap;
    }

    @Transactional(readOnly=false)
    public void addValues(List<ThresholdValue> values) {
        if (values == null || values.isEmpty()) {
            return;
        }
        Long userId = values.get(0).getUserId();
        Example example = new Example(ThresholdValue.class);
        example.setOrderByClause("id asc");
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("userId", (Object)userId);
        List thresholdValues = ((ThresholdValueMapper)this.dao).selectByExample(example);
        HashMap<Long, ThresholdValue> map = new HashMap<Long, ThresholdValue>();
        for (ThresholdValue value : thresholdValues) {
            map.put(value.getParamId(), value);
        }
        for (ThresholdValue value : values) {
            ThresholdValue thresholdValue = (ThresholdValue)map.get(value.getParamId());
            value.setUpdateBy(userId);
            value.setUpdateDate(new Date());
            if (thresholdValue != null) {
                value.setId(thresholdValue.getId());
                value.setCreateDate(thresholdValue.getCreateDate());
                value.setCreateBy(thresholdValue.getCreateBy());
                value.setIsValid(Boolean.valueOf(true));
                this.updateByPrimaryKey(value, userId);
                continue;
            }
            value.setId(null);
            value.setCreateDate(new Date());
            value.setCreateBy(userId);
            value.setIsValid(Boolean.valueOf(true));
            this.add(value);
        }
    }
}

