/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.regcollect.impl;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.supervise.bigdao.regcollect.CompanyGovernMapper;
import cn.smarthse.modules.health.supervise.dao.sys.SysAreaMapper;
import cn.smarthse.modules.health.supervise.entity.regcollect.CompanyGovern;
import cn.smarthse.modules.health.supervise.entity.sys.SysArea;
import cn.smarthse.modules.health.supervise.model.regcollect.CompanyGovernModel;
import cn.smarthse.modules.health.supervise.model.regcollect.CompanyGovernQuery;
import cn.smarthse.modules.health.supervise.model.regcollect.CompanyGovernSummaryModel;
import cn.smarthse.modules.health.supervise.service.regcollect.IGovernService;
import cn.smarthse.modules.health.supervise.service.sys.ISuperviseSysAreaService;
import cn.smarthse.modules.health.supervise.service.sys.impl.SysAreaServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@DubboService
@Transactional(readOnly=true)
public class GovernServiceImpl
extends BaseServiceImpl<CompanyGovernMapper, CompanyGovern>
implements IGovernService {
    @Autowired
    ISuperviseSysAreaService ISysAreaService;
    @Autowired
    SysAreaMapper sysAreaMapper;
    @Autowired
    SysAreaServiceImpl sysAreaServiceImpl;

    public PageInfo<CompanyGovernModel> getRegisterData(JqGridParam param, CompanyGovernQuery queryParam) {
        SysArea area;
        SysArea queryArea = null;
        if (StringUtils.isNotEmpty((String)queryParam.getAreaName())) {
            queryArea = this.getAreaByNames(queryParam.getAreaName(), queryParam.getLevel(), queryParam);
        }
        if (queryArea != null) {
            switch (queryArea.getLevel()) {
                case 1: {
                    queryParam.setProvinceId(queryArea.getId());
                    break;
                }
                case 2: {
                    queryParam.setCityId(queryArea.getId());
                    break;
                }
                case 3: {
                    queryParam.setAreaId(queryArea.getId());
                    break;
                }
                case 4: {
                    queryParam.setStreetId(queryArea.getId());
                    break;
                }
            }
        }
        if ((area = (SysArea)this.ISysAreaService.getById(Long.valueOf(queryParam.getUserAreaId()))) != null) {
            queryParam.setLevel((int)area.getLevel().byteValue());
            switch (area.getLevel()) {
                case 1: {
                    queryParam.setProvinceId(area.getId());
                    break;
                }
                case 2: {
                    queryParam.setCityId(area.getId());
                    break;
                }
                case 3: {
                    queryParam.setAreaId(area.getId());
                    break;
                }
                case 4: {
                    queryParam.setStreetId(area.getId());
                    break;
                }
            }
        }
        System.out.println(queryParam);
        List<CompanyGovernModel> list = ((CompanyGovernMapper)this.dao).getRegisterData(queryParam);
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        PageInfo page = new PageInfo(list);
        return page;
    }

    public SysArea getAreaByNames(String areaName, int level, CompanyGovernQuery queryParam) {
        if (StringUtils.isNotBlank((CharSequence)areaName) && areaName.length() <= 5) {
            Example example = new Example(SysArea.class);
            if (level != 0 && level == 1) {
                example.createCriteria().andEqualTo("isValid", (Object)true).andLike("name", "%" + areaName + "%").andEqualTo("level", (Object)(++level)).andEqualTo("proviceId", (Object)queryParam.getUserAreaId());
            } else if (level != 0 && level == 2) {
                example.createCriteria().andEqualTo("isValid", (Object)true).andLike("name", "%" + areaName + "%").andEqualTo("level", (Object)(++level)).andEqualTo("cityId", (Object)queryParam.getUserAreaId());
            } else if (level == 3) {
                example.createCriteria().andEqualTo("isValid", (Object)true).andLike("name", "%" + areaName + "%").andEqualTo("level", (Object)(++level)).andEqualTo("areaId", (Object)queryParam.getUserAreaId());
            }
            List areaList = this.sysAreaMapper.selectByExample(example);
            if (areaList != null && !areaList.isEmpty()) {
                return (SysArea)areaList.get(0);
            }
        }
        return null;
    }

    public PageInfo<CompanyGovernSummaryModel> getSummaryData(JqGridParam param, CompanyGovernQuery queryParam) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        SysArea area = (SysArea)this.ISysAreaService.getById(Long.valueOf(queryParam.getUserAreaId()));
        if (area != null) {
            queryParam.setLevel((int)area.getLevel().byteValue());
            switch (area.getLevel()) {
                case 1: {
                    queryParam.setProvinceId(area.getId());
                    break;
                }
                case 2: {
                    queryParam.setCityId(area.getId());
                    break;
                }
                case 3: {
                    queryParam.setAreaId(area.getId());
                    break;
                }
                case 4: {
                    queryParam.setStreetId(area.getId());
                    break;
                }
            }
        }
        List<CompanyGovernSummaryModel> list = ((CompanyGovernMapper)this.dao).getSummaryData(queryParam);
        PageInfo page = new PageInfo(list);
        ArrayList<CompanyGovernSummaryModel> result = new ArrayList<CompanyGovernSummaryModel>(12);
        for (int i = 0; i < 12; ++i) {
            CompanyGovernSummaryModel a = new CompanyGovernSummaryModel();
            switch (i) {
                case 1: {
                    a.setIndustryCategory("\u9732\u5929\u7164\u77ff");
                    a.setIndex("1.1");
                    break;
                }
                case 2: {
                    a.setIndustryCategory("\u4e95\u5de5\u7164\u77ff");
                    a.setIndex("1.2");
                    break;
                }
                case 3: {
                    a.setIndustryCategory("\u975e\u7164\u9732\u5929\u77ff\u5c71");
                    a.setIndex("1.3");
                    break;
                }
                case 4: {
                    a.setIndustryCategory("\u975e\u7164\u5730\u4e0b\u77ff\u5c71");
                    a.setIndex("1.4");
                    break;
                }
                case 6: {
                    a.setIndustryCategory("\u9ed1\u8272\u91d1\u5c5e\u51b6\u70bc");
                    a.setIndex("2.1");
                    break;
                }
                case 7: {
                    a.setIndustryCategory("\u6709\u8272\u91d1\u5c5e\u51b6\u70bc");
                    a.setIndex("2.2");
                    break;
                }
                case 9: {
                    a.setIndustryCategory("\u70bc\u6cb9");
                    a.setIndex("3.1");
                    break;
                }
                case 10: {
                    a.setIndustryCategory("\u5316\u5de5");
                    a.setIndex("3.2");
                    break;
                }
            }
            result.add(a);
        }
        CompanyGovernSummaryModel t1 = new CompanyGovernSummaryModel();
        t1.setIndex("1");
        t1.setIndustryCategory("\u77ff\u5c71\uff08\u5408\u8ba1\uff09");
        CompanyGovernSummaryModel t2 = new CompanyGovernSummaryModel();
        t2.setIndex("2");
        t2.setIndustryCategory("\u51b6\u91d1\uff08\u5408\u8ba1\uff09");
        CompanyGovernSummaryModel t3 = new CompanyGovernSummaryModel();
        t3.setIndex("3");
        t3.setIndustryCategory("\u5316\u5de5\uff08\u5408\u8ba1\uff09");
        CompanyGovernSummaryModel t4 = new CompanyGovernSummaryModel();
        t4.setIndustryCategory("\u5408\u8ba1:");
        for (CompanyGovernSummaryModel a : list) {
            String name;
            t4.add(a);
            switch (name = a.getIndustryCategory()) {
                case "\u9732\u5929\u7164\u77ff": {
                    a.setIndex("1.1");
                    result.set(1, a);
                    t1.add(a);
                    break;
                }
                case "\u4e95\u5de5\u7164\u77ff": {
                    a.setIndex("1.2");
                    result.set(2, a);
                    t1.add(a);
                    break;
                }
                case "\u975e\u7164\u9732\u5929\u77ff\u5c71": {
                    a.setIndex("1.3");
                    result.set(3, a);
                    t1.add(a);
                    break;
                }
                case "\u975e\u7164\u5730\u4e0b\u77ff\u5c71": {
                    a.setIndex("1.4");
                    result.set(4, a);
                    t1.add(a);
                    break;
                }
                case "\u9ed1\u8272\u91d1\u5c5e\u51b6\u70bc": {
                    a.setIndex("2.1");
                    result.set(6, a);
                    t2.add(a);
                    break;
                }
                case "\u6709\u8272\u91d1\u5c5e\u51b6\u70bc": {
                    a.setIndex("2.2");
                    result.set(7, a);
                    t2.add(a);
                    break;
                }
                case "\u70bc\u6cb9": {
                    a.setIndex("3.1");
                    result.set(9, a);
                    t3.add(a);
                    t3.add(a);
                    break;
                }
                case "\u5316\u5de5": {
                    a.setIndex("3.2");
                    result.set(10, a);
                    t3.add(a);
                    break;
                }
            }
        }
        result.set(0, t1);
        result.set(5, t2);
        result.set(8, t3);
        result.set(11, t4);
        return page;
    }
}

