/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.legal.impl;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.supervise.dao.legal.SysLegalUploadFileMapper;
import cn.smarthse.modules.health.supervise.entity.legal.SysLegal;
import cn.smarthse.modules.health.supervise.entity.legal.SysLegalUploadFile;
import cn.smarthse.modules.health.supervise.service.legal.ISysLegalUploadFileService;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@DubboService
@Transactional(readOnly=true)
public class SysLegalUploadFileServiceImpl
extends BaseServiceImpl<SysLegalUploadFileMapper, SysLegalUploadFile>
implements ISysLegalUploadFileService {
    @DubboReference
    ISysFileProvideService sysFileServiceImpl;
    @Autowired
    SysLegalUploadFileMapper sysLegalUploadFileMapper;

    public List<SysLegalUploadFile> getByLegalIdAndFileId(Long orgId, Long id, Long fileId) {
        Example example = new Example(SysLegalUploadFile.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("orgId", (Object)orgId).andEqualTo("legalId", (Object)id).andEqualTo("fileId", (Object)fileId).andEqualTo("isValid", (Object)Global.TRUE);
        example.setOrderByClause("id asc");
        List<SysLegalUploadFile> list = this.getListByExample(example);
        return list;
    }

    public boolean getExistsByLegalIdAndFileId(Long orgId, Long id, Long fileId) {
        boolean isFile = this.sysLegalUploadFileMapper.selectExists(orgId, id, fileId);
        return isFile;
    }

    @Transactional(readOnly=false)
    public void addFile(Long id, Long[] fileId2, Long orgId, Long staffid) {
        for (int i = 0; i < fileId2.length; ++i) {
            boolean isFile = this.getExistsByLegalIdAndFileId(orgId, id, fileId2[i]);
            if (isFile) continue;
            SysLegalUploadFile sysLegalUploadFile = new SysLegalUploadFile();
            sysLegalUploadFile.setLegalId(id);
            sysLegalUploadFile.setFileId(fileId2[i]);
            sysLegalUploadFile.setOrgId(orgId);
            this.add(sysLegalUploadFile, staffid, null);
        }
    }

    public List<SysLegal> setLegalUploadFileIdAndName(List<SysLegal> list, Long orgId) {
        for (SysLegal sysLegal : list) {
            ArrayList<Long> fileIdList = new ArrayList<Long>();
            ArrayList<CallSite> fileNameList = new ArrayList<CallSite>();
            Example example = new Example(SysLegalUploadFile.class);
            Example.Criteria c = example.createCriteria();
            c.andEqualTo("orgId", (Object)orgId).andEqualTo("legalId", (Object)sysLegal.getId()).andEqualTo("isValid", (Object)Global.TRUE);
            example.setOrderByClause("id asc");
            List fileList = this.getListByExample(example);
            for (SysLegalUploadFile sysLegalUploadFile : fileList) {
                if (sysLegalUploadFile.getFileId() == null) continue;
                fileIdList.add(sysLegalUploadFile.getFileId());
                SysFileModel sysFile = this.sysFileServiceImpl.getFileById(sysLegalUploadFile.getFileId());
                fileNameList.add((CallSite)((Object)(sysFile.getFileName() + "." + sysFile.getFileExt())));
            }
            sysLegal.setFileIds(fileIdList);
            sysLegal.setFileNames(fileNameList);
        }
        return list;
    }
}

