/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.legal.impl;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.jqgrid.ParamSeachFieldVO;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.enums.legal.SysLegalStatusEnum;
import cn.smarthse.modules.health.enums.legal.SysLegalTypeEnum;
import cn.smarthse.modules.health.supervise.dao.legal.SysLegalMapper;
import cn.smarthse.modules.health.supervise.entity.legal.SysLegal;
import cn.smarthse.modules.health.supervise.entity.legal.SysLegalFocus;
import cn.smarthse.modules.health.supervise.service.legal.ISysLegalFocusService;
import cn.smarthse.modules.health.supervise.service.legal.ISysLegalService;
import cn.smarthse.modules.health.supervise.service.legal.ISysLegalUploadFileService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@DubboService
@Transactional(readOnly=true)
public class SysLegalServiceImpl
extends BaseServiceImpl<SysLegalMapper, SysLegal>
implements ISysLegalService {
    @Autowired
    ISysLegalFocusService sysLegalFocusServiceImpl;
    @Autowired
    ISysLegalUploadFileService sysLegalUploadFileServiceImpl;

    public PageInfo<SysLegal> getSysLegalListByGridParam(JqGridParam gparam) {
        String type = null;
        String status = null;
        String title = null;
        if (gparam.getPostDatas() != null) {
            for (ParamSeachFieldVO sField : gparam.getPostDatas()) {
                if (sField.getSearchField().equals("legalType")) {
                    type = sField.getSearchValue();
                }
                if (sField.getSearchField().equals("legalStatus")) {
                    status = sField.getSearchValue();
                }
                if (!sField.getSearchField().equals("title")) continue;
                title = sField.getSearchValue();
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orgId", gparam.getOrgId());
        map.put("type", type);
        map.put("status", status);
        map.put("title", title);
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List list = ((SysLegalMapper)this.dao).selectSysLegalListByTag(map);
        for (SysLegal sysLegal : list) {
            sysLegal.setStatusName(SysLegalStatusEnum.getName((Integer)sysLegal.getLegalStatus()));
            sysLegal.setTypeName(SysLegalTypeEnum.getName((Integer)sysLegal.getLegalType()));
            if (sysLegal.getLegalType().equals(SysLegalTypeEnum.type6.getValue()) || sysLegal.getLegalType().equals(SysLegalTypeEnum.type8.getValue()) || sysLegal.getLegalType().equals(SysLegalTypeEnum.type7.getValue())) continue;
            sysLegal.setExecuteDate(sysLegal.getUpdateDate());
        }
        if (gparam.getOrgId() != null) {
            list = this.sysLegalUploadFileServiceImpl.setLegalUploadFileIdAndName(list, gparam.getOrgId());
        }
        return new PageInfo(list);
    }

    public List<SysLegal> getSysLegalListByFocus(Long orgId) {
        List<SysLegal> list = ((SysLegalMapper)this.dao).selectSysLegalListByFocus(orgId);
        for (SysLegal sysLegal : list) {
            sysLegal.setStatusName(SysLegalStatusEnum.getName((Integer)sysLegal.getLegalStatus()));
            sysLegal.setTypeName(SysLegalTypeEnum.getName((Integer)sysLegal.getLegalType()));
        }
        return list;
    }

    public List<SysLegal> getSysLegalListByCidAndYear(Long cid) {
        ArrayList<SysLegal> sysLegalList = new ArrayList<SysLegal>();
        if (cid != null) {
            List list = this.sysLegalFocusServiceImpl.getSysLegalFocusListByCid(cid);
            for (SysLegalFocus sysLegalFocus : list) {
                if (sysLegalFocus.getLegalId() == null) continue;
                SysLegal sysLegal = (SysLegal)this.getById(sysLegalFocus.getLegalId());
                sysLegal.setStatusName(SysLegalStatusEnum.getName((Integer)sysLegal.getLegalStatus()));
                sysLegal.setTypeName(SysLegalTypeEnum.getName((Integer)sysLegal.getLegalType()));
                if (!(sysLegal.getLegalType().equals(SysLegalTypeEnum.type6.getValue()) || sysLegal.getLegalType().equals(SysLegalTypeEnum.type8.getValue()) || sysLegal.getLegalType().equals(SysLegalTypeEnum.type7.getValue()))) {
                    sysLegal.setExecuteDate(sysLegal.getUpdateDate());
                }
                if (sysLegal.getLegalStatus() != 1) continue;
                sysLegalList.add(sysLegal);
            }
        }
        return sysLegalList;
    }

    public SysLegal getSysLegalByTitleAndFileNo(String title, String fileNo) {
        Example example = new Example(SysLegal.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("title", (Object)title).andEqualTo("fileNo", (Object)fileNo).andEqualTo("isValid", (Object)Global.TRUE);
        example.setOrderByClause("id asc");
        List list = this.getListByExample(example);
        return (SysLegal)list.get(0);
    }
}

