/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.keyIndustryTrain.impl;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.supervise.dao.keyIndustryTrain.KeyIndustryTrainMapper;
import cn.smarthse.modules.health.supervise.entity.keyIndustryTrain.KeyIndustryTrain;
import cn.smarthse.modules.health.supervise.enums.keyIndustryTrain.KeyIndustryTrainLogStatusEnum;
import cn.smarthse.modules.health.supervise.enums.keyIndustryTrain.KeyIndustryTrainStatusEnum;
import cn.smarthse.modules.health.supervise.enums.keyIndustryTrain.VideoSlicingStatusEnum;
import cn.smarthse.modules.health.supervise.model.keyIndustryTrain.KeyIndustryTrainAddParam;
import cn.smarthse.modules.health.supervise.model.keyIndustryTrain.KeyIndustryTrainAuditExtraDataParam;
import cn.smarthse.modules.health.supervise.model.keyIndustryTrain.KeyIndustryTrainAuditParam;
import cn.smarthse.modules.health.supervise.model.keyIndustryTrain.KeyIndustryTrainEditParam;
import cn.smarthse.modules.health.supervise.model.keyIndustryTrain.KeyIndustryTrainExtraDataParam;
import cn.smarthse.modules.health.supervise.model.keyIndustryTrain.KeyIndustryTrainListParam;
import cn.smarthse.modules.health.supervise.model.keyIndustryTrain.KeyIndustryTrainListVo;
import cn.smarthse.modules.health.supervise.service.keyIndustryTrain.IKeyIndustryTrainService;
import cn.smarthse.modules.health.vo.work.HomeIndexSearchVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Transactional(readOnly=true)
@Service
@DubboService
public class KeyIndustryTrainServiceImpl
extends BaseServiceImpl<KeyIndustryTrainMapper, KeyIndustryTrain>
implements IKeyIndustryTrainService {
    public PageInfo<KeyIndustryTrainListVo> getList(KeyIndustryTrainListParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        return new PageInfo(((KeyIndustryTrainMapper)this.dao).getList(param));
    }

    @Transactional
    public KeyIndustryTrain save(KeyIndustryTrainAddParam param, KeyIndustryTrainExtraDataParam extraDataParam) {
        KeyIndustryTrain entity = new KeyIndustryTrain();
        entity.setId(Long.valueOf(this.idworker.nextId()));
        entity.setTrainProjName(param.getTrainProjName());
        entity.setTrainPersonnelType(param.getTrainPersonnelType());
        entity.setTrainContent(param.getTrainContent());
        entity.setLecturerName(param.getLecturerName());
        entity.setVideoFileId(param.getVideoFileId());
        entity.setVideoDurationSec(param.getVideoDurationSec());
        entity.setTestQuestionsFileIds(param.getTestQuestionsFileIds());
        entity.setFileIds(param.getFileIds());
        entity.setStatus(param.getStatus());
        entity.setVideoSlicingStatus(VideoSlicingStatusEnum.NOT.getCode());
        entity.setSubAreaId(extraDataParam.getSubAreaId());
        entity.setSubOrgId(extraDataParam.getSubOrgId());
        entity.setSubOrgName(extraDataParam.getSubOrgName());
        entity.setSubPersonId(extraDataParam.getSubPersonId());
        entity.setSubPersonName(extraDataParam.getSubPersonName());
        entity.setCreateBy(entity.getSubPersonId());
        entity.setUpdateBy(entity.getSubPersonId());
        Date date = new Date();
        if (KeyIndustryTrainStatusEnum.SUBMIT.getCode().equals(param.getStatus())) {
            entity.setSubTime(date);
        }
        entity.setCreateDate(date);
        entity.setUpdateDate(date);
        return this.add(entity);
    }

    @Transactional
    public Boolean update(KeyIndustryTrainEditParam param, KeyIndustryTrainExtraDataParam extraDataParam) {
        KeyIndustryTrain entity = (KeyIndustryTrain)this.getById(param.getId());
        entity.setTrainProjName(param.getTrainProjName());
        entity.setTrainPersonnelType(param.getTrainPersonnelType());
        entity.setTrainContent(param.getTrainContent());
        entity.setLecturerName(param.getLecturerName());
        entity.setVideoFileId(param.getVideoFileId());
        entity.setVideoDurationSec(param.getVideoDurationSec());
        entity.setTestQuestionsFileIds(param.getTestQuestionsFileIds());
        entity.setFileIds(param.getFileIds());
        entity.setStatus(param.getStatus());
        entity.setVideoSlicingStatus(VideoSlicingStatusEnum.NOT.getCode());
        entity.setSubAreaId(extraDataParam.getSubAreaId());
        entity.setSubOrgId(extraDataParam.getSubOrgId());
        entity.setSubOrgName(extraDataParam.getSubOrgName());
        entity.setSubPersonId(extraDataParam.getSubPersonId());
        entity.setSubPersonName(extraDataParam.getSubPersonName());
        entity.setUpdateBy(entity.getSubPersonId());
        Date date = new Date();
        if (KeyIndustryTrainStatusEnum.SUBMIT.getCode().equals(param.getStatus())) {
            entity.setSubTime(date);
        }
        entity.setUpdateDate(date);
        return ((KeyIndustryTrainMapper)this.dao).updateByPrimaryKey(entity) > 0;
    }

    @Transactional
    public Boolean updateVideoSlicingStatus(Long id, Integer videoSlicingStatus, Long videoSlicingFileId) {
        KeyIndustryTrain entity = new KeyIndustryTrain();
        entity.setId(id);
        entity.setVideoSlicingStatus(videoSlicingStatus);
        entity.setUpdateBy(Long.valueOf(0L));
        entity.setUpdateDate(new Date());
        if (Objects.nonNull(videoSlicingFileId)) {
            entity.setVideoSlicingFileId(videoSlicingFileId);
        }
        return ((KeyIndustryTrainMapper)this.dao).updateByPrimaryKeySelective(entity) > 0;
    }

    @Transactional
    public Boolean delete(List<Long> idList, Long loginUserId) {
        if (CollUtil.isEmpty(idList)) {
            throw new HealthException("\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u57f9\u8bad\u8bfe\u7a0b");
        }
        Example example = new Example(KeyIndustryTrain.class);
        example.createCriteria().andIn("id", idList).andEqualTo("isValid", (Object)Boolean.TRUE);
        List list = this.getListByExample(example);
        if (CollUtil.isEmpty(list)) {
            return Boolean.FALSE;
        }
        if (list.stream().anyMatch(i -> !KeyIndustryTrainStatusEnum.DRAFT.getCode().equals(i.getStatus()))) {
            return Boolean.FALSE;
        }
        KeyIndustryTrain entity = new KeyIndustryTrain();
        entity.setIsValid(Boolean.FALSE);
        entity.setUpdateBy(loginUserId);
        entity.setUpdateDate(new Date());
        return ((KeyIndustryTrainMapper)this.dao).updateByExampleSelective(entity, example) > 0;
    }

    @Transactional
    public Boolean audit(KeyIndustryTrainAuditParam param, KeyIndustryTrainAuditExtraDataParam extraDataParam) {
        Integer status;
        Example example = new Example(KeyIndustryTrain.class);
        example.createCriteria().andIn("id", (Iterable)param.getIdList()).andEqualTo("isValid", (Object)Boolean.TRUE);
        List list = this.getListByExample(example);
        if (CollUtil.isEmpty(list)) {
            throw new HealthException("\u6240\u9009\u57f9\u8bad\u8bfe\u7a0b\u5df2\u7ecf\u4e0d\u5b58\u5728");
        }
        if (list.stream().anyMatch(i -> !KeyIndustryTrainStatusEnum.SUBMIT.getCode().equals(i.getStatus()))) {
            throw new HealthException("\u6240\u9009\u57f9\u8bad\u8bfe\u7a0b\u5b58\u5728\u975e\u5f85\u5ba1\u6838\u72b6\u6001");
        }
        List auditList = list.stream().filter(i -> VideoSlicingStatusEnum.SUCCESS.getCode().equals(i.getVideoSlicingStatus())).collect(Collectors.toList());
        if (CollUtil.isEmpty(auditList)) {
            throw new HealthException("\u6240\u9009\u57f9\u8bad\u8bfe\u7a0b\u5b58\u5728\u5207\u7247\u672a\u6210\u529f\u72b6\u6001");
        }
        if (KeyIndustryTrainLogStatusEnum.BACK.getCode().equals(param.getStatus())) {
            status = KeyIndustryTrainStatusEnum.BACK.getCode();
        } else if (KeyIndustryTrainLogStatusEnum.PASS.getCode().equals(param.getStatus())) {
            status = KeyIndustryTrainStatusEnum.CONFIRM.getCode();
        } else {
            throw new HealthException("\u7cfb\u7edf\u4e0d\u652f\u6301\u8be5\u5ba1\u6838\u72b6\u6001");
        }
        Date date = new Date();
        ArrayList<KeyIndustryTrain> updatedList = new ArrayList<KeyIndustryTrain>(auditList.size());
        for (KeyIndustryTrain keyIndustryTrain : auditList) {
            KeyIndustryTrain entity = new KeyIndustryTrain();
            entity.setId(keyIndustryTrain.getId());
            entity.setStatus(status);
            entity.setAuditOrgId(extraDataParam.getAuditOrgId());
            entity.setAuditOrgName(extraDataParam.getAuditOrgName());
            entity.setAuditPersonId(extraDataParam.getAuditPersonId());
            entity.setAuditPersonName(extraDataParam.getAuditPersonName());
            entity.setUpdateBy(entity.getSubPersonId());
            entity.setAuditTime(date);
            entity.setUpdateDate(date);
            updatedList.add(entity);
        }
        return this.batchUpdateOrInsert(updatedList, KeyIndustryTrainMapper.class, (s, mapper) -> mapper.updateByPrimaryKeySelective(s)) > 0;
    }

    @Transactional
    public Boolean rollBackAudit(List<Long> idList) {
        if (CollUtil.isEmpty(idList)) {
            return Boolean.FALSE;
        }
        Date date = new Date();
        ArrayList<KeyIndustryTrain> updatedList = new ArrayList<KeyIndustryTrain>(idList.size());
        for (Long id : idList) {
            KeyIndustryTrain entity = new KeyIndustryTrain();
            entity.setId(id);
            entity.setStatus(KeyIndustryTrainStatusEnum.SUBMIT.getCode());
            entity.setUpdateBy(entity.getSubPersonId());
            entity.setUpdateDate(date);
            updatedList.add(entity);
        }
        return this.batchUpdateOrInsert(updatedList, KeyIndustryTrainMapper.class, (s, mapper) -> mapper.updateByPrimaryKeySelective(s)) > 0;
    }

    public Integer getKeyIndustryTrainStatusByAreaId(HomeIndexSearchVo searchVo) {
        Example example = new Example(KeyIndustryTrain.class);
        example.createCriteria().andEqualTo("status", (Object)KeyIndustryTrainStatusEnum.CONFIRM.getCode()).andEqualTo("subAreaId", (Object)searchVo.getAreaId()).andEqualTo("isValid", (Object)Boolean.TRUE);
        return CollUtil.isNotEmpty(this.getListByExample(example)) ? 1 : 0;
    }

    public Map<Long, KeyIndustryTrain> getKeyIndustryTrainMap(List<Long> idList) {
        if (CollUtil.isEmpty(idList)) {
            return Collections.emptyMap();
        }
        Example example = new Example(KeyIndustryTrain.class);
        example.createCriteria().andIn("id", idList).andEqualTo("isValid", (Object)Boolean.TRUE);
        List list = this.getListByExample(example);
        return CollUtil.isEmpty(list) ? Collections.emptyMap() : list.stream().collect(Collectors.toMap(KeyIndustryTrain::getId, item -> item, (v1, v2) -> v1));
    }
}

