/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.keyIndustryTrain.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.supervise.dao.keyIndustryTrain.KeyIndustryTrainLogMapper;
import cn.smarthse.modules.health.supervise.entity.keyIndustryTrain.KeyIndustryTrainLog;
import cn.smarthse.modules.health.supervise.model.keyIndustryTrain.KeyIndustryTrainLogAddParam;
import cn.smarthse.modules.health.supervise.model.keyIndustryTrain.KeyIndustryTrainLogListParam;
import cn.smarthse.modules.health.supervise.model.keyIndustryTrain.KeyIndustryTrainLogListVo;
import cn.smarthse.modules.health.supervise.service.keyIndustryTrain.IKeyIndustryTrainLogService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Transactional(readOnly=true)
@Service
@DubboService
public class KeyIndustryTrainLogServiceImpl
extends BaseServiceImpl<KeyIndustryTrainLogMapper, KeyIndustryTrainLog>
implements IKeyIndustryTrainLogService {
    public Map<Long, String> getLastReasonMap(List<Long> workIdList) {
        if (CollUtil.isEmpty(workIdList)) {
            return Collections.emptyMap();
        }
        List<KeyIndustryTrainLog> list = ((KeyIndustryTrainLogMapper)this.dao).getLastReasonList(workIdList);
        if (CollUtil.isEmpty(list)) {
            return Collections.emptyMap();
        }
        return list.stream().filter(i -> StrUtil.isNotBlank((CharSequence)i.getReason())).collect(Collectors.toMap(KeyIndustryTrainLog::getWorkId, KeyIndustryTrainLog::getReason, (v1, v2) -> v1));
    }

    @Transactional
    public Boolean save(KeyIndustryTrainLogAddParam trainLogAddParam) {
        if (Objects.isNull(trainLogAddParam)) {
            return Boolean.FALSE;
        }
        KeyIndustryTrainLog entity = new KeyIndustryTrainLog();
        entity.setId(Long.valueOf(this.idworker.nextId()));
        entity.setWorkId(trainLogAddParam.getWorkId());
        entity.setStatus(trainLogAddParam.getStatus());
        entity.setReason(trainLogAddParam.getReason());
        entity.setOrgId(trainLogAddParam.getOrgId());
        entity.setOrgName(trainLogAddParam.getOrgName());
        entity.setOperator(trainLogAddParam.getOperator());
        entity.setCreateBy(trainLogAddParam.getCreateBy());
        entity.setUpdateBy(trainLogAddParam.getCreateBy());
        Date date = new Date();
        entity.setCreateDate(date);
        entity.setUpdateDate(date);
        return Objects.nonNull(this.add(entity));
    }

    @Transactional
    public Boolean saveBatch(List<KeyIndustryTrainLogAddParam> trainLogAddParamList) {
        if (CollUtil.isEmpty(trainLogAddParamList)) {
            return Boolean.FALSE;
        }
        Date date = new Date();
        ArrayList<KeyIndustryTrainLog> addList = new ArrayList<KeyIndustryTrainLog>();
        for (KeyIndustryTrainLogAddParam trainLogAddParam : trainLogAddParamList) {
            KeyIndustryTrainLog entity = new KeyIndustryTrainLog();
            entity.setId(Long.valueOf(this.idworker.nextId()));
            entity.setWorkId(trainLogAddParam.getWorkId());
            entity.setStatus(trainLogAddParam.getStatus());
            entity.setReason(trainLogAddParam.getReason());
            entity.setOrgId(trainLogAddParam.getOrgId());
            entity.setOrgName(trainLogAddParam.getOrgName());
            entity.setOperator(trainLogAddParam.getOperator());
            entity.setCreateBy(trainLogAddParam.getCreateBy());
            entity.setUpdateBy(trainLogAddParam.getCreateBy());
            entity.setCreateDate(date);
            entity.setUpdateDate(date);
            addList.add(entity);
        }
        return this.batchUpdateOrInsert(addList, KeyIndustryTrainLogMapper.class, (s, mapper) -> mapper.insertSelective(s)) > 0;
    }

    @Transactional
    public Boolean deleteByWorkId(List<Long> idList, Long loginUserId) {
        if (CollUtil.isEmpty(idList)) {
            throw new HealthException("\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u57f9\u8bad\u8bfe\u7a0b");
        }
        Example example = new Example(KeyIndustryTrainLog.class);
        example.createCriteria().andIn("workId", idList).andEqualTo("isValid", (Object)Boolean.TRUE);
        KeyIndustryTrainLog entity = new KeyIndustryTrainLog();
        entity.setIsValid(Boolean.FALSE);
        entity.setUpdateBy(loginUserId);
        entity.setUpdateDate(new Date());
        return ((KeyIndustryTrainLogMapper)this.dao).updateByExampleSelective(entity, example) > 0;
    }

    public PageInfo<KeyIndustryTrainLogListVo> getList(KeyIndustryTrainLogListParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        return new PageInfo(((KeyIndustryTrainLogMapper)this.dao).getList(param));
    }
}

