/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.homeset.impl;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.supervise.dao.homeset.KeyIndustrySetMapper;
import cn.smarthse.modules.health.supervise.entity.homeset.KeyIndustrySet;
import cn.smarthse.modules.health.supervise.entity.homeset.KeyIndustrySetSelected;
import cn.smarthse.modules.health.supervise.entity.sysparam.ImportantIndustryCategory;
import cn.smarthse.modules.health.supervise.service.homeset.IKeyIndustrySetSelectedService;
import cn.smarthse.modules.health.supervise.service.homeset.IKeyIndustrySetService;
import cn.smarthse.modules.health.supervise.service.importantIndustryCategory.IImportantIndustryCategoryService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@DubboService
@Transactional(readOnly=true)
public class KeyIndustrySetServiceImpl
extends BaseServiceImpl<KeyIndustrySetMapper, KeyIndustrySet>
implements IKeyIndustrySetService {
    @DubboReference
    IImportantIndustryCategoryService importantIndustryCategoryService;
    @Autowired
    IKeyIndustrySetSelectedService keyIndustrySetSelectedService;

    public List<KeyIndustrySet> getListByUser(Long userId) {
        List iics = this.importantIndustryCategoryService.getList();
        ArrayList<KeyIndustrySet> finalList = new ArrayList<KeyIndustrySet>();
        HashMap map = new HashMap();
        for (ImportantIndustryCategory iic : iics) {
            if (iic.getImportantType() == null || iic.getImportantType() == 5 || iic.getImportantType() == 6) continue;
            if (map.get(iic.getImportantType()) == null) {
                map.put(iic.getImportantType(), new ArrayList());
            }
            ((List)map.get(iic.getImportantType())).add(iic);
        }
        for (Integer type : map.keySet()) {
            if (((List)map.get(type)).size() <= 0) continue;
            KeyIndustrySet set = new KeyIndustrySet();
            set.setId(Long.valueOf(type.longValue()));
            finalList.add(set);
            set.setName(((ImportantIndustryCategory)((List)map.get(type)).get(0)).getImportantTypeName());
            set.setIndustryNames(String.join((CharSequence)";  ", ((List)map.get(type)).stream().map(ImportantIndustryCategory::getName).collect(Collectors.toList())));
            set.setIndustryIds(String.join((CharSequence)",", ((List)map.get(type)).stream().map(s -> "" + s.getIndustryCategoryId()).collect(Collectors.toList())));
        }
        Example example = new Example(KeyIndustrySet.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("userId", (Object)userId).andEqualTo("isValid", (Object)Global.TRUE);
        List list = this.getListByExample(example);
        if (CollectionUtils.isNotEmpty(list)) {
            finalList.addAll(list);
        }
        List selist = this.keyIndustrySetSelectedService.getListByUserId(userId);
        block2: for (KeyIndustrySet set : finalList) {
            if (set.getId() == null || selist.size() <= 0) continue;
            for (KeyIndustrySetSelected ss : selist) {
                if (!set.getId().equals(ss.getIndustrySetId())) continue;
                set.setSelected(Boolean.valueOf(true));
                continue block2;
            }
        }
        boolean hasSelect = false;
        for (KeyIndustrySet set : finalList) {
            if (set.getSelected() == null || !set.getSelected().booleanValue()) continue;
            hasSelect = true;
            break;
        }
        if (!hasSelect) {
            for (KeyIndustrySet set : finalList) {
                if (set.getId() == null) continue;
                set.setSelected(Boolean.valueOf(true));
            }
        }
        return finalList;
    }

    @Transactional(readOnly=false)
    public void saveKeyIndustrySetList(List<KeyIndustrySet> list, Long userId) {
        this.keyIndustrySetSelectedService.deleteSelected(userId);
        Example example = new Example(KeyIndustrySet.class);
        example.createCriteria().andEqualTo("userId", (Object)userId);
        KeyIndustrySet ss = new KeyIndustrySet();
        ss.setIsValid(Boolean.valueOf(false));
        ((KeyIndustrySetMapper)this.dao).updateByExample(ss, example);
        for (KeyIndustrySet set : list) {
            if (StringUtils.isNotEmpty((String)set.getIndustryIds())) {
                set.setUserId(userId);
                if (set.getId() == null) {
                    this.add(set, userId, null);
                } else {
                    set.setIsValid(Boolean.valueOf(true));
                    ((KeyIndustrySetMapper)this.dao).updateByPrimaryKeySelective(set);
                }
            }
            if (set.getSelected() == null || !set.getSelected().booleanValue()) continue;
            KeyIndustrySetSelected kss = new KeyIndustrySetSelected();
            kss.setIndustrySetId(set.getId());
            kss.setUserId(userId);
            this.keyIndustrySetSelectedService.add((Object)kss, userId, null);
        }
    }

    public List<KeyIndustrySet> getSelectListByUser(Long userId) {
        List iics = this.importantIndustryCategoryService.getList();
        ArrayList<Object> finalList = new ArrayList<Object>();
        HashMap map = new HashMap();
        for (Object iic : iics) {
            if (iic.getImportantType() == null || iic.getImportantType() == 5 || iic.getImportantType() == 6) continue;
            if (map.get(iic.getImportantType()) == null) {
                map.put(iic.getImportantType(), new ArrayList());
            }
            ((List)map.get(iic.getImportantType())).add(iic);
        }
        ArrayList<KeyIndustrySet> defaultlList = new ArrayList<KeyIndustrySet>();
        for (Integer type : map.keySet()) {
            if (((List)map.get(type)).size() <= 0) continue;
            KeyIndustrySet set = new KeyIndustrySet();
            set.setId(Long.valueOf(type.longValue()));
            finalList.add(set);
            defaultlList.add(set);
            set.setName(((ImportantIndustryCategory)((List)map.get(type)).get(0)).getImportantTypeName());
            set.setIndustryNames(String.join((CharSequence)",", ((List)map.get(type)).stream().map(ImportantIndustryCategory::getName).collect(Collectors.toList())));
            set.setIndustryIds(String.join((CharSequence)",", ((List)map.get(type)).stream().map(s -> "" + s.getIndustryCategoryId()).collect(Collectors.toList())));
        }
        Example example = new Example(KeyIndustrySet.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("userId", (Object)userId).andEqualTo("isValid", (Object)Global.TRUE);
        List list = this.getListByExample(example);
        finalList.addAll(list);
        List selist = this.keyIndustrySetSelectedService.getListByUserId(userId);
        block2: for (KeyIndustrySet keyIndustrySet : finalList) {
            if (keyIndustrySet.getId() == null || selist.size() <= 0) continue;
            for (KeyIndustrySetSelected ss : selist) {
                if (!keyIndustrySet.getId().equals(ss.getIndustrySetId())) continue;
                keyIndustrySet.setSelected(Boolean.valueOf(true));
                continue block2;
            }
        }
        List<KeyIndustrySet> sselist = finalList.stream().filter(s -> s.getSelected() == null ? false : s.getSelected()).collect(Collectors.toList());
        if (sselist == null || sselist.size() == 0) {
            return defaultlList;
        }
        return sselist;
    }

    @Transactional(readOnly=false)
    public Integer saveKeyIndustrySet(KeyIndustrySet vo, Long userId) {
        if (vo.getId() == null) {
            vo.setUserId(userId);
            this.add(vo, userId, null);
            KeyIndustrySetSelected kss = new KeyIndustrySetSelected();
            kss.setIndustrySetId(vo.getId());
            kss.setUserId(userId);
            kss.setIsValid(Boolean.valueOf(false));
            this.keyIndustrySetSelectedService.insert(kss);
            return 0;
        }
        if (vo.getSelected() != null) {
            if (this.has5Industry(userId).booleanValue() && vo.getSelected().booleanValue()) {
                return 1;
            }
            List<KeyIndustrySetSelected> listByExample = this.getKeyIndustrySetSelecteds(vo, userId);
            if (CollectionUtils.isEmpty(listByExample)) {
                KeyIndustrySetSelected kss = new KeyIndustrySetSelected();
                kss.setIndustrySetId(vo.getId());
                kss.setUserId(userId);
                kss.setIsValid(vo.getSelected());
                this.keyIndustrySetSelectedService.insert(kss);
            } else {
                KeyIndustrySetSelected selected = listByExample.get(0);
                selected.setIsValid(vo.getSelected());
                this.keyIndustrySetSelectedService.update((Object)selected);
            }
            return 0;
        }
        this.update(vo);
        return 0;
    }

    private List<KeyIndustrySetSelected> getKeyIndustrySetSelecteds(KeyIndustrySet vo, Long userId) {
        Example example = new Example(KeyIndustrySetSelected.class);
        example.createCriteria().andEqualTo("industrySetId", (Object)vo.getId()).andEqualTo("userId", (Object)userId);
        return this.keyIndustrySetSelectedService.getListByExample(example);
    }

    public Boolean has5Industry(Long userId) {
        Example example = new Example(KeyIndustrySetSelected.class);
        example.createCriteria().andEqualTo("userId", (Object)userId).andEqualTo("isValid", (Object)true);
        List listByExample = this.keyIndustrySetSelectedService.getListByExample(example);
        if (CollectionUtils.isEmpty((Collection)listByExample)) {
            return false;
        }
        return listByExample.size() >= 5;
    }

    @Transactional(readOnly=false)
    public void deleteKeyIndustrySet(KeyIndustrySet vo, Long userId) {
        this.delete(vo, userId);
        List<KeyIndustrySetSelected> keyIndustrySetSelecteds = this.getKeyIndustrySetSelecteds(vo, userId);
        KeyIndustrySetSelected selected = keyIndustrySetSelecteds.get(0);
        this.keyIndustrySetSelectedService.delete((Object)selected, userId);
    }
}

