/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.homeset.impl;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.supervise.dao.homeset.KeyFactorsSetMapper;
import cn.smarthse.modules.health.supervise.entity.homeset.KeyFactorsSet;
import cn.smarthse.modules.health.supervise.entity.homeset.KeyIndustrySet;
import cn.smarthse.modules.health.supervise.enums.harmfactor.KeyHarmFactorEnum;
import cn.smarthse.modules.health.supervise.service.homeset.IKeyFactorsSetService;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@DubboService
@Transactional(readOnly=true)
public class KeyFactorsSetServiceImpl
extends BaseServiceImpl<KeyFactorsSetMapper, KeyFactorsSet>
implements IKeyFactorsSetService {
    @Autowired
    KeyFactorsSetMapper keyFactorsSetMapper;

    @Transactional(readOnly=false)
    public List<KeyFactorsSet> getCheckedListByUser(Long userId) {
        Example example = new Example(KeyFactorsSet.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("userId", (Object)userId).andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("isCheck", (Object)Global.TRUE);
        List<Object> list = this.getListByExample(example);
        if (list == null || list.size() == 0) {
            this.addDefalutFactorByUserId(userId);
            list = this.getListByExample(example);
        }
        return list;
    }

    @Transactional(readOnly=false)
    public void addDefalutFactorByUserId(Long UserId) {
        if (UserId != null) {
            for (KeyHarmFactorEnum enu : KeyHarmFactorEnum.values()) {
                KeyFactorsSet info = new KeyFactorsSet();
                info.setIsDefault(Boolean.valueOf(true));
                info.setIsCheck(Boolean.valueOf(true));
                info.setIsValid(Boolean.valueOf(true));
                info.setUserId(UserId);
                info.setName(enu.getName());
                info.setFactorsIds(enu.getIds());
                info.setFactorsNames(enu.getHarmNames());
                this.add(info, UserId, UserId);
            }
        }
    }

    @Transactional(readOnly=false)
    public List<KeyFactorsSet> getListByUser(Long userId) {
        Example example = new Example(KeyIndustrySet.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("userId", (Object)userId).andEqualTo("isValid", (Object)Global.TRUE);
        List<Object> list = this.getListByExample(example);
        if (list == null || list.size() == 0) {
            this.addDefalutFactorByUserId(userId);
            list = this.getListByExample(example);
        }
        return list;
    }
}

