/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.hccheckstat.impl;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.modules.health.enums.hccheckplan.HcCheckTypeEnum;
import cn.smarthse.modules.health.supervise.dao.hccheckstat.HcCheckInfoStatByYearMapper;
import cn.smarthse.modules.health.supervise.entity.hccheckstat.HcCheckInfoStatByYear;
import cn.smarthse.modules.health.supervise.entity.hcchekplan.HcCheckInfoStat;
import cn.smarthse.modules.health.supervise.service.hccheckplan.IHcCheckPlanCompService;
import cn.smarthse.modules.health.supervise.service.hccheckstat.IHcCheckInfoStatByYearService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Lazy(value=false)
@DubboService
@Transactional(readOnly=true)
public class HcCheckInfoStatByYearServiceImpl
implements IHcCheckInfoStatByYearService {
    @DubboReference
    IHcCheckPlanCompService hcCheckPlanCompService;
    @Autowired
    HcCheckInfoStatByYearMapper hcCheckInfoStatByYearMapper;

    public List<HcCheckInfoStatByYear> getHcCheckInfoStatByYearsByCid(Long cid) {
        Example e = new Example(HcCheckInfoStatByYear.class);
        e.createCriteria().andEqualTo("cid", (Object)cid);
        List list = this.hcCheckInfoStatByYearMapper.selectByExample(e);
        for (HcCheckInfoStatByYear vo : list) {
            if (vo.getCheckType() != null) {
                HcCheckTypeEnum type = HcCheckTypeEnum.getThisEnumByValue((Long)vo.getCheckType().longValue());
                if (type != null) {
                    vo.setCheckTypeName(type.getName());
                }
            } else {
                vo.setCheckTypeName("\u6574\u6539\u540e\u68c0\u6d4b");
            }
            String checkTime = "";
            if (vo.getCheckBeginTime() != null && vo.getCheckEndTime() != null) {
                checkTime = DateUtils.formatDate((Date)vo.getCheckBeginTime());
                vo.setCheckTime(checkTime + "\u81f3");
                vo.setCheckTime(vo.getCheckTime() + DateUtils.formatDate((Date)vo.getCheckEndTime()));
            }
            if (vo.getUnqualifiedCount() == null) {
                vo.setUnqualifiedCount(Integer.valueOf(0));
            }
            if (vo.getSumCount() != null && vo.getSumCount() != 0) {
                vo.setQualifiedCountRate(Double.valueOf(new BigDecimal((double)vo.getQualifiedCount().intValue() / (double)vo.getSumCount().intValue() * 100.0).setScale(0, 4).doubleValue()));
                continue;
            }
            vo.setQualifiedCountRate(Double.valueOf(0.0));
        }
        return list;
    }

    public PageInfo<HcCheckInfoStatByYear> getHcCheckInfoStatByYearsPageInfoByCid(JqGridParam jParam, Long cid) {
        PageHelper.startPage((int)jParam.getPage(), (int)jParam.getRows());
        return new PageInfo(this.getHcCheckInfoStatByYearsByCid(cid));
    }

    @Transactional(readOnly=false)
    public void insertHcCheckInfoStatByYearListFromThird() {
        List sourcelist = this.hcCheckPlanCompService.getNewHcCheckInfoStatsByCid(null);
        this.deleteHcCheckInfoStatByYears();
        ArrayList<HcCheckInfoStatByYear> list = new ArrayList<HcCheckInfoStatByYear>();
        for (HcCheckInfoStat stat : sourcelist) {
            HcCheckInfoStatByYear vo = new HcCheckInfoStatByYear();
            vo.setCheckBeginTime(stat.getCheckBeginDate());
            vo.setCheckEndTime(stat.getCheckEndDate());
            vo.setCid(stat.getCid());
            vo.setHcId(stat.getHcId());
            if (stat.getCheckType() != null) {
                vo.setCheckType(Integer.valueOf(stat.getCheckType().intValue()));
            }
            vo.setQualifiedCount(stat.getNotOverproofCount());
            vo.setUnqualifiedCount(stat.getOverproofCount());
            vo.setSumCount(stat.getTotalCount());
            list.add(vo);
        }
        for (HcCheckInfoStatByYear hcCheckInfoStatByYear : list) {
            this.hcCheckInfoStatByYearMapper.insert(hcCheckInfoStatByYear);
        }
    }

    @Transactional(readOnly=false)
    public void deleteHcCheckInfoStatByYears() {
        this.hcCheckInfoStatByYearMapper.delete(new HcCheckInfoStatByYear());
    }
}

