/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.hccheckcomp.impl;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.health.supervise.entity.company.CompanyRisk;
import cn.smarthse.modules.health.supervise.entity.hcchekplan.HcCheckChemicalStat;
import cn.smarthse.modules.health.supervise.entity.hcchekplan.HcCheckComp;
import cn.smarthse.modules.health.supervise.entity.hcchekplan.HcCheckDustStat;
import cn.smarthse.modules.health.supervise.entity.hcchekplan.HcCheckNoiseStat;
import cn.smarthse.modules.health.supervise.entity.sys.SysArea;
import cn.smarthse.modules.health.supervise.entity.sys.SysParam;
import cn.smarthse.modules.health.supervise.service.company.ICompanyRiskService;
import cn.smarthse.modules.health.supervise.service.company.ICompanyService;
import cn.smarthse.modules.health.supervise.service.hccheckcomp.IHcCheckCompService;
import cn.smarthse.modules.health.supervise.service.hccheckplan.IHcCheckPlanCompService;
import cn.smarthse.modules.health.supervise.service.reform.IReformService;
import cn.smarthse.modules.health.supervise.service.sys.ISuperSysParamService;
import cn.smarthse.modules.health.supervise.service.sys.ISuperviseSysAreaService;
import cn.smarthse.modules.health.supervise.vo.hccheckplan.CompanyQueryData;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
@DubboService
public class HcCheckCompServiceImpl
implements IHcCheckCompService {
    @DubboReference
    IHcCheckPlanCompService hcCheckPlanCompService;
    @Autowired
    ISuperviseSysAreaService sysAreaService;
    @Autowired
    ICompanyService companyService;
    @Autowired
    ISuperSysParamService sysParamService;
    @DubboReference
    IReformService reformService;
    @Autowired
    ICompanyRiskService companyRiskService;

    public List<HcCheckComp> getHcCheckCompsMoreThanOneYearByCids(List<Long> cids) {
        List list = this.hcCheckPlanCompService.getHcCheckCompsMoreThanOneYearByCids(cids);
        for (HcCheckComp h : list) {
            SysArea sys;
            Company comp;
            if (h.getCid() == null) continue;
            CompanyRisk cr = this.companyRiskService.getLastRisk(h.getCid());
            if (cr != null && cr.getLevel() != null) {
                h.setRiskLevel(cr.getLevel());
                if (cr.getLevel() == 1) {
                    h.setRiskLevelName("\u4f4e\u98ce\u9669");
                } else if (cr.getLevel() == 2) {
                    h.setRiskLevelName("\u4e2d\u98ce\u9669");
                } else if (cr.getLevel() == 3) {
                    h.setRiskLevelName("\u9ad8\u98ce\u9669");
                }
            }
            if ((comp = (Company)this.companyService.getById(h.getCid())) == null) continue;
            h.setCompanyName(comp.getName());
            if (comp.getAreaId() != null && (sys = (SysArea)this.sysAreaService.getById(comp.getAreaId())) != null) {
                h.setAreaName("");
                if (StringUtils.isNotEmpty((String)sys.getProvinceName())) {
                    h.setAreaName(h.getAreaName() + sys.getProvinceName());
                }
                if (StringUtils.isNotEmpty((String)sys.getCityName())) {
                    h.setAreaName(h.getAreaName() + sys.getCityName());
                }
                if (StringUtils.isNotEmpty((String)sys.getAreaName())) {
                    h.setAreaName(h.getAreaName() + sys.getAreaName());
                }
                if (StringUtils.isNotEmpty((String)sys.getStreetName())) {
                    h.setAreaName(h.getAreaName() + sys.getStreetName());
                }
            }
            if (comp.getIndustryCategory() == null || (sys = (SysParam)this.sysParamService.getById(comp.getIndustryCategory())) == null) continue;
            h.setIndustry(sys.getParamCode() + "-" + sys.getParamValue());
        }
        return list;
    }

    public PageInfo<HcCheckComp> getHcCheckCompsMoreThanOneYearPageInfoByCids(JqGridParam jParam, List<Long> cids) {
        PageInfo result = this.hcCheckPlanCompService.getHcCheckCompsMoreThanOneYearPageInfoByCids(jParam, cids);
        List list = result.getList();
        for (HcCheckComp h : list) {
            SysArea sys;
            Company comp;
            if (h.getCid() == null) continue;
            CompanyRisk cr = this.companyRiskService.getLastRisk(h.getCid());
            if (cr != null && cr.getLevel() != null) {
                h.setRiskLevel(cr.getLevel());
                if (cr.getLevel() == 1) {
                    h.setRiskLevelName("\u4f4e\u98ce\u9669");
                } else if (cr.getLevel() == 2) {
                    h.setRiskLevelName("\u4e2d\u98ce\u9669");
                } else if (cr.getLevel() == 3) {
                    h.setRiskLevelName("\u9ad8\u98ce\u9669");
                }
            }
            if ((comp = (Company)this.companyService.getById(h.getCid())) == null) continue;
            h.setCompanyName(comp.getName());
            if (comp.getAreaId() != null && (sys = (SysArea)this.sysAreaService.getById(comp.getAreaId())) != null) {
                h.setAreaName("");
                if (StringUtils.isNotEmpty((String)sys.getProvinceName())) {
                    h.setAreaName(h.getAreaName() + sys.getProvinceName());
                }
                if (StringUtils.isNotEmpty((String)sys.getCityName())) {
                    h.setAreaName(h.getAreaName() + sys.getCityName());
                }
                if (StringUtils.isNotEmpty((String)sys.getAreaName())) {
                    h.setAreaName(h.getAreaName() + sys.getAreaName());
                }
                if (StringUtils.isNotEmpty((String)sys.getStreetName())) {
                    h.setAreaName(h.getAreaName() + sys.getStreetName());
                }
            }
            if (comp.getIndustryCategory() == null || (sys = (SysParam)this.sysParamService.getById(comp.getIndustryCategory())) == null) continue;
            h.setIndustry(sys.getParamCode() + "-" + sys.getParamValue());
        }
        return result;
    }

    public List<HcCheckComp> getHcCheckCompsLessThanThreeMonthsByCids(List<Long> cids, Integer month) {
        List list = this.hcCheckPlanCompService.getHcCheckCompsLessThanThreeMonthsByCids(cids, month);
        for (HcCheckComp h : list) {
            SysArea sys;
            Company comp;
            if (h.getCid() == null) continue;
            CompanyRisk cr = this.companyRiskService.getLastRisk(h.getCid());
            if (cr != null && cr.getLevel() != null) {
                h.setRiskLevel(cr.getLevel());
                if (cr.getLevel() == 1) {
                    h.setRiskLevelName("\u4f4e\u98ce\u9669");
                } else if (cr.getLevel() == 2) {
                    h.setRiskLevelName("\u4e2d\u98ce\u9669");
                } else if (cr.getLevel() == 3) {
                    h.setRiskLevelName("\u9ad8\u98ce\u9669");
                }
            }
            if ((comp = (Company)this.companyService.getById(h.getCid())) == null) continue;
            h.setCompanyName(comp.getName());
            if (comp.getAreaId() != null && (sys = (SysArea)this.sysAreaService.getById(comp.getAreaId())) != null) {
                h.setAreaName("");
                if (StringUtils.isNotEmpty((String)sys.getProvinceName())) {
                    h.setAreaName(h.getAreaName() + sys.getProvinceName());
                }
                if (StringUtils.isNotEmpty((String)sys.getCityName())) {
                    h.setAreaName(h.getAreaName() + sys.getCityName());
                }
                if (StringUtils.isNotEmpty((String)sys.getAreaName())) {
                    h.setAreaName(h.getAreaName() + sys.getAreaName());
                }
                if (StringUtils.isNotEmpty((String)sys.getStreetName())) {
                    h.setAreaName(h.getAreaName() + sys.getStreetName());
                }
            }
            if (comp.getIndustryCategory() == null || (sys = (SysParam)this.sysParamService.getById(comp.getIndustryCategory())) == null) continue;
            h.setIndustry(sys.getParamCode() + "-" + sys.getParamValue());
        }
        return list;
    }

    public PageInfo<HcCheckComp> getHcCheckCompsLessThanThreeMonthsPageInfoByCids(JqGridParam jParam, List<Long> cids, Integer month) {
        PageInfo result = this.hcCheckPlanCompService.getHcCheckCompsLessThanThreeMonthsPageInfoByCids(jParam, cids, month);
        List list = result.getList();
        for (HcCheckComp h : list) {
            SysArea sys;
            Company comp;
            if (h.getCid() == null) continue;
            CompanyRisk cr = this.companyRiskService.getLastRisk(h.getCid());
            if (cr != null && cr.getLevel() != null) {
                h.setRiskLevel(cr.getLevel());
                if (cr.getLevel() == 1) {
                    h.setRiskLevelName("\u4f4e\u98ce\u9669");
                } else if (cr.getLevel() == 2) {
                    h.setRiskLevelName("\u4e2d\u98ce\u9669");
                } else if (cr.getLevel() == 3) {
                    h.setRiskLevelName("\u9ad8\u98ce\u9669");
                }
            }
            if ((comp = (Company)this.companyService.getById(h.getCid())) == null) continue;
            h.setCompanyName(comp.getName());
            if (comp.getAreaId() != null && (sys = (SysArea)this.sysAreaService.getById(comp.getAreaId())) != null) {
                h.setAreaName("");
                if (StringUtils.isNotEmpty((String)sys.getProvinceName())) {
                    h.setAreaName(h.getAreaName() + sys.getProvinceName());
                }
                if (StringUtils.isNotEmpty((String)sys.getCityName())) {
                    h.setAreaName(h.getAreaName() + sys.getCityName());
                }
                if (StringUtils.isNotEmpty((String)sys.getAreaName())) {
                    h.setAreaName(h.getAreaName() + sys.getAreaName());
                }
                if (StringUtils.isNotEmpty((String)sys.getStreetName())) {
                    h.setAreaName(h.getAreaName() + sys.getStreetName());
                }
            }
            if (comp.getIndustryCategory() == null || (sys = (SysParam)this.sysParamService.getById(comp.getIndustryCategory())) == null) continue;
            h.setIndustry(sys.getParamCode() + "-" + sys.getParamValue());
        }
        return result;
    }

    public Integer getAllCountResultDataByHcId(Long cid, Long hcId) {
        return this.hcCheckPlanCompService.getAllCountResultDataByHcId(cid, hcId);
    }

    public Integer getHcCheckPlanNoAccordCountByYearAndCid(String year, Long cid) {
        return this.hcCheckPlanCompService.getHcCheckPlanNoAccordCountByYearAndCid(year, cid);
    }

    public List<HcCheckComp> getNeverHcCheckCompsByCids(List<CompanyQueryData> query, List<Long> cids) {
        List list = this.hcCheckPlanCompService.getNeverHcCheckCompsByCids(query, cids);
        for (HcCheckComp h : list) {
            SysArea sys;
            Company comp;
            if (h.getCid() == null || (comp = (Company)this.companyService.getById(h.getCid())) == null) continue;
            h.setCompanyName(comp.getName());
            if (comp.getAreaId() != null && (sys = (SysArea)this.sysAreaService.getById(comp.getAreaId())) != null) {
                h.setAreaName("");
                if (StringUtils.isNotEmpty((String)sys.getProvinceName())) {
                    h.setAreaName(h.getAreaName() + sys.getProvinceName());
                }
                if (StringUtils.isNotEmpty((String)sys.getCityName())) {
                    h.setAreaName(h.getAreaName() + sys.getCityName());
                }
                if (StringUtils.isNotEmpty((String)sys.getAreaName())) {
                    h.setAreaName(h.getAreaName() + sys.getAreaName());
                }
                if (StringUtils.isNotEmpty((String)sys.getStreetName())) {
                    h.setAreaName(h.getAreaName() + sys.getStreetName());
                }
            }
            if (comp.getIndustryCategory() == null || (sys = (SysParam)this.sysParamService.getById(comp.getIndustryCategory())) == null) continue;
            h.setIndustry(sys.getParamCode() + "-" + sys.getParamValue());
        }
        return list;
    }

    public PageInfo<HcCheckComp> getNeverHcCheckCompsPageInfoByCids(JqGridParam jParam, List<CompanyQueryData> query, List<Long> cids) {
        PageInfo result = this.hcCheckPlanCompService.getNeverHcCheckCompsPageInfoByCids(jParam, query, cids);
        List list = result.getList();
        for (HcCheckComp h : list) {
            SysArea sys;
            Company comp;
            if (h.getCid() == null) continue;
            CompanyRisk cr = this.companyRiskService.getLastRisk(h.getCid());
            if (cr != null && cr.getLevel() != null) {
                h.setRiskLevel(cr.getLevel());
                if (cr.getLevel() == 1) {
                    h.setRiskLevelName("\u4f4e\u98ce\u9669");
                } else if (cr.getLevel() == 2) {
                    h.setRiskLevelName("\u4e2d\u98ce\u9669");
                } else if (cr.getLevel() == 3) {
                    h.setRiskLevelName("\u9ad8\u98ce\u9669");
                }
            }
            if ((comp = (Company)this.companyService.getById(h.getCid())) == null) continue;
            h.setCompanyName(comp.getName());
            if (comp.getAreaId() != null && (sys = (SysArea)this.sysAreaService.getById(comp.getAreaId())) != null) {
                h.setAreaName("");
                if (StringUtils.isNotEmpty((String)sys.getProvinceName())) {
                    h.setAreaName(h.getAreaName() + sys.getProvinceName());
                }
                if (StringUtils.isNotEmpty((String)sys.getCityName())) {
                    h.setAreaName(h.getAreaName() + sys.getCityName());
                }
                if (StringUtils.isNotEmpty((String)sys.getAreaName())) {
                    h.setAreaName(h.getAreaName() + sys.getAreaName());
                }
                if (StringUtils.isNotEmpty((String)sys.getStreetName())) {
                    h.setAreaName(h.getAreaName() + sys.getStreetName());
                }
            }
            if (comp.getIndustryCategory() == null || (sys = (SysParam)this.sysParamService.getById(comp.getIndustryCategory())) == null) continue;
            h.setIndustry(sys.getParamCode() + "-" + sys.getParamValue());
        }
        return result;
    }

    public PageInfo<HcCheckDustStat> getHcCheckDustStatPageInfoByCidsAndHarmIds(JqGridParam jParam, String areaCode, Byte level, String searchKey, Boolean isFilter, Byte flag) {
        return this.hcCheckPlanCompService.getHcCheckDustStatPageInfoByCidsAndHarmIds(jParam, areaCode, level, searchKey, isFilter, flag);
    }

    public PageInfo<HcCheckChemicalStat> getHcCheckChemicalStatPageInfoByAreaCodeAndHarmIds(JqGridParam jParam, String areaCode, Byte level, String searchKey, Boolean isFilter, Byte flag) {
        return this.hcCheckPlanCompService.getHcCheckChemicalStatPageInfoByAreaCodeAndHarmIds(jParam, areaCode, level, searchKey, isFilter, flag);
    }

    public PageInfo<HcCheckNoiseStat> getHcCheckNoiseStatPageInfoByAreaCodeAndHarmIds(JqGridParam jParam, String areaCode, Byte level, Boolean isFilter, Byte flag) {
        return this.hcCheckPlanCompService.getHcCheckNoiseStatPageInfoByAreaCodeAndHarmIds(jParam, areaCode, level, isFilter, flag);
    }

    public HcCheckDustStat getTotalDustByAreaCode(String areaCode, Byte level, String searchKey, Byte flag) {
        return this.hcCheckPlanCompService.getTotalDustByAreaCode(areaCode, level, searchKey, flag);
    }

    public HcCheckChemicalStat getTotalChemicalByAreaCode(String areaCode, Byte level, String searchKey, Byte flag) {
        return this.hcCheckPlanCompService.getTotalChemicalByAreaCode(areaCode, level, searchKey, flag);
    }

    public List<HcCheckNoiseStat> getHcCheckNoiseStatByAreaCode(String areaCode, Byte level, Boolean isFilter, Byte flag) {
        return this.hcCheckPlanCompService.getHcCheckNoiseStatByAreaCode(areaCode, level, isFilter, flag);
    }

    public List<HcCheckDustStat> getHcCheckDustStatByCidsAndHarmIds(String areaCode, Byte level, String searchKey, Boolean isFilter, Byte flag) {
        return this.hcCheckPlanCompService.getHcCheckDustStatByCidsAndHarmIds(areaCode, level, searchKey, isFilter, flag);
    }

    public List<HcCheckChemicalStat> getHcCheckChemicalStatByAreaCodeAndHarmIds(String areaCode, Byte level, String searchKey, Boolean isFilter, Byte flag) {
        return this.hcCheckPlanCompService.getHcCheckChemicalStatByAreaCodeAndHarmIds(areaCode, level, searchKey, isFilter, flag);
    }

    public List<HcCheckNoiseStat> getHcCheckNoiseStatByAreaCodeAndHarmIds(String areaCode, Byte level, Boolean isFilter, Byte flag) {
        return this.hcCheckPlanCompService.getHcCheckNoiseStatByAreaCode(areaCode, level, isFilter, flag);
    }
}

