/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.hccheckcomp.impl;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.health.enums.company.CompanySizeEnum;
import cn.smarthse.modules.health.supervise.entity.hcchekplan.HcCheckThirdStat;
import cn.smarthse.modules.health.supervise.entity.hcchekplan.ThresholdValues;
import cn.smarthse.modules.health.supervise.entity.warning.CompanyHarms;
import cn.smarthse.modules.health.supervise.enums.HarmTypeEnum;
import cn.smarthse.modules.health.supervise.enums.ImportantIndustryTypeEnum;
import cn.smarthse.modules.health.supervise.enums.ThirdHarmTypeEnum;
import cn.smarthse.modules.health.supervise.service.company.ICompanyService;
import cn.smarthse.modules.health.supervise.service.hccheckcomp.IHcCheckAreaStatService;
import cn.smarthse.modules.health.supervise.service.hccheckplan.IHcCheckAreaThirdStatService;
import cn.smarthse.modules.health.supervise.service.sys.ISuperSysParamService;
import cn.smarthse.modules.health.supervise.service.sys.ISuperviseSysAreaService;
import cn.smarthse.modules.health.supervise.vo.evaluate.EvaluateMaxTimeByOrgIdVo;
import com.github.pagehelper.PageInfo;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
@DubboService
public class HcCheckAreaStatServiceImpl
implements IHcCheckAreaStatService {
    @DubboReference
    IHcCheckAreaThirdStatService hcCheckAreaThirdStatService;
    @Autowired
    ISuperviseSysAreaService sysAreaService;
    @Autowired
    ICompanyService companyService;
    @Autowired
    ISuperSysParamService sysParamService;

    public Integer getHcCheckCompanyCountByAreaAndYear(String areaId, Byte level, Integer year) {
        return this.hcCheckAreaThirdStatService.getHcCheckCompanyCountByAreaAndYear(areaId, level, year);
    }

    public List<HcCheckThirdStat> getHcCheckThirdStatByArea(String areaId, Byte level) {
        return this.hcCheckAreaThirdStatService.getHcCheckThirdStatByArea(areaId, level);
    }

    public List<HcCheckThirdStat> getHcCheckThirdStatByHarm(String areaId, Byte level) {
        List result = this.hcCheckAreaThirdStatService.getHcCheckThirdStatByHarm(areaId, level);
        ArrayList<HcCheckThirdStat> finalResult = new ArrayList<HcCheckThirdStat>();
        for (ThirdHarmTypeEnum type : ThirdHarmTypeEnum.values()) {
            HcCheckThirdStat stat = new HcCheckThirdStat();
            stat.setHarmType(type.getTypeVal().toString());
            stat.setHarmTypeName(type.getHarmTypeName());
            for (HcCheckThirdStat th : result) {
                if (!type.getTypeVal().toString().equals(th.getHarmType())) continue;
                stat.setStaffCount(th.getStaffCount());
                break;
            }
            finalResult.add(stat);
        }
        return finalResult;
    }

    public List<HcCheckThirdStat> getHcCheckThirdStatByIndustry(String areaId, Byte level) {
        List result = this.hcCheckAreaThirdStatService.getHcCheckThirdStatByIndustry(areaId, level);
        ArrayList<HcCheckThirdStat> finalResult = new ArrayList<HcCheckThirdStat>();
        for (ImportantIndustryTypeEnum type : ImportantIndustryTypeEnum.values()) {
            HcCheckThirdStat stat = new HcCheckThirdStat();
            stat.setIndustryImportantType(type.getCodeVal().toString());
            stat.setIndustryImportantTypeName(type.getTypeName());
            for (HcCheckThirdStat th : result) {
                if (!type.getCodeVal().toString().equals(th.getIndustryImportantType())) continue;
                stat.setStaffCount(th.getStaffCount());
                break;
            }
            finalResult.add(stat);
        }
        return finalResult;
    }

    public Integer getWorkHarmStaffCountByAreaAndYear(String areaId, Byte level, Integer year) {
        return this.hcCheckAreaThirdStatService.getWorkHarmStaffCountByAreaAndYear(areaId, level, year, null);
    }

    public Integer getOnWorkCompanyStaffCountByAreaAndYear(String areaId, Byte level, Integer year) {
        return this.hcCheckAreaThirdStatService.getOnWorkCompanyStaffCountByAreaAndYear(areaId, level, year);
    }

    public Integer getCompanyFunctionalOrganizationMemberCountByAreaAndYear(String areaId, Byte level, Integer year) {
        return this.hcCheckAreaThirdStatService.getCompanyFunctionalOrganizationMemberCountByAreaAndYear(areaId, level, year);
    }

    public List<HcCheckThirdStat> getHcCheckThirdBelowProofRateStatByAreaAndYearAndRateValue(String areaId, Byte level, Integer year, Double rateVal) {
        return this.hcCheckAreaThirdStatService.getHcCheckThirdBelowProofRateStatByAreaAndYearAndRateValue(areaId, level, year, rateVal);
    }

    public PageInfo<HcCheckThirdStat> getHcCheckThirdBelowProofRateStatByAreaAndYearAndRateValuePage(JqGridParam jParam, String areaId, Byte level, Integer year, Double rateVal) {
        return this.hcCheckAreaThirdStatService.getHcCheckThirdBelowProofRateStatByAreaAndYearAndRateValuePage(jParam, areaId, level, year, rateVal);
    }

    public List<HcCheckThirdStat> getHcCheckExpiryCompanyMoreThanOneYearByArea(String areaId, Byte level) {
        return this.hcCheckAreaThirdStatService.getHcCheckExpiryCompanyMoreThanOneYearByArea(areaId, level);
    }

    public Integer getHcCheckExpiryCompanyCountMoreThanOneYearByArea(String areaId, Byte level) {
        return this.hcCheckAreaThirdStatService.getHcCheckExpiryCompanyCountMoreThanOneYearByArea(areaId, level);
    }

    public PageInfo<HcCheckThirdStat> getHcCheckExpiryCompanyMoreThanOneYearByAreaPage(JqGridParam jParam, String areaId, Byte level) {
        return this.hcCheckAreaThirdStatService.getHcCheckExpiryCompanyMoreThanOneYearByAreaPage(jParam, areaId, level);
    }

    private String getParentCodeByAreaIdAndLevel(String areaId, Byte level) {
        String parentCode = "";
        if (level == 1) {
            parentCode = areaId.substring(0, 2);
        } else if (level == 2) {
            parentCode = areaId.substring(0, 4);
        } else if (level == 3) {
            parentCode = areaId.substring(0, 6);
        } else if (level == 4) {
            parentCode = areaId.substring(0, 9);
        }
        return parentCode;
    }

    public List<HcCheckThirdStat> getHcCheckExpiryCompanyInTwoWeeksByArea(String areaId, Byte level, Date dateStart, Date dateEnd) {
        return this.hcCheckAreaThirdStatService.getHcCheckExpiryCompanyInTwoWeeksByArea(areaId, level, dateStart, dateEnd);
    }

    public Integer getHcCheckExpiryCompanyCountInTwoWeeksByArea(String areaId, Byte level, Date dateStart, Date dateEnd) {
        return this.hcCheckAreaThirdStatService.getHcCheckExpiryCompanyCountInTwoWeeksByArea(areaId, level, dateStart, dateEnd);
    }

    public PageInfo<HcCheckThirdStat> getHcCheckExpiryCompanyInTwoWeeksByAreaPage(JqGridParam jParam, String areaId, Byte level, Date dateStart, Date dateEnd) {
        return this.hcCheckAreaThirdStatService.getHcCheckExpiryCompanyInTwoWeeksByAreaPage(jParam, areaId, level, dateStart, dateEnd);
    }

    public List<HcCheckThirdStat> getHcCheckExpiryCompanyNeverCheckByArea(String areaId, Byte level) {
        return this.hcCheckAreaThirdStatService.getHcCheckExpiryCompanyNeverCheckByArea(areaId, level);
    }

    public Integer getHcCheckExpiryCompanyNeverCheckCountByArea(String areaId, Byte level) {
        return this.hcCheckAreaThirdStatService.getHcCheckExpiryCompanyNeverCheckCountByArea(areaId, level);
    }

    public PageInfo<HcCheckThirdStat> getHcCheckExpiryCompanyNeverCheckByAreaPage(JqGridParam jParam, String areaId, Byte level) {
        return this.hcCheckAreaThirdStatService.getHcCheckExpiryCompanyNeverCheckByAreaPage(jParam, areaId, level);
    }

    public Integer getHcCheckCompanyCountByAreaAndBetweenTime(String areaId, Byte level, Date begin, Date end) {
        return this.hcCheckAreaThirdStatService.getHcCheckCompanyCountByAreaAndBetweenTime(areaId, level, begin, end);
    }

    public List<HcCheckThirdStat> getHcCheckThirdStatByHarmType(String areaId, Byte level) {
        List result = this.hcCheckAreaThirdStatService.getHcCheckThirdStatByHarmType(areaId, level);
        ArrayList<HcCheckThirdStat> finalResult = new ArrayList<HcCheckThirdStat>();
        for (HarmTypeEnum type : HarmTypeEnum.values()) {
            HcCheckThirdStat stat = new HcCheckThirdStat();
            stat.setHarmType(type.getTypeVal().toString());
            stat.setHarmTypeName(type.getHarmTypeName());
            for (HcCheckThirdStat th : result) {
                if (!type.getTypeVal().toString().equals(th.getHarmType())) continue;
                stat.setStaffCount(th.getStaffCount());
                break;
            }
            finalResult.add(stat);
        }
        return finalResult;
    }

    public List<HcCheckThirdStat> getHcCheckThirdStatByScale(String areaId, Byte level) {
        List result = this.hcCheckAreaThirdStatService.getHcCheckThirdStatByScale(areaId, level);
        ArrayList<HcCheckThirdStat> finalResult = new ArrayList<HcCheckThirdStat>();
        for (CompanySizeEnum type : CompanySizeEnum.values()) {
            HcCheckThirdStat stat = new HcCheckThirdStat();
            stat.setScale(type.getCode().toString());
            stat.setScaleName(type.getName());
            for (HcCheckThirdStat th : result) {
                if (!type.getCode().toString().equals(th.getScale())) continue;
                stat.setStaffCount(th.getStaffCount());
                break;
            }
            finalResult.add(stat);
        }
        return finalResult;
    }

    public String getHarmNamesLastHcCheckByCid(Long cid) {
        Long hcId = this.hcCheckAreaThirdStatService.getLastRegularHcCheckPlanIdByCid(cid);
        if (hcId != null) {
            return this.hcCheckAreaThirdStatService.getHarmNamesByHcIdByHcId(hcId);
        }
        return "";
    }

    public PageInfo<HcCheckThirdStat> getHcCheckThirdBelowProofRateStatByAreaAndYearAndThresholdValuesPage(JqGridParam jParam, String areaId, Byte level, Integer year, ThresholdValues vo) {
        return this.hcCheckAreaThirdStatService.getHcCheckThirdBelowProofRateStatByAreaAndYearAndThresholdValuesPage(jParam, areaId, level, year, vo);
    }

    public List<HcCheckThirdStat> getHcCheckThirdBelowProofRateStatByAreaAndYearAndThresholdValues(String areaId, Byte level, Integer year, ThresholdValues vo) {
        return this.hcCheckAreaThirdStatService.getHcCheckThirdBelowProofRateStatByAreaAndYearAndThresholdValues(areaId, level, year, vo);
    }

    public List<HcCheckThirdStat> hcCheckThirdStatScaleComCountByScaleAndArea(String areaId, Byte level) {
        return this.hcCheckAreaThirdStatService.hcCheckThirdStatScaleComCountByScaleAndArea(areaId, level);
    }

    public Map<Long, Integer> getThirdOrgHcCheckPlanReportedCountByYear(String areaId, Byte level, Integer year) {
        Long[] list = this.getThirdOrgIdListByParentCode(areaId, level);
        if (list == null) {
            return null;
        }
        HashMap<Long, Integer> map = new HashMap<Long, Integer>();
        for (Long orgId : list) {
            if (map.get(orgId) != null) continue;
            Integer count = this.hcCheckAreaThirdStatService.getThirdOrgHcCheckPlanReportedCountByYearAndOrgId(areaId, level, year, orgId);
            map.put(orgId, count);
        }
        return map;
    }

    public Long[] getThirdOrgIdListByParentCode(String areaId, Byte level) {
        List list = this.hcCheckAreaThirdStatService.getThirdOrgIdListByParentCode(areaId, level);
        if (list != null && list.size() > 0) {
            return (Long[])list.stream().toArray(Long[]::new);
        }
        return null;
    }

    public List<EvaluateMaxTimeByOrgIdVo> getHcCheckThirdOrgMaxTimeVo(Long[] orgIds, String areaId, Byte level) {
        ArrayList<EvaluateMaxTimeByOrgIdVo> list = new ArrayList<EvaluateMaxTimeByOrgIdVo>();
        for (Long orgId : orgIds) {
            EvaluateMaxTimeByOrgIdVo vo = new EvaluateMaxTimeByOrgIdVo();
            vo.setOrgId(orgId);
            vo.setBeginMaxtime(this.hcCheckAreaThirdStatService.getLastHcCheckReportTimeByOrgAndParentCode(areaId, level, orgId));
            list.add(vo);
        }
        return list;
    }

    public List<CompanyHarms> getHcCheckCompanyHarmListByParentCodeAndTimeRange(String areaId, Byte level, Date start, Date end) {
        List list = this.hcCheckAreaThirdStatService.getHcCheckCompanyHarmListByParentCode(areaId, level, start, end);
        return list;
    }

    public List<CompanyHarms> getHcCheckCompanyHarmListByParentCodeAndTimeRangeAndCheckValueMoreThanTen(String areaId, Byte level, Date start, Date end) {
        List list = this.hcCheckAreaThirdStatService.getHcCheckCompanyHarmListByParentCode(areaId, level, start, end);
        for (CompanyHarms ch : list) {
            List harmFactorIdList = this.hcCheckAreaThirdStatService.getHcCHeckHarmIdsByCidAndTimeRangeAndCheckValueMoreThanTen(ch.getCid(), start, end);
            if (harmFactorIdList == null || harmFactorIdList.size() <= 0) continue;
            ArrayList<CallSite> strs = new ArrayList<CallSite>();
            for (Long haId : harmFactorIdList) {
                strs.add((CallSite)((Object)("" + haId)));
            }
            ch.setHarmFactorIds(String.join((CharSequence)",", strs));
        }
        return list;
    }

    public List<CompanyHarms> getHcCheckCompanyHarmListByParentCodeAndTwoTimeRangeAndCheckValueMoreThanTen(String areaId, Byte level, Date start1, Date end1, Date start2, Date end2) {
        List list = this.hcCheckAreaThirdStatService.getHcCheckCompanyHarmListByParentCodeAndTwoBetweenTime(areaId, level, start1, end1, start2, end2);
        return list;
    }
}

