/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.gradeset;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.IndustryProvideService;
import cn.smarthse.modules.datacentre.provider.system.riskFactors.IHarmFactorService;
import cn.smarthse.modules.health.supervise.dao.gradeset.GradeHarmKeysetMapper;
import cn.smarthse.modules.health.supervise.dao.gradeset.GradeKeysetMapper;
import cn.smarthse.modules.health.supervise.entity.gradeset.GradeHarmKeyset;
import cn.smarthse.modules.health.supervise.entity.gradeset.GradeKeyset;
import cn.smarthse.modules.health.supervise.model.gradeset.GradeKeySetModel;
import cn.smarthse.modules.health.supervise.model.gradeset.GradeSetForm;
import cn.smarthse.modules.health.supervise.service.gradeset.IGradeHarmKeysetService;
import cn.smarthse.modules.health.supervise.service.gradeset.IGradeKeysetService;
import cn.smarthse.modules.platform.model.AreaModel;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional(readOnly=true)
public class GradeKeysetServiceImpl
extends BaseServiceImpl<GradeKeysetMapper, GradeKeyset>
implements IGradeKeysetService {
    @Resource
    private GradeKeysetMapper gradeKeysetMapper;
    @Autowired
    private IGradeHarmKeysetService gradeHarmKeysetService;
    @Autowired
    private GradeHarmKeysetMapper gradeHarmKeysetMapper;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService areaProvideService;
    @DubboReference(version="1.0.0")
    private IndustryProvideService industryProvideService;
    @DubboReference(version="1.0.0")
    private IHarmFactorService harmFactorService;

    @Transactional(readOnly=false)
    public void saveGradeKeyset(GradeSetForm gradeSetForm, Long areaId, Long loginStaffId) {
        if (areaId == null) {
            return;
        }
        Example e = new Example(GradeKeyset.class);
        e.createCriteria().andEqualTo("areaId", (Object)areaId);
        ((GradeKeysetMapper)this.dao).deleteByExample(e);
        Example he = new Example(GradeHarmKeyset.class);
        he.createCriteria().andEqualTo("areaId", (Object)areaId);
        this.gradeHarmKeysetMapper.deleteByExample(he);
        List<GradeKeySetModel> gradeKeySetModelList = this.parseGradeSetForm(gradeSetForm);
        if (CollectionUtils.isNotEmpty(gradeKeySetModelList)) {
            for (GradeKeySetModel keySetModel : gradeKeySetModelList) {
                GradeKeyset gradeKeyset = keySetModel.getGradeKeyset();
                List harmKeysetList = keySetModel.getHarmKeysetList();
                gradeKeyset.setAreaId(areaId);
                this.add(gradeKeyset, loginStaffId, null);
                if (!CollectionUtils.isNotEmpty((Collection)harmKeysetList)) continue;
                for (GradeHarmKeyset gradeHarmKeyset : harmKeysetList) {
                    gradeHarmKeyset.setAreaId(areaId);
                    this.gradeHarmKeysetService.add((Object)gradeHarmKeyset, loginStaffId, null);
                }
            }
        }
    }

    private List<GradeKeySetModel> parseGradeSetForm(GradeSetForm gradeSetForm) {
        ArrayList<GradeKeySetModel> gradeSetForm1 = new ArrayList<GradeKeySetModel>();
        if (gradeSetForm != null && CollectionUtils.isNotEmpty((Collection)gradeSetForm.getGradeSetForm())) {
            List form = gradeSetForm.getGradeSetForm();
            for (GradeKeySetModel keySetModel : form) {
                GradeKeyset gradeKeyset = keySetModel.getGradeKeyset();
                if (this.testGradeKeySet(gradeKeyset)) {
                    keySetModel.setHarmKeysetList(this.handleHarmList(keySetModel.getHarmKeysetList()));
                    gradeSetForm1.add(keySetModel);
                    continue;
                }
                List<GradeHarmKeyset> gradeHarmKeysets = this.handleHarmList(keySetModel.getHarmKeysetList());
                if (!CollectionUtils.isNotEmpty(gradeHarmKeysets)) continue;
                keySetModel.setHarmKeysetList(this.handleHarmList(keySetModel.getHarmKeysetList()));
                gradeSetForm1.add(keySetModel);
            }
        }
        return gradeSetForm1;
    }

    private List<GradeHarmKeyset> handleHarmList(List<GradeHarmKeyset> harmKeysetList) {
        ArrayList<GradeHarmKeyset> harmKeysetListResult = new ArrayList<GradeHarmKeyset>();
        if (CollectionUtils.isNotEmpty(harmKeysetList)) {
            for (GradeHarmKeyset gradeHarmKeyset : harmKeysetList) {
                if (!this.testGradeKeyHarmSet(gradeHarmKeyset)) continue;
                harmKeysetListResult.add(gradeHarmKeyset);
            }
        }
        return harmKeysetListResult;
    }

    private boolean testGradeKeyHarmSet(GradeHarmKeyset gradeHarmKeyset) {
        return gradeHarmKeyset != null && StringUtils.isNotBlank((CharSequence)gradeHarmKeyset.getHarmIds());
    }

    private boolean testGradeKeySet(GradeKeyset gradeKeyset) {
        return StringUtils.isNotBlank((CharSequence)gradeKeyset.getIndustryIds()) || gradeKeyset.getGovern() != null && gradeKeyset.getGovern() != false || gradeKeyset.getOccNum() != null && gradeKeyset.getOccYear() != null;
    }

    @Transactional(readOnly=true)
    public GradeKeySetModel getGradeKeySetModelByGrade(Byte grade) {
        Example e = new Example(GradeKeyset.class);
        e.createCriteria().andEqualTo("grade", (Object)grade);
        GradeKeySetModel model = new GradeKeySetModel();
        GradeKeyset gradeKeyset = (GradeKeyset)this.getOneByExample(e);
        model.setGradeKeyset(gradeKeyset);
        Example he = new Example(GradeHarmKeyset.class);
        he.createCriteria().andEqualTo("grade", (Object)grade);
        List gradeHarmKeysetList = this.gradeHarmKeysetService.getListByExample(he);
        model.setHarmKeysetList(gradeHarmKeysetList);
        return model;
    }

    @Transactional(readOnly=true)
    public GradeKeySetModel getGradeKeySetModelByGradeAndAreaId(Byte grade, Long AreaId) {
        Example e = new Example(GradeKeyset.class);
        Example.Criteria criteria = e.createCriteria();
        if (grade != null) {
            criteria.andEqualTo("grade", (Object)grade);
        }
        if (AreaId != null) {
            criteria.andEqualTo("AreaId", (Object)AreaId);
        }
        GradeKeySetModel model = new GradeKeySetModel();
        GradeKeyset gradeKeyset = (GradeKeyset)this.getOneByExample(e);
        model.setGradeKeyset(gradeKeyset);
        Example he = new Example(GradeHarmKeyset.class);
        Example.Criteria criteria1 = he.createCriteria();
        if (grade != null) {
            criteria1.andEqualTo("grade", (Object)grade);
        }
        if (AreaId != null) {
            criteria1.andEqualTo("AreaId", (Object)AreaId);
        }
        List gradeHarmKeysetList = this.gradeHarmKeysetService.getListByExample(he);
        model.setHarmKeysetList(gradeHarmKeysetList);
        return model;
    }

    @Transactional(readOnly=true)
    public List<GradeKeySetModel> listAllGradeKeySetModel() {
        Example e = new Example(GradeKeyset.class);
        List gradeKeysetList = this.getListByExample(e);
        if (CollectionUtils.isNotEmpty(gradeKeysetList)) {
            ArrayList<GradeKeySetModel> modelList = new ArrayList<GradeKeySetModel>();
            for (GradeKeyset gradeKeyset : gradeKeysetList) {
                GradeKeySetModel keySetModel = new GradeKeySetModel();
                if (StringUtils.isNotBlank((CharSequence)gradeKeyset.getIndustryIds())) {
                    List industryByIds = this.industryProvideService.getIndustryByIds(gradeKeyset.getIndustryIds());
                    gradeKeyset.setIndustryList(industryByIds);
                }
                keySetModel.setGradeKeyset(gradeKeyset);
                Example he = new Example(GradeHarmKeyset.class);
                he.createCriteria().andEqualTo("grade", (Object)gradeKeyset.getGrade()).andEqualTo("areaId", (Object)gradeKeyset.getAreaId());
                List gradeHarmKeysetList = this.gradeHarmKeysetService.getListByExample(he);
                if (CollectionUtils.isNotEmpty((Collection)gradeHarmKeysetList)) {
                    for (GradeHarmKeyset gradeHarmKeyset : gradeHarmKeysetList) {
                        String harmIds = gradeHarmKeyset.getHarmIds();
                        if (!StringUtils.isNotBlank((CharSequence)harmIds)) continue;
                        List harmFactorList = this.harmFactorService.getHarmByIds(harmIds);
                        gradeHarmKeyset.setHarmList(harmFactorList);
                    }
                }
                keySetModel.setHarmKeysetList(gradeHarmKeysetList);
                modelList.add(keySetModel);
            }
            return modelList;
        }
        return Collections.emptyList();
    }

    @Transactional(readOnly=true)
    public List<GradeKeySetModel> listGradeKeySetModelByAreaId(Long areaId) {
        if (areaId == null) {
            return Collections.emptyList();
        }
        Example e = new Example(GradeKeyset.class);
        e.createCriteria().andEqualTo("areaId", (Object)areaId);
        List gradeKeysetList = this.getListByExample(e);
        if (CollectionUtils.isNotEmpty(gradeKeysetList)) {
            ArrayList<GradeKeySetModel> modelList = new ArrayList<GradeKeySetModel>();
            for (GradeKeyset gradeKeyset : gradeKeysetList) {
                GradeKeySetModel keySetModel = new GradeKeySetModel();
                if (StringUtils.isNotBlank((CharSequence)gradeKeyset.getIndustryIds())) {
                    List industryByIds = this.industryProvideService.getIndustryByIds(gradeKeyset.getIndustryIds());
                    gradeKeyset.setIndustryList(industryByIds);
                }
                keySetModel.setGradeKeyset(gradeKeyset);
                Example he = new Example(GradeHarmKeyset.class);
                he.createCriteria().andEqualTo("grade", (Object)gradeKeyset.getGrade()).andEqualTo("areaId", (Object)areaId);
                List gradeHarmKeysetList = this.gradeHarmKeysetService.getListByExample(he);
                if (CollectionUtils.isNotEmpty((Collection)gradeHarmKeysetList)) {
                    for (GradeHarmKeyset gradeHarmKeyset : gradeHarmKeysetList) {
                        String harmIds = gradeHarmKeyset.getHarmIds();
                        if (!StringUtils.isNotBlank((CharSequence)harmIds)) continue;
                        List harmFactorList = this.harmFactorService.getHarmByIds(harmIds);
                        gradeHarmKeyset.setHarmList(harmFactorList);
                    }
                }
                keySetModel.setHarmKeysetList(gradeHarmKeysetList);
                modelList.add(keySetModel);
            }
            return modelList;
        }
        return Collections.emptyList();
    }

    public Long getGradeSetAreaId(Long areaIdTemp) {
        ArrayList<Long> areaids = new ArrayList<Long>();
        areaids.add(0L);
        AreaModel areaModel = this.areaProvideService.getAreaById(areaIdTemp);
        if (areaModel != null) {
            if (areaModel.getLevel().intValue() == 1) {
                areaids.add(areaModel.getProvinceId());
            } else if (areaModel.getLevel().intValue() == 2) {
                areaids.add(areaModel.getProvinceId());
                areaids.add(areaModel.getCityId());
            } else if (areaModel.getLevel().intValue() == 3) {
                areaids.add(areaModel.getProvinceId());
                areaids.add(areaModel.getCityId());
                areaids.add(areaModel.getAreaId());
            } else if (areaModel.getLevel().intValue() == 4) {
                areaids.add(areaModel.getProvinceId());
                areaids.add(areaModel.getCityId());
                areaids.add(areaModel.getAreaId());
                areaids.add(areaModel.getStreetId());
            }
        }
        Collections.reverse(areaids);
        List<Long> allGradeSetAreaId = this.getAllGradeSetAreaId();
        HashSet<Long> allGradeSetAreaIdSet = new HashSet<Long>(allGradeSetAreaId);
        if (CollectionUtils.isNotEmpty(allGradeSetAreaIdSet)) {
            for (Long areaid : areaids) {
                if (!allGradeSetAreaIdSet.contains(areaid)) continue;
                return areaid;
            }
        }
        return -1L;
    }

    public List<Long> getAllGradeSetAreaId() {
        return this.gradeKeysetMapper.getAllGradeSetAreaId();
    }
}

