/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.company.impl;

import cn.smarthse.common.framework.beans.OssClientBean;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.provider.sms.ISMSProviderWelinkService;
import cn.smarthse.modules.health.bind.entity.SysUserBindLog;
import cn.smarthse.modules.health.bind.enums.UserBindLogTypeEnum;
import cn.smarthse.modules.health.bind.service.ISysUserBindLogService;
import cn.smarthse.modules.health.bind.service.ISysUserBindService;
import cn.smarthse.modules.health.supervise.dao.company.ContactRebindAppealMapper;
import cn.smarthse.modules.health.supervise.entity.contactRebindAppeal.ContactRebindAppeal;
import cn.smarthse.modules.health.supervise.entity.contactRebindAppeal.ContactRebindAppealParam;
import cn.smarthse.modules.health.supervise.entity.contactRebindAppeal.UpdateBindInfoParam;
import cn.smarthse.modules.health.supervise.service.company.IContactRebindAppealService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import jakarta.annotation.Resource;
import java.util.List;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@DubboService
@Transactional(readOnly=true)
public class ContactRebindAppealServiceImpl
extends BaseServiceImpl<ContactRebindAppealMapper, ContactRebindAppeal>
implements IContactRebindAppealService {
    private static final String update_bind_success_template = "\u3010\u6d59\u6c5f\u7701\u75be\u63a7\u5c40\u3011\u60a8\u7533\u8bf7\u7684\u624b\u673a\u53f7\u6362\u7ed1\u5df2\u901a\u8fc7\uff0c\u8bf7\u53ca\u65f6\u767b\u5f55\u201c\u6d59\u91cc\u536b\u4f01\u5e94\u7528\u201d\u8fdb\u884c\u9a8c\u8bc1\u3002";
    private static final String update_bind_fail_template = "\u3010\u6d59\u6c5f\u7701\u75be\u63a7\u5c40\u3011\u60a8\u7533\u8bf7\u7684\u624b\u673a\u53f7\u6362\u7ed1\u56e0\u201c\u63d0\u4ea4\u7684\u300a\u624b\u673a\u53f7\u6362\u7ed1\u6388\u6743\u59d4\u6258\u4e66\u300b\u4e0d\u7b26\u5408\u8981\u6c42\u201d\u672a\u901a\u8fc7\uff0c\u8bf7\u91cd\u65b0\u63d0\u4ea4\u3002";
    @Autowired
    OssClientBean ossClientBean;
    @DubboReference
    private ISysUserBindService sysUserBindService;
    @DubboReference
    private ISMSProviderWelinkService smsProvider;
    @DubboReference
    private ISysUserBindLogService sysUserBindLogService;
    @Resource
    private ContactRebindAppealMapper contactRebindAppealMapper;

    @Transactional
    public ResponseData<Object> changeAuditStatus(Long currentId, UpdateBindInfoParam record) {
        ContactRebindAppeal contactRebindAppeal = (ContactRebindAppeal)((ContactRebindAppealMapper)this.dao).selectByPrimaryKey(record.getContactRebindAppealId());
        if (contactRebindAppeal == null) {
            throw new HealthException("\u672a\u627e\u5230\u7533\u8bf7\u4fe1\u606f\uff0c\u8bf7\u91cd\u8bd5!");
        }
        SysUserBindLog sysUserBindLog = new SysUserBindLog();
        sysUserBindLog.setUserId(contactRebindAppeal.getUserId());
        sysUserBindLog.setId(Long.valueOf(this.idworker.nextId()));
        sysUserBindLog.setCid(contactRebindAppeal.getCid());
        sysUserBindLog.setAuditState(record.getAuditState());
        sysUserBindLog.setBindName(contactRebindAppeal.getNewContactName());
        sysUserBindLog.setSystemSource(Integer.valueOf(contactRebindAppeal.getSystemWide().byteValue()));
        sysUserBindLog.setBindTel(contactRebindAppeal.getNewContactPhone());
        if (record.getAuditState() == 1) {
            sysUserBindLog.setType(UserBindLogTypeEnum.APPEAL_PASS.getValue());
        } else if (record.getAuditState() == 2) {
            sysUserBindLog.setType(UserBindLogTypeEnum.APPEAL_NOPASS.getValue());
        }
        sysUserBindLog.setCreateBy(currentId);
        sysUserBindLog.setEvidenceId(contactRebindAppeal.getEvidenceId());
        sysUserBindLog.setCreateBy(currentId);
        sysUserBindLog.setUpdateBy(currentId);
        this.sysUserBindLogService.insertLog(sysUserBindLog);
        if (record.getAuditState() == 2) {
            ((ContactRebindAppealMapper)this.dao).changeAuditStatus(record.getContactRebindAppealId(), record.getAuditState());
            this.smsProvider.singleSendSms(contactRebindAppeal.getNewContactPhone(), update_bind_fail_template);
            return ResponseData.success((String)"\u7533\u8bf7\u9000\u56de\u6210\u529f");
        }
        if (!((ContactRebindAppealMapper)this.dao).changeAuditStatus(record.getContactRebindAppealId(), record.getAuditState())) {
            throw new HealthException("\u6362\u7ed1\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5!");
        }
        this.sysUserBindService.updateBindInfo(contactRebindAppeal.getCid(), contactRebindAppeal.getNewContactName(), contactRebindAppeal.getNewContactPhone(), contactRebindAppeal.getCurrentContactName(), contactRebindAppeal.getCurrentContactPhone());
        this.smsProvider.singleSendSms(contactRebindAppeal.getNewContactPhone(), update_bind_success_template);
        this.logger.info("\u804c\u4e1a\u5065\u5eb7==\u300b \u624b\u673a\u6362\u7ed1\u7533\u8bf7\u6210\u529f\uff0c\u6362\u7ed1\u624b\u673a{}", (Object)contactRebindAppeal.getNewContactPhone());
        return ResponseData.success((String)"\u7533\u8bf7\u901a\u8fc7\u6210\u529f");
    }

    @Transactional
    public void changeBindInfo(ContactRebindAppeal contactRebindAppeal) {
        ((ContactRebindAppealMapper)this.dao).changeBindInfo(contactRebindAppeal);
    }

    public PageInfo<ContactRebindAppeal> selectContactRebindAppealVo(JqGridParam jqGridParam, ContactRebindAppealParam param) {
        PageHelper.startPage((int)jqGridParam.getPage(), (int)jqGridParam.getRows());
        List<ContactRebindAppeal> data = ((ContactRebindAppealMapper)this.dao).selectContactRebindAppeal(param);
        data.forEach(x -> x.setFullOssUrl(this.ossClientBean.getUrl(x.getOssUrl())));
        return new PageInfo(data);
    }

    public List<ContactRebindAppeal> getByCid(Long cid) {
        Example example = new Example(ContactRebindAppeal.class);
        example.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)1).andEqualTo("auditStatus", (Object)0);
        return ((ContactRebindAppealMapper)this.dao).selectByExample(example);
    }
}

