/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.company.impl;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.health.supervise.dao.company.CompanyMapper;
import cn.smarthse.modules.health.supervise.dao.company.SuCompanyMapper;
import cn.smarthse.modules.health.supervise.entity.check.SupervisePhcPhysicalCheckCompanyInfo;
import cn.smarthse.modules.health.supervise.entity.company.CompanyIndusInfoCount;
import cn.smarthse.modules.health.supervise.entity.company.CompanyRisk;
import cn.smarthse.modules.health.supervise.entity.company.SuCompany;
import cn.smarthse.modules.health.supervise.entity.hcchekplan.HcCheckComp;
import cn.smarthse.modules.health.supervise.entity.trainPlan.TrainPlanCompanyInfo;
import cn.smarthse.modules.health.supervise.enums.company.CompanyRiskLevelEnum;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationUserService;
import cn.smarthse.modules.health.supervise.service.check.ISupervisePhcPhysicalCheckService;
import cn.smarthse.modules.health.supervise.service.company.ICompanyRiskService;
import cn.smarthse.modules.health.supervise.service.company.ICompanyService;
import cn.smarthse.modules.health.supervise.service.company.IThirdCompanyService;
import cn.smarthse.modules.health.supervise.service.evaluate.IThirdEvaluateService;
import cn.smarthse.modules.health.supervise.service.harmFactorDeclare.IDeclareInfoService;
import cn.smarthse.modules.health.supervise.service.hccheckplan.IHcCheckPlanCompService;
import cn.smarthse.modules.health.supervise.service.sys.ISuperSysParamService;
import cn.smarthse.modules.health.supervise.service.sys.ISuperviseSysAreaService;
import cn.smarthse.modules.health.supervise.service.trainPlan.ISuperviseTrainPlanService;
import cn.smarthse.modules.health.supervise.vo.company.CompanyCollectListVo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="superviseCompanyServiceImpl")
@DubboService
@Transactional(readOnly=true)
public class CompanyServiceImpl
extends BaseServiceImpl<CompanyMapper, Company>
implements ICompanyService {
    @Autowired
    public CompanyMapper companyMapper;
    @Autowired
    public ISuperviseSysAreaService sysAreaService;
    @Autowired
    private ISuperSysParamService sysParamService;
    @DubboReference
    IThirdCompanyService thirdCompanyService;
    @DubboReference
    private IThirdEvaluateService thirdEvaluateService;
    @DubboReference
    private IHcCheckPlanCompService hcCheckPlanCompService;
    @DubboReference
    private ISuperviseTrainPlanService superviseTrainPlanService;
    @DubboReference
    private IDeclareInfoService declareInfoService;
    @DubboReference
    private ISupervisePhcPhysicalCheckService supervisePhcPhysicalCheckService;
    @Autowired
    public SuCompanyMapper suCompanyMapper;
    @Autowired
    private IOrganizationUserService organizationUserService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @Autowired
    public ICompanyRiskService companyRiskService;

    public Company getById(Long id, boolean getBaseInfo) {
        CompanySuperviseModel baseInfoModel = this.companyProvideBySuperviseService.getCompanyInfoById(id);
        if (baseInfoModel != null) {
            Company company = new Company();
            BeanUtils.copyProperties((Object)baseInfoModel, (Object)company);
            return company;
        }
        return null;
    }

    @Override
    public Company getById(Long id) {
        if (id == null) {
            return null;
        }
        return (Company)this.thirdCompanyService.getById(id);
    }

    private List<Long> getIds(List<Company> list) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Long> idList = new ArrayList<Long>();
        for (Company c : list) {
            idList.add(c.getId());
        }
        return idList;
    }

    public Company getCompanyByUnifiedSocialCc(String unifiedSocialCc) {
        if (StringUtils.isBlank((CharSequence)unifiedSocialCc)) {
            return null;
        }
        Example e = new Example(Company.class);
        e.createCriteria().andEqualTo("unifiedSocialCc", (Object)unifiedSocialCc).andEqualTo("isValid", (Object)true);
        return (Company)this.getOneByExample(e);
    }

    public Map<String, Object> collectCompanyInfo(Long cid) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        int thisYear = DateUtils.getThisYear();
        String thisYearTrainStr = this.superviseTrainPlanService.getTrainSummInfoByCidAndYear(cid, Integer.valueOf(thisYear));
        String lastYearTrainStr = this.superviseTrainPlanService.getTrainSummInfoByCidAndYear(cid, Integer.valueOf(thisYear - 1));
        data.put("thisYearTrainStr", thisYearTrainStr);
        data.put("lastYearTrainStr", lastYearTrainStr);
        String thisYearDecStr = this.declareInfoService.getDeclareSumInfoByCidAndYear(cid, Integer.valueOf(thisYear));
        String lastYearDecStr = this.declareInfoService.getDeclareSumInfoByCidAndYear(cid, Integer.valueOf(thisYear - 1));
        data.put("thisYearDecStr", thisYearDecStr);
        data.put("lastYearDecStr", lastYearDecStr);
        String thisYearEvaluateCountStr = this.thirdEvaluateService.collectFinishEvaluateStr(cid, thisYear);
        String lastYearEvaluateCountStr = this.thirdEvaluateService.collectFinishEvaluateStr(cid, thisYear - 1);
        data.put("thisYearEvaluateCountStr", thisYearEvaluateCountStr);
        data.put("lastYearEvaluateCountStr", lastYearEvaluateCountStr);
        String thisYearThirdTimeCountStr = this.thirdEvaluateService.collectFinishThirdTimeStr(cid, thisYear);
        String lastYearThirdTimeCountStr = this.thirdEvaluateService.collectFinishThirdTimeStr(cid, thisYear - 1);
        data.put("thisYearThirdTimeCountStr", thisYearThirdTimeCountStr);
        data.put("lastYearThirdTimeCountStr", lastYearThirdTimeCountStr);
        String thisYearPhcCheckInfo = this.supervisePhcPhysicalCheckService.countYearCheckInfoResult(Integer.valueOf(thisYear), cid);
        String lastYearPhcCheckInfo = this.supervisePhcPhysicalCheckService.countYearCheckInfoResult(Integer.valueOf(thisYear - 1), cid);
        data.put("thisYearPhcCheckInfo", thisYearPhcCheckInfo);
        data.put("lastYearPhcCheckInfo", lastYearPhcCheckInfo);
        return data;
    }

    private List<CompanyCollectListVo> setUpData(List<SupervisePhcPhysicalCheckCompanyInfo> checkCompanyList, List<HcCheckComp> hcCheckCompList, List<TrainPlanCompanyInfo> expireMainCompanyList, List<TrainPlanCompanyInfo> expireHseCompanyList, List<CompanyRisk> cRiskList) {
        CompanyCollectListVo cvo;
        ArrayList<CompanyCollectListVo> companyCollectVoList = new ArrayList<CompanyCollectListVo>();
        if (checkCompanyList != null && !checkCompanyList.isEmpty()) {
            for (SupervisePhcPhysicalCheckCompanyInfo supervisePhcPhysicalCheckCompanyInfo : checkCompanyList) {
                cvo = new CompanyCollectListVo();
                cvo.setCid(supervisePhcPhysicalCheckCompanyInfo.getCid());
                cvo.setSource(Integer.valueOf(1));
                cvo.setExpirationTime(supervisePhcPhysicalCheckCompanyInfo.getExpirationTime());
                companyCollectVoList.add(cvo);
            }
        }
        if (hcCheckCompList != null && !hcCheckCompList.isEmpty()) {
            for (HcCheckComp hcCheckComp : hcCheckCompList) {
                cvo = new CompanyCollectListVo();
                cvo.setCid(hcCheckComp.getCid());
                cvo.setSource(Integer.valueOf(2));
                cvo.setExpirationTime(hcCheckComp.getExpiryTime());
                companyCollectVoList.add(cvo);
            }
        }
        if (expireMainCompanyList != null && !expireMainCompanyList.isEmpty()) {
            for (TrainPlanCompanyInfo trainPlanCompanyInfo : expireMainCompanyList) {
                cvo = new CompanyCollectListVo();
                cvo.setCid(trainPlanCompanyInfo.getCid());
                cvo.setSource(Integer.valueOf(3));
                cvo.setExpirationTime(trainPlanCompanyInfo.getExpirationTime());
                companyCollectVoList.add(cvo);
            }
        }
        if (expireHseCompanyList != null && !expireHseCompanyList.isEmpty()) {
            for (TrainPlanCompanyInfo trainPlanCompanyInfo : expireHseCompanyList) {
                cvo = new CompanyCollectListVo();
                cvo.setCid(trainPlanCompanyInfo.getCid());
                cvo.setSource(Integer.valueOf(4));
                cvo.setExpirationTime(trainPlanCompanyInfo.getExpirationTime());
                companyCollectVoList.add(cvo);
            }
        }
        if (cRiskList != null && !cRiskList.isEmpty()) {
            for (CompanyRisk companyRisk : cRiskList) {
                cvo = new CompanyCollectListVo();
                cvo.setCid(companyRisk.getCid());
                cvo.setSource(Integer.valueOf(5));
                cvo.setExpirationTime(companyRisk.getEvaluateTime());
                companyCollectVoList.add(cvo);
            }
        }
        return companyCollectVoList;
    }

    public int syncCompanyRiskLevel(Long smarthseCid, CompanyRiskLevelEnum companyRiskLevel) {
        if (smarthseCid == null || companyRiskLevel == null) {
            return 0;
        }
        Example e = new Example(SuCompany.class);
        e.createCriteria().andEqualTo("smarthseCid", (Object)smarthseCid).andEqualTo("isValid", (Object)true);
        SuCompany result = new SuCompany();
        result.setOccupationalRiskClassify(companyRiskLevel.getValue());
        return this.suCompanyMapper.updateByExampleSelective(result, e);
    }

    public int countCompanyNumByAreaId(Long areaId, Byte levle, Byte isOwnLevel) {
        if (areaId == null) {
            return 0;
        }
        return this.thirdCompanyService.countCompanyNumByAreaId(areaId, levle, isOwnLevel);
    }

    public List<CompanyIndusInfoCount> collectCompanyMajorIndu(Long areaId) {
        return this.thirdCompanyService.collectCompanyMajorInduGroup(areaId);
    }

    public List<Long> getAllCompanyIdList() {
        return this.companyMapper.selectAllId();
    }

    public String queryChooseMapSpliceAreaName(Long chooseMapAreaId) throws Exception {
        if (chooseMapAreaId == null || chooseMapAreaId == 0L) {
            return "\u56fd\u5bb6";
        }
        String chooseMapAreaName = this.suCompanyMapper.queryChooseMapSpliceAreaName(chooseMapAreaId);
        return org.apache.commons.lang3.StringUtils.isBlank((CharSequence)chooseMapAreaName) ? "\u56fd\u5bb6" : chooseMapAreaName;
    }
}

