/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.company.impl;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.health.supervise.dao.company.CompanyRiskMapper;
import cn.smarthse.modules.health.supervise.entity.company.CompanyRisk;
import cn.smarthse.modules.health.supervise.service.company.ICompanyRiskFilesService;
import cn.smarthse.modules.health.supervise.service.company.ICompanyRiskService;
import cn.smarthse.modules.health.supervise.service.company.ICompanyService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@DubboService
@Transactional(readOnly=true)
public class CompanyRiskServiceImpl
extends BaseServiceImpl<CompanyRiskMapper, CompanyRisk>
implements ICompanyRiskService {
    @Autowired
    ICompanyRiskFilesService fileService;
    @Autowired
    ICompanyService companyService;

    @Transactional(readOnly=false)
    public CompanyRisk insertOrUpdate(CompanyRisk risk, Long createOrUpdateBy, String[] fileIds) {
        if (risk.getId() == null) {
            this.add(risk, createOrUpdateBy, risk.getCid());
        } else {
            this.update(risk, createOrUpdateBy);
        }
        this.fileService.addByRisk(risk, fileIds);
        return risk;
    }

    public CompanyRisk getDetailById(Long id) {
        CompanyRisk risk = ((CompanyRiskMapper)this.dao).getDetailById(id);
        this.setFilesByRisk(risk);
        this.setCompanyName(risk);
        return risk;
    }

    private void setCompanyName(CompanyRisk risk) {
        if (risk == null || risk.getCid() == null) {
            return;
        }
        Company company = (Company)this.companyService.getById(risk.getCid());
        if (company != null) {
            risk.setCompanyName(company.getName());
        }
    }

    public PageInfo<CompanyRisk> page(JqGridParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<CompanyRisk> list = this.list(param.getCid());
        PageInfo page = new PageInfo(list);
        return page;
    }

    public List<CompanyRisk> list(Long cid) {
        if (cid == null) {
            return null;
        }
        List<CompanyRisk> list = ((CompanyRiskMapper)this.dao).list(cid);
        if (list == null || list.isEmpty()) {
            return list;
        }
        for (CompanyRisk r : list) {
            this.setFilesByRisk(r);
        }
        return list;
    }

    public List<CompanyRisk> listAllLastCompanyRisk() {
        return ((CompanyRiskMapper)this.dao).listAllLastCompanyRisk();
    }

    private void setFilesByRisk(CompanyRisk r) {
        List files = this.fileService.getByRiskId(r.getId());
        r.setFiles(files);
    }

    public CompanyRisk getLastRisk(Long cid) {
        List<CompanyRisk> list = this.list(cid);
        return list == null || list.isEmpty() ? null : list.get(0);
    }
}

