/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.company.impl;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.supervise.dao.company.CompanyRiskFilesMapper;
import cn.smarthse.modules.health.supervise.entity.company.CompanyRisk;
import cn.smarthse.modules.health.supervise.entity.company.CompanyRiskFiles;
import cn.smarthse.modules.health.supervise.service.company.ICompanyRiskFilesService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@DubboService
@Transactional(readOnly=true)
public class CompanyRiskFilesServiceImpl
extends BaseServiceImpl<CompanyRiskFilesMapper, CompanyRiskFiles>
implements ICompanyRiskFilesService {
    @Transactional(readOnly=false)
    public void deleteByRiskId(Long riskId) {
        if (riskId == null) {
            return;
        }
        Example example = new Example(CompanyRiskFiles.class);
        example.createCriteria().andEqualTo("riskId", (Object)riskId);
        ((CompanyRiskFilesMapper)this.dao).deleteByExample(example);
    }

    @Transactional(readOnly=false)
    public void addByRisk(CompanyRisk risk, String[] fileIds) {
        if (risk == null) {
            return;
        }
        Long riskId = risk.getId();
        this.deleteByRiskId(riskId);
        if (fileIds == null || fileIds.length == 0) {
            return;
        }
        for (String fileId : fileIds) {
            if (StringUtils.isEmpty((CharSequence)fileId)) continue;
            CompanyRiskFiles file = new CompanyRiskFiles();
            file.setFileId(Long.valueOf(fileId));
            file.setRiskId(riskId);
            this.add(file, risk.getUpdateBy(), risk.getCid());
        }
    }

    public List<CompanyRiskFiles> getByRiskId(Long riskId) {
        return ((CompanyRiskFilesMapper)this.dao).getByRiskId(riskId);
    }
}

