/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.company.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.excel.ExcelUtil;
import cn.smarthse.modules.datacentre.enums.CompanyBelongTypeEnum;
import cn.smarthse.modules.datacentre.enums.CompanyBusinessState;
import cn.smarthse.modules.datacentre.enums.CompanyDataSourceEnum;
import cn.smarthse.modules.datacentre.enums.CompanyIsDecCurrentYearEnum;
import cn.smarthse.modules.datacentre.enums.CompanyIsDecEnum;
import cn.smarthse.modules.datacentre.enums.CompanyIsReportForImportEnum;
import cn.smarthse.modules.datacentre.enums.CompanyIsSuperviseEnum;
import cn.smarthse.modules.datacentre.enums.SysParamGroupEnum;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.system.IndustryModel;
import cn.smarthse.modules.datacentre.model.system.SysParamModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.provider.system.ISysParamProvideService;
import cn.smarthse.modules.datacentre.provider.system.IndustryProvideService;
import cn.smarthse.modules.health.enums.company.CompanySizeEnum;
import cn.smarthse.modules.health.supervise.entity.basic.Organization;
import cn.smarthse.modules.health.supervise.entity.sys.SysArea;
import cn.smarthse.modules.health.supervise.model.CreateUserModel;
import cn.smarthse.modules.health.supervise.model.company.CompanyImportModel;
import cn.smarthse.modules.health.supervise.service.company.ICompanyFunOrgService;
import cn.smarthse.modules.health.supervise.service.company.ICompanyImportService;
import cn.smarthse.modules.health.supervise.service.projectTrain.ITrainProjReportService;
import cn.smarthse.modules.health.supervise.service.sys.ISysUserThirdService;
import cn.smarthse.modules.platform.model.AreaModel;
import java.io.InputStream;
import java.lang.constant.Constable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="companyImportServiceImpl")
@DubboService
@Transactional(readOnly=true)
public class CompanyImportServiceImpl
implements ICompanyImportService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompanyImportServiceImpl.class);
    public static final String EXCEL_ERROR_DATA = "excel_error_data";
    public static final String EXCEL_DATA = "excel_data";
    @DubboReference
    private ICompanyFunOrgService companyFunOrgService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @DubboReference(version="1.0.0")
    private ISysParamProvideService dcParamService;
    @DubboReference(version="1.0.0")
    private IndustryProvideService industryProvideService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @DubboReference
    private ITrainProjReportService trainProjReportService;
    @DubboReference
    private ISysUserThirdService sysUserThirdService;

    private boolean isRowEmpty(Row row) {
        for (Cell cell : row) {
            if (cell.getCellType() == CellType.BLANK) continue;
            return false;
        }
        return true;
    }

    private ResponseData<List<CompanyImportModel>> checkCompanyfromExcel(Sheet sheet, Organization org) {
        ResponseData data = new ResponseData();
        LinkedList<CompanyImportModel> companyImportList = new LinkedList<CompanyImportModel>();
        int cellnum = 21;
        List registerTypeParamModelList = this.dcParamService.getSysParamListByChildren(cn.smarthse.modules.health.enums.sysParam.SysParamGroupEnum.register_type.getValue());
        List industryList = this.industryProvideService.getIndustryList();
        Map<String, Long> registerTypeMap = registerTypeParamModelList.stream().collect(Collectors.toMap(SysParamModel::getParamValue, SysParamModel::getId, (v1, v2) -> v1));
        Map<String, Long> industryMap = industryList.stream().collect(Collectors.toMap(IndustryModel::getName, IndustryModel::getId, (v1, v2) -> v1));
        Map areaNameMap = this.sysAreaProvideService.getAreaNameMap();
        Iterator iter = sheet.rowIterator();
        while (iter.hasNext()) {
            Comparable<Boolean> codeByName;
            Constable valueByName;
            Row row = (Row)iter.next();
            int rowIndex = row.getRowNum() + 1;
            if (rowIndex == 1 || rowIndex == 2 || rowIndex == 3 || this.isRowEmpty(row) || row.getZeroHeight()) continue;
            CompanyImportModel importModel = new CompanyImportModel();
            importModel.setCompanyType(Integer.valueOf(1));
            importModel.setIsReliable(Boolean.valueOf(false));
            importModel.setPickupCount(null);
            boolean thisRowIsNull = true;
            for (int i = 0; i <= cellnum; ++i) {
                if (this.validCellIsBlank(row.getCell(i))) continue;
                thisRowIsNull = false;
            }
            if (thisRowIsNull) continue;
            importModel.setExcelAddress("\u884c\u53f7\uff1a" + rowIndex);
            if (this.validCellIsBlank(row.getCell(0))) {
                this.setErrorReason(importModel, "\u4f01\u4e1a\u540d\u79f0\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
                data.setState(ResponseStateEnum.fail);
            } else {
                row.getCell(0).setCellType(CellType.STRING);
                String company = StrUtil.trim((CharSequence)row.getCell(0).getStringCellValue());
                importModel.setName(company);
            }
            if (this.validCellIsBlank(row.getCell(1))) {
                this.setErrorReason(importModel, "\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
                data.setState(ResponseStateEnum.fail);
            } else {
                row.getCell(1).setCellType(CellType.STRING);
                String unifiedSocialCc = StrUtil.trim((CharSequence)row.getCell(1).getStringCellValue());
                importModel.setUnifiedSocialCc(unifiedSocialCc);
                if (StringUtils.isNotBlank((CharSequence)unifiedSocialCc) && unifiedSocialCc.length() != 18) {
                    this.setErrorReason(importModel, "\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u683c\u5f0f\u4e0d\u6b63\u786e");
                    data.setState(ResponseStateEnum.fail);
                }
            }
            if (this.validCellIsBlank(row.getCell(2))) {
                this.setErrorReason(importModel, "\u6240\u5728\u884c\u653f\u533a\u5212\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
                data.setState(ResponseStateEnum.fail);
            } else {
                row.getCell(2).setCellType(CellType.STRING);
                String areaName = StrUtil.trim((CharSequence)row.getCell(2).getStringCellValue());
                importModel.setAreaName(areaName);
                AreaModel areaModel = this.getAreaModelFromMap(areaNameMap, areaName);
                if (areaModel == null) {
                    this.setErrorReason(importModel, "\u201c\u6240\u5728\u884c\u653f\u533a\u5212\u201d\u5185\u5bb9\u4e0d\u6b63\u786e\u6216\u4e0d\u5b8c\u6574");
                    data.setState(ResponseStateEnum.fail);
                } else {
                    SysArea authArea = org.getSysArea();
                    if (authArea != null) {
                        authArea.setAreaId(areaModel.getId());
                        boolean auth = this.sysAreaProvideService.containAuthArea(areaModel.getId(), authArea.getId());
                        if (!auth) {
                            this.setErrorReason(importModel, "\u4e0d\u5728\u76d1\u7ba1\u8303\u56f4\u5185");
                            data.setState(ResponseStateEnum.fail);
                        }
                    }
                    importModel.setAreaId(areaModel.getId());
                }
            }
            if (!this.validCellIsBlank(row.getCell(3))) {
                row.getCell(3).setCellType(CellType.STRING);
                String company = StrUtil.trim((CharSequence)row.getCell(3).getStringCellValue());
                importModel.setWorkAddress(company);
            }
            if (this.validCellIsBlank(row.getCell(4))) {
                this.setErrorReason(importModel, "\u662f\u5426\u76f4\u5c5e\u4f01\u4e1a\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
                data.setState(ResponseStateEnum.fail);
            } else {
                row.getCell(4).setCellType(CellType.STRING);
                String company = StrUtil.trim((CharSequence)row.getCell(4).getStringCellValue());
                valueByName = CompanyBelongTypeEnum.getValueByName((String)company);
                if (valueByName != null) {
                    importModel.setBelongType(valueByName);
                } else {
                    this.setErrorReason(importModel, "\u76f4\u5c5e\u4f01\u4e1a\u7c7b\u578b\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728");
                    data.setState(ResponseStateEnum.fail);
                }
            }
            if (this.validCellIsBlank(row.getCell(5))) {
                this.setErrorReason(importModel, "\u662f\u5426\u5206\u7c7b\u5bf9\u8c61\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
                data.setState(ResponseStateEnum.fail);
            } else {
                row.getCell(5).setCellType(CellType.STRING);
                String company = StrUtil.trim((CharSequence)row.getCell(5).getStringCellValue());
                codeByName = CompanyIsDecEnum.getCodeByName((String)company);
                if (codeByName != null) {
                    importModel.setIsDec((Boolean)codeByName);
                } else {
                    this.setErrorReason(importModel, "\u5206\u7c7b\u5bf9\u8c61\u7c7b\u578b\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728");
                    data.setState(ResponseStateEnum.fail);
                }
            }
            if (this.validCellIsBlank(row.getCell(6))) {
                this.setErrorReason(importModel, "\u662f\u5426\u5f53\u5e74\u5206\u7c7b\u5bf9\u8c61\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
                data.setState(ResponseStateEnum.fail);
            } else {
                row.getCell(6).setCellType(CellType.STRING);
                String company = StrUtil.trim((CharSequence)row.getCell(6).getStringCellValue());
                codeByName = CompanyIsDecCurrentYearEnum.getCodeByName((String)company);
                if (codeByName != null) {
                    importModel.setIsDecCurrentYear((Boolean)codeByName);
                } else {
                    this.setErrorReason(importModel, "\u5f53\u5e74\u5206\u7c7b\u5bf9\u8c61\u7c7b\u578b\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728");
                    data.setState(ResponseStateEnum.fail);
                }
            }
            if (this.validCellIsBlank(row.getCell(7))) {
                this.setErrorReason(importModel, "\u662f\u5426\u5df2\u7533\u62a5\u4f01\u4e1a\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
                data.setState(ResponseStateEnum.fail);
            } else {
                row.getCell(7).setCellType(CellType.STRING);
                String company = StrUtil.trim((CharSequence)row.getCell(7).getStringCellValue());
                valueByName = CompanyIsReportForImportEnum.getValueByName((String)company);
                if (valueByName != null) {
                    importModel.setIsReport((Boolean)valueByName);
                } else {
                    this.setErrorReason(importModel, "\u7533\u62a5\u4f01\u4e1a\u7c7b\u578b\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728");
                    data.setState(ResponseStateEnum.fail);
                }
            }
            if (this.validCellIsBlank(row.getCell(8))) {
                this.setErrorReason(importModel, "\u662f\u5426\u76d1\u7763\u5bf9\u8c61\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
                data.setState(ResponseStateEnum.fail);
            } else {
                row.getCell(8).setCellType(CellType.STRING);
                String company = StrUtil.trim((CharSequence)row.getCell(8).getStringCellValue());
                codeByName = CompanyIsSuperviseEnum.getCodeByName((String)company);
                if (codeByName != null) {
                    importModel.setIsSupervise((Boolean)codeByName);
                } else {
                    this.setErrorReason(importModel, "\u76d1\u7763\u5bf9\u8c61\u7c7b\u578b\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728");
                    data.setState(ResponseStateEnum.fail);
                }
            }
            if (!this.validCellIsBlank(row.getCell(9))) {
                row.getCell(9).setCellType(CellType.STRING);
                String company = StrUtil.trim((CharSequence)row.getCell(9).getStringCellValue());
                importModel.setRegisterAddress(company);
            }
            if (!this.validCellIsBlank(row.getCell(10))) {
                row.getCell(10).setCellType(CellType.STRING);
                String company = StrUtil.trim((CharSequence)row.getCell(10).getStringCellValue());
                importModel.setScaleName(company);
                Byte scale = CompanySizeEnum.getCodeByName((String)company);
                if (scale != null) {
                    importModel.setScale("" + scale);
                } else {
                    this.setErrorReason(importModel, "\u4f01\u4e1a\u89c4\u6a21\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728");
                    data.setState(ResponseStateEnum.fail);
                }
            }
            if (!this.validCellIsBlank(row.getCell(11))) {
                row.getCell(11).setCellType(CellType.STRING);
                String company = StrUtil.trim((CharSequence)row.getCell(11).getStringCellValue());
                importModel.setRegisterTypeName(company);
                if (registerTypeMap.containsKey(company)) {
                    importModel.setRegisterType(registerTypeMap.get(company));
                } else {
                    this.setErrorReason(importModel, "\u7ecf\u6d4e\u7c7b\u578b\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728");
                    data.setState(ResponseStateEnum.fail);
                }
            }
            if (!this.validCellIsBlank(row.getCell(12))) {
                row.getCell(12).setCellType(CellType.STRING);
                String company = StrUtil.trim((CharSequence)StrUtil.trim((CharSequence)row.getCell(12).getStringCellValue()));
                importModel.setIndustryCategoryName(company);
                if (industryMap.containsKey(company)) {
                    importModel.setIndustryCategory(industryMap.get(company));
                } else {
                    this.setErrorReason(importModel, "\u6240\u5c5e\u884c\u4e1a\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728");
                    data.setState(ResponseStateEnum.fail);
                }
            }
            if (!this.validCellIsBlank(row.getCell(13))) {
                row.getCell(13).setCellType(CellType.STRING);
                String company = StrUtil.trim((CharSequence)row.getCell(13).getStringCellValue());
                importModel.setLegalName(company);
            }
            if (!this.validCellIsBlank(row.getCell(14))) {
                row.getCell(14).setCellType(CellType.STRING);
                String company = StrUtil.trim((CharSequence)row.getCell(14).getStringCellValue());
                importModel.setLegalTel(company);
            }
            if (!this.validCellIsBlank(row.getCell(15))) {
                row.getCell(15).setCellType(CellType.STRING);
                String company = StringEscapeUtils.unescapeHtml((String)StrUtil.trim((CharSequence)row.getCell(15).getStringCellValue()));
                importModel.setMainLeaderName(company);
            }
            if (!this.validCellIsBlank(row.getCell(16))) {
                row.getCell(16).setCellType(CellType.STRING);
                String company = StrUtil.trim((CharSequence)row.getCell(16).getStringCellValue());
                importModel.setMainLeaderTel(company);
            }
            if (!this.validCellIsBlank(row.getCell(17))) {
                row.getCell(17).setCellType(CellType.STRING);
                String company = StrUtil.trim((CharSequence)row.getCell(17).getStringCellValue());
                codeByName = CompanyBusinessState.getCodeByName((String)company);
                if (codeByName != null) {
                    importModel.setBusinessState(Byte.valueOf(((Integer)codeByName).byteValue()));
                } else {
                    this.setErrorReason(importModel, "\u8425\u4e1a\u72b6\u6001\u7c7b\u578b\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728");
                    data.setState(ResponseStateEnum.fail);
                }
            }
            if (!this.validCellIsBlank(row.getCell(18))) {
                row.getCell(18).setCellType(CellType.STRING);
                String company = StringEscapeUtils.unescapeHtml((String)StrUtil.trim((CharSequence)row.getCell(18).getStringCellValue()));
                importModel.setOccManagerName(company);
            }
            if (!this.validCellIsBlank(row.getCell(19))) {
                row.getCell(19).setCellType(CellType.STRING);
                String company = StrUtil.trim((CharSequence)row.getCell(19).getStringCellValue());
                importModel.setOccManagerTel(company);
            }
            if (!this.validCellIsBlank(row.getCell(20))) {
                row.getCell(20).setCellType(CellType.STRING);
                String company = StrUtil.trim((CharSequence)row.getCell(20).getStringCellValue());
                importModel.setDataSourceId(company);
            }
            if (!this.validCellIsBlank(row.getCell(21))) {
                row.getCell(21).setCellType(CellType.STRING);
                String company = StrUtil.trim((CharSequence)row.getCell(21).getStringCellValue());
                importModel.setDataSource(CompanyDataSourceEnum.getValue((String)company));
            }
            companyImportList.add(importModel);
        }
        if (!companyImportList.isEmpty()) {
            HashMap<CallSite, CompanyImportModel> map = new HashMap<CallSite, CompanyImportModel>();
            for (CompanyImportModel model : companyImportList) {
                String key = model.getName() + "name";
                if (map.containsKey(key)) {
                    this.setErrorReason(model, "\u91cd\u590d\u6570\u636e");
                    this.setErrorReason((CompanyImportModel)map.get(key), "\u91cd\u590d\u6570\u636e");
                    data.setState(ResponseStateEnum.fail);
                    continue;
                }
                map.put((CallSite)((Object)key), model);
            }
            data.setResult(companyImportList);
        }
        return data;
    }

    private AreaModel getAreaModelFromMap(Map<String, AreaModel> areaNameMap, String areaName) {
        if (StringUtils.isNotBlank((CharSequence)areaName)) {
            areaName = StringUtils.replace((String)areaName, (String)"\u300b", (String)"");
            areaName = StringUtils.replace((String)areaName, (String)">", (String)"");
            areaName = StringUtils.replace((String)areaName, (String)"\uff1e", (String)"");
            return areaNameMap.get(areaName);
        }
        return null;
    }

    private ResponseData<List<CompanyImportModel>> checkCompanyOutpackfromExcel(Sheet sheet, Organization org) {
        int rowIndex = 0;
        ResponseData data = new ResponseData();
        ArrayList<CompanyImportModel> companyImportList = new ArrayList<CompanyImportModel>();
        int cellnum = 10;
        List registerTypeParamModelList = this.dcParamService.getSysParamListByChildren(cn.smarthse.modules.health.enums.sysParam.SysParamGroupEnum.register_type.getValue());
        List nationalParamModelList = this.dcParamService.getSysParamListByChildren(cn.smarthse.modules.health.enums.sysParam.SysParamGroupEnum.national_econ_type.getValue());
        Map areaNameMap = this.sysAreaProvideService.getAreaNameMap();
        Iterator iter = sheet.rowIterator();
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            rowIndex = row.getRowNum() + 1;
            if (rowIndex == 1 || rowIndex == 2 || rowIndex == 3) continue;
            CompanyImportModel importModel = new CompanyImportModel();
            importModel.setCompanyType(Integer.valueOf(2));
            boolean thisRowIsNull = true;
            for (int i = 0; i <= cellnum; ++i) {
                if (this.validCellIsBlank(row.getCell(i))) continue;
                thisRowIsNull = false;
            }
            if (thisRowIsNull) continue;
            importModel.setExcelAddress("\u884c\u53f7\uff1a" + rowIndex);
            companyImportList.add(importModel);
            if (this.validCellIsBlank(row.getCell(0))) {
                this.setErrorReason(importModel, "\u4f01\u4e1a\u540d\u79f0\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
                data.setState(ResponseStateEnum.fail);
            } else {
                row.getCell(0).setCellType(CellType.STRING);
                String company = row.getCell(0).getStringCellValue().trim();
                importModel.setName(company);
            }
            if (this.validCellIsBlank(row.getCell(1))) {
                this.setErrorReason(importModel, "\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
                data.setState(ResponseStateEnum.fail);
            } else {
                row.getCell(1).setCellType(CellType.STRING);
                String unifiedSocialCc = row.getCell(1).getStringCellValue().trim();
                importModel.setUnifiedSocialCc(unifiedSocialCc);
                if (StringUtils.isNotBlank((CharSequence)unifiedSocialCc) && unifiedSocialCc.length() != 18) {
                    this.setErrorReason(importModel, "\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u683c\u5f0f\u4e0d\u6b63\u786e");
                    data.setState(ResponseStateEnum.fail);
                }
            }
            if (this.validCellIsBlank(row.getCell(2))) {
                this.setErrorReason(importModel, "\u6240\u5728\u884c\u653f\u533a\u5212\u4e3a\u5fc5\u586b\u9879\u4e0d\u80fd\u4e3a\u7a7a");
                data.setState(ResponseStateEnum.fail);
            } else {
                row.getCell(2).setCellType(CellType.STRING);
                String areaName = row.getCell(2).getStringCellValue().trim();
                importModel.setAreaName(areaName);
                AreaModel areaModel = this.getAreaModelFromMap(areaNameMap, areaName);
                if (areaModel == null) {
                    this.setErrorReason(importModel, "\u201c\u6240\u5728\u884c\u653f\u533a\u5212\u201d\u5185\u5bb9\u4e0d\u6b63\u786e\u6216\u4e0d\u5b8c\u6574");
                    data.setState(ResponseStateEnum.fail);
                } else {
                    importModel.setAreaId(areaModel.getId());
                }
            }
            if (!this.validCellIsBlank(row.getCell(3))) {
                row.getCell(3).setCellType(CellType.STRING);
                String company = row.getCell(3).getStringCellValue().trim();
                importModel.setCompanyPostalAdress(company);
            }
            if (!this.validCellIsBlank(row.getCell(4))) {
                row.getCell(4).setCellType(CellType.STRING);
                String company = row.getCell(4).getStringCellValue().trim();
                importModel.setRegisterAddress(company);
            }
            if (!this.validCellIsBlank(row.getCell(5))) {
                row.getCell(5).setCellType(CellType.STRING);
                String company = row.getCell(5).getStringCellValue().trim();
                importModel.setCompanyContactTel(company);
            }
            if (!this.validCellIsBlank(row.getCell(6))) {
                row.getCell(6).setCellType(CellType.STRING);
                String company = row.getCell(6).getStringCellValue().trim();
                importModel.setRegisterTypeName(company);
                registerTypeParamModelList.forEach(model -> {
                    if (model.getParamValue().equals(company)) {
                        importModel.setRegisterType(model.getId());
                    }
                });
                if (importModel.getRegisterType() == null) {
                    this.setErrorReason(importModel, "\u7ecf\u6d4e\u7c7b\u578b\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728");
                    data.setState(ResponseStateEnum.fail);
                }
            }
            if (!this.validCellIsBlank(row.getCell(7))) {
                row.getCell(7).setCellType(CellType.STRING);
                String company = row.getCell(7).getStringCellValue().trim();
                importModel.setIndustryCategoryName(company);
                nationalParamModelList.forEach(model -> {
                    if (model.getParamValue().equals(company)) {
                        importModel.setIndustryCategory(model.getId());
                    }
                });
                if (importModel.getIndustryCategory() == null) {
                    this.setErrorReason(importModel, "\u6240\u5c5e\u884c\u4e1a\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728");
                    data.setState(ResponseStateEnum.fail);
                }
            }
            if (!this.validCellIsBlank(row.getCell(8))) {
                row.getCell(8).setCellType(CellType.STRING);
                String company = StringEscapeUtils.unescapeHtml((String)row.getCell(8).getStringCellValue().trim());
                importModel.setLegalName(company);
            }
            if (this.validCellIsBlank(row.getCell(9))) continue;
            row.getCell(9).setCellType(CellType.STRING);
            String company = row.getCell(9).getStringCellValue().trim();
            importModel.setLegalTel(company);
        }
        if (!companyImportList.isEmpty()) {
            HashMap<CallSite, CompanyImportModel> map = new HashMap<CallSite, CompanyImportModel>();
            for (CompanyImportModel model2 : companyImportList) {
                String key = model2.getName() + "name";
                String code = model2.getUnifiedSocialCc() + "code";
                if (map.containsKey(key)) {
                    this.setErrorReason(model2, "\u91cd\u590d\u6570\u636e");
                    this.setErrorReason((CompanyImportModel)map.get(key), "\u91cd\u590d\u6570\u636e");
                    data.setState(ResponseStateEnum.fail);
                } else {
                    map.put((CallSite)((Object)key), model2);
                }
                if (map.containsKey(code)) {
                    this.setErrorReason(model2, "\u91cd\u590d\u6570\u636e");
                    this.setErrorReason((CompanyImportModel)map.get(code), "\u91cd\u590d\u6570\u636e");
                    data.setState(ResponseStateEnum.fail);
                    continue;
                }
                map.put((CallSite)((Object)code), model2);
            }
            data.setResult(companyImportList);
        }
        return data;
    }

    private void checkUnifiedSocialCc(Map<String, List<CompanySuperviseModel>> companySuperviseModelMap, ResponseData<List<CompanyImportModel>> companyImportModelResData, Integer companyType) {
        List companyImportModelList = (List)companyImportModelResData.getResult();
        if (CollUtil.isNotEmpty((Collection)companyImportModelList)) {
            block0: for (CompanyImportModel companyImportModel : companyImportModelList) {
                List<CompanySuperviseModel> dbcompanyList = companySuperviseModelMap.get(companyImportModel.getName() + companyType);
                if (!CollUtil.isNotEmpty(dbcompanyList)) continue;
                for (CompanySuperviseModel dbcompanySuperviseModel : dbcompanyList) {
                    if (StringUtils.isNotBlank((CharSequence)dbcompanySuperviseModel.getUnifiedSocialCc()) && !StringUtils.equalsIgnoreCase((CharSequence)dbcompanySuperviseModel.getUnifiedSocialCc(), (CharSequence)companyImportModel.getUnifiedSocialCc())) {
                        this.setErrorReason(companyImportModel, "\u201c\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u201d\u5185\u5bb9\u4e0d\u6b63\u786e");
                        companyImportModelResData.setState(ResponseStateEnum.fail);
                        continue block0;
                    }
                    this.setErrorReason(companyImportModel, "\u7cfb\u7edf\u5df2\u7ecf\u5b58\u5728\u8be5\u540d\u5b57\u7684\u4f01\u4e1a");
                    companyImportModelResData.setState(ResponseStateEnum.fail);
                }
            }
        }
    }

    @Transactional
    public ResponseData<Map<String, List<CompanyImportModel>>> importCompanyListForExcel(String ossfile, Organization org, Integer companyType, Long loginStaffId, String createUser) throws Exception {
        ResponseData<List<CompanyImportModel>> data;
        Workbook wb = WorkbookFactory.create((InputStream)ExcelUtil.getInstance().getOssInputStream(ossfile));
        Sheet sheet = wb.getSheetAt(0);
        ResponseData<List<CompanyImportModel>> checkData = companyType == 1 ? this.checkCompanyfromExcel(sheet, org) : this.checkCompanyOutpackfromExcel(sheet, org);
        ResponseData resultData = new ResponseData();
        List excelCompanyList = (List)checkData.getResult();
        if (CollUtil.isEmpty((Collection)excelCompanyList)) {
            resultData.setState(ResponseStateEnum.success);
            resultData.setContent("\u65e0\u6570\u636e\u5bfc\u5165");
            return resultData;
        }
        Set companyNameSet = excelCompanyList.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getName())).map(CompanyImportModel::getName).collect(Collectors.toSet());
        List modelList = this.companyProvideBySuperviseService.getCompanyAndCompanySuperviseByNameExcludeDelete(new ArrayList(companyNameSet));
        HashMap<String, List<CompanySuperviseModel>> companySuperviseModelMap = new HashMap();
        if (CollUtil.isNotEmpty((Collection)modelList)) {
            companySuperviseModelMap = modelList.stream().collect(Collectors.groupingBy(k -> k.getName() + k.getCompanyType()));
        }
        Set companyUnitCodeSet = excelCompanyList.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getUnifiedSocialCc())).map(CompanyImportModel::getUnifiedSocialCc).collect(Collectors.toSet());
        List unifiedCcModelList = this.companyProvideBySuperviseService.getCompanyAndCompanySuperviseByUnitCode(new ArrayList(companyUnitCodeSet));
        Map<Object, Object> unifiedCcCompanySuperviseModelMap = new HashMap();
        if (CollUtil.isNotEmpty((Collection)unifiedCcModelList)) {
            unifiedCcCompanySuperviseModelMap = unifiedCcModelList.stream().collect(Collectors.groupingBy(k -> k.getUnifiedSocialCc() + k.getCompanyType()));
        }
        this.checkUnifiedSocialCc(companySuperviseModelMap, checkData, companyType);
        if (checkData.getState().equals(ResponseStateEnum.fail)) {
            Map<String, List<CompanyImportModel>> resultMap = this.suCompanyList2ErrorMap(excelCompanyList);
            resultData.setResult(resultMap);
            resultData.setState(ResponseStateEnum.fail);
            return resultData;
        }
        HashMap<String, List> map = new HashMap<String, List>();
        LinkedList<CompanyImportModel> updateList = new LinkedList<CompanyImportModel>();
        LinkedList<CompanyImportModel> comfirmList = new LinkedList<CompanyImportModel>();
        LinkedList<CompanyImportModel> addList = new LinkedList<CompanyImportModel>();
        LinkedList<CompanyImportModel> otherCompanyTypeList = new LinkedList<CompanyImportModel>();
        LinkedList<CompanyImportModel> codeRepeatList = new LinkedList<CompanyImportModel>();
        HashMap<String, CompanyImportModel> codeRepeatMap = new HashMap<String, CompanyImportModel>();
        for (CompanyImportModel excelsuc : excelCompanyList) {
            String unifiedCcKey;
            List unifiedSocialCccompanyList;
            CompanySuperviseModel dbCompany;
            List companyList = (List)companySuperviseModelMap.get(excelsuc.getName() + companyType);
            if (CollUtil.isNotEmpty((Collection)companyList) && (StringUtils.isBlank((CharSequence)(dbCompany = (CompanySuperviseModel)companyList.get(0)).getUnifiedSocialCc()) || StringUtils.equals((CharSequence)dbCompany.getUnifiedSocialCc(), (CharSequence)excelsuc.getUnifiedSocialCc())) && StringUtils.equals((CharSequence)("" + dbCompany.getAreaId()), (CharSequence)("" + excelsuc.getAreaId()))) {
                excelsuc.setId(dbCompany.getId());
                excelsuc.setIsValid(dbCompany.getIsValid());
                updateList.add(excelsuc);
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)excelsuc.getUnifiedSocialCc()) && CollUtil.isNotEmpty((Collection)(unifiedSocialCccompanyList = (List)unifiedCcCompanySuperviseModelMap.get(unifiedCcKey = excelsuc.getUnifiedSocialCc() + companyType)))) {
                comfirmList.add(excelsuc);
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)excelsuc.getUnifiedSocialCc()) && StringUtils.isNotBlank((CharSequence)excelsuc.getName())) {
                List unifiedSocialCccompanyList2;
                List companyList2;
                int companyTypeTemp = 1;
                if (companyType == 1) {
                    companyTypeTemp = 2;
                }
                if (CollUtil.isNotEmpty((Collection)(companyList2 = (List)companySuperviseModelMap.get(excelsuc.getName() + companyTypeTemp))) && CollUtil.isNotEmpty(unifiedSocialCccompanyList2 = companyList2.stream().filter(f -> excelsuc.getUnifiedSocialCc().equals(f.getUnifiedSocialCc())).collect(Collectors.toList()))) {
                    otherCompanyTypeList.add(excelsuc);
                    continue;
                }
            }
            if (codeRepeatMap.containsKey(excelsuc.getUnifiedSocialCc())) {
                codeRepeatList.add(excelsuc);
                codeRepeatList.add((CompanyImportModel)codeRepeatMap.get(excelsuc.getUnifiedSocialCc()));
            } else {
                codeRepeatMap.put(excelsuc.getUnifiedSocialCc(), excelsuc);
            }
            addList.add(excelsuc);
        }
        if (!addList.isEmpty() && addList.size() != excelCompanyList.size()) {
            data = this.import2Db(addList, org, loginStaffId, createUser);
            map.put(EXCEL_DATA, (List)data.getResult());
        }
        if (!updateList.isEmpty()) {
            resultData.setContent("\u60c5\u51b52");
            map.put(EXCEL_ERROR_DATA, updateList);
            resultData.setResult(map);
            resultData.setState(ResponseStateEnum.warning);
            return resultData;
        }
        if (!comfirmList.isEmpty()) {
            resultData.setContent("\u60c5\u51b53");
            map.put(EXCEL_ERROR_DATA, comfirmList);
            resultData.setResult(map);
            resultData.setState(ResponseStateEnum.warning);
            return resultData;
        }
        if (!otherCompanyTypeList.isEmpty()) {
            resultData.setContent("\u60c5\u51b54");
            map.put(EXCEL_ERROR_DATA, otherCompanyTypeList);
            resultData.setResult(map);
            resultData.setState(ResponseStateEnum.warning);
            return resultData;
        }
        if (!codeRepeatList.isEmpty()) {
            resultData.setContent("\u60c5\u51b55");
            map.put(EXCEL_ERROR_DATA, codeRepeatList);
            resultData.setResult(map);
            resultData.setState(ResponseStateEnum.warning);
            return resultData;
        }
        data = this.import2Db(excelCompanyList, org, loginStaffId, createUser);
        map.put(EXCEL_DATA, (List)data.getResult());
        resultData.setResult(map);
        resultData.setState(ResponseStateEnum.success);
        resultData.setContent("\u5bfc\u5165\u6210\u529f");
        return resultData;
    }

    private Map<String, List<CompanyImportModel>> suCompanyList2ErrorMap(List<CompanyImportModel> companyList) {
        if (companyList != null && !companyList.isEmpty()) {
            HashMap<String, List<CompanyImportModel>> map = new HashMap<String, List<CompanyImportModel>>();
            for (CompanyImportModel suc : companyList) {
                List sucList;
                if (StringUtils.isNotBlank((CharSequence)suc.getErrorReason())) {
                    sucList = (ArrayList)map.get(EXCEL_ERROR_DATA);
                    if (sucList == null) {
                        sucList = new ArrayList();
                        map.put(EXCEL_ERROR_DATA, sucList);
                    }
                    ((List)map.get(EXCEL_ERROR_DATA)).add(suc);
                    continue;
                }
                sucList = (List)map.get(EXCEL_DATA);
                if (sucList == null) {
                    sucList = new ArrayList();
                    map.put(EXCEL_DATA, sucList);
                }
                ((List)map.get(EXCEL_DATA)).add(suc);
            }
            return map;
        }
        return null;
    }

    @Transactional
    public ResponseData<List<CompanyImportModel>> import2Db(List<CompanyImportModel> companyList, Organization org, Long loginStaffId, String createUser) {
        ResponseData responseData = new ResponseData();
        responseData.setState(ResponseStateEnum.success);
        if (CollUtil.isNotEmpty(companyList)) {
            ArrayList<CompanyImportModel> successList = new ArrayList<CompanyImportModel>(companyList.size());
            ArrayList<CreateUserModel> createUserModelList = new ArrayList<CreateUserModel>(companyList.size());
            try {
                for (CompanyImportModel suc : companyList) {
                    CompanySuperviseModel c = new CompanySuperviseModel();
                    BeanUtils.copyProperties((Object)suc, (Object)c);
                    c.setInsertCompanyType(Byte.valueOf((byte)2));
                    c = this.companyProvideBySuperviseService.saveImportCompany(c, loginStaffId);
                    suc.setId(c.getId());
                    successList.add(suc);
                    if (!Objects.equals(createUser, "1")) continue;
                    CreateUserModel createUserModel = new CreateUserModel();
                    createUserModel.setCid(c.getId());
                    createUserModel.setUsername(c.getName());
                    createUserModel.setPassword("Zyj@2022");
                    createUserModel.setCreateBy(loginStaffId);
                    createUserModelList.add(createUserModel);
                }
            }
            catch (Exception e) {
                throw new RuntimeException();
            }
            finally {
                if (CollUtil.isNotEmpty(createUserModelList)) {
                    this.sysUserThirdService.create(createUserModelList);
                }
                responseData.setResult(successList);
            }
        } else {
            responseData.setContent("\u65e0\u6570\u636e\u5bfc\u5165");
        }
        return responseData;
    }

    private List<CompanySuperviseModel> convertOutpackSuperviseModel(List<Map<Integer, String>> mapList, List<String> errList) {
        if (CollectionUtils.isNotEmpty(mapList)) {
            ArrayList<CompanySuperviseModel> companySuperviseModelList = new ArrayList<CompanySuperviseModel>();
            for (Map<Integer, String> mapData : mapList) {
                String industryCategory;
                String errorInfo = "";
                CompanySuperviseModel companySuperviseModel = new CompanySuperviseModel();
                companySuperviseModel.setId(MapUtils.getLong(mapData, (Object)0));
                companySuperviseModel.setName(MapUtils.getString(mapData, (Object)1));
                companySuperviseModel.setUnifiedSocialCc(MapUtils.getString(mapData, (Object)2));
                String detailAreaName = MapUtils.getString(mapData, (Object)3);
                if (StringUtils.isNotBlank((CharSequence)detailAreaName)) {
                    AreaModel areaByName = this.sysAreaProvideService.getAreaByName(detailAreaName);
                    if (areaByName != null) {
                        companySuperviseModel.setAreaId(areaByName.getId());
                    } else {
                        errorInfo = CommonUtil.distinctAppendStr((String)errorInfo, (String)"\u884c\u653f\u533a\u5212\u5730\u5740\u4e0d\u6b63\u786e", (String)",");
                    }
                }
                companySuperviseModel.setWorkAddress(MapUtils.getString(mapData, (Object)4));
                companySuperviseModel.setRegisterAddress(MapUtils.getString(mapData, (Object)5));
                companySuperviseModel.setCompanyContactTel(MapUtils.getString(mapData, (Object)6));
                String registerType = MapUtils.getString(mapData, (Object)7);
                if (StringUtils.isNotBlank((CharSequence)registerType)) {
                    SysParamModel sysParamByName = this.dcParamService.getSysParamByName(registerType, null, SysParamGroupEnum.register_type);
                    if (sysParamByName != null) {
                        companySuperviseModel.setRegisterType(sysParamByName.getId());
                    } else {
                        errorInfo = CommonUtil.distinctAppendStr((String)errorInfo, (String)"\u7ecf\u6d4e\u7c7b\u578b\u586b\u5199\u9519\u8bef", (String)",");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)(industryCategory = MapUtils.getString(mapData, (Object)8)))) {
                    SysParamModel sysParamByName = this.dcParamService.getSysParamByName(industryCategory, null, SysParamGroupEnum.national_econ_type);
                    if (sysParamByName != null) {
                        companySuperviseModel.setIndustryCategory(sysParamByName.getId());
                    } else {
                        errorInfo = CommonUtil.distinctAppendStr((String)errorInfo, (String)"\u6240\u5c5e\u884c\u4e1a\u586b\u5199\u9519\u8bef", (String)",");
                    }
                }
                companySuperviseModel.setLegalName(MapUtils.getString(mapData, (Object)9));
                companySuperviseModel.setLegalTel(MapUtils.getString(mapData, (Object)10));
                companySuperviseModelList.add(companySuperviseModel);
            }
            return companySuperviseModelList;
        }
        return null;
    }

    private String getExcelColName(int index) {
        if (index <= 26) {
            return String.valueOf((char)(65 + index - 1));
        }
        int a = index / 26;
        int b = index % 26;
        return String.valueOf((char)(65 + a - 1)) + String.valueOf((char)(65 + b - 1));
    }

    private boolean validCellIsBlank(Cell cell) {
        if (cell == null) {
            return true;
        }
        if (cell.getCellType() == CellType.BLANK) {
            return true;
        }
        cell.setCellType(CellType.STRING);
        return StringUtils.isBlank((CharSequence)cell.getStringCellValue().trim());
    }

    private void setErrorReason(CompanyImportModel model, String content) {
        if (StringUtils.isNotBlank((CharSequence)model.getErrorReason())) {
            String errorReason = model.getErrorReason();
            if (errorReason.indexOf(content) == -1) {
                model.setErrorReason(model.getErrorReason() + "," + content);
            }
        } else {
            model.setErrorReason(content);
        }
    }
}

