/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.company.impl;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.supervise.dao.company.AbnormalComIgnoreMapper;
import cn.smarthse.modules.health.supervise.entity.company.AbnormalComIgnore;
import cn.smarthse.modules.health.supervise.service.company.IAbnormalComIgnoreService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@DubboService
public class AbnormalComIgnoreServiceImpl
extends BaseServiceImpl<AbnormalComIgnoreMapper, AbnormalComIgnore>
implements IAbnormalComIgnoreService {
    @Transactional(readOnly=false)
    public synchronized void insertOrUpdate(AbnormalComIgnore abnormalComIgnore) {
        AbnormalComIgnore old = this.getByUserAndCom(abnormalComIgnore.getLoginUserId(), abnormalComIgnore.getComType(), abnormalComIgnore.getComId());
        if (old != null) {
            old.setAbnormalMsg(abnormalComIgnore.getAbnormalMsg());
            old.setIsDelete(abnormalComIgnore.getIsDelete());
            old.setUpdateDate(new Date());
            ((AbnormalComIgnoreMapper)this.dao).updateByPrimaryKey(old);
            return;
        }
        ((AbnormalComIgnoreMapper)this.dao).insert(abnormalComIgnore);
    }

    public List<Long> getDeletedComIds(Long loginUserId) {
        return ((AbnormalComIgnoreMapper)this.dao).getDeletedComIds(loginUserId);
    }

    public List<Long> getIgnoreNotIncludeDeletedComIds(Long loginUserId) {
        return ((AbnormalComIgnoreMapper)this.dao).getIgnoreNotIncludeDeletedComIds(loginUserId);
    }

    public List<Long> getAllByUserId(Long loginUserId) {
        return ((AbnormalComIgnoreMapper)this.dao).getAllByUserId(loginUserId);
    }

    public PageInfo<AbnormalComIgnore> getByUser(JqGridParam param, AbnormalComIgnore abnormalComIgnore) {
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        Example example = new Example(AbnormalComIgnore.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("isValid", (Object)true).andEqualTo("loginUserId", (Object)abnormalComIgnore.getLoginUserId()).andEqualTo("isDelete", (Object)false);
        if (abnormalComIgnore.getName() != null && !abnormalComIgnore.getName().isEmpty()) {
            criteria.andLike("name", "%" + abnormalComIgnore.getName() + "%");
        }
        if (abnormalComIgnore.getAbnormalMsg() != null && !abnormalComIgnore.getAbnormalMsg().isEmpty()) {
            criteria.andEqualTo("abnormalMsg", (Object)abnormalComIgnore.getAbnormalMsg());
        }
        List list = ((AbnormalComIgnoreMapper)this.dao).selectByExample(example);
        return new PageInfo(list);
    }

    @Transactional(readOnly=false)
    public void noIgnore(Long userId, Long comId, Integer comType) {
        AbnormalComIgnore com = this.getByUserAndCom(userId, comType, comId);
        if (com != null) {
            com.setIsValid(Boolean.valueOf(false));
            com.setUpdateBy(userId);
            com.setUpdateDate(new Date());
            ((AbnormalComIgnoreMapper)this.dao).updateByPrimaryKey(com);
        }
    }

    @Transactional(readOnly=false)
    public void multiInsertOrUpdate(List<AbnormalComIgnore> abnormalComIgnoreList) {
        for (AbnormalComIgnore ignore : abnormalComIgnoreList) {
            this.insertOrUpdate(ignore);
        }
    }

    @Transactional(readOnly=false)
    public void multiNoIgnore(List<AbnormalComIgnore> abnormalComList) {
        for (AbnormalComIgnore abnormalComIgnore : abnormalComList) {
            this.noIgnore(abnormalComIgnore.getLoginUserId(), abnormalComIgnore.getComId(), abnormalComIgnore.getComType());
        }
    }

    public List<AbnormalComIgnore> getAllByUser(Long userId) {
        Example example = new Example(AbnormalComIgnore.class);
        example.createCriteria().andEqualTo("loginUserId", (Object)userId).andEqualTo("isValid", (Object)true);
        return this.getListByExample(example);
    }

    private AbnormalComIgnore getByUserAndCom(Long userId, Integer comType, Long comId) {
        Example example = new Example(AbnormalComIgnore.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("isValid", (Object)true).andEqualTo("loginUserId", (Object)userId).andEqualTo("comType", (Object)comType).andEqualTo("comId", (Object)comId);
        List list = ((AbnormalComIgnoreMapper)this.dao).selectByExample(example);
        return list != null && !list.isEmpty() ? (AbnormalComIgnore)list.get(0) : null;
    }
}

