/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.check.impl;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.health.supervise.entity.check.CheckParam;
import cn.smarthse.modules.health.supervise.entity.check.PhcCompanyDieaserInfo;
import cn.smarthse.modules.health.supervise.entity.check.PhcCompanySdInfo;
import cn.smarthse.modules.health.supervise.entity.check.PhcPhysicalQueryCheckInfo;
import cn.smarthse.modules.health.supervise.entity.check.PhcYearCheckInfo;
import cn.smarthse.modules.health.supervise.entity.check.SupervisePhcPhysicalCheckCompanyInfo;
import cn.smarthse.modules.health.supervise.service.check.ICheckService;
import cn.smarthse.modules.health.supervise.service.check.ISupervisePhcPhysicalCheckService;
import cn.smarthse.modules.health.supervise.service.company.ICompanyService;
import cn.smarthse.modules.health.supervise.vo.company.CompanySearchVo;
import com.github.pagehelper.PageInfo;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="checkServiceImpl")
@DubboService
@Transactional(readOnly=true)
public class CheckServiceImpl
implements ICheckService {
    @DubboReference
    ISupervisePhcPhysicalCheckService checkService;
    @Autowired
    ICompanyService companyService;

    private void megerCheckInfo(List<Company> list, Map<Long, SupervisePhcPhysicalCheckCompanyInfo> checkCompanyMap) {
        if (list == null || list.size() == 0) {
            return;
        }
        for (Company c : list) {
            Long l = c.getId();
        }
    }

    private CheckParam getParamByCompanySearchVo(CompanySearchVo companySearchVo) {
        CheckParam checkParam = new CheckParam();
        checkParam.setBeginTime(companySearchVo.getBeginTime());
        checkParam.setEndTime(companySearchVo.getEndTime());
        return checkParam;
    }

    private List<Long> getCompanyIds(List<SupervisePhcPhysicalCheckCompanyInfo> companies, Map<Long, SupervisePhcPhysicalCheckCompanyInfo> checkCompanyMap) {
        ArrayList<Long> cids = new ArrayList<Long>();
        if (companies == null) {
            return cids;
        }
        for (SupervisePhcPhysicalCheckCompanyInfo c : companies) {
            Long cid = c.getCid();
            if (!cids.contains(cid)) {
                cids.add(cid);
            }
            if (checkCompanyMap == null) continue;
            checkCompanyMap.put(cid, c);
        }
        return cids;
    }

    public PageInfo<PhcPhysicalQueryCheckInfo> queryCheckPage(JqGridParam gparam, Long cid, Integer yearFlag) {
        return this.checkService.queryCheckPage(gparam, cid, yearFlag);
    }

    public PageInfo<PhcPhysicalQueryCheckInfo> queryCheckPage(JqGridParam gparam, Long cid, Integer yearFlag, Byte type) {
        return this.checkService.queryCheckPage(gparam, cid, yearFlag, type);
    }

    public List<PhcPhysicalQueryCheckInfo> queryCheckList(Long cid) {
        return this.checkService.queryCheckList(cid);
    }

    public PhcYearCheckInfo countYearCheckInfo(Integer year, Long cid) {
        return this.checkService.countYearCheckInfo(year, cid);
    }

    private CompanySearchVo cloneCompanyParam(CompanySearchVo companySearchVo) {
        CompanySearchVo companyParam = null;
        try {
            companyParam = (CompanySearchVo)BeanUtils.cloneBean((Object)companySearchVo);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            companyParam = companySearchVo;
        }
        return companyParam;
    }

    public PageInfo<PhcCompanyDieaserInfo> companyCheckSdInfos(JqGridParam param, Long cid, Integer examResult, Integer yearFlag) {
        return this.checkService.companyCheckSdInfos(param, cid, examResult, false, yearFlag);
    }

    public PageInfo<PhcCompanyDieaserInfo> companyCheckOdInfos(JqGridParam param, Long cid, Byte diagnosedType, Long areaId, Byte areaLevel) {
        return this.checkService.companyCheckOdInfos(param, cid, diagnosedType, areaId, areaLevel);
    }

    public PageInfo<PhcCompanyDieaserInfo> checkSdInfos(JqGridParam param, CheckParam checkParam) {
        return this.checkService.checkSdInfos(param, checkParam);
    }

    public PhcCompanySdInfo getSdInfo(Long id) {
        return this.checkService.getSdInfo(id);
    }

    public PhcCompanySdInfo getOccInfo(Long id) {
        return this.checkService.getOccInfo(id);
    }
}

