/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.check.impl;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.supervise.entity.check.CheckCountInfo;
import cn.smarthse.modules.health.supervise.entity.check.CheckCountParam;
import cn.smarthse.modules.health.supervise.entity.company.CompanyCollectModel;
import cn.smarthse.modules.health.supervise.entity.harmFactorDeclare.HarmFactorDeclareCompanyInfo;
import cn.smarthse.modules.health.supervise.service.check.ICheckCountService;
import cn.smarthse.modules.health.supervise.service.check.ISuperviseCheckThirdHomeService;
import cn.smarthse.modules.health.supervise.service.check.ISupervisePhcPhysicalCheckService;
import cn.smarthse.modules.health.supervise.service.company.ICompanyService;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="checkCountServiceImpl")
@DubboService
@Transactional(readOnly=true)
public class CheckCountServiceImpl
implements ICheckCountService {
    @DubboReference
    ISupervisePhcPhysicalCheckService checkService;
    @Autowired
    ICompanyService companyService;
    @DubboReference
    ISuperviseCheckThirdHomeService superviseCheckThirdHomeService;

    private CompanyCollectModel getCompaniesInfo(List<CompanyCollectModel> list) {
        CompanyCollectModel total = new CompanyCollectModel();
        total.setName("\u5408\u8ba1\uff1a");
        if (list == null || list.size() == 0) {
            return total;
        }
        for (CompanyCollectModel data : list) {
            String cidString = data.getCids();
            if (StringUtils.isEmpty((CharSequence)cidString)) continue;
            List<Long> cids = CheckCountServiceImpl.parseToLongList(cidString, ",");
            this.setDataInfo(data, cids);
            this.countTotalInfo(total, data);
        }
        return total;
    }

    private void setDataInfo(CompanyCollectModel data, List<Long> cids) {
        if (cids == null || cids.size() == 0) {
            return;
        }
        data.setCidArray(cids);
        data.setHarm(this.checkService.getSuperviseStaffInfoCountByCids(cids));
        data.setSure(this.checkService.getSureCountByCompanyIds(cids));
        data.setSuspected(this.checkService.getSuspectedCountByCompanyIds(cids));
        data.setChecked(this.checkService.getHcCheckPlanRegularCountByCids(cids));
        HarmFactorDeclareCompanyInfo declareInfo = this.checkService.getHarmFactorDeclareCompanyInfo(cids);
        data.setDeclare(Integer.valueOf(declareInfo == null ? 0 : declareInfo.getDeclareNum()));
    }

    private void countTotalInfo(CompanyCollectModel total, CompanyCollectModel data) {
        total.setCompanyNum(this.add(total.getCompanyNum(), data.getCompanyNum()));
        total.setHarm(this.add(total.getHarm(), data.getHarm()));
        total.setSuspected(this.add(total.getSuspected(), data.getSuspected()));
        total.setSure(this.add(total.getSure(), data.getSure()));
        total.setDeclare(this.add(total.getDeclare(), data.getDeclare()));
        total.setChecked(this.add(total.getChecked(), data.getChecked()));
    }

    private Integer add(Integer int1, Integer int2) {
        return (int1 == null ? 0 : int1) + (int2 == null ? 0 : int2);
    }

    public static List<Long> parseToLongList(String str, String spliter) {
        ArrayList<Long> longList = new ArrayList<Long>();
        if (StringUtils.isNotEmpty((String)str)) {
            String[] arr;
            for (String a : arr = str.split(spliter)) {
                if (StringUtils.isEmpty((CharSequence)a)) continue;
                longList.add(Long.parseLong(a));
            }
        }
        return longList;
    }

    public CheckCountInfo collectCompanyGroupFromThirdCount(CheckCountParam checkCountParam) {
        CheckCountInfo count = this.checkService.companyCheckInfoCount(checkCountParam);
        count = count == null ? new CheckCountInfo() : count;
        count.setName("\u5408\u8ba1");
        return count;
    }

    public PageInfo<CheckCountInfo> collectCompanyGroupFromThirdPage(JqGridParam param, CheckCountParam checkCountParam) {
        PageInfo page = this.checkService.companyCheckInfos(param, checkCountParam);
        return page;
    }

    public List<CheckCountInfo> collectCompanyGroupFromThirdList(CheckCountParam checkCountParam) {
        return this.checkService.companyCheckInfoList(checkCountParam);
    }
}

