/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.basic;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.PhoneUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.excel.ExcelUtils;
import cn.smarthse.modules.health.supervise.enums.sys.OrganizationTypeEnum;
import cn.smarthse.modules.health.supervise.model.sys.v3.organization.OrganizationUserV3ImportListParam;
import cn.smarthse.modules.health.supervise.model.sys.v3.township.TownshipUserImportDto;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationService;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationUserService;
import cn.smarthse.modules.health.supervise.vo.sys.v3.organization.OrganizationUserV3ImportListVo;
import cn.smarthse.modules.health.supervise.vo.sys.v3.organization.OrganizationV3OneVo;
import cn.smarthse.modules.platform.model.AreaModel;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.HealthException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SysTownshipUserImportListener
extends AnalysisEventListener<TownshipUserImportDto> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SysTownshipUserImportListener.class);
    private static final int BATCH_COUNT = 3000;
    private final Long loginUserId;
    private final ISysAreaProvideService sysAreaProvideService;
    private final IOrganizationService organizationService;
    private final IOrganizationUserService organizationUserService;
    private final List<TownshipUserImportDto> dataList = new ArrayList<TownshipUserImportDto>();
    private final List<TownshipUserImportDto> errDataList = new ArrayList<TownshipUserImportDto>();
    private final List<Long> idList = new ArrayList<Long>();
    private int dataCount = 0;

    public SysTownshipUserImportListener(Long loginUserId, ISysAreaProvideService sysAreaProvideService, IOrganizationService organizationService, IOrganizationUserService organizationUserService) {
        this.loginUserId = loginUserId;
        this.sysAreaProvideService = sysAreaProvideService;
        this.organizationService = organizationService;
        this.organizationUserService = organizationUserService;
    }

    public void invoke(TownshipUserImportDto dto, AnalysisContext context) {
        int rowIndex = context.readRowHolder().getRowIndex() + 1;
        log.debug("\u89e3\u6790\u5230\u4e00\u6761\u6570\u636e\uff0c\u884c\u53f7: {} {}", (Object)rowIndex, (Object)dto);
        dto.setDetailAreaName(StrUtil.trimToEmpty((CharSequence)dto.getDetailAreaName()));
        dto.setUsername(StrUtil.toUpperCase((CharSequence)StrUtil.trimToEmpty((CharSequence)dto.getUsername())));
        dto.setFullName(StrUtil.trimToEmpty((CharSequence)dto.getFullName()));
        dto.setTel(StrUtil.trimToEmpty((CharSequence)dto.getTel()));
        dto.setDepartment(StrUtil.trimToEmpty((CharSequence)dto.getDepartment()));
        dto.setPost(StrUtil.trimToEmpty((CharSequence)dto.getPost()));
        if (StrUtil.isBlank((CharSequence)dto.getDetailAreaName())) {
            dto.setHaveError(Boolean.TRUE);
            dto.setErrorReason(dto.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u6240\u5728\u884c\u653f\u533a\u5212\u4e3a\u5fc5\u586b\u9879\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", ExcelUtils.getExcelColName((int)1)));
        }
        if (StrUtil.isBlank((CharSequence)dto.getUsername())) {
            dto.setHaveError(Boolean.TRUE);
            dto.setErrorReason(dto.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u7528\u6237\u540d\u4e3a\u5fc5\u586b\u9879\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", ExcelUtils.getExcelColName((int)2)));
        }
        if (StrUtil.isBlank((CharSequence)dto.getFullName())) {
            dto.setHaveError(Boolean.TRUE);
            dto.setErrorReason(dto.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u59d3\u540d\u4e3a\u5fc5\u586b\u9879\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", ExcelUtils.getExcelColName((int)3)));
        }
        if (Objects.isNull(dto.getTel())) {
            dto.setHaveError(Boolean.TRUE);
            dto.setErrorReason(dto.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u624b\u673a\u53f7\u4e3a\u5fc5\u586b\u9879\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", ExcelUtils.getExcelColName((int)4)));
        } else if (!PhoneUtil.isMobile((CharSequence)dto.getTel())) {
            dto.setHaveError(Boolean.TRUE);
            dto.setErrorReason(dto.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01", ExcelUtils.getExcelColName((int)4)));
        }
        dto.setId(Long.valueOf(IdWorker.getId()));
        dto.setRowIndex(Integer.valueOf(rowIndex));
        ++this.dataCount;
        if (Boolean.TRUE.equals(dto.getHaveError())) {
            this.errDataList.add(dto);
        } else {
            this.dataList.add(dto);
        }
        if (this.dataCount >= 3000) {
            this.saveData();
            this.dataList.clear();
            this.dataCount = 0;
        }
    }

    private AreaModel getAreaModelFromMap(Map<String, AreaModel> areaNameMap, String areaName) {
        if (StringUtils.isNotBlank((CharSequence)areaName)) {
            areaName = StringUtils.replace((String)areaName, (String)"\u300b", (String)"");
            areaName = StringUtils.replace((String)areaName, (String)">", (String)"");
            areaName = StringUtils.replace((String)areaName, (String)"\uff1e", (String)"");
            return areaNameMap.get(areaName);
        }
        return null;
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        log.debug("\u6240\u6709\u6570\u636e\u89e3\u6790\u5b8c\u6210\uff01");
        this.saveData();
    }

    private void saveData() {
        if (CollUtil.isEmpty(this.errDataList) && CollUtil.isEmpty(this.dataList)) {
            TownshipUserImportDto dto2 = new TownshipUserImportDto();
            dto2.setHaveError(Boolean.TRUE);
            dto2.setErrorReason("\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a");
            this.errDataList.add(dto2);
            throw new HealthException(JSON.toJSONString(this.errDataList));
        }
        if (CollUtil.isNotEmpty(this.errDataList)) {
            throw new HealthException(JSON.toJSONString(this.errDataList));
        }
        log.debug("{}\u6761\u6570\u636e\uff0c\u5f00\u59cb\u5b58\u50a8\u6570\u636e\u5e93\uff01", (Object)this.dataList.size());
        try {
            if (CollUtil.isNotEmpty(this.dataList)) {
                Set usernameSet = this.dataList.stream().map(TownshipUserImportDto::getUsername).collect(Collectors.toSet());
                if (usernameSet.size() < this.dataList.size()) {
                    TownshipUserImportDto dto3 = new TownshipUserImportDto();
                    dto3.setHaveError(Boolean.TRUE);
                    dto3.setErrorReason("Excel\u5217\u8868\u4e2d\u5b58\u5728\u91cd\u590d\u7528\u6237\u540d");
                    this.errDataList.add(dto3);
                    throw new HealthException(JSON.toJSONString(this.errDataList));
                }
                Map areaNameMap = this.sysAreaProvideService.getAreaNameMap();
                OrganizationUserV3ImportListParam param = new OrganizationUserV3ImportListParam();
                List townshipUserV3AllList = this.organizationUserService.getOrganizationUserListForImport(param);
                Map<Object, Object> townshipUserV3UsernameAllMap = new HashMap();
                Map<Object, Object> townshipUserV3TelAllMap = new HashMap();
                if (CollUtil.isNotEmpty((Collection)townshipUserV3AllList)) {
                    townshipUserV3UsernameAllMap = townshipUserV3AllList.stream().collect(Collectors.groupingBy(OrganizationUserV3ImportListVo::getUsername));
                    townshipUserV3TelAllMap = townshipUserV3AllList.stream().filter(i -> StrUtil.isNotBlank((CharSequence)i.getTel())).collect(Collectors.groupingBy(OrganizationUserV3ImportListVo::getTel));
                }
                Set areaIds = this.dataList.stream().map(dto -> this.getAreaModelFromMap(areaNameMap, dto.getDetailAreaName())).filter(Objects::nonNull).filter(areaModel -> areaModel.getLevel() >= 4).map(AreaModel::getId).collect(Collectors.toSet());
                Map delegateOrgMap = new HashMap();
                if (CollUtil.isNotEmpty(areaIds)) {
                    delegateOrgMap = this.organizationService.getDelegateOrgMapByOrgTypeAndAreaId(OrganizationTypeEnum.GOVERNMENT.getValue(), areaIds);
                }
                for (TownshipUserImportDto dto4 : this.dataList) {
                    AreaModel areaModel2 = this.getAreaModelFromMap(areaNameMap, dto4.getDetailAreaName());
                    if (Objects.isNull(areaModel2)) {
                        dto4.setHaveError(Boolean.TRUE);
                        dto4.setErrorReason(dto4.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u6240\u5728\u884c\u653f\u533a\u5212\u5185\u5bb9\u4e0d\u6b63\u786e\u6216\u4e0d\u5b8c\u6574\uff01", ExcelUtils.getExcelColName((int)1)));
                    } else if (areaModel2.getLevel() < 4) {
                        dto4.setHaveError(Boolean.TRUE);
                        dto4.setErrorReason(dto4.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u6240\u5728\u884c\u653f\u533a\u5212\u9700\u7cbe\u786e\u5230\u8857\u9053\u7ea7\u522b\uff01", ExcelUtils.getExcelColName((int)1)));
                    } else {
                        OrganizationV3OneVo delegateOrg = (OrganizationV3OneVo)delegateOrgMap.get(areaModel2.getId());
                        if (Objects.isNull(delegateOrg)) {
                            dto4.setHaveError(Boolean.TRUE);
                            dto4.setErrorReason(dto4.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u6240\u5728\u884c\u653f\u533a\u5212\u4e0d\u5b58\u5728\u4ee3\u8868\u653f\u5e9c\u7ec4\u957f\uff01", ExcelUtils.getExcelColName((int)1)));
                        } else {
                            dto4.setOid(delegateOrg.getId());
                        }
                    }
                    dto4.setUsername(SpringEncryptUtils.encrypt((String)dto4.getUsername()));
                    List townshipUserV3UsernameList = (List)townshipUserV3UsernameAllMap.get(dto4.getUsername());
                    if (CollUtil.isNotEmpty((Collection)townshipUserV3UsernameList)) {
                        dto4.setHaveError(Boolean.TRUE);
                        dto4.setErrorReason(dto4.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u8be5\u7528\u6237\u540d\u5df2\u88ab\u5176\u4ed6\u4eba\u4f7f\u7528\uff01", ExcelUtils.getExcelColName((int)2)));
                    }
                    dto4.setTel(SpringEncryptUtils.encrypt((String)dto4.getTel()));
                    List townshipUserV3TelList = (List)townshipUserV3TelAllMap.get(dto4.getTel());
                    if (CollUtil.isNotEmpty((Collection)townshipUserV3TelList)) {
                        dto4.setHaveError(Boolean.TRUE);
                        dto4.setErrorReason(dto4.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u8be5\u624b\u673a\u53f7\u5df2\u88ab\u5176\u4ed6\u4eba\u4f7f\u7528\uff01", ExcelUtils.getExcelColName((int)4)));
                    }
                    if (Objects.isNull(this.organizationUserService.getAccountIdByTel(dto4.getTel()))) {
                        dto4.setHaveError(Boolean.TRUE);
                        dto4.setErrorReason(dto4.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u65e0\u6cd5\u7ed1\u5b9a\u672a\u6388\u6743\u7684\u6d59\u653f\u9489\u624b\u673a\u53f7\uff01", ExcelUtils.getExcelColName((int)4)));
                    }
                    if (Boolean.TRUE.equals(dto4.getHaveError())) {
                        this.errDataList.add(dto4);
                        continue;
                    }
                    dto4.setLoginUserId(this.loginUserId);
                    this.idList.add(dto4.getId());
                }
                if (CollUtil.isNotEmpty(this.errDataList)) {
                    throw new HealthException(JSON.toJSONString(this.errDataList));
                }
                this.organizationUserService.importTownshipUserData(this.dataList);
            }
        }
        catch (Exception e) {
            this.organizationUserService.rollbackImportUserData(this.idList, this.loginUserId);
            throw e;
        }
        log.debug("\u5b58\u50a8\u6570\u636e\u5e93\u6210\u529f\uff01");
    }
}

