/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.basic;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.health.supervise.dao.basic.SqlMapper;
import cn.smarthse.modules.health.supervise.entity.basic.SqlModel;
import cn.smarthse.modules.health.supervise.service.basic.ISqlService;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.smarthse.exception.ServiceException;
import lombok.Generated;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.util.TablesNamesFinder;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sqlServiceImpl")
@DubboService
public class SqlServiceImpl
extends BaseServiceImpl<SqlMapper, Company>
implements ISqlService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SqlServiceImpl.class);
    private static final Long LIMIT_NUM = 100L;
    private static final String AES_KEY = "1234567890123456";
    private static final Base64.Encoder encoder = Base64.getEncoder();
    private static final Base64.Decoder decoder = Base64.getDecoder();
    private static final String ALGORITHM = "AES";
    private static final String ALGORITHM_STR = "AES/ECB/PKCS5Padding";
    private static final Long MAX_SAFE_INTEGER = 0x1FFFFFFFFFFFFFL;
    private static final Byte MAX_BATCH_SIZE = 100;
    private final ThreadLocal<SqlModel> context = ThreadLocal.withInitial(SqlModel::new);
    ExecutorService executor = Executors.newFixedThreadPool(10);
    @Autowired
    private RedisClient redisClient;
    private static final String SYSTEM_SCHEMA_TABLE_LIST_CACHE = "systemSchemaTableListCache";
    private static final Long SYSTEM_SCHEMA_TABLE_LIST_CACHE_TIME = 604800L;

    public ResponseData<Object> getQueryResult(SqlModel sqlModel) {
        String jsonResult;
        String rawSql;
        Long limit = sqlModel.getLimit();
        boolean noLimit = Objects.equals(limit, -1L);
        try {
            rawSql = SqlServiceImpl.decryptSQL(sqlModel.getSql());
        }
        catch (Exception e) {
            return new ResponseData(ResponseStateEnum.fail, String.format("\u89e3\u5bc6\u51fa\u9519::%s", e));
        }
        List<String> sqlList = SqlServiceImpl.splitRawSQL(rawSql);
        if (CollUtil.isEmpty(sqlList)) {
            return new ResponseData(ResponseStateEnum.fail, "SQL\u811a\u672c\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        int sqlSize = sqlList.size();
        if (sqlSize > MAX_BATCH_SIZE) {
            return new ResponseData(ResponseStateEnum.RequestLimit, String.format("\u8d85\u8fc7\u6700\u5927\u6279\u91cf\uff1a%d\uff01", MAX_BATCH_SIZE));
        }
        Map<Byte, String> sqlMap = IntStream.range(0, sqlSize).boxed().collect(Collectors.toMap(i -> (byte)(i + 1), sqlList::get));
        ConcurrentHashMap resultDataListMap = new ConcurrentHashMap();
        CountDownLatch latch = new CountDownLatch(sqlSize);
        long t1 = System.currentTimeMillis();
        for (Map.Entry<Byte, String> sqlEntry : sqlMap.entrySet()) {
            Byte idx = sqlEntry.getKey();
            String sql = sqlEntry.getValue();
            this.executor.execute(() -> {
                SqlModel ctx = this.context.get();
                ctx.setSql(sql);
                try {
                    Long num = null;
                    Boolean query = ctx.getQuery();
                    if (query != null && query.booleanValue()) {
                        num = this.executeCountQuery(sql);
                        Pair<Boolean, Long> pair = this.overLimit(num, limit);
                        boolean over = (Boolean)pair.getKey();
                        Long max = (Long)pair.getValue();
                        if (over && !noLimit) {
                            resultDataListMap.put(idx, new ResponseData(ResponseStateEnum.RequestLimit, String.format("\u67e5\u8be2\u7ed3\u679c\u6570\uff1a%d\u6761\uff0c\u8d85\u8fc7%d\u6761\uff0c\u8bf7\u5728SQL\u67e5\u8be2\u4e2d\u9650\u5236\u6761\u6570\uff0c\u6216\u901a\u8fc7\u5165\u53c2limit\u624b\u52a8\u6307\u5b9a\u6700\u5927\u67e5\u8be2\u6570\u3002", num, max)));
                            return;
                        }
                    }
                    long l1 = System.currentTimeMillis();
                    List<LinkedHashMap<String, Object>> resultDataList = this.executeDataQueryWithFlattening(sql);
                    long l2 = System.currentTimeMillis();
                    this.postProcessNullEmptyField(resultDataList);
                    SqlServiceImpl.postConvertLargeDataType(resultDataList);
                    SqlServiceImpl.postProcessDateTypeData(sqlModel, resultDataList);
                    resultDataListMap.put(idx, new ResponseData(ResponseStateEnum.success, String.format("\u5171%d\u6761\uff0c\u8017\u65f6 %dms", num, l2 - l1), resultDataList));
                }
                catch (Exception e) {
                    log.debug("\u67e5\u8be2\u5f02\u5e38::", (Throwable)e);
                    resultDataListMap.put(idx, new ResponseData(ResponseStateEnum.fail, String.format("\u67e5\u8be2\u5f02\u5e38::%s", e)));
                }
                finally {
                    this.context.remove();
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        long t2 = System.currentTimeMillis();
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, Boolean.TRUE.booleanValue());
            jsonResult = mapper.writeValueAsString(resultDataListMap.values());
        }
        catch (Exception e) {
            return new ResponseData(ResponseStateEnum.fail, String.format("JSON\u5e8f\u5217\u5316\u5931\u8d25::%s", e));
        }
        long successSize = resultDataListMap.values().stream().filter(r -> r.getState() == ResponseStateEnum.success).count();
        return new ResponseData(ResponseStateEnum.success, String.format("%d,%d,%d", sqlSize, successSize, t2 - t1), (Object)jsonResult);
    }

    public List<LinkedHashMap<String, Object>> exportQueryResult(SqlModel sqlModel) {
        List<LinkedHashMap<String, Object>> resultDataList;
        String sql;
        Long limit = sqlModel.getLimit();
        boolean noLimit = Objects.equals(limit, -1L);
        try {
            sql = SqlServiceImpl.decryptSQL(sqlModel.getSql());
        }
        catch (Exception e) {
            throw new ServiceException("\u89e3\u5bc6\u51fa\u9519");
        }
        if (CharSequenceUtil.isBlank((CharSequence)sql)) {
            throw new ServiceException("SQL\u811a\u672c\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        SqlModel ctx = this.context.get();
        ctx.setSql(sql);
        try {
            Long num = null;
            Boolean query = ctx.getQuery();
            if (query != null && query.booleanValue()) {
                num = this.executeCountQuery(sql);
                Pair<Boolean, Long> pair = this.overLimit(num, limit);
                boolean over = (Boolean)pair.getKey();
                Long max = (Long)pair.getValue();
                if (over && !noLimit) {
                    LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                    map.put("\u5bfc\u51fa\u957f\u5ea6\u9650\u5236\uff01", String.format("\u5bfc\u51fa\u7ed3\u679c\u6570\uff1a%d\u6761\uff0c\u8d85\u8fc7%d\u6761\uff0c\u8bf7\u5728SQL\u67e5\u8be2\u4e2d\u9650\u5236\u6761\u6570\uff0c\u6216\u901a\u8fc7\u5165\u53c2limit\u624b\u52a8\u6307\u5b9a\u6700\u5927\u67e5\u8be2\u6570\u3002", num, max));
                    ArrayList<LinkedHashMap<String, Object>> list = new ArrayList<LinkedHashMap<String, Object>>();
                    list.add(map);
                    ArrayList<LinkedHashMap<String, Object>> arrayList = list;
                    return arrayList;
                }
            }
            resultDataList = this.executeDataQueryWithFlattening(sql);
            this.postProcessNullEmptyField(resultDataList);
            SqlServiceImpl.postConvertLargeDataType(resultDataList);
            SqlServiceImpl.postProcessDateTypeData(sqlModel, resultDataList);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
        finally {
            this.context.remove();
        }
        return resultDataList;
    }

    public LinkedHashSet<String> getFormattedTableColumnNames(Select select) {
        final LinkedHashSet tableAliasDbTableSet = new LinkedHashSet();
        TablesNamesFinder tableFinder = new TablesNamesFinder(){

            public void visit(Table table) {
                String schemaName = table.getSchemaName();
                String tableName = table.getName();
                Alias alias = table.getAlias();
                Object aliasName = alias == null ? schemaName + "." + tableName : alias.getName();
                Pair aliasDbTablePair = new Pair(aliasName, (Object)new Pair((Object)schemaName, (Object)tableName));
                tableAliasDbTableSet.add(aliasDbTablePair);
            }
        };
        tableFinder.getTableList((Statement)select);
        StringBuilder sqlBuilder = new StringBuilder("SELECT t.COLUMN_NAME FROM (");
        String columnQueryTemplate = "SELECT CONCAT('%s.', c.COLUMN_NAME, '.%s') AS COLUMN_NAME FROM information_schema.COLUMNS AS c WHERE c.TABLE_SCHEMA = '%s' AND c.TABLE_NAME = '%s'";
        int index = 0;
        for (Pair pair : tableAliasDbTableSet) {
            if (index > 0) {
                sqlBuilder.append(" UNION ALL ");
            }
            String alias = (String)pair.getKey();
            Pair dbTable = (Pair)pair.getValue();
            sqlBuilder.append(String.format(columnQueryTemplate, alias, index++, dbTable.getKey(), dbTable.getValue()));
        }
        sqlBuilder.append(") t");
        return ((SqlMapper)this.dao).innerCustomQuery(sqlBuilder.toString());
    }

    public Map<String, List<String>> tableStructure(SqlModel sqlModel) {
        List<LinkedHashMap<String, Object>> retList;
        String cacheKey = SYSTEM_SCHEMA_TABLE_LIST_CACHE;
        if (this.redisClient.hasKey(cacheKey)) {
            retList = (List<LinkedHashMap<String, Object>>)this.redisClient.get(cacheKey);
        } else {
            retList = ((SqlMapper)this.dao).getQueryResult("SELECT TABLE_SCHEMA, TABLE_NAME FROM information_schema.tables;");
            this.redisClient.set(cacheKey, retList, SYSTEM_SCHEMA_TABLE_LIST_CACHE_TIME.longValue());
        }
        return retList.parallelStream().collect(Collectors.groupingBy(map -> (String)map.get("TABLE_SCHEMA"), Collectors.mapping(map -> (String)map.get("TABLE_NAME"), Collectors.toList())));
    }

    private Long executeCountQuery(String sql) {
        long num;
        try {
            boolean select;
            boolean bl = select = sql.contains("select") || sql.contains("SELECT");
            num = select ? ((SqlMapper)this.dao).countQueryResult(sql) : 1L;
        }
        catch (Exception e) {
            log.debug("\u67e5\u8be2\u8ba1\u6570\u51fa\u9519::", (Throwable)e);
            num = -1L;
        }
        return num;
    }

    private List<LinkedHashMap<String, Object>> executeDataQueryWithFlattening(String sql) {
        List<LinkedHashMap<String, Object>> resultDataList;
        SqlModel ctx = this.context.get();
        try {
            ctx.setPre(Boolean.TRUE);
            resultDataList = ((SqlMapper)this.dao).getQueryResult(sql);
            ctx.setPre(Boolean.FALSE);
        }
        catch (Exception e) {
            log.debug("\u67e5\u8be2\u51fa\u9519::", (Throwable)e);
            ctx.setPre(Boolean.FALSE);
            ctx.setPost(Boolean.FALSE);
            resultDataList = ((SqlMapper)this.dao).getQueryResult(sql);
        }
        return this.flattenNestedKeys(resultDataList);
    }

    public List<LinkedHashMap<String, Object>> flattenNestedKeys(List<LinkedHashMap<String, Object>> list) {
        if (CollUtil.isEmpty(list)) {
            return list;
        }
        return list.stream().map(map -> {
            if (map == null) {
                return null;
            }
            LinkedHashMap processedMap = new LinkedHashMap();
            map.forEach((k, v) -> {
                StringBuilder fullKey = new StringBuilder((String)k);
                while (v instanceof Map) {
                    Map.Entry entry = ((Map)v).entrySet().iterator().next();
                    fullKey.append('.').append((String)entry.getKey());
                    v = entry.getValue();
                }
                processedMap.put(fullKey.toString(), v);
            });
            return processedMap;
        }).collect(Collectors.toList());
    }

    public void postProcessNullEmptyField(List<LinkedHashMap<String, Object>> resultDataList) {
        boolean doPostProcess;
        SqlModel ctx = this.context.get();
        boolean bl = doPostProcess = ctx.getQuery() != false && ctx.getPost() != false;
        if (doPostProcess) {
            LinkedHashSet<String> columnNameSet = new LinkedHashSet<String>();
            Boolean queryAll = ctx.getQueryAll();
            if (queryAll != null && !queryAll.booleanValue()) {
                columnNameSet.addAll((Collection)ctx.getQueryInfoBySelect().getValue());
            } else {
                columnNameSet.addAll(this.getColumnNameSetByTable());
            }
            LinkedHashMap columnTemplate = new LinkedHashMap();
            columnNameSet.forEach(c -> columnTemplate.put(c, null));
            List columnMapList = resultDataList.stream().map(resultData -> {
                LinkedHashMap columnInstance = SqlServiceImpl.deepCopy(columnTemplate);
                columnNameSet.forEach(k -> {
                    Object v;
                    Object v2 = v = resultData != null ? (Object)resultData.get(k) : null;
                    if (v == null) {
                        columnInstance.put(k, null);
                    } else if (SqlServiceImpl.isEmptyCharSequence(v)) {
                        columnInstance.put(k, "");
                    } else {
                        columnInstance.put(k, v);
                    }
                });
                return columnInstance;
            }).filter(MapUtil::isNotEmpty).collect(Collectors.toList());
            resultDataList.clear();
            resultDataList.addAll(columnMapList);
        }
    }

    private LinkedHashSet<String> getColumnNameSetByTable() {
        SqlModel ctx = this.context.get();
        LinkedHashSet<String> taColumnNameSet = ctx.getFormattedColumnNames();
        if (CollUtil.isEmpty((Collection)taColumnNameSet)) {
            taColumnNameSet = this.getFormattedTableColumnNames(ctx.getSelect());
        }
        LinkedHashSet<String> columnNameSet = new LinkedHashSet<String>();
        for (String taColumnName : taColumnNameSet) {
            String[] split = taColumnName.split("\\.");
            String columnName = split[split.length - 2];
            String idx = split[split.length - 1];
            boolean alreadyExist = columnNameSet.contains(columnName);
            if (alreadyExist) {
                columnNameSet.add(String.format("%s_%s", columnName, idx));
                continue;
            }
            columnNameSet.add(columnName);
        }
        return columnNameSet;
    }

    private static String preProcessSQL(String sql) {
        if ((sql = sql.trim()).endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        return sql;
    }

    public static List<String> splitRawSQL(String rawSql) {
        if (CharSequenceUtil.isBlank((CharSequence)rawSql)) {
            return Collections.emptyList();
        }
        String regex = ";(?=(?:[^']*'[^']*')*[^']*$)";
        return Arrays.stream(rawSql.split(regex)).map(String::trim).filter(CharSequenceUtil::isNotBlank).collect(Collectors.toList());
    }

    private Pair<Boolean, Long> overLimit(Long num, Long limit) {
        if (limit == null) {
            return new Pair((Object)(num > LIMIT_NUM ? 1 : 0), (Object)LIMIT_NUM);
        }
        if (limit > 1000L) {
            return new Pair((Object)Boolean.TRUE, (Object)1000L);
        }
        return new Pair((Object)(num > limit ? 1 : 0), (Object)limit);
    }

    private static void postProcessDateTypeData(SqlModel sqlModel, List<LinkedHashMap<String, Object>> queryResult) {
        boolean doDateFormat = sqlModel.getDateFormat() != null && sqlModel.getDateFormat() != false && CollUtil.isNotEmpty(queryResult);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (doDateFormat) {
            queryResult.stream().filter(Objects::nonNull).forEach(o -> o.replaceAll((k, v) -> SqlServiceImpl.isDateType(v) ? sdf.format(SqlServiceImpl.convertToDate(v)) : v));
        }
    }

    private static void postProcessJsonData(SqlModel sqlModel, List<LinkedHashMap<String, Object>> queryResult) {
        boolean doJsonFormat;
        boolean bl = doJsonFormat = sqlModel.getJsonFormat() != null && sqlModel.getJsonFormat() != false && CollUtil.isNotEmpty(queryResult);
        if (doJsonFormat) {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            queryResult.stream().filter(Objects::nonNull).forEach(o -> o.replaceAll((k, v) -> v.getClass() == String.class && SqlServiceImpl.isValidJson(Convert.toStr((Object)v)) ? gson.toJson((JsonElement)gson.fromJson(Convert.toStr((Object)v), JsonElement.class)) : v));
        }
    }

    private static boolean isValidJson(String jsonString) {
        Gson gson = new Gson();
        try {
            gson.fromJson(jsonString, JsonElement.class);
            return Boolean.TRUE;
        }
        catch (JsonSyntaxException e) {
            return Boolean.FALSE;
        }
    }

    private static void postSetQueryCount(Long num, List<Map<String, Object>> queryResult) {
        if (num != null) {
            HashMap<String, Long> countMap = new HashMap<String, Long>();
            countMap.put("\u67e5\u8be2\u7ed3\u679c\u6570", num);
            queryResult.add(0, countMap);
        }
    }

    private static void postConvertLargeDataType(List<LinkedHashMap<String, Object>> queryResult) {
        if (CollUtil.isEmpty(queryResult)) {
            return;
        }
        queryResult.forEach(map -> {
            if (map != null) {
                map.forEach((key, value) -> {
                    if (value instanceof Long) {
                        map.put(key, SqlServiceImpl.processLong((Long)value));
                    } else if (value instanceof BigInteger) {
                        map.put(key, SqlServiceImpl.processBigInteger((BigInteger)value));
                    }
                });
            }
        });
    }

    public static <K, V> LinkedHashMap<K, V> deepCopy(LinkedHashMap<K, V> original) {
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(byteOut);
            out.writeObject(original);
            out.flush();
            out.close();
            ByteArrayInputStream byteIn = new ByteArrayInputStream(byteOut.toByteArray());
            ObjectInputStream in = new ObjectInputStream(byteIn);
            return (LinkedHashMap)in.readObject();
        }
        catch (Exception e) {
            log.debug("\u5e8f\u5217\u5316\u5931\u8d25::", (Throwable)e);
            throw new ServiceException("\u5e8f\u5217\u5316\u5931\u8d25");
        }
    }

    public static boolean isEmptyCharSequence(Object obj) {
        return obj instanceof CharSequence && CharSequenceUtil.isEmpty((CharSequence)((CharSequence)obj));
    }

    private static Object processLong(Long value) {
        return value > MAX_SAFE_INTEGER ? value.toString() : value;
    }

    private static Object processBigInteger(BigInteger value) {
        return value.compareTo(Convert.toBigInteger((Object)MAX_SAFE_INTEGER)) > 0 ? value.toString() : value;
    }

    private static boolean isDateType(Object obj) {
        if (obj == null) {
            return Boolean.FALSE;
        }
        Class<?> clazz = obj.getClass();
        return Stream.of(Date.class, LocalDate.class, LocalDateTime.class, ZonedDateTime.class).anyMatch(dateClass -> dateClass.isAssignableFrom(clazz));
    }

    private static Date convertToDate(Object obj) {
        if (!SqlServiceImpl.isDateType(obj)) {
            throw new IllegalArgumentException("\u5bf9\u8c61\u4e0d\u662f\u65e5\u671f\u7c7b\u578b");
        }
        if (obj instanceof Date) {
            return (Date)obj;
        }
        if (obj instanceof LocalDate) {
            return Date.from(((LocalDate)obj).atStartOfDay(ZoneId.systemDefault()).toInstant());
        }
        if (obj instanceof LocalDateTime) {
            return Date.from(((LocalDateTime)obj).atZone(ZoneId.systemDefault()).toInstant());
        }
        if (obj instanceof ZonedDateTime) {
            return Date.from(((ZonedDateTime)obj).toInstant());
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u65e5\u671f\u7c7b\u578b");
    }

    private static String decryptSQL(String encryptedSQL) throws Exception {
        SecretKeySpec secretKey = new SecretKeySpec(AES_KEY.getBytes(StandardCharsets.UTF_8), ALGORITHM);
        Cipher cipher = Cipher.getInstance(ALGORITHM_STR);
        cipher.init(2, secretKey);
        byte[] decodedValue = decoder.decode(encryptedSQL);
        byte[] decryptedValue = cipher.doFinal(decodedValue);
        return new String(decryptedValue, StandardCharsets.UTF_8);
    }

    @Generated
    public ThreadLocal<SqlModel> getContext() {
        return this.context;
    }

    @Generated
    public ExecutorService getExecutor() {
        return this.executor;
    }

    @Generated
    public RedisClient getRedisClient() {
        return this.redisClient;
    }
}

